//-----------------------------------------------------------------------//

#include <vcl.h>
#include <string.h>
#include <dir.h>
#include "d:\apclass\apstring.h"
#include "d:\apclass\apvector.h"
#include <fstream.h>
#pragma hdrstop

#include "Unit1.h"
#include "Unit3.h"
#include "Unit4.h"
//-----------------------------------------------------------------------//
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmMain *frmMain;

bool FileOpenNow;
apstring OpenFilename;
apvector<apstring> ProjectFiles;       //LONG filenames of files in project
//-----------------------------------------------------------------------//
bool ExecuteProgram(AnsiString filename)
{
  SHELLEXECUTEINFO ExeInfo;
  memset (&ExeInfo, 0, sizeof (ExeInfo));
  ExeInfo.cbSize = sizeof (ExeInfo);
  ExeInfo.lpVerb = "open";
  ExeInfo.lpFile = filename.c_str();
  //ExeInfo.lpParameters =
  ExeInfo.fMask = SEE_MASK_NOCLOSEPROCESS;
  ExeInfo.nShow = SW_SHOWDEFAULT;

  if (!ShellExecuteEx (&ExeInfo))
    return false;
  else
    return true;
}
//-----------------------------------------------------------------------//
void smbOpenFile(AnsiString filename)
{
  //opens file with given "filename"
  ifstream InputFile(filename.c_str());  //input file object
  AnsiString CurrentLine="";          //current line object
  apstring cLine;               //current line (apstring)

  while(!InputFile.fail())  //loop until file fails
  {
   getline(InputFile, cLine); //get current line of file
   CurrentLine = cLine.c_str();  //convert apstring to AnsiString
   frmMain->memFile->Lines->Append(CurrentLine); //add line to memo object
   FileOpenNow = true;
  }

  if (FileOpenNow)  //did read from file?
  {
   OpenFilename = filename.c_str();  //set filename
  }

  return;
}
//-----------------------------------------------------------------------//
apstring GetFile(apstring filename)
{
//gets file from a long filename
//i.e. d:\temp\hello\this.txt would return this.txt
  apstring dumb = "<none>";
  apstring fs = ":\\";

  if (filename.find(fs) == npos)
   return dumb;

  for (int ctr=filename.length()-1; ctr >= 0; ctr--)
  {
    if (filename[ctr] == '\\')
     return filename.substr(ctr+1,filename.length()-1);  //return file
  }

  return dumb;
}
//-----------------------------------------------------------------------//
__fastcall TfrmMain::TfrmMain(TComponent* Owner)
        : TForm(Owner)
{

}
//-----------------------------------------------------------------------//
void __fastcall TfrmMain::DriveComboBox1Change(TObject *Sender)
{

  try
  {
   try
   {
    DirectoryListBox1->Drive = FileListBox1->Drive;
    DirectoryListBox1->Drive = DriveComboBox1->Drive;
    FileListBox1->Directory = DirectoryListBox1->Directory;
   }
   __except (EXCEPTION_EXECUTE_HANDLER)
   {
   }

  }
  catch (...)
  {

  }

}
//-----------------------------------------------------------------------//

void __fastcall TfrmMain::DirectoryListBox1Change(TObject *Sender)
{
  try
  {
    FileListBox1->Directory = DirectoryListBox1->Directory;
  }
  catch (...)
  {

  }
}
//-----------------------------------------------------------------------//

void __fastcall TfrmMain::FileListBox1DblClick(TObject *Sender)
{
  //open file user selected:
  AnsiString ext = FileListBox1->FileName.c_str();
   ext = ext.SubString(ext.Length()-2,3);  //get extension of file

 if (ext == "exe" || ext == "EXE" || ext == "bat" || ext == "BAT")
 {
  ExecuteProgram(FileListBox1->FileName.c_str());  //execute exe
 }
 else   //not executable (open for editing):
 {
  memFile->Lines->Clear(); //clear lines before opening new file..
  smbOpenFile(FileListBox1->FileName); //function to open file..
 }

}
//-----------------------------------------------------------------------//
void __fastcall TfrmMain::mnuExitClick(TObject *Sender)
{
  exit(0);

}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::FormResize(TObject *Sender)
{
  //resize memo edit control:
  double DirHeightRatio = .340388;
  double MemoHeightRatio = .81834215;
  double MemoWidthRatio = .7350318471;
  
  memFile->Width = double(frmMain->Width) * MemoWidthRatio;  // - 170;
  memFile->Height = double(frmMain->Height) * MemoHeightRatio;

  DirectoryListBox1->Height = frmMain->Height * DirHeightRatio;  //- 271;
  FileListBox1->Top = DirectoryListBox1->Height + DriveComboBox1->Height + 40;
  FilterComboBox->Top = FileListBox1->Height + DirectoryListBox1->Height + DriveComboBox1->Height + 48;

}
//---------------------------------------------------------------------------//
void __fastcall TfrmMain::mnuSaveClick(TObject *Sender)
{
  if (FileOpenNow)  //if existing file open, save:
  {
    memFile->Lines->SaveToFile(OpenFilename.c_str());   //use member function to save file
    return;
  }

  if (SaveDialog->Execute())       //execute save dialog box (file does not exist)
  {
    //ofstream OutFile(SaveDialog->Filename)
    AnsiString filename = SaveDialog->FileName.c_str(); //get filename

     memFile->Lines->SaveToFile(filename);   //use member function to save file
     FileOpenNow = true;
     OpenFilename = filename.c_str();      //set new filename of current file
  }

}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
  FileOpenNow = false;     //no file open
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::mnuSaveAsClick(TObject *Sender)
{
  if (SaveDialog->Execute())       //execute save dialog box (file does not exist)
  {
    //ofstream OutFile(SaveDialog->Filename)
    AnsiString filename = SaveDialog->FileName.c_str(); //get filename

     memFile->Lines->SaveToFile(filename);   //use member function to save file
     FileOpenNow = true;
     OpenFilename = filename.c_str();      //set new filename of current file
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::mnuCloseFileClick(TObject *Sender)
{
  memFile->Lines->Clear();  //clear memo edit..
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ToolButton2Click(TObject *Sender)
{
   memFile->Lines->Clear();  //clear memo edit..
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ToolButton3Click(TObject *Sender)
{
 mnuOpenClick(ToolButton3);
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::ToolButton5Click(TObject *Sender)
{
 mnuSaveClick(ToolButton5);
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::mnuOpenClick(TObject *Sender)
{

  if (OpenDialog->Execute())       //execute open dialog box
  {
    AnsiString filename = OpenDialog->FileName.c_str(); //get filename

     memFile->Lines->Clear();  //clear lines before open file.
     smbOpenFile(filename); //open file now!
     FileOpenNow = true;
     OpenFilename = filename.c_str();      //set new filename of current file
  }
}
//--------------------------------------------------------------------------//
void __fastcall TfrmMain::About1Click(TObject *Sender)
{
  frmAbout = new TfrmAbout(Application);    //define new form..
  frmAbout->Show();                        //show about form
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::mnuCreateBatchClick(TObject *Sender)
{
 //ExecuteProgram("notepad");
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::CreateProject1Click(TObject *Sender)
{

  frmProject = new TfrmProject(Application);    //define new form..
  frmProject->Show();                        //show about form
  int FileCount = ProjectFiles.length();     //get number of files in current project

  if (FileCount > 0)  //if a project is open, then set for editing:
  {
     for (int i=0; i < FileCount; i++)
     {
      AnsiString CurrentItem = ProjectFiles[i].c_str(); //get current file

      frmProject->lstProjectFiles->Items->Add(CurrentItem); //add current item
      frmProject->txtName->Text = lblProjectName->Caption; //set project name
     }
  }

}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::OpenProject1Click(TObject *Sender)
{
  if (OpenProjectDialog->Execute())       //execute open dialog box
  {
    AnsiString filename = OpenProjectDialog->FileName.c_str(); //get filename
    ifstream ProjectFile(filename.c_str()); //define input file object
    apstring cLine;
    AnsiString CurrentLine="";
    int ctr=0;

    ProjectFiles.resize(ctr); //resize vector (opening new project now...)
    cboProjectFiles->Items->Clear(); //clear items in combo box

    while(!ProjectFile.fail())  //loop until file fails
    {
     ProjectFile >> cLine;   //get current line
     CurrentLine = cLine.c_str();  //convert apstring to AnsiString
     apstring file = GetFile(cLine); //get file (if any)

     if (file == "<none>" && cboProjectFiles->Items->Count == 0) //if no file:
      lblProjectName->Caption = CurrentLine; //set project name
     else
     {
      if (file != "<none>")
      {
       ctr++; //increment counter
       AnsiString fname = file.c_str();
       cboProjectFiles->Items->Add(fname);
       ProjectFiles.resize(ctr);
       ProjectFiles[ctr-1] = cLine; //set LONG filename
      }
     }

    }
     memFile->Lines->Clear();  //clear lines before open file.
  }
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::cboProjectFilesChange(TObject *Sender)
{
  int idx = cboProjectFiles->ItemIndex;
  apstring fname = ProjectFiles[idx];
  AnsiString filename = fname.c_str();
  memFile->Lines->Clear(); //clear lines
  smbOpenFile(filename); //open file!
}
//---------------------------------------------------------------------------

void __fastcall TfrmMain::CloseProject1Click(TObject *Sender)
{
  lblProjectName->Caption = "[Project Name]";
  cboProjectFiles->Items->Clear();               //clear combo box items
  ProjectFiles.resize(0);              //resize vector
}
//---------------------------------------------------------------------------

