<HTML>
<HEAD>
<TITLE>Multi-OS Batch Programs</TITLE>
</HEAD>
<BODY>
<H3 ALIGN="center">Multi-OS Batch Programs</H3>
<P>There are enough differences among the various flavors of "DOS" in real DOS, Win95, and NT4 that programs written for one often fail, sometimes for obscure reasons, in one or both of the others.  The first illustration is something I used to prove a point, but also to explore some of the differences.  A number of people have expressed interest in the program even though it's still (9 Feb. 1998) in beta testing (I need to *know* what breaks it) that I have decided to publish the code, comments, and explanatory material much too soon, well before I understand some of it myself.  This is very preliminary stuff and will be rewritten later, when the dust settles (copyright considerations also played a role in that decision).</P>
<P>The program was inspired by a thread in alt.msdos.batch that began with a question about extracting the individual directory names from a fully qualified directory specification.  One thing led to another, and I decided that I needed to explore the possibilities.</P>
<P>Several problems immediately presented themselves, one of which was that the user hadn't indicated what operating environment he was using - "Well, it shouldn't be too hard to make it work in all three." - famous last words.  It was a nightmare: short vs. long names, spaces in names, different behaviors of DIR, case insensitivity, the pattern is a variable but the DIR listing is in a file - how to look for the contents of a file in a variable, list processing using the LOADFIX/DATE scheme is broken after MSDOS6.22 due to lack of LOADFIX, string processing is broken after MSDOS6.22 because of lack of the '/' switch to FOR but fixed to some extent in NT4 with extensions to FOR, and so forth, and so on.  This little devil of a program is the result:</P>
<A HREF="enter.bat">ENTER.BAT</A>
<PRE><CODE> @echo off
 if not %pass%!==! goto %pass%
 set pass=pass2
 set count=!!
 set flag=
 set pattern=
 set realdir=
 set testdir=
 set olddircmd=%dircmd%
 set dircmd=
 set a=
 set ostype=DOS
 if %OS%!==Windows_NT! set ostype=NT
 set null=nul
 if %ostype%==NT set null=
 :loop0
 set pattern=%pattern%%1
 if %2!==! goto cont0
 set pattern=%pattern% 
 shift
 set flag="
 goto loop0
 :cont0
 if not exist %flag%%pattern%%null%%flag% goto error
 echo %pattern%> }1{.dat
 dir %flag%%pattern%*.*%flag% /a:d | find "Volume in drive" > }2{.bat
 echo set !=%%3> volume.bat
 call }2{
 set !=%!%:\
 set realdir=%!%
 :outerloop
 dir %flag%%realdir%*.*%flag% /a:d /b > }3{.dat
 echo.>> }3{.dat
 date < }3{.dat | find "En" > }4{.dat
 echo exit>> }4{.dat
 command /e:1024 < }4{.dat >> nul
 call }5{.bat
 echo %realdir%> }6{.dat
 find /i "%pattern%" }6{.dat > nul
 if not errorlevel 1 goto display
 set count=%count%!
 goto outerloop
 :pass2
 if %ostype%==NT goto nt1
 if %4!==! goto end
 goto cont11
 :nt1
 if %5!==! goto end
 :cont11
 set a=%realdir%
 set testdir=
 :innerloop
 if %ostype%==DOS set a=%a%%4
 if %ostype%==NT set a=%a%%5
 if %ostype%==DOS set testdir=%testdir%%4
 if %ostype%==NT set testdir=%testdir%%5
 shift
 if %ostype%==NT goto nt2
 if %4!==! goto cont1
 goto cont12
 :nt2
 if %5!==! goto cont1
 :cont12
 set a=%a% 
 set testdir=%testdir% 
 goto innerloop
 :cont1
 set a=%a%\
 find /i "%a%" }1{.dat > nul
 if errorlevel 1 goto end
 echo set %count%=%testdir%> }5{.bat
 echo set realdir=%a%>> }5{.bat
 goto end
 :display
 :cleanup
 set dircmd=%olddircmd%
 set maxcount=%count%
 set count=!
 echo The elements in %pattern% are
 :cleancountloop
 set %count%=
 if %count%==%maxcount% goto cleancont
 set count=%count%!
 echo echo %%%count%%%>}5{.bat
 call }5{
 set %count%=
 goto cleancountloop
 :cleancont
 set pass=
 set ostype=
 set count=
 set maxcount=
 set pattern=
 set realdir=
 set testdir=
 set a=
 set flag=
 set olddircmd=
 del }1{.dat
 del }2{.bat
 del }3{.dat
 del }4{.dat
 del }5{.bat
 del }6{.dat
 goto end
 :error
 echo.
 echo.
 echo ERROR Report: %pattern% 
 echo does not exist, lacks a trailing '\' or has some other error.
 :end</CODE></PRE>
<P>Total clarity ... sure it is.  There is a <A HREF="commented.enter.bat">commented version</A> (about 11Kb).  You should not try to retype, or even copy/paste either one because there are significant trailing spaces in some places and other places where a trailing space is a fatal error; feel free to save the files and test them, though (the usual "no commercial use" copyright license applies).  If you have a problem with too little environment space, you can say <B>COMMAND /e:1024</B> at the prompt to spawn a secondary command processor with a larger environment.  In some cases, you may need a larger number in the <B>/e:</B> switch or you can add</P>
<PRE><CODE> set pass=pass1
 command /e:2048 /c%0 %1 %2 %3 %4 %5 %6 %7 %8 %9
 goto end
 :pass1</CODE></PRE>
<P>just ahead of the <B>set pass=pass2</B> line.</P>
<P>There are a number of personal firsts in this program, beginning with it's name: <B>ENTER.BAT</B>.  I've used that name before in <A HREF="listp1.htm">list processing</A>, but this is the first time I've found it necessary to use it for the master file.  The program is recursive - it uses the <B>:PASS2</B> code to process directory entries by redirecting the list of entries into <B>COMMAND.COM></B> after passing them through <B>DATE</B> to prefix each line with <B>Enter</B> (and some other garbage that gets ignored) and therefore must be invoked when the command <B>ENTER</B> is given.  Another first was string comparison by running the pattern and the string in work through <B>FIND</B> in both directions: if <B>a</B> is in <B>b</B> and <B>b</B> is in <B>a</B>, then <B>a</B> and <B>b</B> are identical.  Using the <B>/i</B> switch to <B>FIND</B> makes the comparisons case insensitive.  But mainly, this is the first batch program I've written that is <B>explicitly</B> intended to work in all three "DOS" environments.<P>
<P>Plain text version of <A HREF="enter.bat.txt"><B>ENTER.BAT</B></A> and <A HREF="commented.enter.bat.txt"><B>Commented ENTER.BAT</B></A> are available if you wish to view them or otherwise have a problem with files with the <B>.BAT</B> extension.</P>
<UL>There are several key points to running the program:
<LI>It must be named <B>ENTER.BAT</B>
<LI>The directory to be parsed must be unquoted and may contain no more than eight spaces
<LI>The program must be in the default directory or in the PATH, but it need not be in the directory being examined
<LI>The directory to be parsed must exist, but can be empty
<LI>The directory name must be fully qualified and must end with a backslash: <B>d:\foo\bar\baz\</B>
</UL>
<HR>
<P>In some cases completely different programs are required.  There are a several ways to deal with this:
<UL>
<LI>Separate files for each, using the same file name in the same named directories on different systems.  This might be practical for stand alone systems, but would not be workable in a networked context.
<LI>Separate files with different names, all in a common directory, and a master batch file to detect the OS and call the appropriate subroutine.  This is practical for networked systems, but not for programs that are to be distributed because of the multiple files that have to be remembered when cloning the program.
<LI>All-in-one with internal detection of the OS and jumps to the appropriate code in the file.  The downside of this approach is that it makes for bloated batch programs and slow execution, especially when recursion is used.  It is, however, the most versatile and portable, and is the approach used here, mostly though, because the section is about batch files that run properly under multiple Microsoft operating systems and these program are intended for distribution.
</UL>
Given that the programs here are to be of the last mentioned class, certain blocks of code will recur again and again, especially the code to detect the OS and to deal with long file names.</P>
<P>Detecting the OS is not a straight-forward task: <B>VER</B> tells us what the base OS is, but not whether we are running in a DOS box (Win3.x and Win95).  Most of the time that isn't important and <B>VER</B> would be usable, however, to make use of <B>VER</B>we have to either run it through <B>FIND</B> to check for key words, or import it into an environment variable - both of these require enough extra disk activity to make them undesirable if an alternative that does not require pipes is available.  Unfortunately, the alternative of deducing the information from environment variables also requires pipes and <B>FIND</B> because some of the variables are in lower case and can be extracted only with considerable difficulty.  The least inefficient procedure seems to be to look for NT first, using the <B>OS=</B> environment variable (very low overhead), then to look for "Windows" in the <B>VER</B> report if NT is not found.  If it isn't NT, and "Windows" is not in the report, we will assume MSDOS.  This ignores OS/2 and other non-Microsoft operating systems.</P>
<P>It's time for an aside:<BR>I wrote this book not because I like the MS operating systems and their batch languages, but because I detest them - they are terrible operating systems with brain damaged scripting languages.  NT is the least bad, but it's still a long way from what I would consider really usable.  This book grew out of my need to find ways to get the job done despite Microsoft's best efforts to prevent me from doing whatever need doing.  OS/2 is omitted because it is not a Microsoft operating system and I am not forced to deal with it.</P>
<P>Back to detecting the OS:
<PRE><CODE>set this_os=DOS
if %OS%!==! goto try95
set this_os=NT
goto os_ok
:try95
ver | find "Wi" > nul
if not errorlevel 1 set this_os=WIN
:os_ok</CODE></PRE>
will, in the majority of cases suffice to tell our code which block of commands to use.  Since I know nothing about Win98 or NT5 at this time, I can only assume that they will not introduce additional breakage requiring additional testing.</P>
<B>Rule (0) for the following examples: <EM>Only real DOS, and DOS boxes in Win31, Win95, and NT4 are provided for, and then only in fairly simple cases</EM></B>
<P>Long file names introduce several problems that are intractable: present or absent quotes, and batch file delimiters in file names are the most important.  These interact: if 
<PRE><CODE> WHATARGS.BAT
@echo %1!%2</CODE></PRE>
is given under Win95 
<PRE><CODE>"foo=bar"</CODE></PRE>
as an argument, it reports
<PRE><CODE>"foo=bar"!</CODE></PRE>
but, if it is given 
<PRE><CODE>foo=bar</CODE></PRE>
it reports
<PRE><CODE>foo!bar</CODE></PRE>
Similarly, it reports spaces correctly is the string is quoted, but not if it isn't.
From this simple experiment, it is clear that the proper way to handle file names is to require that long names be quoted and short names unquoted when passed as arguments.  It is important to remember that real DOS barfs if file names are quoted when passed to functions such as <B>DIR</B> - this is the reason for passing short names (the <EM>only</EM> kind of names in real DOS) unquoted, though it makes no difference for short names and long names not containing delimiters in Win95 and NT.  If it is <EM>necessary</EM> to pass long names unquoted, then code like that in the first example in this section will be necessary, along with the implicit assumption that the file names contain no commas, semicolons, equals signs, or clusters of spaces with or without other delimiters because the code can replace only delimiters it knows about in advance and that are hard coded in the program.</P>
<B>Rule (1) for the following examples:
<EM>Long file names are quoted when passed to a batch file as an argument; short file names are never quoted</EM>.</B>
<P>Let's see what applying that preceding stream-of-consciousness stuff can do when applied to some real word code.</P>
<P>A few days ago I responded to a user's question about extracting the base name from a long file name (unspecified OS, but I correctly deduced it was Win95 from the header of his usenet message) with this:
<PRE><CODE> @echo off
 if %1!==}{! goto pass2
 set this=%0
 md }{
 set original=
 :loop
 set original=%original%%1
 shift
 if %1!==! goto cont
 REM following line ends with exactly one space
 set original=%original% 
 goto loop
 :cont
 copy "%original%" }{
 for %%a in (}{\*.*) do %this% }{ %%a
 goto end
 :pass2
 ren %2 *
 dir }{\*.* /b > }{.dat
 echo. >> }{.dat
 set longname=
 date < }{.dat | find "En" > }{.bat
 echo :loop> enter.bat
 echo set longname=%%longname%%%%4>> enter.bat
 echo shift>> enter.bat
 echo if %%4!==! goto end >> enter.bat
 echo set longname=%%longname%% >> enter.bat
 echo goto loop>> enter.bat
 echo :end>> enter.bat
 call }{
 deltree /y }{
 del }{.bat
 del }{.dat
 del enter.bat
 set this=
 echo The long name of "%original%" without the extension is "%longname%"
 set original=
 set longname=
 :end</CODE></PRE>

That code doesn't work in any other environment: real DOS doesn't like the quotes, and NT barfs on the syntax.  The basic code copies the given file to an empty directory and renames all the files in that directory to * to strip the extension.  That is an old DOS trick, but it doesn't work with long file names containing dots in either Win95 or NT4 - it truncates at the first dot instead of the last.  I used the Win95 specific behavior of <B>FOR</B> to get the short name (<B>FOR %%a in ( *.* )</B> returns the short names of every file in the directory - since there was only one, it returns it).  It was necessary to omit the usual <B>CALL</B> from the <B>DO</B> clause in order to avoid having <B>FOR</B> return the new file name as well.</P>
<P>The standard DOS code can be modified somewhat to reduce disk usage
<PRE><CODE>@echo off
md }{
rem> }{\%1
ren }{\%1 *
dir }{\*.* /b > }{.dat
echo. >> }{.dat
date < }{.dat | find "En" > }{.bat
set basename=
echo set basename=%%4> Enter.bat
call }{
deltree /y }{ > nul
for %%a in (enter.bat }{.bat }{.dat) do del %%a
echo %basename%</CODE></PRE>
That provides a module for getting base names in DOS and Win3.1.  It can be made to work under Win95 as well as real DOS and Win3.1 by using the <B>FOR</B> trick mentioned above:
<PRE><CODE>@echo off
if %1!==}{! goto pass2
md }{
rem> }{\%1
for %%a in ( }{\*.* ) do %0 }{ %%a
:pass2
ren }{\%1 *
dir }{\*.* /b > }{.dat
echo. >> }{.dat
date < }{.dat | find "En" > }{.bat
set basename=
echo set basename=%%4> Enter.bat
call }{
deltree /y }{ > nul
for %%a in (enter.bat }{.bat }{.dat) do del %%a
echo %basename%</CODE></PRE></P>
<P>Note that DELTREE doesn't come with NT4 - the above programs fail unless it is present because it is left over from an earlier operating system to which NT4 was an upgrade, or is provided some other way (in a networked directory on a WfW or Win95 machine in the PATH, for example).</P>
<BR>
<HR>
<BR>
<P><A NAME="dirsize">One</A> user asked for a program that would provide a list of directories and their sizes - this provided me with an opportunity to extend the above multi-OS thinking into list processing: it required a bit of string processing and directory listings for each directory in a <B>DIR /s</B> listing.  It brought up an additional point: you can't use syntax like <B>echo set %%quote%%="&gt;&gt; enter.bat</B> because the quote mark will inhibit the <B>&gt;&gt;</B>.  For the fully commented version of this, see <A HREF="commented.dirsize.bat.html"><B>commented.dirsize.bat.html</B></A></P>
<PRE><CODE> @echo off
 dir %1 /a:d /b /s > }{.dat
 echo.>> }{.dat
 date < }{.dat | find "Enter " > }{.src
 echo exit>> }{.src
 set arg=4
 set sw=
 set mark="
 set e=/e:1024
 if %os%!==Windows_NT! set arg=5
 if %os%!==Windows_NT! set sw=/x
 if %os%!==Windows_NT! set e=
 echo @echo off> enter.bat
 echo if %%%arg%!==! goto end>> enter.bat
 echo set quote=>> enter.bat
 echo set dname=>> enter.bat
 echo :loop>> enter.bat
 echo set dname=%%dname%%%%%arg%>> enter.bat
 echo shift>> enter.bat
 echo if %%%arg%!==! goto cont>> enter.bat
 :: Note that there is a space following %%dname%% in the following line
 echo set dname=%%dname%% >>enter.bat
 echo set quote=%%mark%%>> enter.bat
 echo goto loop>> enter.bat
 echo :cont>>enter.bat
 echo echo %%dname%% (size in bytes)>> enter.bat
 echo if exist %%quote%%%%dname%%\*.*%%quote%% dir %sw% %%quote%%%%dname%%%%quote%%>> enter.bat
 echo if not exist %%quote%%%%dname%%\*.*%%quote%% echo          0 file(s)              0 bytes>> enter.bat
 echo :end>> enter.bat
 %comspec% %e% < }{.src | find " bytes" | find /v " free">result.txt
 del }{.dat
 del }{.src
 del enter.bat
 set sw=
 set arg=
 set e=
 set mark=</CODE></PRE>
<P>This approach to list processing is based on the <B>LOADFIX/DATE</B> approach analysed in <A HREF="listp1.htm">List Processing</A> but redirects the preprocessed list to the input of the command processor (<B>COMMAND.COM</B> (DOS and Win95) or <B>CMD.EXE</B> (NT4) so that the <B>ENTER</B> command (provided here by <B>ENTER.BAT</B>) is invoked once for each line in the file.  Note that it is necessary to append an <B>EXIT</B> command to the end of the file, or the command processor will never terminate and the batch program will hang.</P>
<HR>

<PRE>  ** Copyright 1998, Ted Davis - all rights reserved ** </PRE>

<P><A HREF="mailto:tdavis@gearbox.maem.umr.edu">Input and feedback</A> from readers are welcome.</P>
<P>Back to the <A HREF="index.htm">Table of Contents</A> page
<P>Back to my <A HREF="http://gearbox.maem.umr.edu/~tdavis/ted2.htm">personal links</A> page - back to my <A HREF="http://gearbox.maem.umr.edu/~tdavis/tdavis.htm">home page</A></P>

</BODY>
</HTML>
