unit untHiscores;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, shellapi,

  untCongrats; // used to ask the player for his/her name.

type
  TfrmHiScTab = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label5: TLabel;
    OK_button: TButton;
    Label6: TLabel;
    No1: TLabel;
    Name1: TLabel;
    Level1: TLabel;
    Score1: TLabel;
    No2: TLabel;
    Name2: TLabel;
    Level2: TLabel;
    Score2: TLabel;
    No3: TLabel;
    Name3: TLabel;
    Level3: TLabel;
    Score3: TLabel;
    No4: TLabel;
    Name4: TLabel;
    Level4: TLabel;
    Score4: TLabel;
    No5: TLabel;
    Name5: TLabel;
    Level5: TLabel;
    Score5: TLabel;
    No6: TLabel;
    Name6: TLabel;
    Level6: TLabel;
    Score6: TLabel;
    No7: TLabel;
    Name7: TLabel;
    Level7: TLabel;
    Score7: TLabel;
    No8: TLabel;
    Name8: TLabel;
    Level8: TLabel;
    Score8: TLabel;
    No9: TLabel;
    Name9: TLabel;
    Level9: TLabel;
    Score9: TLabel;
    No10: TLabel;
    Name10: TLabel;
    Level10: TLabel;
    Score10: TLabel;
    MainMenu1: TMainMenu;
    Table: TMenuItem;
    ZapTable1: TMenuItem;
    Close1: TMenuItem;
    Help1: TMenuItem;
    Howtoplay1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure AddScore( level, score : longint;
      var rank : integer );
    procedure display_table( rank : integer );
    procedure ZapTable1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Howtoplay1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmHiScTab: TfrmHiScTab;

implementation

{$R *.DFM}

const
  max_hiscores = 10;

type
  hiscores_type = array[ 1..max_hiscores ] of record
                    player_name : string;
                    level, score : longint;
                  end;
var
  hiscores_table : hiscores_type;
  hiscore_filename : string;

{----------------------------------------------------------}

procedure tfrmHiScTab.display_table( rank : integer );
var
  j : integer;
begin
  for j := 1 to max_hiscores do
  begin
    tlabel(FindComponent('Name'+ inttostr(j))).Caption   := hiscores_table[j].player_name;
    tlabel(FindComponent('Level'+ inttostr(j))).Caption := inttostr( hiscores_table[j].level );
    tlabel(FindComponent('Score'+ inttostr(j))).Caption := inttostr( hiscores_table[j].score );
    if j = rank then
    begin
      tlabel(findcomponent( 'No' + inttostr( rank ))).Font.Color     := clblue;
      tlabel(findcomponent( 'Name' + inttostr( rank ))).Font.Color   := clblue;
      tlabel(findcomponent( 'Level' + inttostr( rank ))).Font.Color  := clblue;
      tlabel(findcomponent( 'Score' + inttostr( rank ))).Font.Color  := clblue;
    end
    else
    begin
      tlabel(findcomponent( 'No' + inttostr( j ))).Font.Color     := clblack;
      tlabel(findcomponent( 'Name' + inttostr( j ))).Font.Color   := clblack;
      tlabel(findcomponent( 'Level' + inttostr( j ))).Font.Color  := clblack;
      tlabel(findcomponent( 'Score' + inttostr( j ))).Font.Color  := clblack;
    end;
  end;
end; { display_table }
{----------------------------------------------------------}

procedure tfrmHiScTab.AddScore( level, score : longint;
  var rank : integer );
var
  x : integer;
  found : boolean;

{..........................................................}

procedure move_scores_down( position : integer );
var
  j : integer;
begin
  for j := 10 downto position + 1 do
  begin
    hiscores_table[ j ].level       := hiscores_table[ j - 1 ].level;
    hiscores_table[ j ].score       := hiscores_table[ j - 1 ].score;
    hiscores_table[ j ].player_name := hiscores_table[ j - 1 ].player_name;
  end;
end; { move_scores_down }
{..........................................................}

begin
  x := 1;
  found := false;
  while (x <= max_hiscores) and not found do
  begin
    if score > hiscores_table[ x ].score then
    begin
      found := true;
      if x < 10 then
        move_scores_down( x );
      hiscores_table[ x ].level := level;
      hiscores_table[ x ].score := score;
      rank := x;
      frmget_player_name := tfrmget_player_name.create( nil );
      try
        frmget_player_name.showModal;
        hiscores_table[ x ].player_name := frmget_player_name.edit1.text;
      finally
        frmget_player_name.release;
      end;
      display_table( x );
    end;
    inc( x );
  end;
end; { AddScore }
{----------------------------------------------------------}

procedure blank_hiscore_table;
var
  x : integer;
begin
  { --- blank the table --- }
  for x := 1 to max_hiscores do
  begin
    hiscores_table[ x ].player_name := '';
    hiscores_table[ x ].level := 0;
    hiscores_table[ x ].score := 0;
  end;
end; { blank_hiscore_table }
{----------------------------------------------------------}

procedure TfrmHiScTab.FormCreate(Sender: TObject);
var
  infile : textfile;
  x : integer;
begin
  blank_hiscore_table;
  hiscore_filename := ChangeFileExt( Application.ExeName, '.his' );
  if fileexists( hiscore_filename ) then
  begin
    { read in existing table }
    assignfile( infile, hiscore_filename );
    reset( infile );
    for x := 1 to max_hiscores do
    begin
      readln( infile, hiscores_table[x ].player_name );
      readln( infile, hiscores_table[x ].level );
      readln( infile, hiscores_table[x ].score );
    end;
    closefile( infile );
  end;
  display_table( 0 );
end; { FormCreate }
{----------------------------------------------------------}

procedure save_hiscore_table;
var
  outfile : textfile;
  x : integer;
begin
  assignfile( outfile, hiscore_filename );
  rewrite( outfile );
  for x := 1 to max_hiscores do
  begin
    writeln( outfile, hiscores_table[ x ].player_name );
    writeln( outfile, hiscores_table[ x ].level );
    writeln( outfile, hiscores_table[ x ].score );
  end;
  closefile( outfile );
end; { Save_hiscore_table }
{----------------------------------------------------------}

procedure TfrmHiScTab.ZapTable1Click(Sender: TObject);
begin
  if MessageDlg( 'Wipe out all scores in High Score Table' + #13 +
                 'And start again? Cannot be recovered.' + #13 +
                 'Are you sure?',
                 mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    blank_hiscore_table;
    save_hiscore_table;
    display_table( 0 );
  end;
end; { ZapTable1Click }
{----------------------------------------------------------}

procedure TfrmHiScTab.Close1Click(Sender: TObject);
// menu option "Game / Close" - used to close the
// form and return to main form.
begin
  close;
end; { Close1Click }
{----------------------------------------------------------}

procedure TfrmHiScTab.Howtoplay1Click(Sender: TObject);
begin
  //application.helpjump( 'Title' );
  showmessage( 'Sorry, there is no help file.');
end;
{----------------------------------------------------------}

procedure TfrmHiScTab.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  save_hiscore_table;
  Action := caFree;
end; { FormClose }
{----------------------------------------------------------}

end.
