unit main2;

{

  Simple_ed : A simple text-only editor.

  Author:     Peter E. Williams

  Date:       29 November 2000

  Version:    0.03a beta

  Email:      pwill@ausi.com

  Homepage:   http://www.angelfire.com/biz6/pwillcomputing/

  Freeware.

  History:
    0.01  - Original, 30 Oct 2000
    0.02a - 1 Nov 2000, recompiled without runtime packages.
            Procedure MemoMouseUp added to 'child' unit.
    0.02b - 27 Nov 2000, file open/save types extended to include .mac & *.*
    0.03a - 4 Dec 2000, modified to add files opened to the Window menu, and remove
            these entries when the files are closed.
}

interface

uses
  SysUtils, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, ExtCtrls, Menus,
  IniFiles, StdCtrls;

const
  max_recent_files = 8;

type
  TMainForm2 = class(TForm)
    SpeedBar: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    MainMenu1: TMainMenu;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    File1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Exit1: TMenuItem;
    Browse1: TMenuItem;
    NewFile1: TMenuItem;
    Edit1: TMenuItem;
    Undo1: TMenuItem;
    N1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Window1: TMenuItem;
    Tile1: TMenuItem;
    Cascade1: TMenuItem;
    ArrangeAll1: TMenuItem;
    N2: TMenuItem;
    New1: TMenuItem;
    ClearRecentFilesList1: TMenuItem;
    Close1: TMenuItem;
    procedure FileNew(Sender: TObject);
    function Save_File( var filename2 : string ) : boolean;
    procedure FileSave(Sender: TObject);
    function FileOpen( var filename2 : string ) : boolean;
    function getIniFileName : string;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure SaveFileHandler( sender : tobject );
    procedure OpenFileHandler( sender : tobject );
    procedure Manage_Recent_Files_List( filename1 : string );
    procedure SaveFile1Click(Sender: TObject);
    procedure WindowHandler( sender : tobject );
    procedure Change_filename( oldfilename, newfilename : string );
    procedure add_filename_to_Window_menu( filename1 : string );
    procedure OpenFile1Click(Sender: TObject);
    procedure EditUndo(Sender: TObject);
    procedure EditCut(Sender: TObject);
    procedure EditCopy(Sender: TObject);
    procedure EditPaste(Sender: TObject);
    procedure WindowTile(Sender: TObject);
    procedure WindowCascade(Sender: TObject);
    procedure WindowArrange(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure ClearRecentFilesList1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure MdiFormClosed(Sender: TObject; var Action: TCloseAction);
  end;

var
  MainForm2: TMainForm2;
  Recent_Files_List, Files_currently_open : tstringlist;
  untitled_count : integer;

implementation

uses
  Child;

{$R *.DFM}

{----------------------------------------------------------}

procedure TMainForm2.FileNew(Sender: TObject);
begin
  with TChildForm.Create(Self) do
  begin
    OnClose := MdiFormClosed;
    inc( untitled_count );
    Caption := 'untitled' + inttostr( untitled_count );
    filename1 := caption;
    filecaption := inttostr( Files_currently_open.count + 1 ) + ':' + filename1;
    tag := Files_currently_open.count;
    add_filename_to_Window_menu( filecaption );
  end;
end; { FileNew }
{----------------------------------------------------------}

function TMainForm2.Save_File( var filename2 : string ) : boolean;
begin
  if filename2 = '' then
  begin
    savedialog1.FileName := '*.txt';
    if not savedialog1.execute then
    begin
      result := false;
      exit;
    end;
    filename2 := savedialog1.filename;
  end;

  // write data to file
  with ActiveMDIChild as TChildForm do
    Memo.Lines.SaveToFile(filename2);

  showmessage( 'File Saved' + #13 +
               'Click OK to continue.');
  result := true;
end; { Save_File }
{----------------------------------------------------------}

procedure TMainForm2.FileSave(Sender: TObject);
var
  filename2 : string;
begin
  if ActiveMDIChild = NIL then
    exit;
  with ActiveMDIChild as TChildForm do
  begin
    if copy( filename1, 1, 8 ) = 'untitled' then
    begin
      filename2 := '';
      Save_File( filename2 );
      filename1 := filename2;
      change_filename( filecaption, filename2 );
      Timer1.interval := 10;
    end
    else
      Save_File( filename1 );
    manage_recent_files_list( filename1 );
  end;
end; { FileSave }
{----------------------------------------------------------}

function TMainForm2.FileOpen( var filename2 : string ) : boolean;
begin
  if filename2 = '' then
  begin
    opendialog1.FileName := '*.txt';
    if not opendialog1.execute then
    begin
      result := false;
      exit;
    end;
    filename2 := opendialog1.filename;
  end;

  if not FileExists( filename2 ) then
  begin
    showmessage( 'Error: File "' + filename2 + '" not found.' );
    result := false;
    exit;
  end;

  // read data from file
  with TChildForm.Create(Self) do
  begin
    OnClose := MdiFormClosed;
    Memo.Lines.LoadFromFile(FileName2);
    //    filename1 := filename2;
    filecaption := inttostr( Files_currently_open.count + 1 ) + ':' + filename2;
    filename1 := filename2;
    tag := Files_currently_open.count;
    add_filename_to_Window_menu( filecaption );
    //    Caption := FileName1;
  end;

  showmessage( 'File Opened' + #13 +
               'Click OK to continue.');
  result := true;
end; { FileOpen }
{----------------------------------------------------------}

function TMainForm2.getIniFileName : string;
var
  str1 : string;
begin
  str1 := Extractfilename( Application.ExeName );
  str1 := copy(Extractfilename( str1 ), 1, length(str1)-4);
  result := ExtractFilePath(Application.ExeName)+ str1 + '.ini';
end; { getIniFileName }
{----------------------------------------------------------}

procedure TMainForm2.FormClose(Sender: TObject; var Action: TCloseAction);
var
  ConfigIni : TIniFile;
  j : integer;
begin
  ConfigIni := TIniFile.Create( getIniFileName );
  try
    for j := 1 to max_recent_files do
      if Recent_Files_List.count > 0 then
      begin
        ConfigIni.WriteString( 'Recent Files','File ' + inttostr( j ),
                               Recent_Files_List.strings[ 0 ] );
        Recent_Files_list.delete( 0 );
      end
      else
        ConfigIni.WriteString( 'Recent Files','File ' + inttostr( j ), '' );
  finally
    ConfigIni.Free;
  end;
  Recent_Files_List.free;
  Files_currently_open.free;
end; { FormClose }
{----------------------------------------------------------}

procedure TMainForm2.FormCreate(Sender: TObject);
var
  ConfigIni : TIniFile;
  config_filename, str1 : string;
  j : integer;
begin
  Recent_Files_List := tstringlist.create;
  Files_currently_open := tstringlist.create;
  config_filename := GetIniFilename;
  untitled_count := 0;

  if FileExists( config_filename ) then
  begin
    ConfigIni := TIniFile.Create( config_filename );
    try
      for j := max_recent_files downto 1 do
      begin
        str1 := ConfigIni.ReadString( 'Recent Files',
                                      'File ' + inttostr( j ), '' );
        if str1 > '' then
          manage_Recent_Files_List( str1 );
      end;
    finally
      ConfigIni.Free;
    end;
  end;
  ClearRecentFilesList1.enabled := (Recent_Files_List.count > 0);
end; { FormCreate }
{----------------------------------------------------------}

procedure TMainForm2.SaveFileHandler( sender : tobject );
var
  filename1 : string;
begin
  // filename = '&x filename'
  filename1 := (sender as Tmenuitem).caption;
  filename1 := copy( filename1, 4, length( filename1 ) - 3 );
  if save_file( filename1 ) then
    manage_Recent_Files_List( filename1 );
end; { SaveFileHandler }
{----------------------------------------------------------}

procedure TMainForm2.OpenFileHandler( sender : tobject );
var
  filename1 : string;
begin
  // filename = '&x filename'
  filename1 := (sender as Tmenuitem).caption;
  filename1 := copy( filename1, 4, length( filename1 ) - 3 );
  if FileOpen( filename1 ) then
    Manage_Recent_Files_List( filename1 );
end; { OpenFileHandler }
{----------------------------------------------------------}

procedure TMainForm2.Manage_Recent_Files_List( filename1 : string );
var
  j : integer;
  amenuitem : tmenuitem;
  found : boolean;
begin
  j := 0;
  found := false;
  while (j < Recent_Files_List.count) and (not found) do
    if Recent_Files_List.strings[ j ] = filename1 then
      found := true
    else
      inc( j );

  if found then
    Recent_Files_List.delete( j );
  if Recent_Files_List.count = max_recent_files then
    Recent_Files_List.delete( Recent_Files_List.count - 1 );

  // abandon adding file to list if it doesn't exist.
  if not FileExists( filename1 ) then
    exit;
  // insert at the beginning of the list.
  Recent_Files_List.insert( 0, filename1 );

  if Save1.count > 1 then
    for j := 1 to Save1.count - 1 do
      Save1.delete( 1 );

  if Open1.count > 1 then
    for j := 1 to Open1.count - 1 do
      Open1.delete( 1 );

  for j := 0 to Recent_Files_List.count - 1 do
  begin
    amenuitem := tmenuitem.create( self );
    amenuitem.caption := '&' + inttostr( j + 1 ) + ' ' + Recent_Files_List.strings[ j ];
    amenuitem.OnClick := SaveFileHandler;
    Save1.add( amenuitem );

    amenuitem := tmenuitem.create( self );
    amenuitem.caption := '&' + inttostr( j + 1 ) + ' ' + Recent_Files_List.strings[ j ];
    amenuitem.OnClick := OpenFileHandler;
    Open1.add( amenuitem );
  end;

  ClearRecentFilesList1.enabled := (Recent_Files_List.count > 0);

end; { manage_Recent_Files_List }
{----------------------------------------------------------}

procedure TMainForm2.SaveFile1Click(Sender: TObject);
var
  filename2 : string;
begin
  filename2 := '';
  if save_file( filename2 ) then
  begin
    Manage_Recent_Files_List( filename2 );
    with ActiveMDIChild as TChildForm do
    begin
      filename1 := filename2;
      Save_File( filename2 );
      change_filename( filecaption, filename2 );
      Timer1.interval := 10;
    end;
  end;
end; { SaveFile1Click }
{----------------------------------------------------------}

procedure TMainForm2.WindowHandler( sender : tobject );
var
  filename2 : string;
  i, file_no : Integer;
  found : boolean;
begin
  filename2 := (sender as Tmenuitem).caption;

  file_no := 0;
  i := 0;
  found := false;
  while (i <= Files_currently_open.count - 1) and not found do
  begin
    if Files_currently_open.strings[ i ] =
      StringReplace( filename2, '&', '', [rfreplaceall]) then
    begin
      found := true;
      file_no := i;
    end;
    inc(i);
  end;

  if not found then
    exit;

  with MainForm2 do
    begin
      i := 0;
      found := false;
      while (i <= MDIChildCount-1) and not found do
      begin
        if MDIChildren[i].tag = file_no then
        begin
          MDIChildren[i].BringtoFront;
          found := true;
        end;
        inc(i);
      end;
    end;
end; { WindowHandler }
{----------------------------------------------------------}

procedure TMainForm2.Change_filename( oldfilename, newfilename : string );
var
  i, j, file_no : Integer;
  found, found2 : boolean;
begin
  file_no := 0;
  i := 0;
  found := false;
  while (i <= Files_currently_open.count - 1) and not found do
  begin
    if Files_currently_open.strings[ i ] =
      StringReplace( oldfilename, '&', '', [rfreplaceall]) then
    begin
      found := true;
      file_no := i;
    end;
    inc(i);
  end;

  if not found then
    exit;

  with MainForm2 do
    begin
      i := 0;
      found := false;
      while (i <= MDIChildCount-1) and not found do
      begin
        if MDIChildren[i].tag = file_no then
        begin
          with (MDIChildren[ i ] as tchildform) do
          begin
            filename1 := newfilename;
            j := 3;
            found2 := false;
            while (j <= Window1.count - 1) and not found2 do
            begin
              if oldfilename =
                StringReplace( Window1.items[ i ].caption, '&', '', [rfreplaceall]) then
              begin
                found2 := true;
                Window1.delete( i );
                filecaption := inttostr( file_no ) + ':' + newfilename;
                add_filename_to_Window_menu( filecaption );
              end;
              inc(i);
            end;
          end;
          found := true;
        end;
        inc(i);
      end;
    end;
end; { Change_filename }
{----------------------------------------------------------}

procedure TMainForm2.add_filename_to_Window_menu( filename1 : string );
var
  amenuitem : tmenuitem;
begin
  Files_currently_open.add( filename1 );
  amenuitem := tmenuitem.create( self );
  amenuitem.caption := filename1;
  amenuitem.OnClick := WindowHandler;
  Window1.add( amenuitem );
end; { add_filename_to_Window_menu }
{----------------------------------------------------------}

procedure TMainForm2.OpenFile1Click(Sender: TObject);
var
  filename1 : string;
begin
  filename1 := '';
  if fileopen( filename1 ) then
    Manage_Recent_Files_List( filename1 );
end; { RestoreGame1Click }
{----------------------------------------------------------}

procedure TMainForm2.ClearRecentFilesList1Click(Sender: TObject);
var
  j : integer;
begin
  for j := 0 to Recent_Files_List.count - 1 do
    Recent_Files_List.Delete( 0 );

  if Save1.count > 1 then
    for j := 1 to Save1.count - 1 do
      Save1.delete( 1 );

  if Open1.count > 1 then
    for j := 1 to Open1.count - 1 do
      Open1.delete( 1 );

  ClearRecentFilesList1.enabled := false;

end; { ClearRecentFilesList1Click }
{----------------------------------------------------------}

procedure TMainForm2.EditUndo(Sender: TObject);
begin
  if ActiveMDIChild = NIL then exit;
  with ActiveMDIChild as TChildForm do
    Memo.Perform(WM_UNDO, 0, 0);
end; { EditUndo }
{----------------------------------------------------------}

procedure TMainForm2.EditCut(Sender: TObject);
begin
  if ActiveMDIChild = NIL then exit;
  with ActiveMDIChild as TChildForm do
    Memo.CutToClipboard;
end; { EditCut }
{----------------------------------------------------------}

procedure TMainForm2.EditCopy(Sender: TObject);
begin
  if ActiveMDIChild = NIL then exit;
  with ActiveMDIChild as TChildForm do
    Memo.CopyToClipboard
end; { EditCopy }
{----------------------------------------------------------}

procedure TMainForm2.EditPaste(Sender: TObject);
begin
  if ActiveMDIChild = NIL then exit;
  with ActiveMDIChild as TChildForm do
    Memo.PasteFromClipboard;
end; { EditPaste }
{----------------------------------------------------------}

procedure TMainForm2.WindowTile(Sender: TObject);
begin
  Tile;
end; { WindowTile }
{----------------------------------------------------------}

procedure TMainForm2.WindowCascade(Sender: TObject);
begin
  Cascade;
end; { WindowCascade }
{----------------------------------------------------------}

procedure TMainForm2.WindowArrange(Sender: TObject);
begin
  ArrangeIcons;
end; { WindowArrange }
{----------------------------------------------------------}

procedure TMainForm2.Exit1Click(Sender: TObject);
begin
  Close;
end; { Exit1Click }
{----------------------------------------------------------}

procedure TMainForm2.Close1Click(Sender: TObject);
begin
  if ActiveMDIChild = NIL then
    exit;
  with ActiveMDIChild as TChildForm do
    close;
end; { Close1Click }
{----------------------------------------------------------}

procedure TMainForm2.MdiFormClosed(Sender: TObject; var Action: TCloseAction);
var
  filename2 : string;
  i : Integer;
  found : boolean;
begin
  filename2 := (ActiveMDIChild as tchildform).filecaption;
  i := 3;
  found := false;
  while (i <= Window1.count - 1) and not found do
  begin
    if filename2 =
      StringReplace( Window1.items[ i ].caption, '&', '', [rfreplaceall]) then
    begin
      found := true;
      Window1.delete( i );
    end;
    inc(i);
  end;
  action := caFree;
end; { MdiFormClosed }
{----------------------------------------------------------}

end.

