unit Child;

interface

uses
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Windows, StdCtrls, ExtCtrls;

type
  TChildForm = class(TForm)
    Memo: TMemo;
    Timer1: TTimer;
    procedure DisplayCounters;
    procedure FormCreate(Sender: TObject);
    procedure MemoKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Timer1Timer(Sender: TObject);
    procedure MemoMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
    filename1,
    filecaption : string;
  end;

var
  ChildForm: TChildForm;
  row, col : integer;

implementation

{$R *.DFM}

procedure TChildForm.DisplayCounters;
begin
  caption := Filecaption + format( ' Row: %d Column: %d',
                                 [Memo.CaretPos.y + 1,Memo.CaretPos.x + 1]);
end;
{----------------------------------------------------------}

procedure TChildForm.FormCreate(Sender: TObject);
begin
  DisplayCounters;
  timer1.interval := 10;
end;
{----------------------------------------------------------}

procedure TChildForm.MemoKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  DisplayCounters;
end;
{----------------------------------------------------------}

procedure TChildForm.Timer1Timer(Sender: TObject);
begin
  timer1.interval := 0;
  DisplayCounters;
end;
{----------------------------------------------------------}

procedure TChildForm.MemoMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  DisplayCounters;
end;
{----------------------------------------------------------}

end.
