unit hiscores;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, congrats, Menus, shellapi;

type
  THiScTab = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    OK_button: TButton;
    Label6: TLabel;
    No1: TLabel;
    Name1: TLabel;
    Turns1: TLabel;
    Pieces1: TLabel;
    Score1: TLabel;
    No2: TLabel;
    Name2: TLabel;
    Turns2: TLabel;
    Pieces2: TLabel;
    Score2: TLabel;
    No3: TLabel;
    Name3: TLabel;
    Turns3: TLabel;
    Pieces3: TLabel;
    Score3: TLabel;
    No4: TLabel;
    Name4: TLabel;
    Turns4: TLabel;
    Pieces4: TLabel;
    Score4: TLabel;
    No5: TLabel;
    Name5: TLabel;
    Turns5: TLabel;
    Pieces5: TLabel;
    Score5: TLabel;
    No6: TLabel;
    Name6: TLabel;
    Turns6: TLabel;
    Pieces6: TLabel;
    Score6: TLabel;
    No7: TLabel;
    Name7: TLabel;
    Turns7: TLabel;
    Pieces7: TLabel;
    Score7: TLabel;
    No8: TLabel;
    Name8: TLabel;
    Turns8: TLabel;
    Pieces8: TLabel;
    Score8: TLabel;
    No9: TLabel;
    Name9: TLabel;
    Turns9: TLabel;
    Pieces9: TLabel;
    Score9: TLabel;
    No10: TLabel;
    Name10: TLabel;
    Turns10: TLabel;
    Pieces10: TLabel;
    Score10: TLabel;
    MainMenu1: TMainMenu;
    Table: TMenuItem;
    ZapTable1: TMenuItem;
    Close1: TMenuItem;
    Help1: TMenuItem;
    Howtoplay1: TMenuItem;
    About1: TMenuItem;
    Random1: TMenuItem;
    Wheel1: TMenuItem;
    Website1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure AddScore( winner : char;
                        player_count, turn_no, score : integer;
                        player_x_is_human : boolean;
                        var rank : integer );
    procedure display_table( rank : integer );
    procedure ZapTable1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure Howtoplay1Click(Sender: TObject);
    procedure AboutRandom1Click(Sender: TObject);
    procedure AboutWheel1Click(Sender: TObject);
    procedure Website1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  HiScTab: THiScTab;

implementation

{$R *.DFM}

uses about, unit3;

const
  max_hiscores = 10;

type
  hiscores_type = array[ 1..max_hiscores ] of record
                    player_name : string;
                    turns, pieces, score : longint;
                  end;
var
  hiscores_table : hiscores_type;
{----------------------------------------------------------}

function FileExists(FileName: string): Boolean;

{ Boolean function that returns True if the file exists; otherwise,
  it returns False. Closes the file if it exists. }
var
 F: file;
begin
  {$I-}
  AssignFile(F, FileName);
  FileMode := 0;  { Set file access to read only }
  Reset(F);
  CloseFile(F);
  {$I+}
  FileExists := (IOResult = 0) and (FileName <> '');
end;  { FileExists }
{----------------------------------------------------------}

procedure thisctab.display_table( rank : integer );
var
  j : integer;
begin
  Name1.Caption   := hiscores_table[1 ].player_name;
  Turns1.Caption  := inttostr( hiscores_table[1 ].turns );
  Pieces1.Caption := inttostr( hiscores_table[1 ].pieces );
  Score1.Caption  := inttostr( hiscores_table[1 ].score );
  Name2.Caption   := hiscores_table[2 ].player_name;
  Turns2.Caption  := inttostr( hiscores_table[2 ].turns );
  Pieces2.Caption := inttostr( hiscores_table[2 ].pieces );
  Score2.Caption  := inttostr( hiscores_table[2 ].score );
  Name3.Caption   := hiscores_table[3 ].player_name;
  Turns3.Caption  := inttostr( hiscores_table[3 ].turns );
  Pieces3.Caption := inttostr( hiscores_table[3 ].pieces );
  Score3.Caption  := inttostr( hiscores_table[3 ].score );
  Name4.Caption   := hiscores_table[4 ].player_name;
  Turns4.Caption  := inttostr( hiscores_table[4 ].turns );
  Pieces4.Caption := inttostr( hiscores_table[4 ].pieces );
  Score4.Caption  := inttostr( hiscores_table[4 ].score );
  Name5.Caption   := hiscores_table[5 ].player_name;
  Turns5.Caption  := inttostr( hiscores_table[5 ].turns );
  Pieces5.Caption := inttostr( hiscores_table[5 ].pieces );
  Score5.Caption  := inttostr( hiscores_table[5 ].score );
  Name6.Caption   := hiscores_table[6 ].player_name;
  Turns6.Caption  := inttostr( hiscores_table[6 ].turns );
  Pieces6.Caption := inttostr( hiscores_table[6 ].pieces );
  Score6.Caption  := inttostr( hiscores_table[6 ].score );
  Name7.Caption   := hiscores_table[7 ].player_name;
  Turns7.Caption  := inttostr( hiscores_table[7 ].turns );
  Pieces7.Caption := inttostr( hiscores_table[7 ].pieces );
  Score7.Caption  := inttostr( hiscores_table[7 ].score );
  Name8.Caption   := hiscores_table[8 ].player_name;
  Turns8.Caption  := inttostr( hiscores_table[8 ].turns );
  Pieces8.Caption := inttostr( hiscores_table[8 ].pieces );
  Score8.Caption  := inttostr( hiscores_table[8 ].score );
  Name9.Caption   := hiscores_table[9 ].player_name;
  Turns9.Caption  := inttostr( hiscores_table[9 ].turns );
  Pieces9.Caption := inttostr( hiscores_table[9 ].pieces );
  Score9.Caption  := inttostr( hiscores_table[9 ].score );
  Name10.Caption   := hiscores_table[10 ].player_name;
  Turns10.Caption  := inttostr( hiscores_table[10 ].turns );
  Pieces10.Caption := inttostr( hiscores_table[10 ].pieces );
  Score10.Caption  := inttostr( hiscores_table[10 ].score );
  for j := 1 to max_hiscores do
    if j = rank then
    begin
      tlabel(findcomponent( 'No' + inttostr( rank ))).Font.Color     := clblue;
      tlabel(findcomponent( 'Name' + inttostr( rank ))).Font.Color   := clblue;
      tlabel(findcomponent( 'Turns' + inttostr( rank ))).Font.Color  := clblue;
      tlabel(findcomponent( 'Pieces' + inttostr( rank ))).Font.Color := clblue;
      tlabel(findcomponent( 'Score' + inttostr( rank ))).Font.Color  := clblue;
    end
    else
    begin
      tlabel(findcomponent( 'No' + inttostr( j ))).Font.Color     := clblack;
      tlabel(findcomponent( 'Name' + inttostr( j ))).Font.Color   := clblack;
      tlabel(findcomponent( 'Turns' + inttostr( j ))).Font.Color  := clblack;
      tlabel(findcomponent( 'Pieces' + inttostr( j ))).Font.Color := clblack;
      tlabel(findcomponent( 'Score' + inttostr( j ))).Font.Color  := clblack;
    end;
end; { display_table }
{----------------------------------------------------------}

procedure thisctab.AddScore( winner : char;
                             player_count, turn_no, score : integer;
                             player_x_is_human : boolean;
                             var rank : integer );
var
  x : integer;
  found : boolean;

{..........................................................}

procedure move_scores_down( position : integer );
var
  j : integer;
begin
  for j := 10 downto position + 1 do
  begin
    hiscores_table[ j ].turns       := hiscores_table[ j - 1 ].turns;
    hiscores_table[ j ].pieces      := hiscores_table[ j - 1 ].pieces;
    hiscores_table[ j ].score       := hiscores_table[ j - 1 ].score;
    hiscores_table[ j ].player_name := hiscores_table[ j - 1 ].player_name;
  end;
end; { move_scores_down }
{..........................................................}

begin
  x := 1;
  rank := 0;
  found := false;
  while (x <= max_hiscores) and not found do
  begin
    if score > hiscores_table[ x ].score then
    begin
      found := true;
      rank := x;
      if x < 10 then
        move_scores_down( x );
      hiscores_table[ x ].turns := turn_no;
      hiscores_table[ x ].pieces := player_count;
      hiscores_table[ x ].score := score;
      if (( player_x_is_human ) and (winner = 'X')) or
         ( winner = 'O' ) then
      begin
        get_player_name := tget_player_name.create( nil );
        try
          get_player_name.showModal;
          hiscores_table[ x ].player_name := get_player_name.edit1.text;
        finally
          get_player_name.release;
        end;
      end
      else
        hiscores_table[ x ].player_name := 'The Computer!!!';
      display_table( rank );
    end;
    inc( x );
  end;
end; { AddScore }
{----------------------------------------------------------}

procedure blank_hiscore_table;
var
  x : integer;
begin
  { --- blank the table --- }
  for x := 1 to max_hiscores do
  begin
    hiscores_table[ x ].player_name := '';
    hiscores_table[ x ].turns := 0;
    hiscores_table[ x ].pieces := 0;
    hiscores_table[ x ].score := 0;
  end;
end; { blank_hiscore_table }
{----------------------------------------------------------}

procedure THiScTab.FormCreate(Sender: TObject);
var
  infile : textfile;
  x : integer;
begin
  blank_hiscore_table;
  if fileexists( 'nuclear.his' ) then
  begin
    { read in existing table }
    assignfile( infile, 'nuclear.his' );
    reset( infile );
    for x := 1 to max_hiscores do
    begin
      readln( infile, hiscores_table[x ].player_name );
      readln( infile, hiscores_table[x ].turns );
      readln( infile, hiscores_table[x ].pieces );
      readln( infile, hiscores_table[x ].score );
    end;
    closefile( infile );
  end;
  display_table( 0 );
end; { FormCreate }
{----------------------------------------------------------}

procedure save_hiscore_table;
var
  outfile : textfile;
  x : integer;
begin
  assignfile( outfile, 'nuclear.his' );
  rewrite( outfile );
  for x := 1 to max_hiscores do
  begin
    writeln( outfile, hiscores_table[ x ].player_name );
    writeln( outfile, hiscores_table[ x ].turns );
    writeln( outfile, hiscores_table[ x ].pieces );
    writeln( outfile, hiscores_table[ x ].score );
  end;
  closefile( outfile );
end; { Save_hiscore_table }
{----------------------------------------------------------}

procedure THiScTab.FormDestroy(Sender: TObject);
begin
  save_hiscore_table;
end; { FormDestroy }
{----------------------------------------------------------}

procedure THiScTab.ZapTable1Click(Sender: TObject);
begin
  if MessageDlg( 'Wipe out all scores in High Score Table' + #13 +
                 'And start again? Cannot be recovered.' + #13 +
                 'Are you sure?',
                 mtConfirmation, [mbYes, mbNo], 0) = mrYes then
  begin
    blank_hiscore_table;
    save_hiscore_table;
    display_table( 0 );
  end;
end; { ZapTable1Click }
{----------------------------------------------------------}

procedure THiScTab.Close1Click(Sender: TObject);
// menu option "Game / Close" - used to close the
// form and return to main form.
begin
  close;
end; { Close1Click }
{----------------------------------------------------------}

procedure THiScTab.Howtoplay1Click(Sender: TObject);
begin
  application.helpjump( 'Title' );
end;
{----------------------------------------------------------}

procedure THiScTab.AboutRandom1Click(Sender: TObject);
begin
  want_random := true;
  AboutForm := tAboutForm.create( nil );
  try
    AboutForm.showmodal;
  finally
    AboutForm.release;
  end;
end; { AboutRandom1Click }
{----------------------------------------------------------}

procedure THiScTab.AboutWheel1Click(Sender: TObject);
begin
  want_random := false;
  AboutForm := tAboutForm.create( nil );
  try
    AboutForm.showmodal;
  finally
    AboutForm.release;
  end;
end; { AboutWheel1Click }
{----------------------------------------------------------}

procedure THiScTab.Website1Click(Sender: TObject);
begin
  if ShellExecute(Handle, nil, 'http://members.fortunecity.com/pew', nil, nil, SW_SHOWNORMAL) <= 32 then
    showmessage( 'Error: unable to open website:' + #13 +
    'http://members.fortunecity.com/pew');
end; { Website1Click } 
{----------------------------------------------------------}

end.
