unit about;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus;

type
  TAboutForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    OK_button: TButton;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    { Public declarations }
  end;

var
  AboutForm: TAboutForm;

implementation                                                                       

{$R *.DFM}

uses Unit3;

procedure TAboutForm.Createparams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
    Style := (Style or WS_POPUP) and (not WS_DLGFRAME);
end;

procedure TAboutForm.FormCreate(Sender: TObject);
const
  random_factor = 100;
  random_radius = 100;
  cog_radius = 145;
var
  R: HRgn;
  P: array [0..359] of TPoint;
  x, y, theta, randy,
  centre_x, centre_y : integer;
begin
  width := screen.width;
  height := screen.height;
  centre_x := screen.width div 2;
  centre_y := screen.height div 2;

  // centre all of the components horizontally, offset 10 pixels.
  Label1.Left := centre_x - Label1.Width div 2 - 5;
  Label2.Left := centre_x - Label2.Width div 2 - 5;
  Label3.Left := centre_x - Label3.Width div 2 - 5;
  Label4.Left := centre_x - Label4.Width div 2 - 5;
  Label5.Left := centre_x - Label5.Width div 2 - 5;
  OK_button.Left := centre_x - OK_button.Width div 2 - 5;

  Label1.Top := centre_y - 120;
  Label2.Top := centre_y - 80;
  Label3.Top := centre_y - 60;
  Label4.Top := centre_y - 40;
  Label5.Top := centre_y;
  OK_button.Top := centre_y + 40;

  for theta := 0 to 359 do
  begin

    if want_random then
    begin
      randy := random( random_factor ) * (random( 3 ) - 1);
      x := centre_x + round(random_radius * cos(theta)) +
           randy;
      randy := random( random_factor ) * (random( 3 ) - 1);
      y := centre_y + round(random_radius * sin(theta)) +
           randy;
    end
    else
    begin
      if odd( theta ) then
        randy := cog_radius
      else
        randy := -1 * cog_radius;
      x := centre_x + round( cog_radius * cos( theta + randy ));
      y := centre_y + round( cog_radius * sin( theta + randy ));
    end;

    p[theta]:=point(x,y);
  end;
//  R := CreatePolygonRgn (P , 360 , ALTERNATE);
  R := CreatePolygonRgn (P , 360 , WINDING);
  SetWindowRgn(Handle, R , TRUE);
end;

end.
