unit macarena;

{
  Do_the_Macarena 0.2
    v0.1 [ 21 May 2002 ] - original Delphi version
    v0.2 [ 16 Jun 2002 ] - Uses TThreadedTimer instead of standard TTimer.

  This Delphi version for D5 by:
  Peter E. Williams (pew@pcug.org.au  (or)  pwill@ausi.com)
  based on code in SWAG snippet.

    Easysize unit used for the FormResizer component to resize
      Mr Ascii as you resize your form (you can just omit the unit
      and FormResizer component if you don't have it). I found it
      at http://www.delphi32.com

    TFormResizer 2.0              
       http://www.delphi32.com/vcl/1289/

    TThreadedTimer 1.2a
       http://www.delphi32.com/vcl/3086/

    NB(2) - Spin is a sample unit that comes with D5 and the unit is
      located in the Delphi .../source/samples directory and it
      is used for the TSpinEdit to change the timer interval.

  Programmed by: Jonas Emil M. Enriquez (jeme@gsilink.com)
  Based from the text graphics of Buhrnheim (buhrn@DADOSNET.COM.BR)
}


interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Spin, Easysize, ThdTimer;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    SpinEdit1: TSpinEdit;
    ThreadedTimer1: TThreadedTimer;
    Label2: TLabel;
    FormResizer1: TFormResizer;
    procedure FormCreate(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ThreadedTimer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

Var
  Form1: TForm1;

Type
  STR03 = STRING[3];
Const
  MaxIndex = 16;
  Dance : array[1..3,1..MaxIndex] of STR03 =
    ((' o ', ' o ', ' o ', ' o ', ' o ', ' o ', '<o ', '<o>', ' o>', ' o ', ' o ', ' o ', ' o ', ' o ', ' o ', ' o '),
     ('^|\', '^|^', 'v|^', 'v|v', '|/v', '|X|', ' \|', ' | ', ' \ ', ' x ', '</ ', '<|>', '</>', '<\>', '<)>', ' |\'),
     (' /\', ' >\', '/< ', ' >\', '/< ', ' >\', '/< ', ' >\', '/< ', ' >\', '/< ', ' >\', '/< ', ' >\', ' >>', ' L '));
Var
  Index : integer;

implementation

{$R *.DFM}

{----------------------------------------------------------------}

procedure TForm1.FormCreate(Sender: TObject);
begin
  ThreadedTimer1.enabled := false;
  Form1.Caption := 'Mr Ascii dancing Macarena...';
  FormResizer1.InitializeForm;
  FormResizer1.ResizeFonts := true;
  Label1.Font.Name := 'Fixedsys';
  Label1.Font.Size := 36;
  SpinEdit1.MaxValue := 5000;
  SpinEdit1.MinValue := 20;
  SpinEdit1.Increment := 10;
  // start at 200msec delay
  ThreadedTimer1.Interval := 200;
  SpinEdit1.Value := ThreadedTimer1.Interval;
  Index := 1;
  ThreadedTimer1.enabled := true;
end;
{----------------------------------------------------------------}

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
  ThreadedTimer1.Interval := SpinEdit1.Value;
end;
{----------------------------------------------------------------}

procedure TForm1.FormResize(Sender: TObject);
begin
  FormResizer1.ResizeAll;
end;
{----------------------------------------------------------------}

procedure TForm1.ThreadedTimer1Timer(Sender: TObject);
begin
  ThreadedTimer1.enabled := false;
  Label1.Caption := Dance[ 1,index ] + #13 +
                    Dance[ 2,index ] + #13 +
                    Dance[ 3,index ];
  index := (index mod MaxIndex) + 1;
  ThreadedTimer1.enabled := true;
end;
{----------------------------------------------------------------}

end.
