{-----------------------------------------------------------------------
*  TLabel3D v1.0                                                       *
*                                                                      *
*    Copyright  1996 InforTech, Inc.  All Rights Reserved.            *
*    By: Steven Costa Martins                                          *
*    E-MAIL: steven@mail.telepac.pt                                    *
*    Home Page:                                                        *
*    http://www.geocities.com/SiliconValley/Park/7619/                 *
*                                                                      *
*    Last Modification: 18 Set 1996, 17:41 PM                          *
------------------------------------------------------------------------
*  You are not allowed to redistribute this                            *
*  code or any part of it                                              *
------------------------------------------------------------------------}

unit Label3D;

interface

{$A+} { Word align data }
{$B-} { Complete Boolean Evaluation Directive }
{$D-} { Debug Information Directive }
{$L-} { Local Symbol Information Directive }
{$R-} { Range checking off }
{$S-} { Stack checking off }
{$T-} { We don't need (nor want) this type checking! }

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, DsgnIntf;

type
  TAboutLabel3DProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;
{------------------------------------------------------------------------}
  TCaptionStyle = (csNone, csRaised, csHeavyRaised, csRecessed, csHeavyRecessed);
  TLabel3D = class(TLabel)
  private
    FAbout: TAboutLabel3DProperty;
    FCaptionStyle: TCaptionStyle;
    procedure DoDrawText(var Rect: TRect; Flags: Word);
  protected
    procedure Paint; override;
    procedure SetCaptionStyle(Value: TCaptionStyle);
  public
    constructor Create(AOwner: TComponent); override;
  published
    property About: TAboutLabel3DProperty read FAbout write FAbout;
    property CaptionStyle: TCaptionStyle read FCaptionStyle write SetCaptionStyle default csRecessed;
  end;
{------------------------------------------------------------------------}

procedure Register;

implementation

constructor TLabel3D.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FCaptionStyle := csRecessed;
  Height := 16;
  Width := 62;
end;

procedure TLabel3D.SetCaptionStyle(Value: TCaptionStyle);
begin
  if Value <> FCaptionStyle then
  begin
    FCaptionStyle := Value;
    Invalidate;
  end;
end; { TLabel3D.SetCaptionStyle }

procedure TLabel3D.DoDrawText(var Rect: TRect; Flags: Word);
var
  Text       : array[ 0..255 ] of Char;
  TmpRect    : TRect;
  UpperColor : TColor;
  LowerColor : TColor;
begin
  GetTextBuf(Text, SizeOf(Text));
  if (Flags and DT_CALCRECT <> 0) and ((Text[0] = #0) or ShowAccelChar
      and (Text[0] = '&') and (Text[1] = #0)) then
    StrCopy(Text, ' ');

  if not ShowAccelChar then
    Flags := Flags or DT_NOPREFIX;

  Canvas.Font := Font;

  UpperColor := clBtnHighlight;
  LowerColor := clBtnShadow;

  if (FCaptionStyle = csRecessed) or (FCaptionStyle = csHeavyRecessed) then
  begin
    UpperColor := clBtnShadow;
    LowerColor := clBtnHighlight;
  end;

  if FCaptionStyle in [csRaised, csHeavyRaised, csRecessed, csHeavyRecessed] then
  begin
    If FCaptionStyle in [csRecessed, csHeavyRecessed, csHeavyRaised] then Begin
      TmpRect := Rect;
      OffsetRect( TmpRect, 1, 1 );
      Canvas.Font.Color := LowerColor;
      DrawText(Canvas.Handle, Text, StrLen(Text), TmpRect, Flags);
    End;
    If FCaptionStyle in [csRaised, csHeavyRecessed, csHeavyRaised] then Begin
      TmpRect := Rect;
      OffsetRect( TmpRect, -1, -1 );
      Canvas.Font.Color := UpperColor;
      DrawText(Canvas.Handle, Text, StrLen(Text), TmpRect, Flags);
    End;
  end;

  Canvas.Font.Color := Font.Color;
  if not Enabled then
    Canvas.Font.Color := clGrayText;
  DrawText(Canvas.Handle, Text, StrLen(Text), Rect, Flags);
end; { TLabel3D.DoDrawText }

procedure TLabel3D.Paint;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);
var
  Rect: TRect;
begin
  with Canvas do
  begin
    if not Transparent then
    begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(ClientRect);
    end;
    Brush.Style := bsClear;
    Rect := ClientRect;
    DoDrawText( Rect, ( DT_EXPANDTABS or DT_WORDBREAK ) or
                Alignments[ Alignment ] );
  end;
end; { TLabel3D.Paint }

{------------------------------------------------------------------------}

(*
 * About property
 *)

procedure TAboutLabel3DProperty.Edit;
var
	msg: string;
const
	carriage_return = chr(13);
begin
	msg := 'Label3D Component v1.0';
  AppendStr(msg, carriage_return);
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'Copyright  1996 InforTech, Inc.  All Rights Reserved.');
  AppendStr(msg, carriage_return);
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'Developed by:');
  AppendStr(msg, carriage_return);
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'Steven Costa Martins');
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'E-Mail: steven@mail.telepac.pt');
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'Home Page:');
  AppendStr(msg, carriage_return);
  AppendStr(msg, 'http://www.geocities.com/SiliconValley/Park/7619/');
  AppendStr(msg, carriage_return);
  ShowMessage(msg);
end;

function TAboutLabel3DProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAboutLabel3DProperty.GetValue: string;
begin
  Result := 'Click on...for About box';
end;

{------------------------------------------------------------------------}
procedure Register;
begin
  RegisterComponents( 'InforTech', [TLabel3D] );
  {Register the about box property editor}
  RegisterPropertyEditor(TypeInfo(TAboutLabel3DProperty),
      TLabel3D, 'ABOUT', TAboutLabel3DProperty);
end;
{------------------------------------------------------------------------}

end.
