Unit weights_unit;

Interface

Uses
  Windows, Messages, sysutils, Classes, Graphics,
  Controls, Forms, Grids, Aligrid,
  gomoku_common_unit;

Type
  TWeights_form = class(tform)
    weights: TStringAlignGrid;
    procedure Adjust_StringGrid_size(
      var sg : tStringAlignGrid );
    procedure fix_form_elements;
    procedure FormCreate(Sender: TObject);
    procedure init;
    procedure highlight_highest_weights( X, Y : integer );
    procedure weightsKeyPress(Sender: TObject; var Key: Char);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  Private
    { Private declarations }
    offset : integer;
    gr1 : TGridRect;
    highlight_brush : tbrush;
  Public
    { Public declarations }
  End;

var
  Weights_form: tWeights_form;

Implementation

{$R *.DFM}

{----------------------------------------------------------}

procedure tWeights_form.Adjust_StringGrid_size(
  var sg : tStringAlignGrid );
const
  YeOldeCellKudgeFactor = 3;
begin
  with SG do
    begin
      Width := (ColCount)*DefaultColWidth +
               GridLineWidth * (ColCount)+
               YeOldeCellKudgeFactor;

      Height := (RowCount)*DefaultRowHeight +
               GridLineWidth * (RowCount)+
               YeOldeCellKudgeFactor;
    end;
end; { Adjust_StringGrid_size }
{---------------------------------------------------------}

procedure tWeights_form.fix_form_elements;
var
  Q, Q2 : integer;
begin
  with Weights do
  begin
    if want_row_col_numbers then
    begin
      FixedRows := 1;
      FixedCols := 1;
      RowCount := Max_y + 1;
      ColCount := Max_x + 1;
      // move the Weights
      for Q := Max_X downto 1 do
        for Q2 := Max_Y downto 1 do
          Weights.cells[ Q, Q2 ] := Weights.cells[ Q-1, Q2-1 ];
      Weights.cells[ 0,0 ] := '';
      for Q := 1 to Max_x do
        cells[ Q, 0 ] := inttostr(Q);
      for Q := 1 to Max_y do
        cells[ 0, Q ] := inttostr(Q);
    end
    else
    begin
      if (RowCount > Max_Y) and (ColCount > Max_X) then
      begin
       // move the Weights
        for Q := 1 to Max_X + 1 do
          for Q2 := 1 to Max_Y + 1 do
          begin
            if (Q = Max_X + 1) and (Q2 = Max_Y + 1) then
              Weights.cells[ Q-1, Q2-1 ] := ''
            else
              Weights.cells[ Q-1, Q2-1 ] := Weights.cells[ Q, Q2 ];
          end;
      end;
      FixedRows := 0;
      FixedCols := 0;
      RowCount := Max_y;
      ColCount := Max_x;
    end;
  end;
  Adjust_StringGrid_size( Weights );
  // this width assignment statement will only work if the
  // screen resolution permits (mine does not -- mine is 800x600 = 812w).
  width := Weights.left + Weights.width + 20;
  height := Weights.top + Weights.height + 30;

  if want_row_col_numbers then
    offset := 1
  else
    offset := 0;
end; { fix_form_elements }
{---------------------------------------------------------}

procedure TWeights_form.FormCreate(Sender: TObject);
begin
  gr1.Left := -1;
  gr1.Top := -1;
  gr1.Bottom := -1;
  gr1.Right := -1;
  Weights.Selection := gr1;

  // now set the cell highlight colour
  highlight_brush := tbrush.create;
  highlight_brush.color := clYellow;
end; { FormCreate }
{---------------------------------------------------------}

procedure TWeights_Form.init;
var
  q : integer;
begin
  fix_form_elements;

  // assumes that weights have been calculated
  for q := 1 to Max_X * Max_Y do
    if want_row_col_numbers then
      Weights.cells[ move_weights[ q ].x1,
        move_weights[ q ].y1 ] :=
        inttostr(move_weights[ q ].weight)
    else
      Weights.cells[ move_weights[ q ].x1 - 1,
        move_weights[ q ].y1 - 1 ] :=
        inttostr(move_weights[ q ].weight);
end; { init }
{---------------------------------------------------------}

procedure TWeights_Form.highlight_highest_weights( X, Y : integer );
begin
  if want_row_col_numbers then
    Weights.CellBrush[ X,Y ] := highlight_brush
  else
    Weights.CellBrush[ X-1,Y-1 ] := highlight_brush;
  refresh;
end; { highlight_move }
{---------------------------------------------------------}

procedure TWeights_form.weightsKeyPress(Sender: TObject; var Key: Char);
begin
  case key of
    chr(vk_escape) :
      close;

    'w' : // show the width & height of stringgrid and form
          // useful for debugging to see if you have designed them at the correct size
      caption := format( 'sg_width=%d, sg_height=%d, fm_width=%d, fm_height=%d',
      [weights.width,weights.height,width,height]);
      
  end; { case }
  key := #0;
end; { weightsKeyPress }
{---------------------------------------------------------}

procedure TWeights_form.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end; { FormClose }
{---------------------------------------------------------}

end.
