unit statistics_tests_unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TStatistics_tests_form = class(TForm)
    Panel2: TPanel;
    Panel1: TPanel;
    Weigh_4_Blocked1: TCheckBox;
    Ignore_4_Blocked1: TCheckBox;
    co_ord_weights1: TCheckBox;
    Panel3: TPanel;
    Weigh_4_Blocked2: TCheckBox;
    Ignore_4_Blocked2: TCheckBox;
    No_co_ord_weights1: TCheckBox;
    Defence_first: TCheckBox;
    Panel4: TPanel;
    Weigh_4_Blocked3: TCheckBox;
    Ignore_4_Blocked3: TCheckBox;
    co_ord_weights2: TCheckBox;
    Panel5: TPanel;
    Weigh_4_Blocked4: TCheckBox;
    Ignore_4_Blocked4: TCheckBox;
    No_co_ord_weights2: TCheckBox;
    offence_first: TCheckBox;
    ok_button: TButton;
    Button1: TButton;
    test_selected_label: TLabel;
    times_to_do_each_test: TEdit;
    Label2: TLabel;
    procedure count_tests;
    procedure set_statistics_tests;
    procedure set_checkboxes;
    procedure ok_buttonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Defence_firstClick(Sender: TObject);
    procedure offence_firstClick(Sender: TObject);
    procedure co_ord_weights1Click(Sender: TObject);
    procedure co_ord_weights2Click(Sender: TObject);
    procedure No_co_ord_weights1Click(Sender: TObject);
    procedure No_co_ord_weights2Click(Sender: TObject);
    procedure Weigh_4_Blocked1Click(Sender: TObject);
    procedure Weigh_4_Blocked2Click(Sender: TObject);
    procedure Weigh_4_Blocked3Click(Sender: TObject);
    procedure Weigh_4_Blocked4Click(Sender: TObject);
    procedure Ignore_4_Blocked1Click(Sender: TObject);
    procedure Ignore_4_Blocked2Click(Sender: TObject);
    procedure Ignore_4_Blocked3Click(Sender: TObject);
    procedure Ignore_4_Blocked4Click(Sender: TObject);
  private
    { Private declarations }
    parent_changing : boolean;
  public
    { Public declarations }
    NumberTestsSelected : integer;
  end;

var
  Statistics_tests_form: TStatistics_tests_form;

implementation

{$R *.DFM}

uses gomoku_common_unit;

{----------------------------------------------------------}

procedure TStatistics_tests_form.count_tests;
var
  x,y,z : boolean;
begin
  NumberTestsSelected := 0;
  for x := false to true do
    for y := false to true do
      for z := false to true do
        if statistics[ x,y,z ].perform_test then
          inc(NumberTestsSelected);
  test_selected_label.caption := 'You have ' +
    inttostr( NumberTestsSelected ) + ' tests selected.';
end; { count_tests }
{----------------------------------------------------------}

procedure TStatistics_tests_form.set_checkboxes;
begin
  // defence first
  defence_first.checked :=
    statistics[ true, true, true ].perform_test or
    statistics[ true, true, false ].perform_test or
    statistics[ true, false, true ].perform_test or
    statistics[ true, false, false ].perform_test;

  // defence first
  // .. co-ord weights
  co_ord_weights1.checked :=
    statistics[ true, true, true ].perform_test or
    statistics[ true, true, false ].perform_test;

  // defence first
  // .. co-ord weights
  // .... weigh 4 blocked
  weigh_4_blocked1.checked :=
    statistics[ true, true, true ].perform_test;

  // defence first
  // .. co-ord weights
  // .... ignore 4 blocked
  ignore_4_blocked1.checked :=
    statistics[ true, true, false ].perform_test;

  // defence first
  // .. no co-ord weights
  no_co_ord_weights1.checked :=
    statistics[ true, false, true ].perform_test or
    statistics[ true, false, false ].perform_test;

  // defence first
  // .. no co-ord weights
  // .... weigh 4 blocked
  weigh_4_blocked2.checked :=
    statistics[ true, false, true ].perform_test;

  // defence first
  // .. no co-ord weights
  // .... ignore 4 blocked
  ignore_4_blocked2.checked :=
    statistics[ true, false, false ].perform_test;

  // offence first
  offence_first.checked :=
    statistics[ false, true, true ].perform_test or
    statistics[ false, true, false ].perform_test or
    statistics[ false, false, true ].perform_test or
    statistics[ false, false, false ].perform_test;

  // offence first
  // .. co-ord weights
  co_ord_weights2.checked :=
    statistics[ false, true, true ].perform_test or
    statistics[ false, true, false ].perform_test;

  // offence first
  // .. co-ord weights
  // .... weigh 4 blocked
  weigh_4_blocked3.checked :=
    statistics[ false, true, true ].perform_test;

  // offence first
  // .. co-ord weights
  // .... ignore 4 blocked
  ignore_4_blocked3.checked :=
    statistics[ false, true, false ].perform_test;

  // offence first
  // .. no co-ord weights
  no_co_ord_weights2.checked :=
    statistics[ false, false, true ].perform_test or
    statistics[ false, false, false ].perform_test;

  // offence first
  // .. no co-ord weights
  // .... weigh 4 blocked
  weigh_4_blocked4.checked :=
    statistics[ false, false, true ].perform_test;

  // offence first
  // .. no co-ord weights
  // .... ignore 4 blocked
  ignore_4_blocked4.checked :=
    statistics[ false, false, false ].perform_test;
end; { set_checkboxes }
{----------------------------------------------------------}

procedure TStatistics_tests_form.set_statistics_tests;
begin
  if parent_changing then
    exit;

  // !!! IMPORTANT !!! simply changing a checkbox's checked property
  // is enough to trigger an OnClick event ... that is why the
  // above exit statement is needed.

  // defence first
  // .. co-ord weights
  // .... weigh 4 blocked
  statistics[ true, true, true ].perform_test :=
    defence_first.checked and
    co_ord_weights1.checked and
    weigh_4_blocked1.checked;

  // .... ignore 4 blocked
  statistics[ true, true, false ].perform_test :=
    defence_first.checked and
    co_ord_weights1.checked and
    ignore_4_blocked1.checked;

  // .. no co-ord weights
  // .... weigh 4 blocked
  statistics[ true, false, true ].perform_test :=
    defence_first.checked and
    no_co_ord_weights1.checked and
    weigh_4_blocked2.checked;

  // .... ignore 4 blocked
  statistics[ true, false, false ].perform_test :=
    defence_first.checked and
    no_co_ord_weights1.checked and
    ignore_4_blocked2.checked;

  // offence first
  // .. co-ord weights
  // .... weigh 4 blocked
  statistics[ false, true, true ].perform_test :=
    offence_first.checked and
    co_ord_weights2.checked and
    weigh_4_blocked3.checked;

  // .... ignore 4 blocked
  statistics[ false, true, false ].perform_test :=
    offence_first.checked and
    co_ord_weights2.checked and
    ignore_4_blocked3.checked;

  // .. no co-ord weights
  // .... weigh 4 blocked
  statistics[ false, false, true ].perform_test :=
    offence_first.checked and
    no_co_ord_weights2.checked and
    weigh_4_blocked4.checked;

  // .... ignore 4 blocked
  statistics[ false, false, false ].perform_test :=
    offence_first.checked and
    no_co_ord_weights2.checked and
    ignore_4_blocked4.checked;

  count_tests;
end; { set_statistics_tests }
{----------------------------------------------------------}

procedure TStatistics_tests_form.ok_buttonClick(Sender: TObject);
begin
  set_statistics_tests;
end; { ok_buttonClick }
{----------------------------------------------------------}

procedure TStatistics_tests_form.FormCreate(Sender: TObject);
begin
  parent_changing := true;
  set_checkboxes;
  count_tests;
  parent_changing := false;
end; { FormCreate }
{----------------------------------------------------------}

procedure TStatistics_tests_form.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if strtointdef(times_to_do_each_test.text,-1) >= 0 then
    CanClose := true
  else
  begin
    showmessage( 'Please enter a value for number of tests to perform.');
    CanClose := false;
  end;
end; { FormCloseQuery }
{----------------------------------------------------------}

procedure TStatistics_tests_form.Defence_firstClick(Sender: TObject);
var
  old_parent_changing : boolean;
begin
  co_ord_weights1.enabled := Defence_first.checked;
  weigh_4_blocked1.enabled := Defence_first.checked;
  ignore_4_blocked1.enabled := Defence_first.checked;

  no_co_ord_weights1.enabled := Defence_first.checked;
  weigh_4_blocked2.enabled := Defence_first.checked;
  ignore_4_blocked2.enabled := Defence_first.checked;

  if not Defence_first.checked then
  begin
    old_parent_changing := parent_changing;
    co_ord_weights1.checked := false;
    no_co_ord_weights1.checked := false;
    parent_changing := old_parent_changing;
    set_statistics_tests;
  end;
end; { Defence_firstClick }
{----------------------------------------------------------}

procedure TStatistics_tests_form.offence_firstClick(Sender: TObject);
var
  old_parent_changing : boolean;
begin
  co_ord_weights2.enabled := offence_first.checked;
  weigh_4_blocked3.enabled := offence_first.checked;
  ignore_4_blocked3.enabled := offence_first.checked;

  no_co_ord_weights2.enabled := offence_first.checked;
  weigh_4_blocked4.enabled := offence_first.checked;
  ignore_4_blocked4.enabled := offence_first.checked;

  if not offence_first.checked then
  begin
    old_parent_changing := parent_changing;
    co_ord_weights2.checked := false;
    no_co_ord_weights2.checked := false;
    parent_changing := old_parent_changing;
    set_statistics_tests;
  end;
end; { offence_firstClick }
{----------------------------------------------------------}

procedure TStatistics_tests_form.co_ord_weights1Click(Sender: TObject);
var
  old_parent_changing : boolean;
begin
  weigh_4_blocked1.enabled := co_ord_weights1.checked;
  ignore_4_blocked1.enabled := co_ord_weights1.checked;

  if co_ord_weights1.checked and not parent_changing then
    defence_first.checked := true;

  old_parent_changing := parent_changing;
  if not co_ord_weights1.checked then
  begin
    parent_changing := true;
    weigh_4_blocked1.checked := false;
    ignore_4_blocked1.checked := false;
  end;
  parent_changing := old_parent_changing;
  set_statistics_tests;
end; { co_ord_weights1Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.co_ord_weights2Click(Sender: TObject);
var
  old_parent_changing : boolean;
begin
  weigh_4_blocked3.enabled := co_ord_weights2.checked;
  ignore_4_blocked3.enabled := co_ord_weights2.checked;

  if co_ord_weights2.checked and not parent_changing then
    offence_first.checked := true;

  old_parent_changing := parent_changing;
  if not co_ord_weights2.checked then
  begin
    parent_changing := true;
    weigh_4_blocked3.checked := false;
    ignore_4_blocked3.checked := false;
  end;
  parent_changing := old_parent_changing;
  set_statistics_tests;
end; { co_ord_weights2Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.No_co_ord_weights1Click(Sender: TObject);
var
  old_parent_changing : boolean;
begin
  weigh_4_blocked2.enabled := No_co_ord_weights1.checked;
  ignore_4_blocked2.enabled := No_co_ord_weights1.checked;

  if No_co_ord_weights1.checked and not parent_changing then
    defence_first.checked := true;

  old_parent_changing := parent_changing;
  if not No_co_ord_weights1.checked then
  begin
    parent_changing := true;
    weigh_4_blocked2.checked := false;
    ignore_4_blocked2.checked := false;
  end;
  parent_changing := old_parent_changing;
  set_statistics_tests;
end; { No_co_ord_weights1Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.No_co_ord_weights2Click(Sender: TObject);
var
  old_parent_changing : boolean;
begin
  weigh_4_blocked4.enabled := No_co_ord_weights2.checked;
  ignore_4_blocked4.enabled := No_co_ord_weights2.checked;

  if no_co_ord_weights2.checked and not parent_changing then
    offence_first.checked := true;

  old_parent_changing := parent_changing;
  if not no_co_ord_weights2.checked then
  begin
    parent_changing := true;
    weigh_4_blocked4.checked := false;
    ignore_4_blocked4.checked := false;
  end;
  parent_changing := old_parent_changing;
  set_statistics_tests;
end; { No_co_ord_weights2Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.Weigh_4_Blocked1Click(Sender: TObject);
begin
  if Weigh_4_Blocked1.checked then
    co_ord_weights1.checked := true;
  set_statistics_tests;
end; { Weigh_4_Blocked1Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.Weigh_4_Blocked2Click(Sender: TObject);
begin
  if Weigh_4_Blocked2.checked then
    no_co_ord_weights1.checked := true;
  set_statistics_tests;
end; { Weigh_4_Blocked2Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.Weigh_4_Blocked3Click(Sender: TObject);
begin
  if Weigh_4_Blocked3.checked then
    co_ord_weights2.checked := true;
  set_statistics_tests;
end; { Weigh_4_Blocked3Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.Weigh_4_Blocked4Click(Sender: TObject);
begin
  if Weigh_4_Blocked4.checked then
    no_co_ord_weights2.checked := true;
  set_statistics_tests;
end; { Weigh_4_Blocked4Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.Ignore_4_Blocked1Click(Sender: TObject);
begin
  if Ignore_4_Blocked1.checked then
    co_ord_weights1.checked := true;
  set_statistics_tests;
end; { Ignore_4_Blocked1Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.Ignore_4_Blocked2Click(Sender: TObject);
begin
  if Ignore_4_Blocked2.checked then
    co_ord_weights2.checked := true;
  set_statistics_tests;
end; { Ignore_4_Blocked2Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.Ignore_4_Blocked3Click(Sender: TObject);
begin
  if Ignore_4_Blocked3.checked then
    co_ord_weights2.checked := true;
  set_statistics_tests;
end; { Ignore_4_Blocked3Click }
{----------------------------------------------------------}

procedure TStatistics_tests_form.Ignore_4_Blocked4Click(Sender: TObject);
begin
  if Ignore_4_Blocked4.checked then
    no_co_ord_weights2.checked := true;
  set_statistics_tests;
end; { Ignore_4_Blocked4Click }
{----------------------------------------------------------}

end.
