unit Board_unit;

Interface

Uses
  Windows, Messages, sysutils, Classes, Graphics,
  Controls, Forms, Dialogs,
  Stdctrls, comctrls, Menus, Grids, Aligrid, Math,
  gomoku_common_unit;

Type
  string1 = string[1];

Const
  Max_x = 15;
  Max_y = 15;
  win_length = 5;
  blank_cell : string1 = '';
  X_piece : string1 = 'X';
  O_piece : string1 = 'O';
  WM_USER_APPLICATION_MINIMIZE = WM_USER+1;

Type
  tplayers = (X_player, O_player, X_computer, O_computer);

  TBoard_form = class(tform)
    MainMenu1: TMainMenu;
    Quit1: TMenuItem;
    board: TStringAlignGrid;
    X_move_label: TLabel;
    O_move_label: TLabel;
    Help1: TMenuItem;
    Game1: TMenuItem;
    NewGame1: TMenuItem;
    Computeris1: TMenuItem;
    O1: TMenuItem;
    X1: TMenuItem;
    AutoplayMode1: TMenuItem;
    N1: TMenuItem;
    SuggestAMove1: TMenuItem;
    HowtoPlay1: TMenuItem;
    Settingupagame1: TMenuItem;
    DontLetComputerMoveMode1: TMenuItem;
    About1: TMenuItem;
    RowandColumnNumbers1: TMenuItem;
    N2HumanOpponentsMode1: TMenuItem;
    ViewWeights1: TMenuItem;
    Tactics1: TMenuItem;
    DefenceorOffence1: TMenuItem;
    DefenceFirstunlesswinning1: TMenuItem;
    OffenceFirst1: TMenuItem;
    Weight4orlesswhenblocked1: TMenuItem;
    DoStatisticsTests1: TMenuItem;
    N2: TMenuItem;
    UseCoordinateWeights1: TMenuItem;
    Status_label: TLabel;
    Keyboardshortcuts1: TMenuItem;
    procedure print_rules(Sender: tobject);
    procedure Settingupagame1Click(Sender: TObject);
    procedure Quick_sort( Lo, Hi : integer );
    procedure check_any_direction_for_blank(
      X, Y, X_delta, Y_delta : integer );
    procedure Assess_moves_for_blank(
      X, Y : integer );
    procedure count_pieces_in_line(
      X, Y, X_delta, Y_delta : integer );
    procedure check_for_winner;
    procedure weigh_move_options;
    procedure report_winner;
    procedure ChecktoClose(
      var OK_to_close : boolean );
    procedure do_end_of_game_stuff;
    procedure autoplay_game;
    procedure computers_move;
    procedure play_new_game;
    procedure Adjust_StringGrid_size(
      var sg : tStringAlignGrid );
    procedure fix_form_elements;
    Procedure FormCreate(Sender: tobject);
    procedure highlight_move( X, Y : integer );
    procedure do_player_move(
        piece : string1;
        current_row, current_col : integer;
        var success : boolean );
    procedure handle_2_human_opponents;
    procedure Clear_cell;
    procedure update_dont_move_caption;
    procedure CellSelected( which_piece : string1 );
    procedure toggle_dont_move_mode;
    procedure Quit1Click(Sender: TObject);
    procedure PlayGame1Click(Sender: TObject);
    procedure BoardKeyPress(Sender: TObject; var Key: Char);
    procedure BoardMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure BoardMouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure O1Click(Sender: TObject);
    procedure X1Click(Sender: TObject);
    procedure AutoplayMode1Click(Sender: TObject);
    procedure SuggestAMove1Click(Sender: TObject);
    procedure DontLetComputerMoveMode1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure RowandColumnNumbers1Click(Sender: TObject);
    procedure N2HumanOpponentsMode1Click(Sender: TObject);
    procedure ViewWeights1Click(Sender: TObject);
    procedure DefenceFirstunlesswinning1Click(Sender: TObject);
    procedure OffenceFirst1Click(Sender: TObject);
    procedure show_Weight_4_when_blocked;
    procedure Weight4orlesswhenblocked1Click(Sender: TObject);
    procedure show_Defence_first;
    procedure Show_Co_ord_Weights;
    procedure UseCoordinateWeights1Click(Sender: TObject);
    procedure Get_statistics(Sender: TObject);
    procedure Keyboardshortcuts1Click(Sender: TObject);
  Private
    { Private declarations }
    AutoPlayCount, level, turn_counter, offset : integer;
    dont_let_computer_move,
    player_quits, play_a_game, autoplay_mode,
    two_human_opponents,
    suggest_a_move : boolean;
    computers_piece, players_piece : string1;
    game_over_string : string;
    whose_move : tplayers;
    winner : twinner;
    gr1 : TGridRect;
    highlight_brush : tbrush;
    procedure OnUserAppMin(var M: TMessage);
      message WM_USER_APPLICATION_MINIMIZE;
  Public
    { Public declarations }
  End;

var
  Board_form: tBoard_form;
  number2autoplay, numberGames2Test : integer;
  Defence_first,
  Weight_4_when_blocked,
  Co_ord_weights,
  stat_mode : boolean;

Implementation

uses
  play_again_unit, Exit2Humans_unit,
  weights_unit, how_many_moves_unit, Statistics_unit, statistics_tests_unit;

{$R *.DFM}

{----------------------------------------------------------}

procedure tBoard_form.OnUserAppMin(var M: TMessage);
begin
  Application.Minimize;
end; { OnUserAppMin }
{----------------------------------------------------------}

procedure tBoard_form.print_rules(Sender: tobject);
begin
  showmessage(
    'Welcome to the oriental game of GoMoku. ' +
    'This version is played on an 15 by 15 grid. ' +
    'During your play, you may cover one grid ' +
    'intersection with a marker. The object ' +
    'of the game is to get 5 adjacent markers ' +
    'in a row -- horizontally, vertically, or ' +
    'along either diagonal. On the board ' +
    'diagram, your moves are marked with a ' +
    '"X", and the computer moves with a "O". ' );
end; { print_rules }
{----------------------------------------------------------}

procedure TBoard_form.Settingupagame1Click(Sender: TObject);
begin
  showmessage( 'To set up a board position:' + #13 +
    'Press D for "Don''t Move Mode"' + #13 +
    'then press:' + #13 +
    'X to place an X piece,' + #13 +
    'O to place an O piece,' + #13 +
    'or Enter to place your piece' + #13 +
    'or space to clear a cell.' + #13 + #13 +
    'After each piece is placed to computer will tell you the move it would have made.'+ #13 +
    'Press D to exit "Don''t Move Mode" then it will still be your turn.' );
end; { Settingupagame1Click }
{----------------------------------------------------------}

procedure TBoard_Form.Quick_sort( Lo, Hi : integer );

{ QUICKSORT sorts elements in the array A with indices between  }
{ LO and HI (both inclusive). Note that the QUICKSORT proce-    }
{ dure provides only an "interface" to the program. The actual  }
{ processing takes place in the SORT procedure, which executes  }
{ itself recursively.                                           }

{..........................................................}

procedure sort( l, r : integer );

var
  i,j : integer;
  x,y : move_weight_subtype;

begin
  i := l;
  j := r;
  x := move_weights[ (l+r) DIV 2 ];
  repeat
    while move_weights[ i ].weight > x.weight do
      i := i + 1;
    while x.weight > move_weights[ j ].weight do
      j := j - 1;
    if i <= j then
    begin
      y := move_weights[ i ];
      move_weights[ i ] := move_weights[ j ];
      move_weights[ j ] := y;
      i := i + 1;
      j := j - 1;
    end;
  until i > j;
  if l < j then
    sort( l,j );
  if i < r then
    sort( i,r );
end; { sort }
{..........................................................}

begin
  sort( Lo,Hi );
end; { sort_hi_scores }
{----------------------------------------------------------}

function Rate_closeness_to_centre(
  Q, maxQ : integer ) : integer;
//
// The param Q is rated for how close it is to the
// centre (or middle) of MaxQ.
// This gives the strategy that on a blank board,
// the centre cell(s) [depending on whether MaxQ is odd or even]
// are the preferred moves.
// E.g. range is assumed to be 1..MaxQ
// for example for 1..8 (MaxQ = 8)
// Rating returned is:
// Q -> Rating
// 1 -> 1 (min = 1)
// 2 -> 2
// 3 -> 3
// 4 -> 4  ) middle 2 numbers
// 5 -> 4  )   "    "    "
// 6 -> 3
// 7 -> 2
// 8 -> 1 (maxQ)
//
// when MaxQ is odd there will be a single middle
// number, so it gets the highest rating.
begin
  if Q <= (MaxQ div 2 + ord(odd(MaxQ))) then
    Result := Q
  else
    Result := abs(Q-MaxQ-1);
end; { Rate_Closeness_to_centre }
{----------------------------------------------------------}

procedure TBoard_Form.check_any_direction_for_blank(
  X, Y, X_delta, Y_delta : integer );
var
  count, extra,
  freeBeforeCount, freeAfterCount,
  freeCount : integer;

  // array index is false for X, or true for O
  before_count,
  after_count,
  total : array [ boolean ] of integer;

  index : boolean;
{..........................................................}

  procedure count_before_or_after(
    X_delta, Y_delta : integer;
    var X_count, O_count, LocalfreeCount : integer );
  var
    Q : integer;
  begin
    X_count := 0;
    O_count := 0;
    LocalFreeCount := 0;
    // count the X and O pieces before the current cell
    for Q := 1 to win_length-1 do
    begin
      if (X + X_delta * Q <= max_x) and
         (X + X_delta * Q >= 1) and
         (Y + Y_delta * Q <= max_y) and
         (Y + Y_delta * Q >= 1) then
      begin
        if (board.cells[ X + X_delta * Q - 1 + offset,
                         Y + Y_delta * Q - 1 + offset ] = X_piece) then
        begin
           if O_count = 0 then
             // we have not found O pieces so keep counting X's
           begin
             // only count it if we have not first found a blank cell
             if LocalFreeCount = 0 then
               inc(X_count)
           end
           else
             // we found an X after an O, so stop
             break;
        end
        else
          if (board.cells[ X + X_delta * Q - 1 + offset,
                           Y + Y_delta * Q - 1 + offset ] = O_piece) then
          begin
            if X_count = 0 then
              // we have not found X pieces so keep counting O's
            begin
              // only count it if we have not first found a blank cell
              if LocalFreeCount = 0 then
                inc(O_count)
            end
            else
              // we found an O after an X, so stop
              break;
          end
          else
            if (board.cells[ X + X_delta * Q - 1 + offset,
                             Y + Y_delta * Q - 1 + offset ] = blank_cell) then
              // count the blank cells
              inc(LocalFreeCount);
      end
      else
        break; // hit border
    end;

  end; { count_before_or_after }
{..........................................................}

begin
  extra := 0;
  count_before_or_after( -X_delta, -Y_delta,
    before_count[ false ], before_count[ true ], freeBeforeCount );
  count_before_or_after( X_delta, Y_delta,
    after_count[ false ], after_count[ true ], freeAfterCount );

  total[ false ] := before_count[ false ] + after_count[ false ];
  total[ true ] := before_count[ true ] + after_count[ true ];

  count := total[ false ] + total[ true ];
  // limit count to a max of 4.
  if count > 4 then
    count := 4;

  if count = 0 then
    exit;

  if (total[ false ] >= win_length - 1) or
     (total[ true ] >= win_length - 1) then
  begin
    if ((computers_piece = O_piece) and
        (total[ false ] >= win_length - 1)) or
       ((computers_piece = X_piece) and
        (total[ true ] >= win_length - 1)) then
      extra := -90
    else
      extra := 90;
  end
  else
  begin
    for index := false to true do
    begin
      if (before_count[ index ] > 0) or (after_count[ index ] > 0) then
      begin
        freeCount := freeBeforeCount;
        if (After_count[ index ] >= 0) or
           (After_count[not(index)] = 0) then
        freeCount := freeCount + freeAfterCount;

        if total[ index ] + freeCount >= win_length then
        begin
          // extra must be +/- 90 since value
          // needs to be > than double max value
          // returned by Rate_closeness_to_centre (16)
          // and > than 4 * 20 (used below).
          if ((computers_piece = X_piece) and not index) or
             ((computers_piece = O_piece) and index) then
            // defense first
            extra := extra - 90
          else
            // offense second
            extra := extra + 90
        end // if
        else
          if total[ index ] + freeCount >= win_length-1 then
          begin
            // extra must be +/- 20 since value
            // needs to be > than max value
            // returned by Rate_closeness_to_centre (16)
            if ((computers_piece = X_piece) and not index) or
               ((computers_piece = O_piece) and index) then
              // defense first
              extra := extra - 20
            else
              // offense second
              extra := extra + 20
          end // if
          else
          begin
            // not a good move!!!
            if not Weight_4_when_blocked then
              // get out and don't change the weight
              exit;
          end; // else
      end; // if
    end; // for index
    if not Defence_first then
      extra := -1 * extra;
  end; // else

  move_weights[(x-1)*level + y].X1 := X;
  move_weights[(x-1)*level + y].Y1 := Y;
  move_weights[(x-1)*level + y].weight :=
    integer(Round(
    move_weights[(x-1)*level + y].weight +
    power((count+1),8) + extra));
end; { check_any_direction_for_blank }
{----------------------------------------------------------}

procedure TBoard_Form.Assess_moves_for_blank(
  X, Y : integer );
begin
  check_any_direction_for_blank( X, Y, 1, 0 );
  check_any_direction_for_blank( X, Y, -1, 0 );
  check_any_direction_for_blank( X, Y, 0, 1 );
  check_any_direction_for_blank( X, Y, 0, -1 );
  check_any_direction_for_blank( X, Y, 1, 1 );
  check_any_direction_for_blank( X, Y, -1, -1 );
  check_any_direction_for_blank( X, Y, 1, -1 );
  check_any_direction_for_blank( X, Y, -1, 1 );
end; { Assess_moves_for_blank }
{----------------------------------------------------------}

procedure TBoard_Form.count_pieces_in_line(
  X, Y, X_delta, Y_delta : integer );
var
  Q, X_count, O_count : integer;
begin
  X_count := 0;
  O_count := 0;
  // count the X and O pieces before the current cell
  for Q := 0 to win_length-1 do
  begin
    if (X + X_delta * Q <= max_x) and
       (X + X_delta * Q >= 1) and
       (Y + Y_delta * Q <= max_y) and
       (Y + Y_delta * Q >= 1) then
    begin
      if (board.cells[ X + X_delta * Q - 1 + offset,
                       Y + Y_delta * Q - 1 + offset ] = X_piece) and
         (O_count = 0) then
        inc(X_count)
      else
        if (board.cells[ X + X_delta * Q - 1 + offset,
                         Y + Y_delta * Q - 1 + offset ] = O_piece) and
           (X_count = 0) then
          inc(O_count)
        else
          break;
    end
    else
      break; // hit border
  end;

  if X_count = win_length then
      winner := XXX;
  if O_count = win_length then
      winner := OOO;
end; { count_pieces_in_line }
{----------------------------------------------------------}

procedure TBoard_Form.check_for_winner;
var
  x, y : integer;
begin
  x := 1;
  while (x <= max_x) and (winner = no_winner) do
  begin
    y := 1;
    while (y <= max_y) and (winner = no_winner) do
    begin
      if (board.cells[ x-1+offset, y-1+offset ] = O_piece) or
         (board.cells[ x-1+offset, y-1+offset ] = X_piece) then
      begin
        count_pieces_in_line( X, Y, 1, 0 );
        if winner = no_winner then
          count_pieces_in_line( X, Y, 0, 1 );
        if winner = no_winner then
          count_pieces_in_line( X, Y, 1, 1 );
        if winner = no_winner then
          count_pieces_in_line( X, Y, 1, -1 );
      end;
      inc(y);
    end;
    inc(x);
  end;
end; { check_for_winner }
{----------------------------------------------------------}

procedure TBoard_Form.weigh_move_options;
var
  x, y : integer;
begin
  // the next procedure looks for a winner
  check_for_winner;
  if winner <> no_winner then
    exit;

  for x := 1 to max_x do
    for y := 1 to max_y do
    begin
      move_weights[(x-1)*level + y ].X1 := X;
      move_weights[(x-1)*level + y ].Y1 := Y;
      if board.cells[ x-1+offset, y-1+offset ] = blank_cell then
      begin
        if Co_ord_weights then
        begin
          // set weight to X rating
          move_weights[(x-1)*level + y].weight :=
            Rate_closeness_to_centre( X, max_X );

          // then add on Y rating
          move_weights[(x-1)*level + y].weight :=
            move_weights[(x-1)*level + y].weight +
            Rate_closeness_to_centre( Y, max_Y );
        end
        else
          move_weights[(x-1)*level + y].weight := 0;

        Assess_moves_for_blank( X, Y );
      end
      else
        move_weights[(x-1)*level + y ].weight := -1; // illegal move
    end;
end; { weigh_move_options }
{----------------------------------------------------------}

procedure TBoard_Form.report_winner;
begin
  caption := 'Turn '+ inttostr(turn_counter) + ' : Game Over.';

  if autoplay_mode then
    Game_Over_String := Game_Over_String +
      'There was ' + inttostr(AutoplayCount) +
      ' move(s) made by X before there was a result.' + #13;

  case winner of
    XXX :
      if computers_piece = X_piece then
        Game_Over_string := Game_Over_string + #13 +
          'Computer as X wins.' + #13 +
          'Game Over.'
      else
        Game_Over_string := Game_Over_string + #13 +
          'Player X wins.' + #13 +
          'Game Over.';
    OOO :
      if computers_piece = O_piece then
        Game_Over_string := Game_Over_string + #13 +
          'Computer as O wins.' + #13 +
          'Game Over.'
      else
        Game_Over_string := Game_Over_string + #13 +
          'Player O wins.' + #13 +
          'Game Over.';
    no_winner :
      Game_Over_string := Game_Over_string + #13 +
        'There is no winner' + #13 +
        'Game Over.';
    tie :
      Game_Over_string := Game_Over_string + #13 +
        'The Game is Tied!' + #13 +
        'Game Over.';
    ended_with_error :
      Game_Over_string := Game_Over_string + #13 +
        'Ooopps!!! The Game Ended in an Error.' + #13 +
        'Game Over.';
  end; // case

  if stat_mode then
    caption := Game_over_string
  else
    showmessage( Game_Over_string );
end; { report_winner }
{----------------------------------------------------------}

procedure TBoard_Form.ChecktoClose(
  var OK_to_close : boolean );
// sets 'player_quits' to true to allow form to close,
// if the player says 'no' to next game.
begin
  OK_to_close := false;
  play_again_form := tplay_again_form.create( nil );
  try
    play_again_form.label1.caption := 'Would you like to play another game ?' + #13 +
      ' "Yes" starts a new game' + #13 +
      ' "No" quits GoMoku';
    play_again_form.autoplay.checked := autoplay_mode;
    if play_again_form.showmodal = mrYes then
    begin
      autoplay_mode := play_again_form.autoplay.checked;

      if autoplay_mode then
        whose_move := X_computer
      else
        whose_move := X_player;

      computers_piece := O_piece;
      players_piece := X_piece;

      if autoplay_mode then
      play_a_game := true;
      player_quits := false;
    end
    else
    begin
      OK_to_close := true;
      player_quits := true;
    end;
  finally
    FreeAndNil(play_again_form);
  end;
end; { ChecktoClose }
{----------------------------------------------------------}

procedure TBoard_Form.do_end_of_game_stuff;
var
  ok : boolean;
begin
  ok := false;
  if stat_mode then
    exit;
  ChecktoClose( ok );
  if ok then
    close
  else
    play_new_game;
end; { do_end_of_game_stuff }
{----------------------------------------------------------}

procedure TBoard_Form.computers_move;
var
  X, Y, count, Random_move,
  highest_move_rating : integer;
  found : boolean;
begin
  caption := 'Turn '+ inttostr(turn_counter) +
    ' ... it''s my move as ' + computers_piece + '.';
  weigh_move_options;

  if winner <> no_winner then
  begin
    report_winner;
    do_end_of_game_stuff;
    exit;
  end;

  quick_sort(1, max_x * max_y );
  highest_move_rating := move_weights[ 1 ].weight;

  if highest_move_rating = -1 then
  begin
    game_over_string := 'There are no more moves.';
    winner := tie;
  end
  else
  begin
    count := 0;
    found := false;
    x := 1;
    while not found and (x <= max_x*max_y) do
    begin
      if move_weights[ x ].weight = highest_move_rating then
        inc(count)
      else
        found := true;
      inc(x);
    end;

    if count > 0 then
    begin
      Random_move := random( count ) + 1;
      X := move_weights[ Random_move ].X1;
      Y := move_weights[ Random_move ].Y1;
      if dont_let_computer_move then
      begin
        showmessage( format('computers move, as player ' +
                     computers_piece +
                     ' would be Row,Col (%d,%d)' + #13 +
                     'with a highest_move_rating = %d' + #13 +
                     'Number of moves to choose from = %d',
                     [Y,X,highest_move_rating,count]));
        exit;
      end;

      if suggest_a_move then
      begin
        showmessage( format('The move I suggest, as player ' +
                     computers_piece +
                     ' would be Row,Col (%d,%d)' + #13 +
                     'with a highest_move_rating = %d' + #13 +
                     'Number of moves to choose from = %d',
                     [Y,X,highest_move_rating,count]));
        exit;
      end;

      if (X >= 1) and (X <= max_x) and
         (Y >= 1) and (Y <= max_y) then
      begin
        if board.cells[ X-1+offset,Y-1+offset ] = blank_cell then
        begin
          board.cells[ X-1+offset, Y-1+offset ] := computers_piece;
          if computers_piece = O_piece then
            O_move_label.caption :=
              format('Player O (computer) moves: Row,Col (%d,%d)',
              [Y,X])
          else
            X_move_label.caption :=
              format('Player X (computer) moves: Row,Col (%d,%d)',
              [Y,X]);
          highlight_move( X-1, Y-1 );
        end
        else
        begin
          game_over_string := 'Error: computer attempted to move in non-vacant cell.';
          winner := ended_with_error;
          exit;
        end;
      end
      else
      begin
        game_over_string := format('Randomly picked move co-ords are wrong.' + #13 +
          'col, row [%d,%d]',[X,Y]);
        winner := ended_with_error;
      end;
    end
    else
    begin
      game_over_string := 'Error - there are zero moves of the indicated rating.';
      winner := ended_with_error;
    end;
  end;

  if winner = no_winner then
    weigh_move_options;

  if winner = no_winner then
  begin
    case whose_move of
      X_computer :
      begin
        // when X moves increment the counter
        inc(turn_counter);
        if autoplay_mode then
          whose_move := O_computer
        else
        begin
          whose_move := O_player;
          caption := 'Turn ' + inttostr(turn_counter) +
            ' ... make a move player O.';
        end;
      end;

      O_computer :
        if autoplay_mode then
          whose_move := X_computer
        else
        begin
          whose_move := X_player;
          caption := 'Turn ' + inttostr(turn_counter) +
            ' ... make a move player X.';
        end;
    end; // case
  end
  else
    begin
      report_winner;
      do_end_of_game_stuff;
      exit;
    end;
end; { computers_move }
{----------------------------------------------------------}

procedure TBoard_form.autoplay_game;
var
  old_computers_piece : string;
begin
  old_computers_piece := computers_piece;

  case whose_move of
    X_player : whose_move := X_computer;
    O_player : whose_move := O_computer;
  end;

  AutoPlayCount := 1;
  while (winner = no_winner) and
        (whose_move in [O_computer,X_computer]) and
        (AutoPlayCount <= number2autoplay) do
  begin
    case whose_move of
      X_computer : computers_piece := X_piece;
      O_computer : computers_piece := O_piece;
    end;
    if computers_piece = old_computers_piece then
      // we only count the number of moves from one side
      inc(AutoPlayCount);
    computers_move;
  end;

  if (winner = no_winner) and autoplay_mode then
  begin
    showmessage( 'Okay... I''ve finished autoplaying ' +
      inttostr(number2autoplay) + ' moves.' + #13 +
      ' and still no winner.' + #13 +
      'Leaving you in 2 human mode.' );
    computers_piece := old_computers_piece;
    autoplay_mode := false;
    two_human_opponents := true;
    N2HumanOpponentsMode1.Checked := two_human_opponents;
    O1.Checked := true;
    X1.Checked := false;
    case whose_move of
      X_computer :
      begin
        whose_move := X_player;
        caption := 'Turn ' + inttostr(turn_counter) +
          ' ... make a move player X.';
      end;
      O_computer :
      begin
        whose_move := O_player;
        caption := 'Turn ' + inttostr(turn_counter) +
          ' ... make a move player O.';
      end;
    end; // case
  end;
end; { autoplay_game }
{---------------------------------------------------------}

procedure TBoard_form.play_new_game;
var
  i,j : integer;
begin
  for i:= 1 to max_x do
    for j := 1 to max_y do
      Board.cells[ i-1 + offset,j-1 + offset ] := blank_cell;

  player_quits := false;
  play_a_game := true;

  game_over_string := '';
  winner := no_winner;
  X_move_label.caption := 'Player X is yet to move.';
  O_move_label.caption := 'Player O is yet to move.';

  O1.Checked := (computers_piece = O_piece) or autoplay_mode;
  X1.Checked := (computers_piece = X_piece) or autoplay_mode;
  autoplaymode1.Checked := autoplay_mode;
  DontLetComputerMoveMode1.Checked := dont_let_computer_move;

  // X always moves first (whether its the player or computer)
  turn_counter := 1;
  suggest_a_move := false;

  if autoplay_mode then
    whose_move := X_computer
  else
  begin
    players_piece := X_piece;
    computers_piece := O_piece;
    whose_move := X_player;
  end;

  if dont_let_computer_move then
  begin
    caption := 'Don''t let computer move mode ON.';
    whose_move := X_player;
  end
  else
    if autoplay_mode then
      autoplay_game
    else
    begin
      if computers_piece = O_piece then
      begin
        whose_move := X_player;
        caption := 'Turn 1 ... make a move player X.';
      end
      else
      begin
        whose_move := X_computer;
        computers_move;
      end;
    end;
end; { play_new_game }
{----------------------------------------------------------}

procedure TBoard_form.About1Click(Sender: TObject);
begin
  showmessage( 'GoMoku for Windows' + #13 +
    'v0.04  2002 Peter E. Williams' + #13 +
    '(a very simple game!)' + #13 +
    'written using Delphi 5.' + #13 +
    '(The best language for Windows programming!!!)' + #13 +
    'Freeware !!!' + #13 +
    'Source code available.' + #13 +
    'email: pew@pcug.org.au' + #13 +
    '(Send me an email, I''d love to hear from you :-)))' );
end; { About1Click }
{----------------------------------------------------------}

procedure tBoard_form.Adjust_StringGrid_size(
  var sg : tStringAlignGrid );
const
  YeOldeCellKudgeFactor = 3;
begin
  with SG do
    begin
      Width := (ColCount)*DefaultColWidth +
               GridLineWidth * (ColCount)+
               YeOldeCellKudgeFactor;

      Height := (RowCount)*DefaultRowHeight +
               GridLineWidth * (RowCount)+
               YeOldeCellKudgeFactor;
    end;
end; { Adjust_StringGrid_size }
{---------------------------------------------------------}

procedure tBoard_form.fix_form_elements;
var
  Q, Q2 : integer;
begin
  RowandColumnNumbers1.Checked := want_row_col_numbers;
  with board do
  begin
    if want_row_col_numbers then
    begin
      FixedRows := 1;
      FixedCols := 1;
      RowCount := Max_y + 1;
      ColCount := Max_x + 1;
      // move the board
      for Q := Max_X downto 1 do
        for Q2 := Max_Y downto 1 do
          board.cells[ Q, Q2 ] := board.cells[ Q-1, Q2-1 ];
      board.cells[ 0,0 ] := blank_cell;
      for Q := 1 to Max_x do
        cells[ Q, 0 ] := inttostr(Q);
      for Q := 1 to Max_y do
        cells[ 0, Q ] := inttostr(Q);
    end
    else
    begin
      if (RowCount > Max_Y) and (ColCount > Max_X) then
      begin
        // move the board
        for Q := 1 to Max_X + 1 do
          for Q2 := 1 to Max_Y + 1 do
          begin
            if (Q = Max_X + 1) and (Q2 = Max_Y + 1) then
              board.cells[ Q-1, Q2-1 ] := blank_cell
            else
              board.cells[ Q-1, Q2-1 ] := board.cells[ Q, Q2 ];
          end;
      end;
      FixedRows := 0;
      FixedCols := 0;
      RowCount := Max_y;
      ColCount := Max_x;
    end;
  end;
  Adjust_StringGrid_size( board );
  width := board.left + board.width + 30;
  X_move_label.top := board.top + board.height + 8;
  O_move_label.top := board.top + board.height + 23;
  status_label.top := board.top + board.height + 47;
  height := status_label.top + 82;

  if want_row_col_numbers then
    offset := 1
  else
    offset := 0;
end; { fix_form_elements }
{---------------------------------------------------------}

procedure tBoard_form.FormCreate(Sender: tobject);
var
  x,y,z : boolean;
begin
  About1Click( nil );

  want_row_col_numbers := true;  // default
  fix_form_elements;

  Randomize;
  level := max_x;

  // now set the cell highlight colour
  highlight_brush := tbrush.create;
  highlight_brush.color := clYellow;

  gr1.Left := -1;
  gr1.Top := -1;
  gr1.Bottom := -1;
  gr1.Right := -1;
  board.Selection := gr1;

  dont_let_computer_move := false;
  two_human_opponents := false;

  show;
  showmessage( 'We alternate moves. You go first...' );

  computers_piece := O_piece;
  players_piece := X_piece;

  autoplay_mode := false;
  number2autoplay := 1;

  Defence_first := true;
  show_Defence_first;

  Weight_4_when_blocked := false;
  show_Weight_4_when_blocked;

  co_ord_weights := true;
  Show_Co_ord_Weights;

  // hide the status_label since we only want to
  // see it when doing statistics.
  status_label.visible := false;

  // default for test number of games
  numberGames2Test := 10;

  // the default is to perform all statistic tests
  for x := false to true do
    for y := false to true do
      for z := false to true do
        statistics[ x,y,z ].perform_test := true;

  play_new_game;
end; { formcreate }
{----------------------------------------------------------}

procedure TBoard_form.Quit1Click(Sender: TObject);
var
  OK : boolean;
begin
  ok := true; // default is close program
  if (turn_counter > 1) or dont_let_computer_move then
    ChecktoClose( ok );
  if OK then
  begin
    player_quits := true;
    play_a_game := false;
    close;
  end
  else
    play_new_game;
end; { Quit1Click }
{----------------------------------------------------------}

procedure TBoard_form.PlayGame1Click(Sender: TObject);
begin
  play_new_game;
end; { PlayGame1Click }
{----------------------------------------------------------}

procedure TBoard_Form.highlight_move( X, Y : integer );
begin
  board.CellBrush[ X+offset,Y+offset ] := highlight_brush;
  refresh;
  if not autoplay_mode then
    sleep( 500 );
  board.ResetBrushCell( X+offset,Y+offset );
  refresh;
end; { highlight_move }
{----------------------------------------------------------}

procedure TBoard_form.do_player_move(
  piece : string1;
  current_row, current_col : integer;
  var success : boolean );
begin
  success := false;
  if (current_row - offset >= 0) and (current_row - offset < max_y) and
     (current_col - offset >= 0) and (current_col - offset < max_x) then
  begin
    if (board.cells[ current_col, current_row ] = blank_cell) or
       dont_let_computer_move then
    // if "dont_let_computer_move" is true then we can move anywhere.
    begin
      board.cells[ current_col, current_row ] := piece;
      if whose_move = X_player then
        X_move_label.caption :=
          format('Player X moves: Row,Col (%d,%d)',
          [current_row+1-offset,current_col+1-offset])
      else
        O_move_label.caption :=
          format('Player O moves: Row,Col (%d,%d)',
          [current_row+1-offset,current_col+1-offset]);
      highlight_move( current_col-offset, current_row-offset );
      success := true;
    end
    else
      showmessage( 'That cell is occupied.' + #13 +
                   'Please try again.');
  end;
end; { do_player_move }
{----------------------------------------------------------}

procedure TBoard_Form.handle_2_human_opponents;
begin
  weigh_move_options;
  if winner <> no_winner then
  begin
    report_winner;
    do_end_of_game_stuff;
    exit;
  end
  else
  begin
    if whose_move = X_player then
      inc(turn_counter);
    case whose_move of
      X_player :
        begin
          whose_move := O_player;
          caption := 'Turn ' + inttostr(turn_counter) +
            ' ... make a move player O.';
          players_piece := O_piece;
        end;
      O_player :
        begin
          whose_move := X_player;
          caption := 'Turn ' + inttostr(turn_counter) +
            ' ... make a move player X.';
          players_piece := X_piece;
        end;
    end; // case
  end;
end; { handle_2_human_opponents }
{----------------------------------------------------------}

procedure TBoard_Form.update_dont_move_caption;
var
  str1 : string;
begin
  if dont_let_computer_move then
  begin
    str1 := 'Don''t move mode ON.';
    case whose_move of
      X_player : str1 := str1 + 'X (player) to move';
      O_player : str1 := str1 + 'O (player) to move';
      X_computer : str1 := str1 + 'X (computer) to move';
      O_computer : str1 := str1 + 'O (computer) to move';
    end;
    caption := str1;
  end;
end; { update_dont_move_caption }
{----------------------------------------------------------}

procedure TBoard_Form.CellSelected( which_piece : string1 );
var
  Current_row, Current_col : integer;
  success : boolean;
  old_whose_move : tplayers;
begin
  Current_row := Board.Row;
  Current_col := Board.Col;

  if want_row_col_numbers then
    if (current_row = 0) or (current_col = 0) then
    begin
      showmessage('You cannot move in the row/col numbers');
      exit;
    end;

  if not dont_let_computer_move then
  begin
    if (which_piece <> players_piece) or
       (whose_move in [X_computer, O_computer]) then
       // it's the computer's move not the user's.
    begin
      showmessage( 'It''s the computers turn.');
      exit;
    end;
  end;

  do_player_move( which_piece, current_row, current_col, success );
  if success then
    if two_human_opponents then
      handle_2_human_opponents
    else
    begin
      old_whose_move := whose_move;
      case whose_move of
        X_player : whose_move := O_computer;
        O_player : whose_move := X_computer;
      end;

      computers_move;
      if dont_let_computer_move then
      begin
        whose_move := old_whose_move;
        update_dont_move_caption;
      end;
    end; // else
end; { CellSelected }
{----------------------------------------------------------}

procedure TBoard_Form.toggle_dont_move_mode;
begin
  dont_let_computer_move := not dont_let_computer_move;
  DontLetComputerMoveMode1.Checked := dont_let_computer_move;

  if dont_let_computer_move then
  begin
    update_dont_move_caption;
    showmessage( 'To see the computers move rating, place an X piece' + #13 +
                 'with "don''t let computer move mode ON".')
  end
  else
  begin
    case whose_move of
      X_player :
        caption := 'Turn ' + inttostr(turn_counter) +
                   ' ... make a move player X.';
      O_player :
        caption := 'Turn ' + inttostr(turn_counter) +
                   ' ... make a move player O.';
      O_computer, X_computer :
        computers_move;
    end; // case
  end;
end; { toggle_dont_move_mode }
{----------------------------------------------------------}

procedure TBoard_Form.clear_cell;
var
  Current_row, Current_col : integer;
begin
  if dont_let_computer_move then
  begin
    caption := 'Don''t let computer move mode ON.';
    Current_row := Board.Row;
    Current_col := Board.Col;
    board.cells[ current_col, current_row ] := blank_cell;
  end;
end;
{----------------------------------------------------------}

procedure TBoard_Form.BoardKeyPress(Sender: TObject; var Key: Char);
begin
  case key of
    '2' : // toggle 2 human opponents mode (Game / 2 Human Opponents Mode)
      N2HumanOpponentsMode1Click( nil );
    'A','a' : // autoplay mode on (Game / Autoplay Mode)
      AutoplayMode1Click( nil );

    'B','b' : // Help / About
      About1Click( nil );

    'D','d' : // toggle don't move mode (Game / Don't Let Computer Move Mode)
      toggle_dont_move_mode;

    'E','e' : // help / Setting up a game (board position)
      Settingupagame1Click( nil );

    'H','h' : // Help / How to play
      print_rules( nil );

    'K','k' : // 'K - Help / Keyboard shortcuts (this screen)' + #13 +
      Keyboardshortcuts1Click( nil );

    'N','n' : // Game / New Game
      play_new_game;

    'O','o' : // Play an 'O' piece
      CellSelected( O_piece );

    'Q','q' : // Game / Quit
      close;

    'R','r' : // Game / Row and Column Numbers
      RowandColumnNumbers1Click( nil );

    'S','s' : // Game / Suggest A Move
      SuggestAMove1Click( nil );

    'T','t' : // test statistics;
       Get_statistics( nil );

    'W','w' : // view weights
      ViewWeights1Click( nil );

    'X','x' : // Play an 'X' piece
      CellSelected( X_piece );

    chr(vk_escape) : // minimize the game
      PostMessage(Handle, WM_USER_APPLICATION_MINIMIZE, 0, 0);

    chr(vk_return) : // Play the current player's piece
      CellSelected( players_piece );

    ' ' : // space - clear the cell (only valid in Don't Move Mode)
      clear_cell;
  end; { case }
  key := #0;
end; { BoardKeyPress }
{----------------------------------------------------------}

procedure TBoard_Form.BoardMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if whose_move = X_player then
    CellSelected( X_piece )
  else
    if whose_move = O_player then
      CellSelected( O_piece )
    else
      showmessage( 'It''s the computers turn.');
end; { BoardMouseDown }
{----------------------------------------------------------}

procedure TBoard_Form.BoardMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
  CellX,
  CellY : Longint;
begin
  { convert to stringgrid coords }
  Board.MouseToCell(X, Y, CellX, CellY);

  if (cellx >= 0) and (cellx < Board.colcount) and
     (celly >= 0) and (celly < Board.rowcount) then
    if Board.cells[ cellx, celly ] = blank_cell then
    begin
      { valid selection }
      Board.Cursor := crDefault;
    end
    else
    begin
      { invalid selection }
      Board.Cursor := crNo;
    end
  else
    { outside the stringgrid }
    Board.cursor := crNo;
end; { BoardMouseMove }
{----------------------------------------------------------}

procedure TBoard_Form.FormClose(Sender: TObject; var Action: TCloseAction);
var
  ok_to_close : boolean;
begin
  if not player_quits then
  begin
    ok_to_close := false;
    ChecktoClose( Ok_to_close );
    if ok_to_close then
    begin
      FreeAndNil( highlight_brush );
      Action := caFree;
    end
    else
    begin
      Action := caNone;
      play_new_game;
    end;
  end
  else
  begin
    FreeAndNil( highlight_brush );
    Action := caFree;
  end;
end; { FormClose }
{----------------------------------------------------------}

procedure TBoard_form.O1Click(Sender: TObject);
begin
  if whose_move in [O_computer,X_computer] then
    exit;
  // computer is O
  computers_piece := O_piece;
  players_piece := X_piece;
  O1.Checked := true;
  X1.Checked := false;
  case whose_move of
    O_player : whose_move := O_computer;
    X_player : whose_move := X_player;
  end;
  if not dont_let_computer_move then
  begin
    if whose_move = O_computer then
      computers_move;
    update_dont_move_caption;
  end;
end; { O1Click }
{----------------------------------------------------------}

procedure TBoard_form.X1Click(Sender: TObject);
begin
  if whose_move in [O_computer,X_computer] then
    exit;
  // computer is X
  computers_piece := X_piece;
  players_piece := O_piece;
  O1.Checked := false;
  X1.Checked := true;
  case whose_move of
    O_player : whose_move := O_player;
    X_player : whose_move := X_computer;
  end;
  if not dont_let_computer_move then
  begin
    if whose_move = X_computer then
      computers_move;
    update_dont_move_caption;
  end;
end; { X1Click }
{----------------------------------------------------------}

procedure TBoard_form.AutoplayMode1Click(Sender: TObject);
begin
  autoplay_mode := not autoplay_mode;
  autoplaymode1.Checked := autoplay_mode;
  if autoplay_mode then
  begin
    how_many_moves_form := thow_many_moves_form.create( nil );
    how_many_moves_form.edit1.text := inttostr( number2autoplay );
    try
      how_many_moves_form.showmodal;
      // we won't have been able to close the form without giving
      // an integer >= 0.
      number2autoplay := strtointdef( how_many_moves_form.edit1.text, -1 );
    finally
      how_many_moves_form.free;
    end;

    if number2autoplay = 0 then
    begin
      // user does not want to autoplay any moves.
      showmessage( 'You entered zero for number of moves to autoplay,' + #13 +
        'so we are not in autoplay mode.');
      autoplay_mode := false;
      autoplaymode1.Checked := false;
      exit;
    end;
    O1.Checked := true;
    X1.Checked := true;
    dont_let_computer_move := false;
    autoplay_game;
  end
  else
  begin
    O1.Checked := (computers_piece = O_piece);
    X1.Checked := (computers_piece = X_piece);
    case whose_move of
      O_computer :
        begin
          whose_move := O_player;
          caption := 'Turn ' + inttostr(turn_counter) +
            ' ... make a move player O.';
        end;
      X_computer :
        begin
          whose_move := X_player;
          caption := 'Turn ' + inttostr(turn_counter) +
            ' ... make a move player X.';
        end;
    end; // case
  end;
end; { AutoplayMode1Click }
{----------------------------------------------------------}

procedure TBoard_form.SuggestAMove1Click(Sender: TObject);
var
  old_computers_piece, old_caption : string;
begin
  old_computers_piece := computers_piece;
  case whose_move of
    O_player : computers_piece := O_piece;
    X_player : computers_piece := X_piece;
  end;
  suggest_a_move := true;
  old_caption := caption;
  computers_move;
  computers_piece := old_computers_piece;
  caption := old_caption;
  suggest_a_move := false;
end; { SuggestAMove1Click }
{----------------------------------------------------------}

procedure TBoard_form.DontLetComputerMoveMode1Click(Sender: TObject);
begin
  toggle_dont_move_mode;
end; { DontLetComputerMoveMode1Click }
{----------------------------------------------------------}

procedure TBoard_form.RowandColumnNumbers1Click(Sender: TObject);
begin
  want_row_col_numbers := not want_row_col_numbers;
  fix_form_elements;
end; { RowandColumnNumbers1Click }
{----------------------------------------------------------}

procedure TBoard_form.N2HumanOpponentsMode1Click(Sender: TObject);
var
  exit1 : boolean;
begin
  exit1 := false;
  two_human_opponents := not two_human_opponents;
  N2HumanOpponentsMode1.Checked := two_human_opponents;
  if two_human_opponents then
  begin
    O1.Checked := true;
    X1.Checked := false;
    showmessage( 'Now in 2 Human opponents mode.');
  end
  else
  begin
    Exit2Humans_form := tExit2Humans_form.create( nil );
    try
      case Exit2Humans_form.showmodal of
        mrYes : // Computer Plays O
          O1Click( nil );
        mrNo : // Computer Plays X
          X1Click( nil );
        mrCancel, mrOK :
          begin
            N2HumanOpponentsMode1.Checked := true;
            two_human_opponents := true;
            showmessage( 'Staying in 2 Human opponents mode.');
            exit1 := true;
          end
      end; // case
    finally
      FreeAndNil(Exit2Humans_form);
    end; // try
    if exit1 then
      exit;
  end;
end; { N2HumanOpponentsMode1Click }
{----------------------------------------------------------}

procedure TBoard_form.ViewWeights1Click(Sender: TObject);
var
  x : integer;
  highest_move_rating : integer;
  found, exit1 : boolean;
var
  old_computers_piece : string;
begin
  old_computers_piece := computers_piece;

  exit1 := false;
  // we'll use the Exit2Humans_form to as which side's weights
  // we want to look at
  Exit2Humans_form := tExit2Humans_form.create( nil );
  try
    Exit2Humans_form.caption := 'Select the side that you want to see the weights of';
    Exit2Humans_form.computerO.caption := 'Check weights for &O';
    Exit2Humans_form.computerX.caption := 'Check weights for &X';
    case Exit2Humans_form.showmodal of
      mrYes : // Computer Plays O
        computers_piece := O_piece;
      mrNo : // Computer Plays X
        computers_piece := X_piece;
      mrCancel, mrOK :
        begin
          showmessage( 'You didn''t select either so cancelled showing weights.');
          exit1 := true;
        end
    end; // case
  finally
    FreeAndNil(Exit2Humans_form);
  end; // try

  if exit1 then
    exit;

  weigh_move_options;
  // move weight must have been calculated before the weight_form is created
  weights_form := tweights_form.create( nil );
  try
    weights_form.init;
    weights_form.caption := 'Board weights as player ' + computers_piece;
    if winner <> no_winner then
    begin
      report_winner;
      weights_form.caption := game_over_string;
    end
    else
    begin
      quick_sort(1, max_x * max_y );
      highest_move_rating := move_weights[ 1 ].weight;
      if highest_move_rating = -1 then
      begin
        game_over_string := 'There are no more moves.';
        winner := tie;
      end
      else
      begin
        //count := 0;
        found := false;
        x := 1;
        while not found and (x <= max_x*max_y) do
        begin
          if move_weights[ x ].weight = highest_move_rating then
            weights_form.highlight_highest_weights(
              move_weights[ x ].X1,
              move_weights[ x ].Y1)
          else
            found := true;
          inc(x);
        end; // while
      end; // else
    end; // else
    weights_form.showmodal;
  finally
    FreeAndNil(weights_form);
  end;
  computers_piece := old_computers_piece;
end; { ViewWeights1Click }
{----------------------------------------------------------}

procedure TBoard_form.show_Defence_first;
begin
  DefenceFirstunlesswinning1.checked := Defence_first;
  OffenceFirst1.Checked := not Defence_first;
end; { show_Defence_first }
{----------------------------------------------------------}

procedure TBoard_form.DefenceFirstunlesswinning1Click(Sender: TObject);
begin
  Defence_first := true;
  show_Defence_first;
end; { DefenceFirstunlesswinning1Click }
{----------------------------------------------------------}

procedure TBoard_form.OffenceFirst1Click(Sender: TObject);
begin
  Defence_first := false;
  show_Defence_first;
end; { OffenceFirst1Click }
{----------------------------------------------------------}

procedure TBoard_form.show_Weight_4_when_blocked;
begin
  Weight4orlesswhenblocked1.checked := Weight_4_when_blocked;
end; { show_Weight_4_when_blocked }
{----------------------------------------------------------}

procedure TBoard_form.Weight4orlesswhenblocked1Click(Sender: TObject);
begin
  Weight_4_when_blocked := not Weight_4_when_blocked;
end; { Weight4orlesswhenblocked1Click }
{----------------------------------------------------------}

procedure TBoard_form.Show_Co_ord_Weights;
begin
  UseCoordinateWeights1.checked := Co_ord_weights;
end; { Show_Co_ord_Weights }
{----------------------------------------------------------}

procedure TBoard_form.UseCoordinateWeights1Click(Sender: TObject);
begin
  Co_ord_weights := not Co_ord_weights;
  Show_Co_ord_Weights;
end; { UseCoordinateWeights1Click }
{----------------------------------------------------------}

procedure TBoard_form.Get_statistics(Sender: TObject);
var
  old_Defence_first,
  old_Weight_4_when_blocked,
  old_Co_ord_weights,
  temp_Defence_first,
  temp_Co_ords_Weights,
  temp_Block_4_weights : boolean;
  QQ, test_number, tempMR, old_number2autoplay : integer;
  str9 : string;
{..........................................................}

  procedure build_test_name(
    temp_Defence_first,
    temp_Co_ords_Weights,
    temp_Block_4_weights : boolean );
  begin
    if temp_Defence_first then
      str9 := 'Defence first'
    else
      str9 := 'Offence first';

    if temp_Co_ords_Weights then
      str9 := str9 + ', Weigh Co-ords'
    else
      str9 := str9 + ', Do Weigh Co-ords';

    if temp_Block_4_weights then
      str9 := str9 + ', Weigh 4 Blocked'
    else
      str9 := str9 + ', Ignore 4 Blocked';
  end; { build_test_name }
  {..........................................................}

  procedure new_game_for_stats;
  var
    i,j : integer;
  begin
    for i:= offset + 1 to max_x + offset do
      for j := offset + 1 to max_y + offset do
        Board.cells[ i-1,j-1 ] := blank_cell;

    player_quits := false;
    play_a_game := true;

    game_over_string := '';
    winner := no_winner;
    X_move_label.caption := 'Player X is yet to move.';
    O_move_label.caption := 'Player O is yet to move.';

    O1.Checked := (computers_piece = O_piece) or autoplay_mode;
    X1.Checked := (computers_piece = X_piece) or autoplay_mode;
    autoplaymode1.Checked := autoplay_mode;
    DontLetComputerMoveMode1.Checked := dont_let_computer_move;

    // X always moves first (whether its the player or computer)
    turn_counter := 1;
    suggest_a_move := false;

    if autoplay_mode then
      whose_move := X_computer
    else
      whose_move := X_player;
  end;
{..........................................................}

  procedure report_statistics;
  var
    temp_Defence_first,
    temp_Co_ords_Weights,
    temp_Block_4_weights : boolean;
    str1 : string;
  const
    line_width = 91;
  {..........................................................}

    procedure report_performed_test;
      {..........................................................}

      procedure print_statistics_line( caption1 : string;
        pad_length : integer;
        v1 : stat_value_type );
      var
        result1 : twinner;
      begin
        str1 := caption1;
        for result1 := low( twinner ) to high( twinner ) do
          str1 := str1 + format( '%-*d',[pad_length,v1[result1]]);
        statistics_form.richedit1.lines.add( str1 );
      end; { print_statistics_line }
      {..........................................................}

      procedure print_a_percentages( pad_length : integer );
      var
        result1 : twinner;
      begin
        str1 := 'Percentage games (%)         : ';
        for result1 := low( twinner ) to high( twinner ) do
          str1 := str1 + format( '%-*d',
            [ pad_length,
              ((statistics[ temp_Defence_first,
                           temp_Co_ords_Weights,
                           temp_Block_4_weights ].number_won[result1] * 100)
                           div numberGames2Test )]);
        statistics_form.richedit1.lines.add( str1 );
      end; { print_statistics_line }
      {..........................................................}

    begin { report_performed_test }
      statistics_form.richedit1.lines.add(
        '                               X Wins   , O Wins   , Tied Game, No result, ended_with_error' );
      statistics_form.richedit1.lines.add(
        '                               ---------, ---------, ---------, ---------, ----------------' );
      print_statistics_line(
        'Highest number moves for win : ', 11,
        statistics[ temp_Defence_first,
                    temp_Co_ords_Weights,
                    temp_Block_4_weights ].highest_number_of_moves_for_win );

      print_statistics_line(
        'Lowest number moves for win  : ', 11,
        statistics[ temp_Defence_first,
                    temp_Co_ords_Weights,
                    temp_Block_4_weights ].lowest_number_of_moves_for_win );

      print_statistics_line(
        'Average number moves for win : ', 11,
        statistics[ temp_Defence_first,
                    temp_Co_ords_Weights,
                    temp_Block_4_weights ].average_number_of_moves_for_win );

      print_statistics_line(
        'Total number of moves        : ', 11,
        statistics[ temp_Defence_first,
                    temp_Co_ords_Weights,
                    temp_Block_4_weights ].total_moves );

      print_statistics_line(
        'Number of Games Won          : ', 11,
        statistics[ temp_Defence_first,
                    temp_Co_ords_Weights,
                    temp_Block_4_weights ].number_won );

      print_a_percentages( 11 );
    end; { report_performed_test }
    {..........................................................}

  begin { report_statistics }
    statistics_form := tstatistics_form.create( nil );
    try

    str9 := format( 'Statistic Test Results for %d Games x %d Tests',
        [numberGames2Test, QQ] );
    statistics_form.richedit1.lines.add(
      StringOfChar(' ',(line_width-length(str9)) div 2) + str9 );
    statistics_form.richedit1.lines.add(
      StringOfChar(' ',(line_width-length(str9)) div 2) +
      StringOfChar('*',length(str9)) );
    statistics_form.richedit1.lines.add( '' );

    for temp_Defence_first := true downto false do
    begin
      for temp_Co_ords_Weights := true downto false do
      begin
        for temp_Block_4_weights := true downto false do
        begin
          build_test_name(
            temp_Defence_first, temp_Co_ords_Weights, temp_Block_4_weights );
          statistics_form.richedit1.lines.add(
            StringOfChar(' ',(line_width-length(str9)) div 2) + str9 );
          statistics_form.richedit1.lines.add(
            StringOfChar(' ',(line_width-length(str9)) div 2) +
            StringOfChar('=',length(str9)) );
          if statistics[ temp_Defence_first,
                         temp_Co_ords_Weights,
                         temp_Block_4_weights ].perform_test then
            report_performed_test
          else
            statistics_form.richedit1.lines.add( '*** Test Not Performed ***' );
          statistics_form.richedit1.lines.add( '' );
          statistics_form.richedit1.lines.add( '' );
        end;
      end;
    end;
      statistics_form.ShowModal;
    finally
      statistics_form.free;
    end;
  end; { report_statistics }
{..........................................................}

  procedure add_2_statistics;
  begin
    with statistics[ temp_Defence_first,
                     temp_Co_ords_Weights,
                     temp_Block_4_weights ] do
    begin
      if turn_counter > highest_number_of_moves_for_win[ winner ] then
        highest_number_of_moves_for_win[ winner ] := turn_counter;

      if (turn_counter < lowest_number_of_moves_for_win[ winner ]) and
         (lowest_number_of_moves_for_win[ winner ] <> 0) then
        lowest_number_of_moves_for_win[ winner ] := turn_counter;

     inc(number_won[ winner ]);
     total_moves[ winner ] := total_moves[ winner ] + turn_counter;

     if number_won[ winner ] <> 0 then
       average_number_of_moves_for_win[ winner ] :=
       total_moves[ winner ] div number_won[ winner ];
    end;
  end; { add_2_statistics }
{..........................................................}

  procedure perform_statistics_test;
  var
    result_index : twinner;
    index1 : integer;
  begin
    build_test_name(
      temp_Defence_first, temp_Co_ords_Weights, temp_Block_4_weights );
    for result_index := low(twinner) to high(twinner) do
      with statistics[ temp_Defence_first,
                       temp_Co_ords_Weights,
                       temp_Block_4_weights ] do
      begin
        highest_number_of_moves_for_win[ result_index ] := 0;
        lowest_number_of_moves_for_win[ result_index ] := 0;
        average_number_of_moves_for_win[ result_index ] := 0;
        total_moves[ result_index ] := 0;
        number_won[ result_index ] := 0;
      end;

    Defence_first := temp_Defence_first;
    Co_ord_weights := temp_Co_ords_Weights;
    Weight_4_when_blocked := temp_Block_4_weights;

    for index1 := 1 to numberGames2Test do
    begin
      status_label.caption :=
        format( 'Test %d of %d : Game %d of %d%s%s',
          [test_number,QQ,index1,numberGames2Test,#13,str9] );
      new_game_for_stats;
      autoplay_game;
      add_2_statistics;
    end;
  end; { perform_statistics_test }
{..........................................................}

begin { Get_statistics }
  statistics_tests_form := tstatistics_tests_form.create( nil );
  try
    statistics_tests_form.times_to_do_each_test.text :=
      inttostr( numberGames2Test );
    tempMR := statistics_tests_form.showmodal;
    // we won't have been able to close the form without giving
    // an integer >= 0.
    numberGames2Test :=
      strtointdef( statistics_tests_form.times_to_do_each_test.text, -1 );
    statistics_tests_form.count_tests;
    QQ := statistics_tests_form.NumberTestsSelected;
  finally
    statistics_tests_form.free;
  end;

  if tempMR <> mrOK then
  begin
    showmessage( 'You cancelled the Statistic Tests.');
    exit;
  end;

  if numberGames2Test = 0 then
  begin
    // user has entered zero for number of tests
    showmessage( 'You entered zero for number of moves to test,' + #13 +
      'so we will not do any statistics test.');
    exit;
  end;

  if QQ = 0 then
  begin
    // user has not selected any tests
    showmessage( 'You have not selected any tests to perfrom,' + #13 +
      'so we will not do any statistics test.');
    exit;
  end;

  old_Defence_first := Defence_first;
  old_Weight_4_when_blocked := Weight_4_when_blocked;
  old_Co_ord_weights := Co_ord_weights;

  status_label.visible := true;

  old_number2autoplay := number2autoplay;
  number2autoplay := max_x * max_y;
  autoplay_mode := true;
  stat_mode := true;

  test_number := 0;
  for temp_Defence_first := true downto false do
    for temp_Co_ords_Weights := true downto false do
      for temp_Block_4_weights := true downto false do
        if statistics[ temp_Defence_first,
                       temp_Co_ords_Weights,
                       temp_Block_4_weights ].perform_test then
        begin
          inc(test_number);
          perform_statistics_test;
        end;

  stat_mode := false;
  autoplay_mode := false;
  number2autoplay := old_number2autoplay;

  status_label.caption := 'Tests Complete.';
  report_statistics;
  status_label.visible := false;

  Defence_first := old_Defence_first;
  Weight_4_when_blocked := old_Weight_4_when_blocked;
  Co_ord_weights := old_Co_ord_weights;

  computers_piece := O_piece;
  players_piece := X_piece;

  play_new_game;

end; { Get_statistics }
{----------------------------------------------------------}

procedure TBoard_form.Keyboardshortcuts1Click(Sender: TObject);
begin
  showmessage(
    'Here are all keyboard shortcuts' + #13 +
    '' + #13 +
    '2 - Toggle 2 human opponents mode' + #13 +
    'A - Autoplay mode ON (computer finishes playing current game)' + #13 +
    'B - Help / About' + #13 +
    'D - Toggle "Don''t Move Mode"' + #13 +
    'E - Help / Setting Up A Game' + #13 +
    'H - Help / How to Play' + #13 +
    'K - Help / Keyboard shortcuts (this screen)' + #13 +
    'N - Play New Game' + #13 +
    'O - Place an O piece (only valid if it is O''s turn or in Don''t Move Mode).' + #13 +
    'Q - Quit (you will be prompted - enter Y to exit)' + #13 +
    'R - Toggle Row and Column numbers' + #13 +
    'S - Suggest A Move' + #13 +
    'T - Do Statistics Test' + #13 +
    'W - View Weights' + #13 +
    'X - Place an X piece (only valid if it is X''s turn or in Don''t Move Mode).' + #13 +
    'esc - Minimise program' + #13 +
    'space - Clear the cell (only valid in Don''t Move Mode).' + #13 +
    '' + #13 +
    'Alt-C - open the Tactics menu' + #13 +
    '... 3 submenus:' + #13 +
    '...... Defence or Offence (submenus: Defence First, Offence First),' + #13 +
    '...... Weight 4 or less when blocked,' + #13 +
    '...... Use Co-ordinate Weights' + #13 +
    '' + #13 +
    'Alt-G - open Games menu' + #13 +
    '' + #13 +
    'Alt-H - open Help menu' );
end; { Keyboardshortcuts1Click }
{----------------------------------------------------------}

end.
