unit Unit1;

{
  This program illustrates how to use the DColorBtn component.

  Note: The properties DisabledColor & DownColor are new to the
  component, but you don't really need them. They were simple to
  add and I like them, so I left them in. You could remove these
  2 properties and it would still work OK.

  -- PEW ( mailto:pwill@ausi.com, or pew@pcug.org.au )

  18 Feb 2002

  Using: Delphi 5 Pro.
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, DColorBtn;

type
  TForm1 = class(TForm)
    Button1: TButton;
    MainMenu1: TMainMenu;
    Enable1: TMenuItem;
    Button11: TMenuItem;
    Button21: TMenuItem;
    Normalbutton1: TMenuItem;
    DColorBtn1: TDColorBtn;
    DColorBtn2: TDColorBtn;
    procedure FormCreate(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button21Click(Sender: TObject);
    procedure Normalbutton1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  // DcolorBtn1 does not change color when you click it
  // because DownColor default to clBtnFace (which is the
  // same as the default color)
  Dcolorbtn1.caption := 'CColorBtn' + #13 +
    'with default values';
  // CcolorBtn2 will change color when you click it
  // DownColor set at design time (in this example)
  Dcolorbtn1.enabled := true;
  Button11.checked := true;

  Dcolorbtn2.caption := 'DColorBtn' + #13 +
    'additional color related' + #13 +
    'properties set at design time';
  Dcolorbtn2.enabled := true;
  Button21.checked := true;

  // needed to make the disabled color same as button color
  // when button is not the standard color
  // note: you could do this at design time
  Dcolorbtn2.DisabledColor := DcolorBtn2.Color;
  // uncomment next lime to see how to use DisabledColor
  //Dcolorbtn2.DisabledColor := clLime;

  NormalButton1.checked := true;
  Button1.enabled := true;
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
  // toggle the menu item
  button11.checked := not button11.checked;
  // enable/disabled the colorbtn based on the menu
  // item's checked property
  Dcolorbtn1.enabled := button11.checked;
end;

procedure TForm1.Button21Click(Sender: TObject);
begin
  // toggle the menu item
  button21.checked := not button21.checked;
  // enable/disabled the colorbtn based on the menu
  // item's checked property
  Dcolorbtn2.enabled := button21.checked;
end;

procedure TForm1.Normalbutton1Click(Sender: TObject);
begin
  // toggle the menu item
  Normalbutton1.checked := not Normalbutton1.checked;
  // enable/disabled the button1 based on the menu
  // item's checked property
  Button1.enabled := Normalbutton1.checked;
end;

end.
