unit DColorBtn;

{ ------------------------------------------------------------
  Author: Unknown +
  ------  modifications by Peter E. Williams +
          suggestions from alt.comp.lang.borland-delphi newsgroup +
          mods by Michael Phillips + PEW.

  This code is freeware and is placed into the Public Domain
  by Peter E. Williams (pwill@ausi.com).

  This version: 0.03 - Dated: 17 February 2002
  Note: renamed to "DColorBtn.pas"

  Note: new to v0.03 2 new properties added:
  DownColor & DisabledColor
  and test program included.

  Previous versions:
  -----------------
  (under the name: "AcolorBtn.pas")
  Version: 0.02 - Dated: 14 February 2001
  Version: 0.01 - Dated: 14 April 2000

  Thanks and Acknowledgements:
  ---------------------------
  Thanks to the unknown person who originally sent me version 0.01 of this code,
  and to Bruce Roberts (ber@bounceitattcanada.xnet) who posted up v0.02 modifications
  to the ng. Thanks also to all those in the alt.comp.lang.borland-delphi newsgroup
  for their discussion of it and support.

  Thanks also to Michael Phillips for cleaning up the code for 0.03

  Last modified by: Peter E. Williams

  Known bugs:
  ----------

   (#1 is now fixed!!!)
    #1 - Captions containing #13 characters are displayed as
         as single line of text.

    (#2 is now fixed!!!)
    #2 - There is no visual difference between Enabled true or false. The
         Enabled property works otherwise as normal. Workaround is to use
         the Font.Style settings to show when a button is Enabled, e.g.
         for Enabled = true set to [fsbold], false set to [fsitalic] (this
         is NOT done automatically).

   Available from:
         http://www.angelfire.com/biz6/pwillcomputing/delphi.html
         http://members.fortunecity.com/pew/delphi.html
   as filename:
         colorbtn_src_003.zip

 ------------------------------------------------------------
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TDColorBtn = class(TButton)
  private
    IsFocused: Boolean;
    FCanvas: TCanvas;
    FDownColor : TColor;
    FDisabledColor : TColor;
    procedure CNDrawItem(var Msg: TWMDrawItem); message CN_DRAWITEM;
    procedure CMFontChanged(var Msg: TMessage); message CM_FONTCHANGED;
    procedure CMEnabledChanged(var Msg: TMessage); message CM_ENABLEDCHANGED;
    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk);
      message WM_LBUTTONDBLCLK;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure SetButtonStyle(ADefault: Boolean); override;
  public
    constructor Create (AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Color;
    property DownColor : TColor read FDownColor write FDownColor;
    property DisabledColor : TColor read FDisabledColor write FDisabledColor;
  end;

procedure Register;

{------------------------------------------------------------}

implementation

{------------------------------------------------------------}

constructor TDColorBtn.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  FCanvas := TCanvas.Create;
  FDownColor := clBtnFace;
  FDisabledColor := clBtnFace;
end;
{------------------------------------------------------------}

destructor TDColorBtn.Destroy;
begin
  FCanvas.Free;
  inherited Destroy;
end;
{------------------------------------------------------------}

procedure TDColorBtn.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params do
    Style := Style or BS_OWNERDRAW;
end;
{------------------------------------------------------------}

procedure TDColorBtn.CNDrawItem(var Msg: TWMDrawItem);
var
  OdsDown, OdsFocus, ActionFocus: Boolean;
  Rect, bRect : TRect;
  spacer : integer;
  SaveIndex: Integer;
begin

  with Msg.DrawItemStruct^ do
    begin
      SaveIndex := SaveDC(hDC);
      FCanvas.Lock;
      try

        // initialize
        FCanvas.Handle := hDC;
        FCanvas.Font := Font;
        FCanvas.Brush := Brush;

        Rect := ClientRect;
        Dec (Rect.Right);
        Dec (Rect.Bottom);

        OdsDown := itemState and ODS_SELECTED <> 0;
        OdsFocus := itemState and ODS_FOCUS <> 0;
        ActionFocus := ItemAction = oda_Focus;

        with FCanvas do
        begin
          // code to fix bug #2
          // button color is (one of 3 possiblities):
          // (1) normally Color,
          // (2) DownColor when button is down
          // (3) DisabledColor when button is disabled (enabled = false)
          if OdsDown then
            Brush.Color := fDownColor  // (2)
          else
            if enabled then
              Brush.Color := Color  // (1)
            else
              Brush.Color := fDisabledColor;  // (3)

          if not ActionFocus then
          begin
            // fill with current color
            Brush.Style := bsSolid;
            FillRect (Rect);
          end;
          // do not fill any more
          Brush.Style := bsClear;
          // draw border if default
          if Default or OdsFocus then
          begin
            Pen.Color := clWindowFrame;
            if not ActionFocus then
              Rectangle (Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
            // reduce the area for further operations
            InflateRect (Rect, -1, -1);
          end;

          if OdsDown then
          begin
            // draw gray border all around
            Pen.Color := clBtnShadow;
            if not ActionFocus then
              Rectangle (Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
          end
          else if not ActionFocus then
          begin
            // gray border (bottom-right)
            Pen.Color :=  clWindowFrame;
            MoveTo(Rect.Left, Rect.Bottom);
            LineTo(Rect.Right, Rect.Bottom);
            LineTo(Rect.Right, Rect.Top);

            // if OdsDown then keep gray border
            if not OdsDown then
              // white border (top-left)
              Pen.Color := clWhite;
            LineTo(Rect.Left, Rect.Top);
            LineTo(Rect.Left, Rect.Bottom);

            // gray border (bottom-right, internal)
            Pen.Color := clBtnShadow;
            InflateRect (Rect, -1, -1);
            MoveTo(Rect.Left, Rect.Bottom);
            LineTo(Rect.Right, Rect.Bottom);
            LineTo(Rect.Right, Rect.Top);
          end;
          // draw the caption
          InflateRect (Rect, -2, -2);
          if OdsDown then
          begin
            Inc (Rect.Left, 2);
            Inc (Rect.Top, 2);
          end;
          Font := Self.Font;

          // --- new code for v0.02
          if not ActionFocus then
          begin
            bRect := Rect;

            DrawText(fCanvas.Handle, pChar(Caption), -1, bRect,
              dt_CalcRect or dt_WordBreak or dt_Center);

            spacer := (((Rect.Bottom - Rect.Top) - (bRect.Bottom - bRect.Top)) div 2);
            bRect := Rect;
            bRect.Top := bRect.Top + spacer;

            // new to DColorBtn
            if not enabled then
            begin
              OffsetRect(bRect, 1, 1);
              Font.Color := clBtnHighlight;
            end;

            DrawText(fCanvas.Handle, pChar(Caption), -1, bRect,
              dt_WordBreak or dt_Center);

            // new to DColorBtn
            if not enabled then
            begin
              OffsetRect(bRect, -1, -1);
              Font.Color := clBtnShadow;
              DrawText(fCanvas.Handle, pChar(Caption), -1, bRect,
                dt_WordBreak or dt_Center);
            end;

          end;
          // --- end of v0.02 new code.

          // draw the focus rect around the text
          Brush.Style := bsSolid;
          Pen.Color:= clBlack;
          Brush.Color := clWhite;
          if IsFocused or OdsFocus or ActionFocus then
            DrawFocusRect (Rect);
        end; // with FCanvas and if DrawEntire

      finally
        FCanvas.Handle := 0;
        FCanvas.Unlock;
        RestoreDC(hDC, SaveIndex);
      end;
    end;

  Msg.Result := 1; // message handled
end;
{------------------------------------------------------------}

procedure TDColorBtn.CMFontChanged(var Msg: TMessage);
begin
  inherited;
  Invalidate;
end;
{------------------------------------------------------------}

procedure TDColorBtn.CMEnabledChanged(var Msg: TMessage);
begin
  inherited;
  Invalidate;
end;
{------------------------------------------------------------}

procedure TDColorBtn.WMLButtonDblClk(var Message: TWMLButtonDblClk);
begin
  Perform(WM_LBUTTONDOWN, Message.Keys, Longint(Message.Pos));
end;
{------------------------------------------------------------}

procedure TDColorBtn.SetButtonStyle (ADefault: Boolean);
begin
  if ADefault <> IsFocused then
  begin
    IsFocused := ADefault;
    Invalidate; {Refresh - in TBitBtn.SetButtonStyle }
  end;
end;
{------------------------------------------------------------}

procedure Register;
begin
  RegisterComponents('Samples', [TDColorBtn]);
end;
{------------------------------------------------------------}

end.
