unit join_unit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus;

const
  One_K = 1024;
type
  ErrorAction_type = (Abort, Retry, Cancel);
  TForm2 = class(TForm)
    Part1filename: TEdit;
    Label1: TLabel;
    Join_button: TButton;
    Cancel_button: TButton;
    browse_button: TButton;
    Status_Memo: TMemo;
    OpenDialog1: TOpenDialog;
    output_filename: TEdit;
    Label2: TLabel;
    MainMenu1: TMainMenu;
    MainMain1: TMenuItem;
    Help1: TMenuItem;
    extension: TEdit;
    change_extension_button: TButton;
    Label3: TLabel;
    procedure Handle_IOError( Str1 : String; 
                              var ErrorAction : ErrorAction_Type );
    procedure browse_buttonClick(Sender: TObject);
    procedure Part1filenameExit(Sender: TObject);
    procedure Join_buttonClick(Sender: TObject);
    procedure MainMenu1Click(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure change_extension_buttonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.DFM}

{---------------------------------------------------------}

procedure TForm2.Handle_IOError( Str1 : String;
                                 var ErrorAction : ErrorAction_Type );

// only called when there IS an IOError. Don't know what it is.

begin
  case MessageDlg( Str1 + ' File access error. Try again?',
                   mtCustom, [mbAbort, mbRetry, mbCancel], 0) of
    mrAbort : ErrorAction := Abort;
    mrRetry : ErrorAction := Retry;
    mrCancel : ErrorAction := Cancel;
  end;
end; { Handle_IOError }
{---------------------------------------------------------}

procedure TForm2.browse_buttonClick(Sender: TObject);
begin
  opendialog1.filename := '*.*';
  if opendialog1.execute then
    Part1filename.text := opendialog1.filename;
end; { browse_buttonClick }
{---------------------------------------------------------}

procedure TForm2.Part1filenameExit(Sender: TObject);
begin
  if length( extension.Text ) = 0 then
    showmessage( 'Error: you can''t specify a blank extension.' )
  else
  begin
    // extension should NOT have a leading '.'
    if copy( extension.Text, 1, 1 ) = '.' then
      extension.Text := copy( extension.Text, 2, (length( extension.Text ) - 1) );
    if (Part1filename.text <> 'Part 1 filename') then
      output_filename.text := changefileext( Part1filename.text, '.' + extension.Text )
    else
      showmessage( 'Error: You need to enter a part 1 filename.' + #13 +
                   'Hint, use the "Browse" button.');
  end;
end; { Part1filenameExit }
{---------------------------------------------------------}

procedure TForm2.Join_buttonClick(Sender: TObject);
var
  NumRead, NumWritten, part_to_append,
  TotalWrittenPerPart, GrandTotalWritten : integer;
  FromFile, ToFile : tfilestream;
  FromFilename, ToFilename, temp_str : string;
  Buf: array[ 1..One_K ] of Char;
  ReadErrorAction, WriteErrorAction :  ErrorAction_type;
  IOError, Read_IOError, Write_IOError : boolean;
begin
  Status_memo.lines.clear;
  FromFile := nil;
  ToFile := nil;
  part_to_append := 1;
  if (Part1filename.text <> '') and (output_filename.text <> '') then
  begin
    FromFilename := Part1filename.text;
    ToFilename := output_filename.text;

    FromFilename := changefileext( Part1filename.text, '.' + inttostr(part_to_append) );
    if ExtractFileDrive( FromFilename ) <> '' then
      if (string(ExtractFileDrive( FromFilename ))[1] in [ 'A','a','B','b' ]) then
        showmessage( 'Please insert diskette containing file:' + #13 +
                     FromFilename + #13 +
                     'Just hit OK when last part has been processed.' );

    if not fileExists( FromFilename ) then
    begin
      Status_memo.Lines.Add( 'Error: Part 1 file does not exist.');
      exit;
    end;

    // try to open the output file
    repeat
      IOError := false;
      try
        ToFile := TFileStream.Create( ToFilename, fmCreate or fmShareExclusive);
      except
        on EFCreateError do Handle_IOError( 'File Create Error', WriteErrorAction );
        else
          Handle_IOError( 'Write Error (opening output file)', WriteErrorAction );
        IOError := true;
      end;
    until (not IOError) or
          ((IOError) and (WriteErrorAction <> Retry));

    // if we didn't open the output file successfully...
    if IOError then
      exit;

    temp_str := 'Writing file: ' + ToFilename;
    GrandTotalWritten := 0;

    while FileExists( Fromfilename ) do
    begin
      repeat
      until (not IOError) or
            ((IOError) and (ReadErrorAction <> Retry));

      if IOError then
        exit;

      TotalWrittenPerPart := 0;
      repeat
        begin
        IOError := false;
        try
          FromFile := TFileStream.Create( FromFilename, fmOpenRead or fmShareExclusive);
        except
          on EFOpenError do Handle_IOError( 'File Open Error', ReadErrorAction );
          else
            Handle_IOError( 'Read Error (opening output file)', ReadErrorAction );
          IOError := true;
        end;

        repeat
          Read_IOError := false;
          numRead := 0;
          try
            numRead := FromFile.Read(Buf, sizeof(buf));    // to read bufferSize bytes
          except
            on EFilerError do Handle_IOError( 'File Read Error', ReadErrorAction );
            else
              Handle_IOError( 'Read Error (reading input file)', ReadErrorAction );
            Read_IOError := true;
          end;

          Write_IOError := false;
          numWritten := 0;
          try
            numWritten := ToFile.Write(Buf, numRead);    // to write numRead bytes
          except
            on EFilerError do Handle_IOError( 'File Write Error', WriteErrorAction );
            else
              Handle_IOError( 'Read Error (writing output file)', WriteErrorAction );
            Write_IOError := true;
          end;
          TotalWrittenPerPart := TotalWrittenPerPart + NumWritten;
        until (NumRead = 0) or (NumWritten <> NumRead) or
              ((Read_IOError) and (ReadErrorAction <> Retry)) or
              ((Write_IOError) and (WriteErrorAction <> Retry));

        if (Write_IOError or Read_IOError) then
          exit;

      end;
      until (NumRead = 0) or (NumWritten <> NumRead);

      FromFile.Free();

      Status_memo.Lines.Add( 'File part: ' + FromFilename + ' read (' +
                       inttostr(TotalWrittenPerPart div One_K) + ' K bytes).');
      GrandTotalWritten := GrandTotalWritten + TotalWrittenPerPart;
      inc( part_to_append );
      FromFilename := changefileext( Part1filename.text, '.' + inttostr(part_to_append) );
      if (string(ExtractFileDrive( FromFilename ))[1] in [ 'A','a','B','b' ]) then
        showmessage( 'Please insert diskette containing file:' + #13 +
                     FromFilename + #13 +
                     'Just hit OK when last part has been processed.' );
    end;

    ToFile.Free();

    Status_Memo.lines.add( 'Output file: ' + ToFilename + ' written (' +
                           inttostr(GrandTotalWritten div One_K) + ' K bytes).' );
  end;
end; { Join_buttonClick }
{---------------------------------------------------------}

procedure TForm2.MainMenu1Click(Sender: TObject);
begin
  close;
end; { MainMenu1Click }
{---------------------------------------------------------}

procedure TForm2.Help1Click(Sender: TObject);
begin
  Application.HelpJump( 'Title' );
end; { Help1Click }
{---------------------------------------------------------}

procedure TForm2.change_extension_buttonClick(Sender: TObject);
begin
  if length( extension.Text ) = 0 then
    showmessage( 'Error: you can''t specify a blank extension.' )
  else
  begin
    // extension should NOT have a leading '.'
    if copy( extension.Text, 1, 1 ) = '.' then
      extension.Text := copy( extension.Text, 2, (length( extension.Text ) - 1) );
    output_filename.Text := changefileext( output_filename.Text, '.' + extension.Text );
  end;
end; { change_extension_buttonClick }
{---------------------------------------------------------}

end.
