unit Chop_unit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages,
  Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus;

const
  One_K = 1024;
type
  ErrorAction_type = (Abort, Retry, Cancel);
  TForm1 = class(TForm)
    Input_filename: TEdit;
    Input_fn_label: TLabel;
    Output_filename: TEdit;
    Output_fn_label: TLabel;
    How_many_label: TLabel;
    How_many_blocks: TEdit;
    Note_label: TLabel;
    Status_memo: TMemo;
    Start: TButton;
    MainMenu1: TMainMenu;
    Help1: TMenuItem;
    Browse: TButton;
    OpenDialog1: TOpenDialog;
    MainMenu2: TMenuItem;
    cancel_button: TButton;
    procedure Handle_IOError( Str1 : String;
                              var ErrorAction : ErrorAction_Type );
    procedure StartClick(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure BrowseClick(Sender: TObject);
    procedure Input_filenameExit(Sender: TObject);
    procedure MainMenu2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{---------------------------------------------------------}

procedure TForm1.Handle_IOError( Str1 : String;
                                 var ErrorAction : ErrorAction_Type );

// only called when there IS an IOError. Don't know what it is.

begin
  case MessageDlg( Str1 + ' Try again?',
                   mtCustom, [mbAbort, mbRetry, mbCancel], 0) of
    mrAbort : ErrorAction := Abort;
    mrRetry : ErrorAction := Retry;
    mrCancel : ErrorAction := Cancel;
  end;
end; { Handle_IOError }
{---------------------------------------------------------}

procedure TForm1.StartClick(Sender: TObject);
var
  ChopSize, // number of 1K blocks
  NumRead, NumWritten, // in bytes
  blockcount, // count for ChopSize x One_K blocks
  SizeWritten, // in K
  TotalBytesWritten // in bytes
//  , Number_of_full_blocks, Last_block_size
  : integer;
  ChopSizeStr, FromFStr, ToFStr : string;
  FromFile, ToFile: tfilestream;
  Buf: array[ 1..One_K ] of Char;
  ReadErrorAction, WriteErrorAction :  ErrorAction_type;
  IOError, Read_IOError, Write_IOError : boolean;
begin
  Status_memo.Clear;
  FromFStr := Input_filename.text;
  ToFStr := Output_filename.text;
  TotalBytesWritten := 0;
  FromFile := nil;
  ToFile := nil;
  if length( ToFstr ) > 0 then
  begin
    ChopSizeStr := how_many_blocks.text;
    try
    begin
      ChopSize := strtoint( how_many_blocks.text );

      { Start looking for files }
      if fileExists(FromFStr) then
      begin
        repeat
          IOError := false;
          try
            FromFile := TFileStream.Create( FromFStr, fmOpenRead or fmShareExclusive);
          except
            on EFOpenError do Handle_IOError( 'File Open Error', ReadErrorAction );
            else
              Handle_IOError( 'Read Error (opening output file)', ReadErrorAction );
            IOError := true;
          end;
        until (not IOError) or
              ((IOError) and (ReadErrorAction <> Retry));

        if IOError then
          exit;

//        Last_block_size := (FromFile.Size -
//          ((FromFile.Size div (One_K * ChopSize)) * One_K * ChopSize));
//        Number_of_full_blocks := FromFile.Size div (One_K * ChopSize);
//        showmessage( '# of full blocks = ' + inttostr( number_of_full_blocks ) + #13 +
//          'Last_block_size = ' + inttostr(last_block_size));

        Status_memo.Lines.Add( 'Copying ' + inttostr(FromFile.size div One_K) + ' K bytes...');

        blockcount := 1;
        repeat
        begin
          ToFStr := ChangeFileExt( ToFStr, '.' + inttostr( blockcount ));
          if ExtractFileDrive( ToFStr ) <> '' then
            if (string(ExtractFileDrive( ToFStr ))[1] in [ 'A','a','B','b' ]) then
              showmessage( 'Please insert destination diskette for file:' + #13 +
                           ToFStr );
          repeat
            IOError := false;
            try
              ToFile := TFileStream.Create( ToFStr, fmCreate or fmShareExclusive);
            except
              on EFCreateError do Handle_IOError( 'File Create Error', WriteErrorAction );
              else
                Handle_IOError( 'Write Error (opening output file)', WriteErrorAction );

              IOError := true;
            end;
          until (not IOError) or
                ((IOError) and (WriteErrorAction <> Retry));

          if IOError then
            exit;

          inc( blockcount );
          SizeWritten := 0;
          repeat
            Read_IOError := false;
            numRead := 0;
            try
              numRead := FromFile.Read(Buf, sizeof(buf));    // to read bufferSize bytes
            except
              on EFilerError do Handle_IOError( 'File Read Error', ReadErrorAction );
              else
                Handle_IOError( 'Read Error (reading input file)', ReadErrorAction );
              Read_IOError := true;
            end;

            Write_IOError := false;
            numWritten := 0;
            try
              // --- change for v0.06a
              //  numWritten := ToFile.Write(Buf, sizeof(buf));    // to write numRead bytes
              numWritten := ToFile.Write(Buf, numRead );    // to write numRead bytes

            except
              on EFilerError do Handle_IOError( 'File Write Error', WriteErrorAction );
              else
                Handle_IOError( 'Read Error (writing output file)', WriteErrorAction );
              Write_IOError := true;
            end;

            TotalBytesWritten := TotalBytesWritten + NumWritten;
            if NumWritten <> 0 then
              inc( SizeWritten );
          until (NumRead = 0) or
                (NumWritten <> NumRead) or
                (SizeWritten = ChopSize) or
                ((Read_IOError) and (ReadErrorAction <> Retry)) or
                ((Write_IOError) and (WriteErrorAction <> Retry));

          ToFile.free();

          if (Write_IOError) then
            exit;
          Status_memo.Lines.Add( 'File: ' + ToFStr + ' written (' +
                                 inttostr(SizeWritten) + ' K bytes written)' );
        end;
        until (NumRead = 0) or (NumWritten <> NumRead);

        FromFile.Free();

        Status_memo.Lines.Add( 'Finished! Total of ' +
                               inttostr(TotalBytesWritten div One_K) + ' K bytes written.');
      end
      else
        Status_memo.Lines.Add( 'Error: Input file does not exist.');
    end;
      except
        Status_memo.lines.add( 'Error: Number of blocks not valid.')
    end;
  end
  else
    Status_memo.lines.add( 'Error: you have not specified an output filename.');
end; { StartClick }
{---------------------------------------------------------}

procedure TForm1.Help1Click(Sender: TObject);
begin
  Application.HelpJump( 'Title' );
end; { Help1Click }
{---------------------------------------------------------}

procedure TForm1.BrowseClick(Sender: TObject);
begin
  opendialog1.filename := '*.*';
  opendialog1.execute;
  input_filename.text := opendialog1.filename;
end; { BrowseClick }
{----------------------------------------------------------}

procedure TForm1.Input_filenameExit(Sender: TObject);
begin
  if (input_filename.text <> 'Input filename' ) then
    output_filename.text := changefileext( input_filename.text, '' );
end; { Input_filenameExit }
{----------------------------------------------------------}

procedure TForm1.MainMenu2Click(Sender: TObject);
begin
  close;
end; { MainMenu2Click }
{----------------------------------------------------------}

end.

