unit arraycolorbutton;

{ ------------------------------------------------------------
  Author: Unknown +
  ------  modifications by Peter E. Williams +
          suggestions from alt.comp.lang.borland-delphi newsgroup.

  This code is freeware and is placed into the Public Domain by Peter E. Williams
  (pwill@ausi.com).

  This version: 0.02 - Dated: 15 February 2001

  Previous versions:
  -----------------
  Version: 0.01 - Dated: 14 April 2000

  Modified to form new unit based on AColorBtn & arraybtn,
  based entirely on Acolorbtn with Row & Col properties of arraybtn added.

  Note: The only difference between this component and AColorBtn is
  essentially that this component has additional 'row' & 'col' published
  properties.

  Thanks and Acknowledgements:
  ---------------------------
  Thanks to the unknown person who originally sent me version 0.01 of this code,
  and to Bruce Roberts (ber@bounceitattcanada.xnet) who posted up v0.02 modifications
  to the ng. Thanks also to all those in the alt.comp.lang.borland-delphi newsgroup
  for their discussion of it and support.

  Last modified by: Peter E. Williams

  Known bugs:
  ----------

   (#1 is now fixed!!!)
    #1 - Captions containing #13 characters are displayed as
         as single line of text.

    #2 - There is no visual difference between Enabled true or false. The
         Enabled property works otherwise as normal. Workaround is to use
         the Font.Style settings to show when a button is Enabled, e.g.
         for Enabled = true set to [fsbold], false set to [fsitalic] (this
         is NOT done automatically).

   Available from:
         http://www.angelfire.com/biz6/pwillcomputing/peter_delphi_page.html
   as filename:
         arraycolorbtn_src.zip

 ------------------------------------------------------------
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TArrayColorButton = class(TButton)
  private
    IsFocused: Boolean;
    FCanvas: TCanvas;
    FRow,FCol: integer;
    procedure SetRow(r: integer);
    procedure SetCol(c: integer);
    procedure CNDrawItem(var Msg: TWMDrawItem); message CN_DRAWITEM;
    procedure CMFontChanged(var Msg: TMessage); message CM_FONTCHANGED;
    procedure CMEnabledChanged(var Msg: TMessage); message CM_ENABLEDCHANGED;
    procedure WMLButtonDblClk(var Message: TWMLButtonDblClk);
      message WM_LBUTTONDBLCLK;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure SetButtonStyle(ADefault: Boolean); override;
  public
    procedure SetBounds (ALeft, ATop, AWidth, AHeight: Integer); override;
    constructor Create (AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Row: integer read FRow write SetRow default 1;
    property Col: integer read FCol write SetCol default 1;
    property Color;
    property Width default 75;
    property Height default 25;
    property ParentShowHint;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnEnter;
    property OnExit;
  end;

procedure Register;

implementation

constructor TArrayColorButton.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  SetBounds (Left, Top, 75, 25);
  FCanvas := TCanvas.Create;
  FRow:=1;
  FCol:=1;
end;

destructor TArrayColorButton.Destroy;
begin
  inherited Destroy;
  FCanvas.Free;
end;

procedure TArrayColorButton.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  with Params
    do Style := Style or bs_OwnerDraw;
end;

procedure TArrayColorButton.CreateWnd;
begin
  inherited CreateWnd;
end;

procedure TArrayColorButton.SetBounds (ALeft, ATop,
  AWidth, AHeight: Integer);
begin
  inherited SetBounds (ALeft, ATop, AWidth, AHeight);
end;

procedure TArrayColorButton.CNDrawItem(var Msg: TWMDrawItem);
var
  OdsDown, OdsFocus, ActionFocus: Boolean;
  Rect, bRect : TRect;
  spacer : integer;
begin

  // initialize
  FCanvas.Handle := Msg.DrawItemStruct^.hDC;
  Rect := ClientRect;
  Dec (Rect.Right);
  Dec (Rect.Bottom);
  with Msg.DrawItemStruct^ do
  begin
    OdsDown := itemState and ODS_SELECTED <> 0;
    OdsFocus := itemState and ODS_FOCUS <> 0;
    ActionFocus := ItemAction = oda_Focus
  end;

  with FCanvas do
  begin
    Brush.Color := Color;
    if not ActionFocus then
    begin
      // fill with current color
      Brush.Style := bsSolid;
      FillRect (Rect);
    end;
    // do not fill any more
    Brush.Style := bsClear;
    // draw border if default
    if Default or OdsFocus then
    begin
      Pen.Color := clWindowFrame;
      if not ActionFocus then
        Rectangle (Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
      // reduce the area for further operations
      InflateRect (Rect, -1, -1);
    end;

    if OdsDown then
    begin
      // draw gray border all around
      Pen.Color := clBtnShadow;
      if not ActionFocus then
        Rectangle (Rect.Left, Rect.Top, Rect.Right, Rect.Bottom);
    end
    else if not ActionFocus then
    begin
      // gray border (bottom-right)
      Pen.Color :=  clWindowFrame;
      MoveTo(Rect.Left, Rect.Bottom);
      LineTo(Rect.Right, Rect.Bottom);
      LineTo(Rect.Right, Rect.Top);

      // white border (top-left)
      Pen.Color :=  clWhite;
      LineTo(Rect.Left, Rect.Top);
      LineTo(Rect.Left, Rect.Bottom);

      // gray border (bottom-right, internal)
      Pen.Color := clBtnShadow;
      InflateRect (Rect, -1, -1);
      MoveTo(Rect.Left, Rect.Bottom);
      LineTo(Rect.Right, Rect.Bottom);
      LineTo(Rect.Right, Rect.Top);
    end;
    // draw the caption
    InflateRect (Rect, -2, -2);
    if OdsDown then
    begin
      Inc (Rect.Left, 2);
      Inc (Rect.Top, 2);
    end;
    Font := Self.Font;

    // --- new code for v0.02
    if not ActionFocus then
    begin
      bRect := Rect;
      DrawText(fCanvas.Handle, pChar(Caption), -1, bRect, dt_CalcRect or dt_WordBreak or dt_Center);
      spacer := (((Rect.Bottom - Rect.Top) - (bRect.Bottom - bRect.Top)) div 2);
      bRect := Rect;
      bRect.Top := bRect.Top + spacer;
      DrawText(fCanvas.Handle, pChar(Caption), -1, bRect, dt_WordBreak or dt_Center);
    end;
    // --- end of v0.02 new code.

    // draw the focus rect around the text
    Brush.Style := bsSolid;
    Pen.Color:= clBlack;
    Brush.Color := clWhite;
    if IsFocused or OdsFocus or ActionFocus then
      DrawFocusRect (Rect);
  end; // with FCanvas and if DrawEntire
  FCanvas.Handle := 0;
  Msg.Result := 1; // message handled
end;

procedure TArrayColorButton.CMFontChanged(var Msg: TMessage);
begin
  inherited;
  Invalidate;
end;

procedure TArrayColorButton.CMEnabledChanged(var Msg: TMessage);
begin
  inherited;
  Invalidate;
end;

procedure TArrayColorButton.WMLButtonDblClk(var Message: TWMLButtonDblClk);
begin
  Perform(WM_LBUTTONDOWN, Message.Keys, Longint(Message.Pos));
end;

procedure TArrayColorButton.SetButtonStyle (ADefault: Boolean);
begin
  if ADefault <> IsFocused then
  begin
    IsFocused := ADefault;
    Invalidate;
  end;
end;

procedure TArrayColorButton.SetRow(r: integer);
begin
    if r>-1 then FRow:= r;
end;

procedure TArrayColorButton.SetCol(c: integer);
begin
    if c>-1 then FCol:= c;
end;

procedure Register;
begin
  RegisterComponents('3rd Party', [TArrayColorButton]);
end;

end.
