unit Animunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Edit1: TEdit;
    Your_response: TLabel;
    Yes: TButton;
    Button1: TButton;
    No: TButton;
    List: TButton;
    Button2: TButton;
    procedure save_data_file;
    procedure list_animals;
    procedure print_questions( var k : integer; var quit : boolean );
    procedure animals_gen;
    procedure FormCreate(Sender: TObject);
    procedure scroll_memo_down;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

const
  max_animal_data = 199; { e.g. 100 animals.
                           for n animals, equals n * 2 - 1
                           e.g. n animal answers and n - 1 questions }

type
  temp_animals = array[ 1..100 ] of string[ 20 ];
  q_and_a_type = array[ 1..max_animal_data ] of string;

var
  questions_and_answers : ^q_and_a_type;
  next_q_and_a : integer;
  answer, your_animal,
  distinguishing_question : string;
{----------------------------------------------------------}

procedure tform1.scroll_memo_down;

Var
  ScrollMessage : TWMVScroll;
  i : integer;
begin
  ScrollMessage.Msg := WM_VScroll;
  for i := Memo1.Lines.Count - 1 DownTo 0 do
  begin
    ScrollMessage.ScrollCode := sb_LineDown;
    ScrollMessage.Pos := 0;
    Memo1.Dispatch(ScrollMessage);
  end;
end;
{----------------------------------------------------------}

procedure quicksort( var a : temp_animals; Lo,Hi: integer);

{..........................................................}

procedure sort( l,r : integer);

var
  i, j : integer;
  x, y : string;

begin
  i := l;
  j := r;
  x := a[(l+r) DIV 2];
  repeat
    while a[ i ] < x do
      i:=i+1;
    while x < a[ j ] do
      j:=j-1;
    if i <= j then
    begin
      y := a[ i ];
      a[ i ] := a[ j ];
      a[ j ] := y;
      i := i + 1;
      j := j - 1;
    end;
  until i > j;
  if l < j then
    sort( l,j );
  if i < r then
    sort( i,r );
end; { sort }
{..........................................................}

begin ;
  sort(Lo,Hi);
end; { quicksort }
{----------------------------------------------------------}

procedure read_data_file;

var
  i : integer;
  datafile : text;

begin
  for i := 1 to max_animal_data do
    questions_and_answers^[ i ] := '';
  i := 1;
  assign( datafile, 'animals.dat' );
  reset( datafile );
  while (not eof( datafile )) and (i <= max_animal_data) do
  begin
    readln( datafile, questions_and_answers^[ i ] );
    i := i + 1;
  end;
  close( datafile );
  next_q_and_a := i;
end; { read_data_file }
{----------------------------------------------------------}

procedure tform1.save_data_file;

var
  i : integer;
  datafile : textfile;

begin
  i := 1;
  assignfile( datafile, 'animals.dat' );
  rewrite( datafile );
  while (questions_and_answers^[ i ] <> '') and (i <= max_animal_data) do
  begin
    writeln( datafile, questions_and_answers^[ i ] );
    i := i + 1;
  end;
  closefile( datafile );
  memo1.lines.add( 'Data file ANIMALS.DAT saved.' );
end; { save_data_file }
{----------------------------------------------------------}

procedure tform1.list_animals;

var
  x, i, count : integer;
  temp1 : temp_animals;
  temp_str : string;

begin
  for x := 1 to 100 do
    temp1[ x ] := '';
  count := 1;
  for i := 1 to max_animal_data do
  begin
    if copy( questions_and_answers^[ i ], 1, 2 ) = '\A' then
    begin
      temp1[ count ] := copy( questions_and_answers^[ i ], 3,
                        (length(questions_and_answers^[ i ]) - 2) );
      count := count + 1;
    end;
  end;
  quicksort( temp1, 1, count - 1 );
  x := 0;
  memo1.lines.add( '' );
  memo1.lines.add( 'Animals I already know are:' );
  memo1.lines.add( '' );
  temp_str := '';
  for i := 1 to count do
  begin
{    gotoxy( (14 * x + 1), wherey ); }
    temp_str := temp_str + temp1[ i ];
    temp_str := temp_str + copy('                 ',1,(14 - length(temp1[i])));
    x := x + 1;
    if x > 2 then
    begin
      x := 0;
      memo1.lines.add( temp_str );
      temp_str := '';
    end;
  end;
  memo1.lines.add( '' );
  memo1.lines.add( '' );
  scroll_memo_down;
end; { list_animals }
{----------------------------------------------------------}

procedure tform1.print_questions( var k : integer; var quit : boolean );

var
   found, no_slash_found : boolean;
   q, c, t, temp_str : string;
   x,y,z, code : integer;

begin
  x := 0;
  y := 0;
  quit := false;
  q := questions_and_answers^[ k ];
  repeat
    z := 3;
    no_slash_found := true;
    temp_str := '';
    while (z <= length(q)) and no_slash_found do
    begin
      if copy( q,z,1 ) <> '\' then
        temp_str := temp_str +  copy( q,z,1 )
      else
        no_slash_found := false;
      z := z + 1
    end;
    memo1.lines.add( temp_str + ' ?' );
    edit1.SetFocus;
    case form1.showmodal of
      mrYes : c := 'Y';
      mrNo : c := 'N';
      mrCancel : c := 'QUIT';
    end;
  until (upcase(c[ 1 ]) in ['Y','N','Q']);
  t := '\' + upcase(c[ 1 ]);

  if c <> 'QUIT' then
  begin
    found := false;
    x := 3;
    while (x <= length( q ) - 1) and not found do
    begin
      if copy( q,x,2 ) = t then
        found := true
      else
        x := x + 1;
    end;

    found := false;
    y := x + 1;
    while (y <= length( q )) and not found do
    begin
      if copy( q,y,1 ) = '\' then
        found := true
      else
        y := y + 1;
    end;
  end
    else
    begin
      found := false;
      quit := true;
    end;

  if found then
    val(copy( q, x+2, y-x-2 ), k, code );

  scroll_memo_down;
end; { print_questions }
{----------------------------------------------------------}

function upstring( s1 : string ) : string;

var
  x : integer;
  s2 : string;

begin
  s2 := '';
  for x := 1 to length( s1 ) do
    s2 := s2 + upcase( s1[ x ] );
  upstring := s2;
end; { upstring }
{----------------------------------------------------------}

procedure tform1.animals_gen;

var
  k, z1 : integer;
  b, temp_str, temp_str2 : string;
  quit : boolean;

begin
  memo1.lines.clear;
  questions_and_answers := nil;
  new( questions_and_answers );
  memo1.lines.add( 'Animal' );
  memo1.lines.add( '======');
  memo1.lines.add( '' );
  memo1.lines.add( 'Play ''Guess The Animal''' );
  memo1.lines.add( 'Think of an animal and the computer will try to guess it.');
  memo1.lines.add( '' );
  read_data_file;
  repeat
    repeat
      memo1.lines.add( 'Are you thinking of an animal (yes, list, quit) ? ');
{      edit1.setfocus; }
      case form1.showmodal of
        mrYes : answer := 'Y';
        mrCancel : answer := 'QUIT';
        mrIgnore : answer := 'LIST';
      else
        answer := form1.edit1.text;
      end;
      if answer = '' then
        answer := ' ';
      if upstring(answer) = 'LIST' then
        list_animals;
    until (upcase(answer[ 1 ]) = 'Y') or (upstring(answer) = 'QUIT');
    if (upstring(answer) <> 'QUIT') then
    begin
      k := 1;
      repeat
        print_questions( k, quit );
      until (copy( questions_and_answers^[ k ],1,2 ) <> '\Q') or
            (quit);
      if quit then
        answer := 'QUIT';
      if not quit then
      begin
        memo1.lines.add( 'Is it a ' + copy( questions_and_answers^[ k ],3,
               (length(questions_and_answers^[ k ])-2)) + '? ' );
        edit1.setfocus;
        case form1.showmodal of
          mrYes : answer := 'Y';
          mrNo : answer := 'N';
          mrCancel : answer := 'QUIT';
        end;
        if upcase(answer[ 1 ]) = 'Y' then
        begin
          memo1.lines.add( 'I guessed it correctly!' );
          memo1.lines.add( 'Why not try another animal?' );
          memo1.lines.add( '' );
        end
        else
        begin
          memo1.lines.add( '' );
          memo1.lines.add( 'What was the animal you were thinking of (then click "OK") ? ');
          repeat
            edit1.setfocus;
            case form1.showmodal of
              mrOK : begin
                       your_animal := form1.edit1.text;
                       if length( your_animal ) = 0 then
                         memo1.lines.add( 'Please type the name of your animal and click "OK"');
                     end;
              mrCancel : answer := 'QUIT';
            end;
          until (length( your_animal ) > 0) or (answer = 'QUIT');

          if answer <> 'QUIT' then
          begin
            memo1.lines.add( 'Please type in a question that would distinguish a ' );
            memo1.lines.add( your_animal + ' from a ' +
                             copy( questions_and_answers^[ k ],3,
                             (length(questions_and_answers^[ k ])-2)) + '(then click "OK") ?' );
            repeat
              edit1.setfocus;
              case form1.showmodal of
                mrOK : begin
                         distinguishing_question := form1.edit1.text;
                         if length( distinguishing_question ) = 0 then
                           memo1.lines.add( 'Please type a question to distinguish your animal and click "OK"');
                       end;
                mrCancel : answer := 'QUIT';
              end;
            until (length( distinguishing_question ) > 0) or (answer = 'QUIT');

            if answer <> 'QUIT' then
            repeat
              memo1.lines.add( 'For a ' + your_animal + ' the answer would be (yes, no, quit) ?' );
              edit1.setfocus;
              case form1.showmodal of
                mrYes : answer := 'Y';
                mrNo : answer := 'N';
                mrCancel : answer := 'QUIT';
              end;
            until (upcase(answer[ 1 ]) in ['Y','N','Q']);
            if answer <> 'QUIT' then
            begin
              if upcase(answer[ 1 ]) = 'Y' then
                b := 'N'
              else
                b := 'Y';
              z1 := next_q_and_a;
              inc( next_q_and_a, 2 );
              questions_and_answers^[ z1 ] := questions_and_answers^[ k ];
              questions_and_answers^[ z1 + 1 ] := '\A' + your_animal;
              str( z1 + 1, temp_str );
              str( z1, temp_str2 );
              questions_and_answers^[ k ] := '\Q' + distinguishing_question + '\' +
                                          upcase(answer[1]) + temp_str + '\' +
                                          b + temp_str2 + '\';
            end;
          end;
      end;
    end;
    scroll_memo_down;
  end;
  until (upstring(answer) = 'QUIT');
  save_data_file;
  dispose( questions_and_answers );
  application.terminate;
end; { animals_gen }
{----------------------------------------------------------}

procedure TForm1.FormCreate(Sender: TObject);
begin
  animals_gen;
end; { FormCreate }
{----------------------------------------------------------}

end.
