uses
  crt;

const
  max_animal_data = 199; { e.g. 100 animals.
                           for n animals, equals n * 2 - 1
                           e.g. n animal answers and n - 1 questions }

type
  temp_animals = array[ 1..100 ] of string[ 20 ];

var
  questions_and_answers : array[ 1..max_animal_data ] of string;
  next_q_and_a : integer;
  answer, your_animal,
  computers_animal, distinguishing_question : string;
{----------------------------------------------------------}

procedure quicksort( var a : temp_animals; Lo,Hi: integer);

{..........................................................}

procedure sort( l,r : integer);

var
  i, j : integer;
  x, y : string;

begin
  i := l;
  j := r;
  x := a[(l+r) DIV 2];
  repeat
    while a[ i ] < x do
      i:=i+1;
    while x < a[ j ] do
      j:=j-1;
    if i <= j then
    begin
      y := a[ i ];
      a[ i ] := a[ j ];
      a[ j ] := y;
      i := i + 1;
      j := j - 1;
    end;
  until i > j;
  if l < j then
    sort( l,j );
  if i < r then
    sort( i,r );
end; { sort }
{..........................................................}

begin ;
  sort(Lo,Hi);
end; { quicksort }
{----------------------------------------------------------}

procedure read_data_file;

var
  i : integer;
  datafile : text;

begin
  for i := 1 to max_animal_data do
    questions_and_answers[ i ] := '';
  i := 1;
  assign( datafile, 'animals.dat' );
  reset( datafile );
  while (not eof( datafile )) and (i <= max_animal_data) do
  begin
    readln( datafile, questions_and_answers[ i ] );
    i := i + 1;
  end;
  close( datafile );
  next_q_and_a := i;
end; { read_data_file }
{----------------------------------------------------------}

procedure save_data_file;

var
  i : integer;
  datafile : text;

begin
  i := 1;
  assign( datafile, 'animals.dat' );
  rewrite( datafile );
  while (questions_and_answers[ i ] <> '') and (i <= max_animal_data) do
  begin
    writeln( datafile, questions_and_answers[ i ] );
    i := i + 1;
  end;
  close( datafile );
  writeln( output, 'Data file ANIMALS.DAT saved.');
end; { save_data_file }
{----------------------------------------------------------}

procedure list_animals;

var
  x, i, z, count : integer;
  temp1 : temp_animals;

begin
  for x := 1 to 100 do
    temp1[ x ] := '';
  count := 1;
  for i := 1 to max_animal_data do
  begin
    if copy( questions_and_answers[ i ], 1, 2 ) = '\A' then
    begin
      gotoxy( 12 * x, wherey );
      if copy( questions_and_answers[ i ], z, 1 ) <> '\' then
      begin
        temp1[ count ] := copy( questions_and_answers[ i ], 3,
                          (length(questions_and_answers[ i ]) - 2) );
        count := count + 1;
      end;
    end;
  end;
  quicksort( temp1, 1, count - 1 );
  x := 0;
  writeln( output );
  writeln( output, 'Animals I already know are:' );
  writeln( output );
  for i := 1 to count - 1 do
  begin
    gotoxy( (15 * x + 1), wherey );
    write( output, temp1[ i ] );
    x := x + 1;
    if x > 4 then
    begin
      x := 0;
      writeln( output );
    end;
  end;
  writeln( output );
  writeln( output );
end; { list_animals }
{----------------------------------------------------------}

procedure print_questions( var k : integer );

var
   found, no_slash_found : boolean;
   q, c, t : string;
   x,y,z, code : integer;

begin
  q := questions_and_answers[ k ];
  repeat
    z := 3;
    no_slash_found := true;
    while (z <= length(q)) and no_slash_found do
    begin
      if copy( q,z,1 ) <> '\' then
        write( output, copy( q,z,1 ) )
      else
        no_slash_found := false;
      z := z + 1
    end;
    write( output, ' ? ');
    readln( input, c );
  until (upcase(c[ 1 ]) in ['Y','N']);
  t := '\' + upcase(c[ 1 ]);

  found := false;
  x := 3;
  while (x <= length( q ) - 1) and not found do
  begin
    if copy( q,x,2 ) = t then
      found := true
    else
      x := x + 1;
  end;

  found := false;
  y := x + 1;
  while (y <= length( q )) and not found do
  begin
    if copy( q,y,1 ) = '\' then
      found := true
    else
      y := y + 1;
  end;

  if found then
    val(copy( q, x+2, y-x-2 ), k, code );
end; { print_questions }
{----------------------------------------------------------}

function upstring( s1 : string ) : string;

var
  x : integer;
  s2 : string;

begin
  s2 := '';
  for x := 1 to length( s1 ) do
    s2 := s2 + upcase( s1[ x ] );
  upstring := s2;
end; { upstring }
{----------------------------------------------------------}

var
  k, i, z1 : integer;
  b, temp_str, temp_str2 : string;

begin
  clrscr;
  writeln( output, '                                     Animal');
  writeln( output, '                                     ======');
  writeln( output );
  writeln( output );
  writeln( output, 'Play ''Guess The Animal''' );
  writeln( output, 'Think of an animal and the computer will try to guess it.');
  writeln( output );
  read_data_file;
  repeat
    repeat
      write( 'Are you thinking of an animal (y, list, quit) ? ');
      readln( input, answer );
      if upstring(answer) = 'LIST' then
        list_animals;
    until (upcase(answer[ 1 ]) = 'Y') or (upstring(answer) = 'QUIT');
    if (upstring(answer) <> 'QUIT') then
    begin
      k := 1;
      repeat
        print_questions( k );
      until copy( questions_and_answers[ k ],1,2 ) <> '\Q';
      write( output, 'Is it a ',copy( questions_and_answers[ k ],3,
             (length(questions_and_answers[ k ])-2)), '? ' );
      readln( input, answer );
      if upcase(answer[ 1 ]) = 'Y' then
      begin
        writeln( output, 'I guessed it correctly!');
        writeln( output, 'Why not try another animal?' );
        writeln( output );
      end
      else
      begin
        write( output, 'What was the animal you were thinking of ? ');
        readln( input, your_animal );
        write( output, 'Please type in a question that would distinguish a ' );
        writeln( output, your_animal, ' from a ',
                 copy( questions_and_answers[ k ],3,
                 (length(questions_and_answers[ k ])-2)) );
        write( output, '? ');
        readln( input, distinguishing_question );
        repeat
          write( output, 'For a ',your_animal,' the answer would be ?' );
          readln( input, answer );
        until (upcase(answer[ 1 ]) in ['Y','N']);
        if upcase(answer[ 1 ]) = 'Y' then
          b := 'N'
        else
          b := 'Y';
        z1 := next_q_and_a;
        inc( next_q_and_a, 2 );
        questions_and_answers[ z1 ] := questions_and_answers[ k ];
        questions_and_answers[ z1 + 1 ] := '\A' + your_animal;
        str( z1 + 1, temp_str );
        str( z1, temp_str2 );
        questions_and_answers[ k ] := '\Q' + distinguishing_question + '\' +
                                      upcase(answer[1]) + temp_str + '\' +
                                      b + temp_str2 + '\';
      end;
    end;
  until (answer = 'quit') or (answer = 'QUIT');
  save_data_file;
end.