/*
  KString (char*) Class Header
  ----------------------------
	Adapted from the string class from "Learning C++", (Neil Graham, 1991)
  Copyright (c) Kevin John Staunton-Lambert 1998
  Copyright (c) The University of Huddersfield 1998
*/

const RC_MAX = 127;

class KString
{
	int nLength;
	char* p;

public:
  KString()
	{
		nLength = 0;
		p = 0;
	}
	KString(const char* a);
	KString(const KString& t);
	~KString();

	friend KString operator+(const KString& s, const KString& t);
	friend int operator== (const KString& s, const KString& t);
	friend int operator<= (const KString& s, const KString& t);
	friend int operator>= (const KString& s, const KString& t);
	friend int operator!= (const KString& s, const KString& t);

	int find(const KString& t, int i = 1);

	int len();

	friend int length(const KString& s)
	{
	  return s.nLength;
	}
	friend refs(const KString& s)
	{
		return s.p == 0 ? 0 : *s.p;
	}

	int length(const char* p);

	KString& operator=(const KString& t);
	KString& operator+=(const KString& t);

	char& operator[] (int i);
	
	KString mid(int i, int n);

	KString sub(int i, int n);
	KString left(int n);
	KString right(int n);

	KString ucase();
	KString lcase();

	KString replace(char Ch1, char Ch2);

	friend istream& operator>>(istream& ci, KString& t);
	friend ostream& operator<<(ostream& co, const KString& t);

  int tointeger();
  double tofloat();

};