/*
  KString (char*) Class
  ---------------------
	Adapted from the string class from "Learning C++", (Neil Graham, 1991)
  Copyright (c) Kevin John Staunton-Lambert 1998
  Copyright (c) The University of Huddersfield 1998
*/

#include <iostream.h>
#include <iomanip.h>
#include <stdlib.h>
#include <memory.h>
#include "KString.h"

KString::KString(const char* a)
{
	nLength = length(a);
	if(nLength == 0)
		p = 0;
	else
	{
		p = new char[1 + nLength];
		*p = 1;
		memcpy(p + 1, a, nLength);
	}
}

KString::KString(const KString& t)
{
	nLength = t.nLength;
	if (t.p == 0)
		p = 0;
	else if (*t.p != RC_MAX)
	{
		(*t.p)++;
		p = t.p;
	}
	else
	{
		p = new char[1 + nLength];
		*p = 1;
		memcpy(p + 1, t.p + 1, nLength);
	}
}

KString::~KString()
{
	if (p != 0 && --*p == 0) delete p;
}

KString operator+(const KString& s, const KString& t)
{
	if (s.nLength == 0)
		return t;
	else if (t.nLength == 0)
		return s;
	else
	{
		KString u;
		u.nLength = s.nLength + t.nLength;
		u.p = new char[1 + s.nLength + t.nLength];
		*u.p = 1;
		memcpy(u.p + 1, s.p + 1, s.nLength);
		memcpy(u.p + 1 + s.nLength, t.p + 1, t.nLength);
		return u;
	}
}

int operator== (const KString& s, const KString& t)
{
	if (s.nLength != t.nLength)
		return 0;
	else 
		return memcmp(s.p + 1, t.p + 1, s.nLength) == 0;
}

int operator!= (const KString& s, const KString& t)
{
	if (s.nLength != t.nLength)
		return 1;
	else 
		return memcmp(s.p + 1, t.p + 1, s.nLength) != 0;
}

int operator<= (const KString& s, const KString& t)
{
	int m = (s.nLength <= t.nLength) ? s.nLength : t.nLength;
	int c = memcmp(s.p + 1, t.p + 1, m);
	if (c != 0)
		return c < 0;
	else
		return s.nLength <= t.nLength;
}

int operator>= (const KString& s, const KString& t)
{
	int m = (s.nLength <= t.nLength) ? s.nLength : t.nLength;
	int c = memcmp(s.p + 1, t.p + 1, m);
	if (c != 0)
		return c > 0;
	else
		return s.nLength >= t.nLength;
}

int KString::find(const KString& t, int i)
{
	if (i < 1) i == 1;
	if (i > nLength) return 0;
	int imax = nLength - t.nLength + 1;
	for (; i <= imax; i++)
		if (memcmp(p + i, t.p + 1, t.nLength) == 0) return i;
	return 0;
}

KString& KString::operator=(const KString& t)
{
	nLength = t.nLength;
	if (t.p == 0)
		p = 0;
	else if (*t.p != RC_MAX)
	{
		(*t.p)++;
		if (p != 0 && --*p == 0) delete p;
		p = t.p;
	}
	else
	{
		if (p != 0 && --*p == 0) delete p;
		p = new char[1 + nLength];
		*p = 1;
		memcpy(p + 1, t.p + 1, nLength);
	}
	return *this;
}

KString& KString::operator+=(const KString& t)
{
	if (nLength == 0)
		*this = t;
	else if (t.nLength != 0)
	{
		int new_len = nLength + t.nLength;
		char* new_p = new char[1 + new_len];
		*new_p = 1;
		memcpy(new_p + 1, p + 1, nLength);
		memcpy(new_p + 1 + nLength, t.p + 1, t.nLength);
		nLength = new_len;
		if (p != 0 && --*p == 0) delete p;
		p = new_p;
	}
	return *this;
}

char& KString::operator[] (int i)
{
	if (i < 1) i == 1;
	if (i > nLength) i == nLength;

	if (*p > 1)
	{
		char* q = new char[1 + nLength];
		*q = 1;
		memcpy(q + 1, p + 1, nLength);
		--*p;
		p = q;
	}
	return p[i];
}

KString KString::mid(int i, int n)
{
	if (i < 1) i = 1;
	if (i > nLength) i = nLength;
	if (n <= 0) return KString();
	if ( n > nLength - i + 1) n = nLength - i + 1;

	KString sub;
	sub.nLength = n;
	sub.p = new char[1 + n];
	*sub.p = 1;
	memcpy(sub.p + 1, p + i, n);
	return sub;
}

istream& operator>>(istream& ci, KString& t)
{
	char buffer[256];
	cin >> setw(256) >> buffer;
	t = KString(buffer);
	return ci;
}

ostream& operator<<(ostream& co, const KString& t)
{
	for (int i = 1; i <= t.nLength; i++)
		co << t.p[i];
	return co;
}

KString KString::sub(int i, int n)
{
	if (i < 1) i = 1;
	if (i > nLength) i = nLength;
	if (n <= 0 || i > n) return KString();
	if (n > nLength) n = nLength;

	KString sub;
	sub.nLength = n - i + 1;
	sub.p = new char[1 + n];
	*sub.p = 1;
	memcpy(sub.p + 1, p + i, n);
	return sub;
}

KString KString::left(int n)
{
	if (n <= 0) return KString();
	if ( n > nLength) n = nLength;

	KString sub;
	sub.nLength = n;
	sub.p = new char[1 + n];
	*sub.p = 1;
	memcpy(sub.p + 1, p + 1, n);
	return sub;
}

KString KString::right(int n)
{
	if (n <= 0) return KString();
	if ( n > nLength) n = nLength;

	KString sub;
	sub.nLength = n;
	sub.p = new char[1 + n];
	*sub.p = 1;
	memcpy(sub.p + 1, p + nLength - n + 1, n);
	return sub;
}

int KString::length(const char* p)
{
	int nLength = 0;
	while (*p++)
		nLength++;
	return nLength;
}

int KString::len()
{
	return nLength;
}

KString KString::ucase()
{
	KString sub;
	sub.nLength = nLength;
	sub.p = new char[1 + nLength];
	*sub.p = 1;
	memcpy(sub.p + 1, p + 1, nLength);
	for (int f = 0; f <= nLength; f++)
		if (sub.p[f] >= 97 && sub.p[f] <= 122) sub.p[f] = sub.p[f] - 32;
	return sub;
}

KString KString::lcase()
{
	KString sub;
	sub.nLength = nLength;
	sub.p = new char[1 + nLength];
	*sub.p = 1;
	memcpy(sub.p + 1, p + 1, nLength);
	for (int f = 0; f <= nLength; f++)
		if (sub.p[f] >= 65 && sub.p[f] <= 90) sub.p[f] = sub.p[f] + 32;
	return sub;
}

KString KString::replace(char Ch1, char Ch2)
{
	KString sub;
	sub.nLength = nLength;
	sub.p = new char[1 + nLength];
	*sub.p = 1;
	memcpy(sub.p + 1, p + 1, nLength);
	for (int f = 0; f <= nLength; f++)
		if (sub.p[f] == Ch1) sub.p[f] = Ch2;
	return sub;
}

int KString::tointeger()
{
	char* sub;
	sub = new char[1 + nLength];
	*sub = 1;
	memcpy(sub, p + 1, nLength);
  return atoi(sub);
}

double KString::tofloat()
{
	char* sub;
	sub = new char[1 + nLength];
	memcpy(sub, p + 1, nLength);
  return atof(sub);
}