/*
  Basic CGI (Common Gateway Interface) example (using C++)
  --------------------------------------------------------
	An investigation into the interconnectivity of 
	Internet and Database Technologies
  Copyright (c) Kevin John Staunton-Lambert 1998
  Copyright (c) The University of Huddersfield 1998
*/

#include <iostream.h>
#include <stdlib.h>
#include "KString.h"

// CGI Query Parameter (string) manipulation function prototypes
int Length(const char* p);
KString PutParam(KString p, int Param);
int total; // Global variable used to calculate combined total of the parameters passed to program

void main()
{
  // Request the query string which is passed after the ? by the server (QUERY_STRING)
	char *EnvVar = getenv("QUERY_STRING");
	if (EnvVar == 0) EnvVar = "No+Parameters+Passed";

	// MIME Header (Requried for output into an HTML browser)
  cout << "Content-Type: text/html\n\n";

	cout << "<html>\n";
	cout << "  <body bgcolor=#ffffff>\n";
  cout << "    <p align=center><font size=5 color=#800080><b><i>Basic example of CGI (Common Gateway Interface)</i></b></font></p>\n";
	cout << "    <font size=2>This page has been generated by the C++ program <b>CGIExample.exe</b>. This program splits out the QUERY_STRING into it's various parameter components and lists the server environment variables. This program also demonstrates <i>state</i> on a web page by calling itself with the original QUERY_STRING + the additional parameter submited with the form on this page.</font><br><hr>\n";
	cout << "    <font color=#000080 face='Arial'><strong>Command line used to invoke this page</strong></font><br><br><small>CGIExample.exe?" << EnvVar << "</small>";

	// Add the form controls to demonstrate a CGI program effectively calling itself
	cout << "    <hr><font color=#000080 face='Arial'><strong>QUERY_STRING Parameters split apart</strong></font>\n";
	cout << "    <form action='CGIExample.exe'>\n"; // Call self
  cout << "      <table>\n";
	cout << "        <tr><th>Parameter</th><th>Value</th><th>SubTotal</th></tr>\n";

  // Split out parameters passed in the query string
  int f = 1;
  total = 0;
	while (PutParam((KString)EnvVar, f++) != "");
	cout << "        <tr><td><td><input type=text name='num" << f - 1 << "'></td><td><input type=submit value='<<< Add parameter'></td></tr>\n";
  cout << "      </table>\n";
	cout << "    </form>\n";
  cout << "    <font color=RED><b>Total = " << total << "</b></font> (Average = " << (float)total / (float)(f - 2) << ")<hr>\n";

	// Show list of server environment variables passed by the server
	cout << "    <font color=#000080 face='Arial'><strong>List of server environment variables passed to CGI program by the server</strong></font><br><br>\n";
	cout << "    <table border='1' cellpadding='7' cellspacing='0'>\n";

	// Query String
	EnvVar = getenv("QUERY_STRING");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>QUERY_STRING</td><td><small>The information that follows the question mark (?) in the URL that referenced this script.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

  // Remote Address
	EnvVar = getenv("REMOTE_ADDR");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>REMOTE_ADDR</td><td><small>The IP address of the client.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

  // Remote Host
	EnvVar = getenv("REMOTE_HOST");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>REMOTE_HOST</td><td><small>The hostname of the client.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

  // Remote Identifier
	EnvVar = getenv("REMOTE_IDENT");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>REMOTE_IDENT</td><td><small>Remote identifer</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

  // Remote User
	EnvVar = getenv("REMOTE_USER");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>REMOTE_USER</td><td><small>The user name supplied by the client and authenticated by the server.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

    // Script name and path (CGIExample.exe)
	EnvVar = getenv("SCRIPT_NAME");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>SCRIPT_NAME</td><td><small>The name of the script program being executed.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

  // Web server description
	EnvVar = getenv("SERVER_SOFTWARE");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>SERVER_SOFTWARE</td><td><small>The name and version of the Web server under which the Internet Server Extension is running.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// Web server name
	EnvVar = getenv("SERVER_NAME");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>SERVER_NAME</td><td><small>The servers hostname (or IP address) as it should appear in self-referencing URLs.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// Protocol (HTTP version)
	EnvVar = getenv("SERVER_PROTOCOL");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>SERVER_PROTOCOL</td><td><small>The name and version of the information-retrieval protocol relating to this request, usually HTTP/1.0.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// Port number (Usualy 80 for HTML)
	EnvVar = getenv("SERVER_PORT");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>SERVER_PORT</td><td><small>The TCP/IP port on which the request was received. (Usually 80 for HTML)</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// Port secure
	EnvVar = getenv("SERVER_PORT_SECURE_");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>SERVER_PORT_SECURE</td><td><small>The value of 0 or 1. The value 1 indicates the request is on the encrypted port.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// CGI Request method (i.e. GET or POST)
	EnvVar = getenv("REQUEST_METHOD");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>REQUEST_METHOD</td><td><small>The HTTP request method. (GET/POST)</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

  // Path information
	EnvVar = getenv("PATH_INFO");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>PATH_INFO</td></td><td><small>Additional path information, as given by the client. This comprises the trailing part of the URL after the script name but before the query string (if any).</td><td><small><b>" << EnvVar << "</b></tr>\n";

  // Path Translated
	EnvVar = getenv("PATH_TRANSLATED");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>PATH_TRANSLATED</td><td><small>The value of PATH_INFO, but with any virtual path name expanded into a directory specification.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// Content type
	EnvVar = getenv("CONTENT_TYPE");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>CONTENT_TYPE</td><td><small>The content type of the information supplied in the body of a POST request.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// Content length
	EnvVar = getenv("CONTENT_LENGTH");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>CONTENT_LENGTH</td><td><small>The number of bytes that the script can expect to receive from the client.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// Components to accept as HTTP (e.g. HTML)
	EnvVar = getenv("HTTP_ACCEPT");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>HTTP_ACCEPT</td><td><small>Special-case HTTP header. Values of the Accept: fields are concatenated, separated by a comma (,)</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// HTTP User Agent
	EnvVar = getenv("HTTP_USER_AGENT");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>HTTP_USER_AGENT</td><td>Agent</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// HTTP Referer
	EnvVar = getenv("HTTP_REFERER");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>HTTP_REFERER</td><td>Referer</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// HTTP Content Type
	EnvVar = getenv("HTTP_CONTENT_TYPE");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>HTTP_CONTENT_TYPE</td><td>Content type (MIME)</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// HTTP Content Length
	EnvVar = getenv("HTTP_CONTENT_LENGTH");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>HTTP_CONTENT_LENGTH</td><td>Length</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// HTTP*
	EnvVar = getenv("HTTP_*");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>HTTP_*</td><td>HTTP Information summary</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// Authorisation Type
	EnvVar = getenv("AUTH_TYPE");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>AUTH_TYPE</td><td><small>The type of authorisation in use. If the user name has been authenticated by the server, this will contain Basic. Otherwise, it will not be present.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// Gateway Interface
	EnvVar = getenv("GATEWAY_INTERFACE");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>GATEWAY_INTERFACE</td><td><small>The revision of the CGI (Common Gateway Interface) specification with which this server complies.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// Logon
	EnvVar = getenv("LOGON_USER");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>LOGON_USER</td><td><small>The users WindowsNT account.</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	// URL
	EnvVar = getenv("URL");
	if (EnvVar == 0) EnvVar = "<i><font color=red>&lt;Not Known&gt;</font></i>";
	cout << "      <tr><td align=right><small>URL</td><td><small>The URL of the request</td><td><small><b>" << EnvVar << "</b></td></tr>\n";

	cout << "    </table>\n";
	cout << "  </body>\n";
	cout << "</html>";
}

// Extract a particular parameter component from the query string
KString PutParam(KString p, int Param)
{
	// Convert parameter '+' to space characters
	p = p.replace('+', ' ');

	KString ParamName = "";
	KString ParamValue = "";

	int StringPos1 = 0, StringPos2 = 0;

  for (int f = 1; f < Param; f++)
	{
		// Find start of specified parameter
		StringPos1 = p.find("&", StringPos1 + 1);
	}

	if (f == 1 || StringPos1 != 0)
	{
		// Find parameter name
		StringPos2 = p.find("=", StringPos1 + 1);
		ParamName = p.sub(StringPos1 + 1, StringPos2 - 1);

		StringPos1 = StringPos2;
		StringPos2 = p.find("&", StringPos1 + 1);
		if (StringPos2 == 0) StringPos2 = p.len() + 1;
		ParamValue = p.sub(StringPos1 + 1, StringPos2 - 1);
		if (ParamValue == "=") ParamValue = "";
	  cout << "        <tr><td>" + ParamName + "</td><td><input type=text name='" + ParamName + "' value='" + ParamValue + "'></td>";
    if (ParamValue.len() > 0)
		{ 
			total = total + ParamValue.tointeger();
      cout << "<td><i>" << total << "</i></td><td><small>(Extracted " << ParamValue.tointeger() << " from parameter)</small></td></tr>";
		}
		
		cout << '\n';
	}
  return ParamName + ParamValue;
}
