'-----"Talbot's Vision"---
'**************************************************************************
'Use SPRITE EDITOR UNDER "d:\Qbasic\Swspv1\"
'
' Please view tileeng3.txt for further info.
' Copright 2002, By Steve Morrow, All rights  reserved.
'
'

DEFINT A-Z                              ' All variables are default integers.
'$DYNAMIC                               ' Dynamically sort memory for more...

DECLARE SUB Animate ()
DECLARE SUB InitVars ()                 ' Initializes variables.
DECLARE SUB LoadMap ()                  ' Loads a map.
DECLARE SUB LoadTiles ()                ' Load the tiles by simple Bload.
DECLARE SUB MoveUp ()                   ' Handles moving `up' event.
DECLARE SUB MoveDown ()                 ' Handles moving `down' event.
DECLARE SUB MoveLeft ()                 ' Handles moving `left' event.
DECLARE SUB MoveRight ()                ' Handles moving `right' event.
DECLARE SUB PutPlayerPic ()             ' Puts the player pic.
DECLARE SUB PutTile (x, y, TileNumber)  ' Put a tile.
DECLARE SUB SetupPalette ()             ' Setup n!Media palette.
DECLARE SUB ShowMap ()                  ' Show the map...

TYPE WorldDataType                      ' WorldData holds generic world info.
 Rows            AS INTEGER             ' Number of rows in world.
 Cols            AS INTEGER             ' Number of cols in world.
 TopRow          AS INTEGER             ' Current player row in world.
 TopCol          AS INTEGER             ' Current player col in world
 Action          AS INTEGER             ' So we only do things when needed.
 AnimCycle       AS INTEGER             ' Which frame player is on.
 Direc           AS INTEGER             ' What direction player is going in.
 PlayerY         AS INTEGER             ' Adjusted player y pos for more 3d.
END TYPE

TYPE MapType                            ' Map type, easy to add tile values.
 Tile            AS INTEGER             ' Identifies tile in any spot...
END TYPE

CONST North = 1, South = 2, East = 3, West = 4  ' Tracks dirs of player.
CONST True = -1, False = 0                      ' Boolean vals for easiness.
DIM SHARED Path AS STRING
Path = "c:\unzipped\Talbot~1\" + "RPG \"        ' Select start file path"

DIM SHARED Wall1(229), Brick1(229), Bldg1(229)
DIM SHARED Grass1(129), Water1(129), Tree1(129)
DIM SHARED Board1(129), Board2(129), Floor1(129), River1(129)
DIM SHARED Player1(129), Playlft(129), River2(129)
DIM SHARED WatEdge1(129), WatEdge2(129), RvEdge1(129), RvEdge2(129)
DIM SHARED TreeShd(129), GrassSh(129), Brick2(129)
DIM SHARED Bldg2(129), MtTop(129), MtBase(129), Sky1(129)
DIM SHARED MtTop2(129), SmallTree(129), Land1(129), WaterRt(129)
DIM SHARED Blank(129), Window1(129), Door1(129)
DIM SHARED Player1mask(129), Guy(400), Guym(400), Player2(129)
DIM SHARED PlayerUp1Mask(129), PlayerUp1(129)
DIM SHARED PlayerUp2Mask(129), PlayerUp2(129)
DIM SHARED PlayerRt1Mask(129), PlayerRt1(129)
DIM SHARED PlayerRt2Mask(129), PlayerRt2(129)
DIM SHARED PlayerDn1Mask(129), PlayerDn1(129)
DIM SHARED PlayerDn2Mask(129), PlayerDn2(129)
DIM SHARED PlayerLft1mask(129), PlayerLft1(129)
DIM SHARED PlayerLft2Mask(129), PlayerLft2(129)
DIM SHARED PlShadLft(129), PlShadLfMsk(129)
DIM SHARED Floor2(129), Floor3(129), Tree2(129), Stones(129)
DIM SHARED Block(129), Fence(129), Fencesid(129), Door3(129)
DIM SHARED Flower1(129), Skulls(129), Buildshw(129)
DIM SHARED Brick3dim(129), Land2(129)
' Tree, grass, water tiles.
DIM SHARED WorldData AS WorldDataType           ' WorldData variables.
DIM SHARED Map(-9 TO 123, -9 TO 123) AS MapType   ' The map, memory hog, reduce
                                                ' for more mem, smaller map.
DIM SHARED Dir$, Pal$, ix, ij, An
Dir$ = Path + "Images\"                         ' Tile directory.
Pal$ = Path                                     ' Sprite directory.

CALL InitVars                                   ' Initialize variables.
CALL LoadMap                                    ' Load a/the map.
CALL LoadTiles                                  ' Load tiles.

SCREEN 13                                       ' Set screen mode.
CALL SetupPalette                               ' Set our palette.
CALL ShowMap                                    ' Show map...
   PUT (160, WorldData.PlayerY), PlayerRt1Mask, AND
   PUT (160, WorldData.PlayerY), PlayerRt1, OR


DO
' Main heart loop of program.
 kbd$ = INKEY$                                  ' `Transparent' input.
 CALL Animate
 IF kbd$ <> "" THEN                             ' If other than nothing...
  SELECT CASE kbd$                              ' ... find what key it is...
   CASE CHR$(0) + "H"                           ' Hit up arrow.
    CALL MoveUp                                 ' Call up events.
    WorldData.Action = True                     ' An action happened.
   CASE CHR$(0) + "P"                           ' Hit down arrow.
    CALL MoveDown                               ' Call down events.
    WorldData.Action = True                     ' An action happened.
   CASE CHR$(0) + "K"                           ' Hit left arrow.
    CALL MoveLeft                               ' Call left events.
    WorldData.Action = True                     ' An action happened.
   CASE CHR$(0) + "M"                           ' Hit right arrow.
    CALL MoveRight                              ' Call right events.
    WorldData.Action = True                     ' An action happened.

   CASE CHR$(27)                                ' ESC; end.
    END
  END SELECT
 END IF

 IF WorldData.Action = True THEN                ' If an action did happen...
  CALL ShowMap                                  ' Show the map since we moved.
  WorldData.Action = False                      ' No more action.
 END IF                                         ' This is the spot where
                                                ' you would check if they
LOOP                                            ' hit a village or something.


' [ World Map Data ] 
'  No more Walk property... if the tile is less than 0, you can't walk on it,
' otherwise it's > 0 and you can walk on it... This is here for a little more
' simplicity. If you do decide to go off this engine, you'll probably want to
' make the maps separate .map files or something, and you'll have to change
' this... just make sure you understand the code.

'Deep, Wide

MainMap:
DATA 110,115
DATA -13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13,-13
DATA -11,-14,-11,-14,-11,-11,-14,-11,-14,-11,-14,-11,-11,-14,-11,-11,-11,-14,-11,-14,-11,-11,-11,-14,-11,-14,-11,-14,-14,-11,-11,-14,-11,-14,-11,-14,-14,-11,-11,-11,-14,-14,-14,-14,-14,-11,-11,-11,-11,-11,-11,-11,-11,-11,-11,-14,-14,-14,-14,-14,-14,-14,-14,-11,-11,-14,-14,-11,-11,-11,-14,-14,-14,-14,-14,-11,-11,-11,-14,-14,-11,-11,-11,-11,-14,-11,-14,-14,-14,-11,-11,-11,-14,-11,-14,-14,-14,-14,-14,-11,-11,-14,-14,-11,-11,-14,-14,-11,-14,-14,-14,-11,-14,-11,-14
DATA -12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12,-12
DATA 3,3,3,3,2,3,3,3,3,3,3,2,3,3,3,3,3,2,3,3,3,3,2,3,3,3,3,3,2,3,3,3,3,3,3,3,2,3,3,2,2,3,3,-22,3,2,2,2,3,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3
DATA 1,1,1,1,1,1,1,-1,1,1,1,1,-1,1,1,1,1,-1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-22,1,1,1,1,1,1,1,1,1,1,1,1,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,-1,1,12,1,1,-1,1,12,1,1,-1,-1,12,1,1,12,1,1,-10,-7,-7,-15,1,1,1,-1,1,1,-1,1,1,1,1,1,1,1,-22,1,1,1,1,1,1,1,1,1,1,1,1,1,7,7,7,7,-8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,-8,7,7,7,7,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,-1,1,1,1,12,1,1,1,1,12,1,1,1,1,12,12,1,1,1,1,1,1,-9,-7,-7,-7,-7,1,1,12,1,1,12,1,1,-1,1,1,1,-22,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-8,7,-8,7,-8,7,-8,7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,7,-8,-8,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,12,1,1,-3,-3,-3,-3,-3,-3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,-9,-7,-7,1,1,1,1,1,1,1,1,12,1,1,-22,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-8,7,-8,7,-8,7,-8,7,-8,7,7,7,7,7,7,7,7,7,7,7,-8,7,7,7,7,7,7,-8,7,-8,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,-3,7,7,7,7,7,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,-1,1,1,-8,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-8,7,-8,7,-8,7,-8,7,-8,7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,7,-8,-8,-8,-8,-8,-8,7,-8,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,-3,7,7,7,7,7,-3,18,1,1,1,1,1,1,1,-20,-20,-20,-20,5,-20,-20,-20,-20,-20,1,1,12,1,-1,12,-1,1,-8,-8,-8,-8,-8,-8,15,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,1,-8,7,-8,7,-8,7,-8,7,-8,7,-8,7,-8,7,7,7,7,7,7,7,7,7,-8,7,7,7,7,7,7,-8,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,-3,7,7,7,7,7,-3,18,1,1,1,1,-1,1,1,-20,6,6,6,6,6,6,6,6,-20,18,1,-1,1,-1,-1,12,1,-8,-8,-8,10,16,10,10,16,10,16,10,10,16,10,10,16,-8,1,-8,7,-8,7,-8,7,-8,7,-8,7,-8,7,-8,7,7,7,-8,-8,-8,-8,-8,-8,-8,7,7,7,7,7,7,-8,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,-3,7,7,7,-3,18,1,1,1,1,1,12,1,1,-20,6,6,6,6,6,6,6,6,-20,18,1,12,-1,-1,12,1,1,1,1,-8,10,10,16,16,10,16,10,10,10,10,10,16,10,-8,1,-8,7,-8,7,-8,7,-8,7,-8,7,-8,7,-8,-8,-8,7,-8,-8,7,7,7,7,7,7,7,7,7,7,7,-8,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,-4,-4,-4,-4,-4,18,1,1,1,1,1,1,1,1,-20,6,6,6,6,6,6,6,6,-20,18,1,-1,12,-1,-1,1,-1,1,1,-8,16,10,10,10,16,10,10,10,16,10,10,16,10,-8,1,-8,7,-8,7,-8,7,-8,7,-8,7,-8,7,7,7,-8,7,-8,-8,7,7,7,7,7,7,7,7,7,7,7,-8,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,-1,1,-4,-18,-4,18,1,1,1,1,1,-1,1,1,1,-20,-20,-20,-20,-20,-20,-20,-20,-20,-20,18,1,12,-1,12,12,-1,12,1,1,-8,16,16,10,10,16,10,10,10,10,10,10,10,10,-8,1,-8,7,-8,7,-8,7,-8,7,-8,7,-8,-8,-8,7,-8,7,-8,-8,-8,-8,7,-8,-8,-8,-8,-8,-8,-8,-8,-8,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,12,-1,1,18,18,1,-1,1,1,1,1,12,1,1,1,-4,-4,-17,-4,-17,-4,-17,-4,-17,-4,18,-1,1,-1,1,-1,12,1,1,1,-8,10,10,16,10,10,10,16,10,16,10,10,10,16,-8,1,-8,7,-8,7,-8,7,-8,7,-8,7,7,7,-8,7,-8,7,7,7,7,-8,7,-8,7,7,7,7,7,7,7,7,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,-1,1,1,12,1,1,-1,1,12,1,1,1,1,1,1,1,1,-4,-4,-4,-18,-4,-4,-18,-4,-4,-4,18,12,-1,12,-1,12,1,-1,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,1,-8,7,-8,7,-8,7,-8,7,-8,-8,-8,7,-8,7,-8,-8,-8,-8,7,-8,7,-8,7,-8,-8,-8,-8,-8,-8,-8,-8,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,12,1,1,1,1,-1,-1,-1,1,-1,1,1,1,1,1,1,1,1,13,13,13,13,13,13,13,13,13,18,1,12,-1,12,1,1,8,-10,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,1,-8,7,-8,7,-8,7,-8,7,7,7,-8,7,-8,7,-8,7,7,7,7,-8,7,-8,7,-8,7,7,7,7,7,7,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,-1,1,1,12,-1,12,1,12,1,1,1,1,1,1,1,1,1,13,13,13,13,13,13,13,13,1,1,1,12,1,1,8,-10,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,1,-8,7,-8,7,-8,7,-8,-8,-8,7,-8,7,-8,7,-8,7,-8,-8,-8,-8,7,-8,7,-8,7,-8,-8,-8,-8,-8,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,12,1,-1,-1,-1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,8,-10,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,1,-8,7,-8,7,7,7,7,7,-8,7,-8,7,7,7,7,7,7,7,7,7,7,7,7,-8,7,7,7,7,7,-8,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,12,12,12,12,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,1,1,1,-1,-1,1,1,1,8,-10,-7,-7,-7,-7,-7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-7,-8,1,-8,7,-8,-8,-8,7,7,7,-8,7,-8,-8,-8,-8,7,-8,-8,-8,-8,-8,-8,-8,-8,-8,7,-8,-8,-8,-8,-8,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,1,12,1,1,1,1,1,1,1,-1,12,1,1,8,-10,-7,-7,-7,-7,-7,-7,-8,18,18,18,18,18,18,18,18,18,18,-8,-7,-8,1,-8,7,-8,7,7,7,7,7,-8,7,7,7,7,-8,7,7,7,7,7,7,7,7,7,7,7,-8,7,7,7,7,7,-8,7,-8,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,-1,1,1,1,1,-1,12,1,1,1,1,1,1,1,1,1,1,-1,1,12,1,1,8,-10,-7,-7,-7,-7,-7,-7,-7,-8,18,17,1,1,1,1,1,1,17,1,-8,-7,-8,1,-8,7,-8,7,-8,-8,-8,-8,-8,-8,-8,-8,7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,7,-8,7,-8,-8,-8,7,-8,1,1,12,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,12,1,1,1,1,12,-1,1,1,1,1,1,1,1,1,1,1,-1,1,1,1,8,-10,-7,-7,-7,-7,-7,-7,-7,-7,-8,18,1,1,1,1,17,1,1,1,1,-8,-7,-8,1,-8,7,-8,7,-8,7,7,7,7,7,7,7,7,7,7,-8,7,7,7,7,7,7,7,7,7,7,7,-8,7,7,7,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,-1,1,1,1,1,1,1,1,1,-1,1,1,12,1,1,1,1,1,1,1,1,1,1,12,-1,1,8,-10,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,18,1,1,1,1,1,1,1,1,1,-8,-7,-8,-8,-8,7,-8,7,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,7,-8,7,-8,-8,-8,-8,-8,-8,-8,-8,-8,7,-8,-8,-8,-8,-8,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,12,1,1,1,1,1,1,1,1,12,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,12,8,-10,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,18,1,1,1,1,1,1,1,1,1,-8,-8,-8,18,7,7,7,7,-8,7,7,7,7,7,7,7,7,-8,7,7,7,-8,7,7,7,7,7,7,7,7,7,7,7,-8,7,7,7,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,-20,-20,-20,-20,1,1,1,1,1,1,-1,1,1,12,1,1,-6,-6,-6,1,1,1,1,1,1,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,18,1,1,1,1,1,1,1,1,1,1,18,18,18,-8,-8,-8,-8,-8,7,-8,-8,-8,-8,-8,-8,3,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,1,-8,1,-8,-8,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,-20,-20,-20,-20,1,1,1,1,1,1,12,1,1,1,1,10,10,-6,-6,10,10,10,10,10,10,-9,11,-7,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,18,1,1,1,1,1,1,1,1,1,1,-22,-21,-21,-21,-21,-21,-21,-21,10,10,-22,19,19,19,19,3,19,19,19,19,19,19,19,19,19,1,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,-1,1,1,1,1,1,1,1,1,1,1,1,1,1,10,10,10,10,10,10,10,10,10,-9,11,-7,-7,-7,-7,-7,-7,-7,-7,-7,-8,18,1,1,1,1,1,1,1,1,1,-22,10,10,10,10,10,10,10,10,10,-22,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,12,1,1,1,1,1,1,1,1,1,1,1,1,1,10,10,10,10,10,10,10,10,10,10,-9,11,-7,-7,-7,-7,-7,-7,-7,-7,-8,18,1,1,1,1,1,1,1,1,-22,10,10,10,10,10,10,10,10,10,-22,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,-1,-1,1,1,1,1,1,-2,-2,-2,1,1,1,1,1,1,1,1,10,10,10,10,10,10,10,10,10,10,10,-9,11,-7,-7,-7,-7,-7,-7,-7,-8,18,1,1,1,1,1,1,1,-22,10,10,10,10,10,10,10,10,10,-22,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,12,12,1,1,1,1,1,-2,-2,-2,1,1,1,1,-1,1,1,1,1,10,10,10,10,10,10,10,10,10,10,10,-9,11,-7,-7,-7,-7,-7,-7,-8,18,1,1,1,1,1,1,-22,10,10,10,10,10,10,10,10,10,-22,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,12,1,1,1,-1,1,10,10,10,10,10,10,10,10,10,10,10,-9,11,-7,-7,-7,-7,-7,-8,18,1,1,1,1,1,-22,10,10,10,10,10,10,10,10,10,-22,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,-19,1,1,1,1,1,1,1,1,1,1,1,1,1,-19,1,1,1,12,1,1,10,10,10,10,10,10,10,10,10,10,10,10,10,-9,-7,-7,-7,-8,18,1,1,1,1,-22,10,10,10,10,10,10,10,10,10,-22,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,12,1,-4,-4,-4,-4,-4,1,1,1,1,1,1,1,12,1,1,1,-1,1,1,1,10,10,10,10,10,10,10,10,10,10,10,10,10,-9,-7,-7,-21,-21,-21,-21,-21,-22,10,10,10,10,10,10,10,10,10,-22,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,-4,9,9,9,9,-4,18,-1,1,1,1,1,-1,1,1,-1,-1,12,1,1,1,1,1,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,-22,10,10,10,10,10,10,10,10,10,-22,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,-1,1,-4,9,9,9,-4,-4,18,12,1,1,1,1,12,1,1,12,12,-19,1,1,1,1,1,1,1,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,-22,10,10,10,10,10,10,10,10,10,-22,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,12,1,-4,9,9,9,-4,18,1,1,1,-19,1,1,1,1,1,1,1,12,1,1,1,1,1,1,1,1,10,10,10,10,10,10,10,10,10,10,10,10,10,-22,10,10,10,10,10,10,10,10,10,-22,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,-4,-4,-4,-4,-4,18,1,1,12,1,1,1,1,1,1,1,14,1,1,1,1,1,1,1,1,1,10,10,10,10,10,10,10,10,10,10,10,-22,10,10,10,10,10,10,10,10,10,-22,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-3,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,18,18,18,18,1,1,1,1,1,-19,-19,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,10,10,10,10,10,10,10,10,10,-22,10,10,10,10,10,10,10,10,10,-22,1,1,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,12,12,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,10,10,10,10,10,10,10,-22,10,10,10,10,10,10,10,10,10,-22,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,10,10,10,10,10,-22,10,10,10,10,10,10,10,10,10,-22,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -21,-21,-21,-21,-21,-21,1,1,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,-21,10,10,10,10,10,10,10,10,10,-22,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -4,9,9,9,9,-4,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,10,10,10,10,10,10,10,10,10,10,10,10,-22,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -23,9,9,9,9,-23,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,10,10,10,10,10,10,10,10,10,10,-22,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -23,9,9,9,9,-23,18,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,10,10,10,10,10,10,10,10,-22,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -23,9,9,9,9,-23,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -23,9,9,9,9,-23,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,-8,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -23,9,9,9,9,-23,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -23,9,9,9,9,-23,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -23,9,9,9,9,-23,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -23,9,9,9,9,-23,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,-8,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA -4,9,9,9,9,-4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
DATA 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1

REM $STATIC
SUB Animate
RANDOMIZE TIMER

'Animates water frames

  IF Map(ix + WorldData.TopCol, ij + WorldData.TopRow).Tile = -7 THEN
     IF INT(An / 4) = An / 4 THEN
        PUT (ix * 16, ij * 16), River1, PSET
     ELSE
        IF An > 4 THEN
           PUT (ix * 16, ij * 16), River2, PSET
        END IF
     END IF
  END IF
ix = ix + 1: IF ix > 18 THEN ix = 0: ij = ij + 1: IF ij > 11 THEN ij = 0
An = An + 1: IF An > 10 THEN An = 0
END SUB

SUB InitVars

' TopRow = 38, PlayerY = 96
WorldData.TopCol = 0                   ' Where they start in map (col).X
WorldData.TopRow = 28                   ' Where they start in map (row).Y
WorldData.PlayerY = 92                  ' Y pixel location for player show.
                                        ' This is raised so it sorta looks
                                        ' like they are in front of the tile
                                        ' above them...
END SUB

SUB LoadMap

RESTORE MainMap                                 ' Read data from MainMap
READ WorldData.Rows, WorldData.Cols             ' Read row and column count.

FOR i = 1 TO WorldData.Rows
 FOR j = 1 TO WorldData.Cols
  READ Map(j, i).Tile                           ' Read tile in...
 NEXT j
NEXT i

END SUB

SUB LoadTiles

'TileDir$ = Path + "sprs\"
'CHDIR TileDir$                          ' Goto tile directory.

' Load all sprites into segmented memory addresses
 
DEF SEG = VARSEG(Grass1(0)): BLOAD Dir$ + "Grass1.spr", VARPTR(Grass1(0)): DEF SEG
DEF SEG = VARSEG(Water1(0)): BLOAD Dir$ + "water1.spr", VARPTR(Water1(0)): DEF SEG
DEF SEG = VARSEG(Tree1(0)): BLOAD Dir$ + "oaktree2.spr", VARPTR(Tree1(0)): DEF SEG
DEF SEG = VARSEG(Bldg1(0)): BLOAD Dir$ + "Tilbox.spr", VARPTR(Bldg1(0)): DEF SEG
DEF SEG = VARSEG(Brick1(0)): BLOAD Dir$ + "brick.spr", VARPTR(Brick1(0)):  DEF SEG
DEF SEG = VARSEG(Wall1(0)): BLOAD Dir$ + "waltil.spr", VARPTR(Wall1(0)): DEF SEG
DEF SEG = VARSEG(Board1(0)): BLOAD Dir$ + "board.spr", VARPTR(Board1(0)): DEF SEG
DEF SEG = VARSEG(Board2(0)): BLOAD Dir$ + "door1.spr", VARPTR(Board2(0)): DEF SEG
DEF SEG = VARSEG(Floor1(0)): BLOAD Dir$ + "floor.spr", VARPTR(Floor1(0)): DEF SEG
DEF SEG = VARSEG(River1(0)): BLOAD Dir$ + "flow.spr", VARPTR(River1(0)): DEF SEG
DEF SEG = VARSEG(Player1(0)): BLOAD Dir$ + "manlf.spr", VARPTR(Player1(0)): DEF SEG
DEF SEG = VARSEG(Player2(0)): BLOAD Dir$ + "man.spr", VARPTR(Player2(0)): DEF SEG
DEF SEG = VARSEG(Playlft(0)): BLOAD Dir$ + "man2.spr", VARPTR(Playlft(0)): DEF SEG
DEF SEG = VARSEG(River2(0)): BLOAD Dir$ + "flow2.spr", VARPTR(River2(0)): DEF SEG
DEF SEG = VARSEG(WatEdge1(0)): BLOAD Dir$ + "watedg1.spr", VARPTR(WatEdge1(0)): DEF SEG
DEF SEG = VARSEG(WatEdge2(0)): BLOAD Dir$ + "watedge2.spr", VARPTR(WatEdge2(0)): DEF SEG
DEF SEG = VARSEG(RvEdge1(0)): BLOAD Dir$ + "wtcorner.spr", VARPTR(RvEdge1(0)): DEF SEG
DEF SEG = VARSEG(RvEdge2(0)): BLOAD Dir$ + "wtcornr2.spr", VARPTR(RvEdge2(0)): DEF SEG
DEF SEG = VARSEG(TreeShd(0)): BLOAD Dir$ + "trshadow.spr", VARPTR(TreeShd(0)): DEF SEG
DEF SEG = VARSEG(GrassSh(0)): BLOAD Dir$ + "grshadow.spr", VARPTR(GrassSh(0)): DEF SEG
DEF SEG = VARSEG(Brick2(0)): BLOAD Dir$ + "brick2.spr", VARPTR(Brick2(0)): DEF SEG
DEF SEG = VARSEG(Bldg2(0)): BLOAD Dir$ + "Tile3.spr", VARPTR(Bldg2(0)): DEF SEG
DEF SEG = VARSEG(MtTop(0)): BLOAD Dir$ + "mountain.spr", VARPTR(MtTop(0)): DEF SEG
DEF SEG = VARSEG(MtBase(0)): BLOAD Dir$ + "mtbase.spr", VARPTR(MtBase(0)): DEF SEG
DEF SEG = VARSEG(Sky1(0)): BLOAD Dir$ + "sky.spr", VARPTR(Sky1(0)): DEF SEG
DEF SEG = VARSEG(MtTop2(0)): BLOAD Dir$ + "mtn3.spr", VARPTR(MtTop2(0)): DEF SEG
DEF SEG = VARSEG(SmallTree(0)): BLOAD Dir$ + "smalltr.spr", VARPTR(SmallTree(0)): DEF SEG
DEF SEG = VARSEG(Land1(0)): BLOAD Dir$ + "land.spr", VARPTR(Land1(0)): DEF SEG
DEF SEG = VARSEG(WaterRt(0)): BLOAD Dir$ + "watercnr.spr", VARPTR(WaterRt(0)): DEF SEG
DEF SEG = VARSEG(Blank(0)): BLOAD Dir$ + "blank.spr", VARPTR(Blank(0)): DEF SEG
DEF SEG = VARSEG(Window1(0)): BLOAD Dir$ + "window.spr", VARPTR(Window1(0)): DEF SEG
DEF SEG = VARSEG(Door1(0)): BLOAD Dir$ + "door2.spr", VARPTR(Door1(0)): DEF SEG
DEF SEG = VARSEG(PlayerLft1mask(0)): BLOAD Dir$ + "plylfmsk.spr", VARPTR(PlayerLft1mask(0)): DEF SEG
DEF SEG = VARSEG(PlayerLft1(0)): BLOAD Dir$ + "plylft.spr", VARPTR(PlayerLft1(0)): DEF SEG
DEF SEG = VARSEG(PlayerRt1Mask(0)): BLOAD Dir$ + "plyrtmsk.spr", VARPTR(PlayerRt1Mask(0)): DEF SEG
DEF SEG = VARSEG(PlayerRt1(0)): BLOAD Dir$ + "plyrt.spr", VARPTR(PlayerRt1(0)): DEF SEG
DEF SEG = VARSEG(PlayerUp1(0)): BLOAD Dir$ + "plyup1.spr", VARPTR(PlayerUp1(0)): DEF SEG
DEF SEG = VARSEG(PlayerUp1Mask(0)): BLOAD Dir$ + "plup1msk.spr", VARPTR(PlayerUp1Mask(0)): DEF SEG
DEF SEG = VARSEG(PlayerDn1Mask(0)): BLOAD Dir$ + "pldn1msk.spr", VARPTR(PlayerDn1Mask(0)): DEF SEG
DEF SEG = VARSEG(PlayerDn1(0)): BLOAD Dir$ + "plydn1.spr", VARPTR(PlayerDn1(0)): DEF SEG
DEF SEG = VARSEG(PlShadLft(0)): BLOAD Dir$ + "plyshl.spr", VARPTR(PlShadLft(0)): DEF SEG
DEF SEG = VARSEG(PlShadLfMsk(0)): BLOAD Dir$ + "plshmlft.spr", VARPTR(PlShadLfMsk(0)): DEF SEG
DEF SEG = VARSEG(Floor2(0)): BLOAD Dir$ + "floor2.spr", VARPTR(Floor2(0)): DEF SEG
DEF SEG = VARSEG(Floor3(0)): BLOAD Dir$ + "floor3.spr", VARPTR(Floor3(0)): DEF SEG
DEF SEG = VARSEG(Tree2(0)): BLOAD Dir$ + "tree2.spr", VARPTR(Tree2(0)): DEF SEG
DEF SEG = VARSEG(Stones(0)): BLOAD Dir$ + "stones.spr", VARPTR(Stones(0)): DEF SEG
DEF SEG = VARSEG(Block(0)): BLOAD Dir$ + "wood1.spr", VARPTR(Block(0)): DEF SEG
DEF SEG = VARSEG(Fence(0)): BLOAD Dir$ + "fence.spr", VARPTR(Fence(0)): DEF SEG
DEF SEG = VARSEG(Fencesid(0)): BLOAD Dir$ + "fencesid.spr", VARPTR(Fencesid(0)): DEF SEG
DEF SEG = VARSEG(Door3(0)): BLOAD Dir$ + "door3.spr", VARPTR(Door3(0)): DEF SEG
DEF SEG = VARSEG(Flower1(0)): BLOAD Dir$ + "flowers.spr", VARPTR(Flower1(0)): DEF SEG
DEF SEG = VARSEG(Skulls(0)): BLOAD Dir$ + "skulls.spr", VARPTR(Skulls(0)): DEF SEG
DEF SEG = VARSEG(Buildshw(0)): BLOAD Dir$ + "bldgshdw.spr", VARPTR(Buildshw(0)): DEF SEG
DEF SEG = VARSEG(Brick3dim(0)): BLOAD Dir$ + "brick3d.spr", VARPTR(Brick3dim(0)): DEF SEG
DEF SEG = VARSEG(Land2(0)): BLOAD Dir$ + "land2.spr", VARPTR(Land2(0)): DEF SEG
'CHDIR ".."                              ' Go back to initial dir.

END SUB

SUB MoveDown

' Current direction is south. IF the row beneath and in our current column
' is walkable (value > 0 ) then increment row.
' The IF Map( ...blah...) refers to the map array, with TopCol and TopRow
' values in mind...

WorldData.Direc = South

Look.Map = Map(WorldData.TopCol + 10, WorldData.TopRow + 7).Tile
IF Look.Map > 0 THEN
 WorldData.TopRow = WorldData.TopRow + 1
END IF

END SUB

SUB MoveLeft

WorldData.Direc = West

IF Map(WorldData.TopCol + 9, WorldData.TopRow + 6).Tile > 0 THEN
 WorldData.TopCol = WorldData.TopCol - 1
'IF WorldData.TopCol < 1 THEN WorldData.TopCol = 1
END IF
' PUT (160, WorldData.PlayerY), Player1, OR
' PUT (160, WorldData.PlayerY), Player1mask, AND

END SUB

SUB MoveRight

WorldData.Direc = East

IF Map(WorldData.TopCol + 11, WorldData.TopRow + 6).Tile > 0 THEN
 WorldData.TopCol = WorldData.TopCol + 1
'IF WorldData.TopCol > 22 THEN WorldData.TopCol = 22
END IF

END SUB

SUB MoveUp

WorldData.Direc = North

IF Map(WorldData.TopCol + 10, WorldData.TopRow + 5).Tile > 0 THEN
 WorldData.TopRow = WorldData.TopRow - 1
'IF WorldData.TopRow < 1 THEN WorldData.TopRow = 1
END IF

END SUB

SUB PutPlayerPic

SELECT CASE WorldData.Direc
 CASE North
'  IF WorldData.AnimCycle = 1 THEN
   PUT (160, WorldData.PlayerY), PlayerUp1Mask, AND
   PUT (160, WorldData.PlayerY), PlayerUp1, OR
'  ELSE
'   PUT (160, WorldData.PlayerY), PlayerUp2Mask, AND
'   PUT (160, WorldData.PlayerY), PlayerUp2, OR
'  END IF
 CASE East
'  IF WorldData.AnimCycle = 1 THEN
   PUT (160, WorldData.PlayerY), PlayerRt1Mask, AND
   PUT (160, WorldData.PlayerY), PlayerRt1, OR
'  ELSE
'   PUT (160, WorldData.PlayerY), PlayerRt2Mask, AND
'   PUT (160, WorldData.PlayerY), PlayerRt2, OR
'  END IF
 CASE South
'  IF WorldData.AnimCycle = 1 THEN
   PUT (160, WorldData.PlayerY), PlayerDn1Mask, AND
   PUT (160, WorldData.PlayerY), PlayerDn1, OR
'  ELSE
'   PUT (160, WorldData.PlayerY), PlayerDn2Mask, AND
'   PUT (160, WorldData.PlayerY), PlayerDn2, OR
'  END IF
 CASE West
'  IF WorldData.AnimCycle = 1 THEN
   PUT (160, WorldData.PlayerY), PlayerLft1mask, AND
   PUT (160, WorldData.PlayerY), PlayerLft1, OR
'   PUT (160, WorldData.PlayerY + 16), PlShadLfMsk, AND
'   PUT (160, WolrdData.PlayerY + 16), PlShadLft, OR
'  ELSE
'   PUT (160, WorldData.PlayerY), PlayerLft2Mask, AND
'   PUT (160, WorldData.PlayerY), PlayerLft2, OR
'  END IF
END SELECT

END SUB

SUB PutTile (x, y, TileNumber)

' (Negative Tiles = UNWALKABLE)  --  Example: -23
' Anything undefined is by default grass sprite
' @@ - not used,  ** repeated object

SELECT CASE TileNumber                          ' Which tile to show?
 CASE -23
   PUT (x, y), Brick3dim, PSET                  ' Path walkway
 CASE -22
   PUT (x, y), Fencesid, PSET                   ' Fence(side view/slanted)
 CASE -21
   PUT (x, y), Fence, PSET                      ' Fence(facing front)
 CASE -20
   PUT (x, y), Block, PSET                      ' Wall(wooden)
 CASE -19
   PUT (x, y), Tree2, PSET                      ' Tree (medium size)
 CASE -18
   PUT (x, y), Door1, PSET                      ' Brick doorway (entrance)
 CASE -17
   PUT (x, y), Window1, PSET                    ' Brick window (cross shape)
 CASE -16
   PUT (x, y), Tree1, PSET                      ' Tree (regular size)
 CASE -15
   PUT (x, y), WaterRt, PSET                    ' Water slanted down/right
 CASE -14
   PUT (x, y), MtTop2, PSET                     ' Mountain lower peak(grey)
 CASE -13
   PUT (x, y), Sky1, PSET                       ' Sky(stars/dots)
 CASE -12
   PUT (x, y), MtBase, PSET                     ' Mountain base(purple)
 CASE -11
   PUT (x, y), MtTop, PSET                      ' Mountain peak
 CASE -10
   PUT (x, y), RvEdge1, PSET                    ' Water slanted down/left
 CASE -9
   PUT (x, y), WatEdge2, PSET                   ' Water base (curved/right)
 CASE -8
   PUT (x, y), Brick2, PSET                     ' Brick wall(red)
 CASE -7
   PUT (x, y), River1, PSET                     ' Water center(animated)
 CASE -6
   PUT (x, y), Bldg2, PSET                      ' Pink/black tile
 CASE -5
  PUT (x, y), Wall1, PSET                       ' Cylinder shape(light blue)
 CASE -4
   PUT (x, y), Brick1, PSET                     ' Brick wall(yellow)
 CASE -3
   PUT (x, y), Bldg1, PSET                      ' 3-d tile(light blue)
 CASE -2
   PUT (x, y), Water1, PSET                     ' Water base(still picture)
  CASE -1
    PUT (x, y), Tree1, PSET                     ' Regular-sized tree **
 CASE 0
   PUT (x, y), Blank, PSET                      ' Sky(stars/dots) **
 CASE 1
   PUT (x, y), Grass1, PSET                     ' Grass.
 CASE 2
   PUT (x, y), SmallTree, PSET                  ' Tree (small size)
 CASE 3
   PUT (x, y), Land1, PSET                      ' Land(shaded/below mt base)
 CASE 4
   PUT (x, y), Board1, PSET                     ' Board(slants in it) @@
 CASE 5
   PUT (x, y), Board2, PSET                     ' Door entrance w/floor(slanted)
 CASE 6
   PUT (x, y), Floor1, PSET                     ' Floor(spiral shaped circle)
 CASE 7
   PUT (x, y), Floor2, PSET                     ' Floor(spotted brown)
 CASE 8
   PUT (x, y), WatEdge1, PSET                   ' Water base(curved up)
 CASE 9
   PUT (x, y), Floor3, PSET                     ' Floor(stone-shaped/brown)
 CASE 10
   PUT (x, y), Stones, PSET                     ' Stones(brown\on ground)
 CASE 11
  PUT (x, y), RvEdge2, PSET                     ' Water(curved\left)
 CASE 12
  PUT (x, y), TreeShd, PSET                     ' Tree(shadow/on ground)
 CASE 13
  PUT (x, y), GrassSh, PSET                     ' Building(grass shadow/right)
 CASE 14
  PUT (x, y), Player1, AND                      ' Man mask(looking left)
  PUT (x, y), Player2, OR                       ' Man shape(looking left)
 CASE 15
  PUT (x, y), Door3, PSET                       ' Door(flowers on floor/slanted)
 CASE 16
  PUT (x, y), Flower1, PSET                     ' Flowers(stones on ground)
 CASE 17
  PUT (x, y), Skulls, PSET                      ' Skulls(on ground)
 CASE 18
  PUT (x, y), Buildshw, PSET                    ' Building shadow(on ground)
 CASE 19
  PUT (x, y), Land2, PSET                       ' Grass shade(olive green)
END SELECT

END SUB

SUB SetupPalette

' This loads the palette, it's nothing of consequence, just move on...

DIM Pal(512)

DEF SEG = VARSEG(Pal(0))
BLOAD Pal$ + "nmedia.pal", 0
i = 0
FOR C = 0 TO 255
 OUT &H3C8, C
 OUT &H3C9, PEEK(i)
 OUT &H3C9, PEEK(i + 1)
 OUT &H3C9, PEEK(i + 2)
 i = i + 4
NEXT C
DEF SEG

END SUB

SUB ShowMap

' Go thru number of tiles that will be on screen, reference to map array
' keeping in mind out TopRow and TopCol values, show with PutTile sub.

FOR i = 0 TO 18
 FOR j = 0 TO 11
  CALL PutTile(i * 16, j * 16, Map(i + WorldData.TopCol, j + WorldData.TopRow).Tile)
 NEXT j
NEXT i

CALL PutPlayerPic

'WorldData.Rows;WorldData.Cols
END SUB

