/* SJ - Binary File Tool - Version Bianca-4                                 */
/* (C) 1996, 2000 Unicorn Dreams Artwork Programs                           */
/* Programmed by "Cyberknight" Masao Kawata                                 */

/* This program is "freeware". I expect it to be useful to someone else...  */
/* Contact me: cyberknight@catsrule.garfield.com                            */
/* Home Page : http://welcome.to/unicorndreams                              */

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* System variables' definitions                                            */

char
  BX='\0',BY='\0',BZ='\0',
  BM[8][9]={"Desert","Forest","Galactic","Mountain","Ocean","Queen","Sky","Space"},
  BA[10][10]={"Amethyst","Diamond","Emerald","Golden","Jade","Ruby","Sapphire","Silver","Topaz","Turquoise"},
  BB[16][14]={"Basilisk","Dragon","Gremlin","Gryphon","Harpy","Hinotori","Kentauros","Khimaira","Likaanthropos","Minotauros","Pegasos","Phoenix","Salamander","Siren","Sphynx","Triton"};
unsigned long
  RndLong;

/* Functions' and Procedures' definitions                                   */

  void ClrStI()
  { int
      A;

    while (((A=getchar())!=EOF)&&(A!='\n'));
  }

  unsigned long Rnd(Mode)
  int
    Mode;
  { if (Mode)
      switch (((char)RndLong)&0x30)
      { case '\x10':
          RndLong*=0xA1E573CDL;
          RndLong^=0xB604892FL;
          break;
        case '\x20':
          RndLong*=0x2C806BD5L;
          RndLong^=0x913F47AEL;
          break;
        case '\x30':
          RndLong*=0x567D0EB4L;
          RndLong^=0xAF13C892L;
          break;
        default:
          RndLong*=0x92B6D0FEL;
          RndLong^=0xC8417A35L;
      }
    return(RndLong);
  }

  void RndSeed(Seed)
  unsigned long
    Seed;
  { RndLong =Seed^0xFEDCBA98L;
    RndLong+=Seed*0x76543210L;
  }

  void ErrorExit(ErrorNumber,StrArg1,StrArg2)
  int ErrorNumber;
  char
    *StrArg1,*StrArg2;
  { char
      ErrStr[256];

    fprintf(stderr,"%s %s %s ",BM[BX],BA[BY],BB[BZ]);
    switch (ErrorNumber)
    { case 2:
        fprintf(stderr,"found syntax error, %s \"%s\".\n",StrArg1,StrArg2);
        break;
      case 3:
        fprintf(stderr,"says: File size cannot be zero.\n");
        break;
      case 4:
        fprintf(stderr,"found bad %s \"%s\".\n",StrArg1,StrArg2);
        break;
      case 5:
        fprintf(stderr,"says: There are missing parameters.\n");
        break;
      case 6:
        fprintf(stderr,"says: There are too many parameters.\n");
        break;
      case 7:
        fprintf(stderr,"couldn't allocate enough memory.\n");
        break;
      case 8:
        sprintf(ErrStr,"couldn't open \"%s\"",StrArg1);
        perror(ErrStr);
        break;
      case 9:
        sprintf(ErrStr,"couldn't create \"%s\"",StrArg1);
        perror(ErrStr);
        break;
      case 10:
        sprintf(ErrStr,"couldn't write into \"%s\"",StrArg1);
        perror(ErrStr);
        break;
      case 11:
        fprintf(stderr,"couldn't seek source \"%s\".\n",StrArg1);
        break;
      case 12:
        fprintf(stderr,"couldn't seek destiny \"%s\".\n",StrArg1);
        break;
      case 13:
        fprintf(stderr,"found unexpected end of source \"%s\".\n",StrArg1);
        break;
      case 14:
        fprintf(stderr,"found unexpected end of StdIn.\n");
        break;
      case 15:
        fprintf(stderr,"found empty source \"%s\".\n",StrArg1);
        break;
    }
    exit(ErrorNumber);
  }

  unsigned char FileExist(FileName)
  char
    *FileName;
  { FILE
      *A;

    if ((A=fopen(FileName,"rb"))!=NULL)
    { fclose(A);
      return('\1');
    }
    else
      return('\0');
  }

  long FileSize(FileHandle)
  FILE
    *FileHandle;
  { long
      CurrentPos=ftell(FileHandle),
      FinalPos;

    fseek(FileHandle,0L,2);
    FinalPos=ftell(FileHandle);
    fseek(FileHandle,CurrentPos,0);
    return(FinalPos);
  }

  unsigned char Fill(Destiny,Start,Size,FillByte)
  FILE
    *Destiny;
  long
    Start,Size;
  char
    FillByte;
  { char
      Buffer[1];
    long
      Rest;

    Buffer[0]=FillByte;
    if (fseek(Destiny,Start,0))
      return(12);
    for (Rest=0L;Rest<Size;Rest++)
      if (!fwrite(Buffer,sizeof(char),(size_t)1,Destiny))
        return(10);
    return(0);
  }

  void Help(ProgName,Mode)
  char
    *ProgName,Mode;
  { fprintf(stdout,"Binary File Splitter/Joiner - Version Bianca-4.\n");
    fprintf(stdout,"(C) 1996, 1998 Unicorn Dreams Artwork Products, Hi-Brazil, Terra.\n");
    fprintf(stdout,"Programmed by \"Cyberknight\" Masao Kawata.\n\n");
    switch(Mode)
    { case '\0':
        fprintf(stdout,"Generic syntax: %s <operation and options> <arguments>\n",ProgName);
        fprintf(stdout,"This help     : %s \n",ProgName);
        fprintf(stdout,"Topic help    : %s <operation|0|1|2>\n\n",ProgName);

        fprintf(stdout,"Operations, options and arguments: \n");
        fprintf(stdout,"s[.][-](BYTE) <SOURCE> [DESTINY base name] <ARG>    : Split file.\n");
        fprintf(stdout,"e[-][BYTE] <SOURCE> <DESTINY> <START> <ARG>         : Extract part of file.\n");
        fprintf(stdout,"j[.][BYTE] <SOURCE base name> [DESTINY] [NUMBER]    : Join splitted files.\n");
        fprintf(stdout,"a[.][BYTE] <SOURCES...> <DESTINY>                   : Append files.\n");
        fprintf(stdout,"i[-][BYTE] <SOURCE> <DESTINY> <START> <ARG> <OFFSET>: Insert file.\n");

        fprintf(stdout,"Notes:\n");
        fprintf(stdout,"- <> arguments are required, [] are optional, () depends on options; \n");
        fprintf(stdout,"- numbers may be octals, decimals or hexadecimals (given in C format); \n");
        fprintf(stdout,"- don't use spaces between operations and options; \n");
        fprintf(stdout,"- read help topics from \"0\" to \"3\" before using this program.\n");
        break;
      case 's':
      case 'S':
        fprintf(stdout,"s[.][-](BYTE) <SOURCE> [DESTINY base name] <ARG> : if  option  \"-\"  is  not \n");
        fprintf(stdout,"  given, it  creates as many  DESTINY sub-files of size ARG as necessary to \n");
        fprintf(stdout,"  split SOURCE. If \"-\" is  given, it'll create ARG sub-files. All sub-files \n");
        fprintf(stdout,"  will have  3 digit decimal  extensions, starting from \".000\". If  DESTINY \n");
        fprintf(stdout,"  isn't given, it'll create SOURCE.xxx named files. If option \".\" is given, \n");
        fprintf(stdout,"  it'll wait for <Return> key press before each destiny file is created. If \n");
        fprintf(stdout,"  option \"-\" is not used, then if a BYTE is given  and the last sub-file is \n");
        fprintf(stdout,"  smaller than SIZE, it'll be complemented with BYTEs.\n\n");

        fprintf(stdout,"Examples: \n");
        fprintf(stdout,"%s s- Picture.GIF 10 : if \"Picture.GIF\" is 1003 bytes long, \n",ProgName);
        fprintf(stdout,"  this  will  create files from \"Picture.GIF.000\" to \"Picture.GIF.002\" with \n");
        fprintf(stdout,"  101 bytes and from \"Picture.GIF.003\" to \"Picture.GIF.009\" with 100 bytes.\n");
        fprintf(stdout,"%s s.85 Freeware.LZH FreeLZH 1450000 : this will create \n",ProgName);
        fprintf(stdout,"  1450000 bytes  long files  named \"FreeLZH.000\", \"FreeLZH.001\" and  so on, \n");
        fprintf(stdout,"  waiting  for <Return> key press  before  each  sub-file  is  created  and \n");
        fprintf(stdout,"  complementing the  last file with \"U\"s (ASCII 85), making it also 1450000 \n");
        fprintf(stdout,"  bytes long.\n");
        break;
      case 'e':
      case 'E':
        fprintf(stdout,"e[-][BYTE] <SOURCE> <DESTINY> <START> <ARG> : copies a  segment  of  SOURCE \n");
        fprintf(stdout,"  into  DESTINY. The  position of the first byte of  SOURCE is 0. If option \n");
        fprintf(stdout,"  \"-\" is not given, program will copy ARG bytes, from START to START+ARG-1. \n");
        fprintf(stdout,"  If option \"-\" is  used, program will copy bytes from  START to  ARG (ARG- \n");
        fprintf(stdout,"  START+1 bytes). If file ends before expected and a BYTE is given, DESTINY \n");
        fprintf(stdout,"  will be complemented with BYTEs.\n\n");

        fprintf(stdout,"Examples: \n");
        fprintf(stdout,"%s e- Document.Txt Index.ASC 0 0x4ff: this will copy 1280 \n",ProgName);
        fprintf(stdout,"  bytes (from 0 to 4FFH) from Document.Txt into Index.ASC.\n");
        fprintf(stdout,"%s e0 Binary.Dat Segment.A45 9876 0400 : this will copy \n",ProgName);
        fprintf(stdout,"  256 bytes (from  9876 to  10131) from \"Binary.Dat\" into \"Segment.A45\". If \n");
        fprintf(stdout,"  file \"Binary.Dat\" ends  before 10131, \"Segment.A45\" will  be complemented \n");
        fprintf(stdout,"  with zeros, making it 256 bytes long.\n");
        break;
      case 'j':
      case 'J':
        fprintf(stdout,"j[.][BYTE] <SOURCE base name> [DESTINY] [NUMBER] : if  NUMBER is given, the \n");
        fprintf(stdout,"  program will try to join NUMBER sub-files, else it'll join sub-files till \n");
        fprintf(stdout,"  one  is not  found. Sub-files must  have 3 digits  decimal extensions (as \n");
        fprintf(stdout,"  produced by \"s\" operation). If DESTINY is not specified, program will use \n");
        fprintf(stdout,"  SOURCE base name as destiny. If NUMBER is given and a source isn't found, \n");
        fprintf(stdout,"  the next is searched and joined, while a warning message is printed. If a \n");
        fprintf(stdout,"  BYTE is given, missing files' positions will be filled with BYTEs, asking \n");
        fprintf(stdout,"  the user to input  the expected size of each missing file. If  option \".\" \n");
        fprintf(stdout,"  is given, it'll prompt before opening each sub-file for reading.\n\n");

        fprintf(stdout,"Examples: \n");
        fprintf(stdout,"%s j. Game Tetris.Exe 4: this will join 4 files, \n",ProgName);
        fprintf(stdout,"  from \"Game.000\" to \"Game.003\" into  Index.Exe, waiting  for <Return>  key \n");
        fprintf(stdout,"  press before each source file is read. If  any source file is  not found, \n");
        fprintf(stdout,"  the next will be joined.\n");
        fprintf(stdout,"%s j32 Doc.Txt 6: this will join 6 files, from \n",ProgName);
        fprintf(stdout,"  \"Doc.Txt.000\" till \"Doc.Txt.005\" into \"Doc.Txt\". If a source file  is not \n");
        fprintf(stdout,"  found, program will ask for the  missing file expected size and will fill \n");
        fprintf(stdout,"  with spaces (ASCII 32) its position.\n");
        break;
      case 'a':
      case 'A':
        fprintf(stdout,"a[.][BYTE] <SOURCES...> <DESTINY> : joins a series of SOURCES into DESTINY. \n");
        fprintf(stdout,"  If \".\" is  given, the program will  wait for a <Return> key press  before \n");
        fprintf(stdout,"  each source  file is read. If BYTE is not given  and a source file is not \n");
        fprintf(stdout,"  found, the next is joined and a warning is printed. If BYTE is given, the \n");
        fprintf(stdout,"  program will  prompt for the missing file expected size and will fill its \n");
        fprintf(stdout,"  positions with BYTEs.\n\n");

        fprintf(stdout,"Examples: \n");
        fprintf(stdout,"%s a Head Index Chapt0 Chapt1 Conclusion Book0: this will \n",ProgName);
        fprintf(stdout,"  join  the files \"Head\", \"Index\", \"Chapt0\", \"Chapt1\" and \"Conclusion\" into \n");
        fprintf(stdout,"  Book0.\n");
        fprintf(stdout,"%s a. 000 001 002 Data.Bin: this will join \"000\", \"001\" \n",ProgName);
        fprintf(stdout,"  and \"002\" into \"Data.Bin\", waiting  for <Return> before  each  source  is \n");
        fprintf(stdout,"  read.\n");
        break;
      case 'i':
      case 'I':
        fprintf(stdout,"i[-][BYTE] <SOURCE> <DESTINY> <START> <ARG> <OFFSET> : inserts  bytes  from \n");
        fprintf(stdout,"  SOURCE into DESTINY, at OFFSET. The position  of the first byte of SOURCE \n");
        fprintf(stdout,"  and  DESTINY  is  0. If option \"-\" is not  given, program will  copy  ARG \n");
        fprintf(stdout,"  bytes, from  START to START+ARG-1. If  option \"-\" is  used, program  will \n");
        fprintf(stdout,"  copy from START to ARG (ARG-START+1 bytes). If file ends  before expected \n");
        fprintf(stdout,"  and a BYTE is given, DESTINY will be complemented with BYTEs.\n\n");

        fprintf(stdout,"Examples: \n");
        fprintf(stdout,"%s i 1972.Dat October.Tmp 10000 1000 1500: this will insert \n",ProgName);
        fprintf(stdout,"  1000 bytes (from 10000 to 10999) from \"1972.Dat\" into \"October.Tmp\" (from \n");
        fprintf(stdout,"  1500 to  2499). If \"1972.Dat\" ends before  10999, program will  copy into \n");
        fprintf(stdout,"  \"October.Tmp\" only the bytes it can find.\n");
        fprintf(stdout,"%s i1- Fig0.Tga Fig2.Tga 1024 1039 0: this will insert 16 \n",ProgName);
        fprintf(stdout,"  bytes (from  1024 to 1039) from \"Fig0.Tga\" into  beginning  of \"Fig2.Tga\" \n");
        fprintf(stdout,"  (from 0 to 15). If \"Fig0.Tga\" ends before position 1039, the program will \n");
        fprintf(stdout,"  fill the positions of missing bytes with 1.\n");
        break;
      case '0':
        fprintf(stdout,"Usage agreement notification: \n");
        fprintf(stdout,"This software is a freeware, although not a public domain software (no one, \n");
        fprintf(stdout,"except  the author, can modify it for distribution or use any part of it in \n");
        fprintf(stdout,"any  other programs or products for  any  purpose). No one can sell this or \n");
        fprintf(stdout,"include it, without the express permission of the author, in any commercial \n");
        fprintf(stdout,"product. It is  provided as  is, without  any guarantees  or  warranty. The \n");
        fprintf(stdout,"author isn't responsible for any data losses or  any form of damage  caused \n");
        fprintf(stdout,"due to use or  misuse of this program. You  must agree to all these to  use \n");
        fprintf(stdout,"the program. May the Unicorns guide and protect you through out the evil.\n\n");

        fprintf(stdout,"Author's comments: \n");
        fprintf(stdout,"Yes, such agreement messages can really fright a novice user. They are need \n");
        fprintf(stdout,"to  allow programmers to  do they job without the  fear of lawers. I expect \n");
        fprintf(stdout,"this program to be of great utility to you. Don't forget to  read the other \n");
        fprintf(stdout,"help topics.\n\n");

        fprintf(stdout,"Special thanks: to my Family, to the Unicorns, to Isaac Asimov, to Peter S. \n");
        fprintf(stdout,"Beagle, to  Michael Ende, to all Real Science Fiction and  Fantasy Writers, \n");
        fprintf(stdout,"to all Artists, to the Nature, to The Imagination and to The Freedom!\n");
        break;
      case '1':
        fprintf(stdout,"Known bugs: \n");
        fprintf(stdout,"- I  couldn't find  file \"stdarg.h\" in  some Linux  systems, so the program \n");
        fprintf(stdout,"  doesn't use functions with variable number of arguments. This led to some \n");
        fprintf(stdout,"  function  calls with dummy data. This note is really only interesting for \n");
        fprintf(stdout,"  programmers (I don't want them saying \"why didn't  he use functions  with \n");
        fprintf(stdout,"  variable number of arguments here and there?\"\n");
        break;
      case '2':
        fprintf(stdout,"Expert information: \n");
        fprintf(stdout,"This program was written in C and accepts arguments in C format (octals are \n");
        fprintf(stdout,"any number beginning by a zero; decimals are any number not  beginning by a \n");
        fprintf(stdout,"zero; hexadecimals  are numbers beginning by \"0x\"). The source file  may be \n");
        fprintf(stdout,"found, if not in the same place you found this, at my Home Page: \n");
        fprintf(stdout,"http://welcome.to/unicorndreams or http://unicorndreams.n3.net \n");
        fprintf(stdout,"If you have any sugestions about  the program, like wanted features, let me \n");
        fprintf(stdout,"know (send me an EMail: cyberknight@catsrule.garfield.com).\n\n");

        fprintf(stdout,"Program exit code values: \n");
        fprintf(stdout," 0 = Okay (normal termination)    8 = file openning error\n");
        fprintf(stdout," 1 = unknown operation            9 = file creation error\n");
        fprintf(stdout," 2 = syntax error                10 = write error\n");
        fprintf(stdout," 3 = invalid zero block size     11 = source seek error\n");
        fprintf(stdout," 4 = bad operand or argument     12 = destiny seek error\n");
        fprintf(stdout," 5 = missing parameters          13 = unexpected end of source file\n");
        fprintf(stdout," 6 = too many parameters         14 = unexpected end of StdIn\n");
        fprintf(stdout," 7 = not enough memory           15 = source is empty\n");
        break;
      default :
        fprintf(stderr,"Unicorn says: Unknown help topic \"%c\".\n",Mode);
        exit(1);
    }
    exit(0);
  }

  unsigned char Ins(Source,Destiny,Start,Size,OffSet)
  FILE
    *Source,*Destiny;
  long
    Start,Size,OffSet;
  { char
      *Buffer;
    long
      Rest=Size;
    size_t
      Reading;

    if ((Buffer=(char *)malloc(sizeof(char)*8192))==NULL)
      ErrorExit(7,"","");
    if (fseek(Source,Start,0))
    { free(Buffer);
      return(11);
    }
    if (fseek(Destiny,OffSet,0))
    { free(Buffer);
      return(12);
    }
    while (Rest)
    { if (Rest>8192L)
        Reading=(size_t)8192;
      else
        Reading=(size_t)Rest;
      if (fread(Buffer,sizeof(char),Reading,Source)!=Reading)
      { free(Buffer);
        return(13);
      }
      if (!fwrite(Buffer,sizeof(char),Reading,Destiny))
      { free(Buffer);
        return(10);
      }
      Rest-=(long)Reading;
    }
    free(Buffer);
    return(0);
  }

  int main (ArgCnt,ArgStr)
  int
    ArgCnt;
  char
    *ArgStr[];
  { unsigned char
      Operation,
      AltFlag='\0',
      PromptFlag='\0',
      TmpChr,
      AuxChr,
      ErrCod,
      DestinyExist,
      OvrwrtMode='\0',
      ByteBuffer[1],
      MetLen,
      MasterSize,
      Keyword[256],
      KeySize,
      *Master,
      *MasterLen;
    char
      SourceName[256],DestinyName[256],
      TmpStr[256],
      MsgStr[256];
    unsigned int
      Number,
      ByteOption,
      A,C;
    int
      B;
    long
      CurPos,
      Size,
      OffSetPos,
      SourceSize,
      AuxS,AuxR;
    unsigned long
      LongNumber;
    FILE
      *Source,*Destiny;
    time_t
      Time;

    if (ArgCnt==1)
      Help(ArgStr[0],'\0');
    else if (ArgCnt<3)
      Help(ArgStr[0],ArgStr[1][0]);
    Operation=ArgStr[1][0];
    A=0;
    B=strlen(ArgStr[1]);
    for (Number=1;Number<(unsigned int)B;Number++)
      if (ArgStr[1][Number]=='-')
        AltFlag='\1';
      else if (ArgStr[1][Number]=='.')
        PromptFlag='\1';
      else if (((ArgStr[1][Number]>='0')&&(ArgStr[1][Number]<='9'))||
               ((ArgStr[1][Number]>='A')&&(ArgStr[1][Number]<='F'))||
               ((ArgStr[1][Number]>='a')&&(ArgStr[1][Number]<='f'))||
                (ArgStr[1][Number]=='x')||(ArgStr[1][Number]<='X'))
        TmpStr[A++]=ArgStr[1][Number];
      else
      { fprintf(stderr,"Unicorn says: Syntax error, invalid character \"%c\".\n",ArgStr[1][Number]);
        exit(2);
      }
    TmpStr[A]='\0';
    if (strlen(TmpStr))
      if (sscanf(TmpStr,"%i",&Number))
        if (Number>255)
        { fprintf(stderr,"Unicorn says: Bad operand, out of range \"%u\".\n",Number);
          exit(4);
        }
        else
          ByteOption=Number;
      else
      { fprintf(stderr,"Unicorn says: Bad operand \"%s\".\n",TmpStr);
        exit(4);
      }
    else
      ByteOption=256;
    RndSeed((unsigned long)time(&Time));
    BX=(char)(Rnd(1)%8);
    BY=(char)(Rnd(1)%10);
    BZ=(char)(Rnd(1)%16);
    fprintf(stdout,"The Unicorn heard your call. She summoned ");
    if (BM[BX][0]=='O')
      fprintf(stdout,"an");
    else
      fprintf(stdout,"a");
    fprintf(stdout," %s %s %s",BM[BX],BA[BY],BB[BZ]);
    switch (Operation)
    { case 's':
      case 'S':
        fprintf(stdout,"\nto split your file.\n");
        if (ArgCnt<4)
          ErrorExit(5,"","");
        if (ArgCnt>5)
          ErrorExit(6,"","");
        else
        { if (!sscanf(ArgStr[ArgCnt-1],"%li",&LongNumber))
            ErrorExit(4,"number",ArgStr[ArgCnt-1]);
          strncpy(SourceName,ArgStr[2],(size_t)255);
          SourceName[255]='\0';
          strncpy(DestinyName,ArgStr[ArgCnt-2],(size_t)255);
          DestinyName[255]='\0';
        }
        if ((AltFlag)&&(ByteOption<256))
          ErrorExit(2,"cannot use byte with","-");
        if (!LongNumber)
          ErrorExit(3,"","");
        if ((Source=fopen(SourceName,"rb"))==NULL)
          ErrorExit(8,SourceName,"");
        SourceSize=FileSize(Source);
        if (AltFlag)
        { AuxS=SourceSize/LongNumber;
          AuxR=SourceSize%LongNumber;
          Number=(unsigned int)LongNumber;
        }
        else
        { AuxS=LongNumber;
          Number=(unsigned int)(SourceSize/AuxS);
          AuxR=SourceSize-AuxS*(long)Number;
          if (AuxR)
            Number++;
          else
            AuxR=AuxS;
        }
        CurPos=0L;
        OvrwrtMode='\0';
        for (A=0;A<Number;A++)
        { sprintf(TmpStr,"%s.%03u",DestinyName,A);
          fprintf(stdout,"%s %s %s will create \"%s\".",BM[BX],BA[BY],BB[BZ],TmpStr);
          if (PromptFlag)
          { fprintf(stdout," Press <Return> key when ready...");
            ClrStI();
          }
          else
            fprintf(stdout,"..\n");
          TmpChr='\0';
          while ((OvrwrtMode!='A')&&(OvrwrtMode!='S')&&(TmpChr!='Y')&&(TmpChr!='N')&&(FileExist(TmpStr)))
          { fprintf(stdout,"%s %s %s found a file already named \"%s\".\n",BM[BX],BA[BY],BB[BZ],TmpStr);
            fprintf(stdout,"Overwrite? (y)es, (a)ll, (r)ename, (c)hange base, (N)o, (s)kip all or (e)xit? ");
            if ((B=getchar())==EOF)
              ErrorExit(14,"","");
            ClrStI();
            TmpChr=(unsigned char)B;
            if (TmpChr>='a')
              TmpChr=(TmpChr-'a')+'A';
            switch (TmpChr)
            { case '\n':
                TmpChr='N';
              case 'Y':
              case 'N':
                break;
              case 'A':
              case 'S':
                OvrwrtMode=TmpChr;
                break;
              case 'R':
                fprintf(stdout,"%s %s %s asks you a new name instead of \"%s\": ",BM[BX],BA[BY],BB[BZ],TmpStr);
                fscanf(stdin,"%s",TmpStr);
                ClrStI();
                break;
              case 'C':
                fprintf(stdout,"%s %s %s asks you a new base name instead of \"%s\": ",BM[BX],BA[BY],BB[BZ],DestinyName);
                fscanf(stdin,"%s",DestinyName);
                ClrStI();
                TmpStr[0]='\0';
                sprintf(TmpStr,"%s.%03u",DestinyName,A);
                break;
              case 'E':
                exit(0);
              default:
                fprintf(stderr,"%s %s %s says: Invalid choice \"%c\".\n",BM[BX],BA[BY],BB[BZ],TmpChr);
            }
          }
          if (AltFlag)
          { Size=AuxS;
            if (AuxR)
            { Size++;
              AuxR--;
            }
          }
          else if ((A+1)==Number)
            Size=AuxR;
          else
            Size=AuxS;
          DestinyExist=FileExist(TmpStr);
          if ((!DestinyExist)||(DestinyExist&&((TmpChr!='N')&&(OvrwrtMode!='S'))))
          { if ((Destiny=fopen(TmpStr,"wb"))==NULL)
              ErrorExit(9,TmpStr,"");
            switch (Ins(Source,Destiny,CurPos,Size,0L))
            { case '\xA':
                ErrorExit(10,TmpStr,"");
              case '\xB':
                ErrorExit(11,SourceName,"");
              case '\xC':
                ErrorExit(12,TmpStr,"");
              case '\xD':
                ErrorExit(13,SourceName,"");
            }
            if (!AltFlag)
              if ((A+1)==Number)
                if (ByteOption<256)
                  if (ErrCod=Fill(Destiny,AuxR,AuxS-AuxR,(char)ByteOption))
                    ErrorExit((int)ErrCod,TmpStr,"");
            fclose(Destiny);
          }
          CurPos+=Size;
        }
        fclose(Source);
        break;
      case 'e':
      case 'E':
        fprintf(stdout,"\nto extract a sub-file.\n");
        if (PromptFlag)
          ErrorExit(2,"invalid option",".");
        if (ArgCnt<6)
          ErrorExit(5,"","");
        else if (ArgCnt>6)
          ErrorExit(6,"","");
        if (!sscanf(ArgStr[4],"%li",&LongNumber))
          ErrorExit(4,"start position",ArgStr[4]);
        CurPos=LongNumber;
        if (!sscanf(ArgStr[5],"%li",&LongNumber))
          if (AltFlag)
            ErrorExit(4,"end position",ArgStr[5]);
          else
            ErrorExit(4,"length",ArgStr[5]);
        AuxS=LongNumber;
        if (AltFlag)
          if (AuxS>=CurPos)
            AuxS-=CurPos-1L;
          else
            ErrorExit(4,"final position",ArgStr[5]);
        else if (!AuxS)
          ErrorExit(3,"","");
        if ((Source=fopen(ArgStr[2],"rb"))==NULL)
          ErrorExit(8,ArgStr[2],"");
        SourceSize=FileSize(Source);
        if (SourceSize<(CurPos+AuxS))
          if (CurPos>=SourceSize)
          { fprintf(stderr,"%s %s %s warns: Start position is set after end of source.\n",BM[BX],BA[BY],BB[BZ]);
            AuxR=AuxS;
            AuxS=0;
          }
          else
          { AuxR=CurPos+AuxS-SourceSize;
            AuxS-=AuxR;
          }
        else
          AuxR=0;
        fprintf(stdout,"%s %s %s will write into \"%s\"...\n",BM[BX],BA[BY],BB[BZ],ArgStr[3]);
        TmpChr='\0';
        while (FileExist(ArgStr[3])&&(TmpChr!='Y'))
        { fprintf(stdout,"%s %s %s found a file already named \"%s\".\n",BM[BX],BA[BY],BB[BZ],ArgStr[3]);
          fprintf(stdout,"Overwrite? (y)es or (N)o? ");
          if ((B=getchar())==EOF)
            ErrorExit(14,"","");
          ClrStI();
          TmpChr=(unsigned char)B;
          if (TmpChr>='a')
            TmpChr=(TmpChr-'a')+'A';
          switch (TmpChr)
          { case 'Y':
              break;
            case '\n':
            case 'N':
              exit(0);
            default:
              fprintf(stderr,"%s %s %s says: Invalid choice \"%c\".\n",BM[BX],BA[BY],BB[BZ],TmpChr);
          }
        }
        if ((Destiny=fopen(ArgStr[3],"wb"))==NULL)
          ErrorExit(9,ArgStr[3],"");
        switch (Ins(Source,Destiny,CurPos,AuxS,0L))
        { case '\xA':
            ErrorExit(10,ArgStr[3],"");
          case '\xB':
            ErrorExit(11,ArgStr[2],"");
          case '\xC':
            ErrorExit(12,ArgStr[3],"");
          case '\xD':
            ErrorExit(13,ArgStr[2],"");
        }
        fclose(Source);
        if (ByteOption<256)
          if (ErrCod=Fill(Destiny,AuxS,AuxR,(char)ByteOption))
            ErrorExit((int)ErrCod,ArgStr[3],"");
        fclose(Destiny);
        break;
      case 'j':
      case 'J':
        fprintf(stdout,"\nto join your files.\n");
        if (AltFlag)
          ErrorExit(2,"invalid option","-");
        if (ArgCnt<3)
          ErrorExit(5,"","");
        else if (ArgCnt>5)
          ErrorExit(6,"","");
        if (ArgCnt>3)
          strncpy(DestinyName,ArgStr[3],(size_t)255);
        else
          strncpy(DestinyName,ArgStr[2],(size_t)255);
        if (ArgCnt==5)
          if (sscanf(ArgStr[4],"%li",&LongNumber))
            AltFlag='\1';
          else
            ErrorExit(4,"number",ArgStr[4]);
        if ((AltFlag)&&(!LongNumber))
          ErrorExit(4,"number of sub-files","0");
        else
          Number=(unsigned int)LongNumber;
        DestinyName[255]='\0';
        fprintf(stdout,"%s %s %s will write into \"%s\"...\n",BM[BX],BA[BY],BB[BZ],DestinyName);
        TmpChr='\0';
        while (FileExist(DestinyName)&&(TmpChr!='Y'))
        { fprintf(stdout,"%s %s %s found a file already named \"%s\".\n",BM[BX],BA[BY],BB[BZ],DestinyName);
          fprintf(stdout,"Overwrite? (y)es or (N)o? ");
          if ((B=getchar())==EOF)
            ErrorExit(14,"","");
          ClrStI();
          TmpChr=(unsigned char)B;
          if (TmpChr>='a')
            TmpChr=(TmpChr-'a')+'A';
          switch (TmpChr)
          { case 'Y':
              break;
            case '\n':
            case 'N':
              exit(0);
            default:
              fprintf(stderr,"%s %s %s says: Invalid choice \"%c\".\n",BM[BX],BA[BY],BB[BZ],TmpChr);
          }
        }
        if ((Destiny=fopen(DestinyName,"wb"))==NULL)
          ErrorExit(9,DestinyName,"");
        CurPos=0L;
        A=0;
        B=0;
        while (!B)
        { TmpStr[0]='\0';
          sprintf(TmpStr,"%s.%03u",ArgStr[2],A);
          fprintf(stdout,"%s %s %s is searching for \"%s\".",BM[BX],BA[BY],BB[BZ],TmpStr);
          if (PromptFlag)
          { fprintf(stdout," Press <Return> key when ready...");
            ClrStI();
          }
          else
            fprintf(stdout,"..\n");
          if ((Source=fopen(TmpStr,"rb"))==NULL)
            if (AltFlag)
            { sprintf(MsgStr,"%s %s %s couldn't open source \"%s\"",BM[BX],BA[BY],BB[BZ],TmpStr);
              perror(MsgStr);
              if (ByteOption<256)
              { fprintf(stderr,"%s %s %s will filling missing file space with byte \"%u\".\n",BM[BX],BA[BY],BB[BZ],ByteOption);
                fprintf(stdout,"Enter missing source \"%s\" expected size: ",TmpStr);
                while (!fscanf(stdin,"%li",&LongNumber))
                { fprintf(stderr,"%s %s %s says: Bad number. Try again.\n",BM[BX],BA[BY],BB[BZ]);
                  ClrStI();
                }
                if (ErrCod=Fill(Destiny,CurPos,LongNumber,(char)ByteOption))
                  ErrorExit((int)ErrCod,DestinyName,"");
                CurPos+=LongNumber;
              }
              else
                fprintf(stderr,"%s %s %s will search for next file.\n",BM[BX],BA[BY],BB[BZ]);
            }
            else
              B++;
          else
          { SourceSize=FileSize(Source);
            if (!SourceSize)
              fprintf(stderr,"%s %s %s warns you that \"%s\" is empty.\n",BM[BX],BA[BY],BB[BZ],TmpStr);
            else
            { switch (Ins(Source,Destiny,0L,SourceSize,CurPos))
              { case '\xA':
                  ErrorExit(10,DestinyName,"");
                case '\xB':
                  ErrorExit(11,TmpStr,"");
                case '\xC':
                  ErrorExit(12,DestinyName,"");
                case '\xD':
                  ErrorExit(13,TmpStr,"");
              }
              CurPos+=SourceSize;
            }
            fclose(Source);
          }
          A++;
          if ((AltFlag)&&(A>=Number))
            B++;
        }
        fclose(Destiny);
        break;
      case 'a':
      case 'A':
        fprintf(stdout,"\nto gather your files.\n");
        if (AltFlag)
          ErrorExit(2,"invalid option","-");
        if (ArgCnt<4)
          ErrorExit(5,"","");
        Number=ArgCnt-1;
        fprintf(stdout,"%s %s %s will create \"%s\"...\n",BM[BX],BA[BY],BB[BZ],ArgStr[Number]);
        TmpChr='\0';
        while (FileExist(ArgStr[Number])&&(TmpChr!='Y'))
        { fprintf(stdout,"%s %s %s found a file already named \"%s\".\n",BM[BX],BA[BY],BB[BZ],ArgStr[Number]);
          fprintf(stdout,"Overwrite? (y)es or (N)o? ");
          if ((B=getchar())==EOF)
            ErrorExit(14,"","");
          ClrStI();
          TmpChr=(unsigned char)B;
          if (TmpChr>='a')
            TmpChr=(TmpChr-'a')+'A';
          switch (TmpChr)
          { case 'Y':
              break;
            case '\n':
            case 'N':
              exit(0);
            default:
              fprintf(stderr,"%s %s %s says: Invalid choice \"%c\".\n",BM[BX],BA[BY],BB[BZ],TmpChr);
          }
        }
        if ((Destiny=fopen(ArgStr[Number],"wb"))==NULL)
          ErrorExit(9,ArgStr[Number],"");
        CurPos=0L;
        A=2;
        while (A<Number)
        { fprintf(stdout,"%s %s %s will read \"%s\".",BM[BX],BA[BY],BB[BZ],ArgStr[A]);
          if (PromptFlag)
          { fprintf(stdout," Press <Return> when ready...");
            ClrStI();
          }
          else
            fprintf(stdout,"..\n");
          if ((Source=fopen(ArgStr[A],"rb"))==NULL)
          { sprintf(MsgStr,"%s %s %s couldn't open source \"%s\"",BM[BX],BA[BY],BB[BZ],ArgStr[A]);
            perror(MsgStr);
            if (ByteOption<256)
            { fprintf(stderr,"%s %s %s says: Filling missing file space with byte %u.\n",BM[BX],BA[BY],BB[BZ],ByteOption);
              fprintf(stdout,"Enter missing source \"%s\" size: ",ArgStr[A]);
              while (!fscanf(stdin,"%li",&LongNumber))
              { fprintf(stderr,"%s %s %s says: Bad number. Try again.\n",BM[BX],BA[BY],BB[BZ]);
                ClrStI();
              }
              switch (Fill(Destiny,CurPos,LongNumber,(char)ByteOption))
              { case '\x8':
                  sprintf(MsgStr,"%s %s %s says: Couldn't write into destiny %s",BM[BX],BA[BY],BB[BZ],TmpStr);
                  perror(SourceName);
                  return(10);
                case '\xA':
                  sprintf(MsgStr,"%s %s %s says: Couldn't seek destiny %s",BM[BX],BA[BY],BB[BZ],TmpStr);
                  perror(SourceName);
                  return(12);
              }
              CurPos+=LongNumber;
            }
            else
              fprintf(stderr,"Searching to next file.");
          }
          else
          { SourceSize=FileSize(Source);
            if (!SourceSize)
              fprintf(stderr,"%s %s %s will search for next file.\n",BM[BX],BA[BY],BB[BZ]);
            else
            { switch (Ins(Source,Destiny,0L,SourceSize,CurPos))
              { case '\xA':
                  ErrorExit(10,ArgStr[Number],"");
                case '\xB':
                  ErrorExit(11,ArgStr[A],"");
                case '\xC':
                  ErrorExit(12,ArgStr[Number],"");
                case '\xD':
                  ErrorExit(13,ArgStr[A],"");
              }
              CurPos+=SourceSize;
            }
            fclose(Source);
          }
          A++;
        }
        fclose(Destiny);
        break;
      case 'i':
      case 'I':
        fprintf(stdout,"\nto insert a file into another.\n");
        if (PromptFlag)
          ErrorExit(2,"invalid option",".");
        if (ArgCnt<7)
          ErrorExit(5,"","");
        else if (ArgCnt>7)
          ErrorExit(6,"","");
        if (!sscanf(ArgStr[4],"%li",&LongNumber))
          ErrorExit(4,"number",ArgStr[4]);
        CurPos=LongNumber;
        if (!sscanf(ArgStr[5],"%li",&LongNumber))
          ErrorExit(4,"number",ArgStr[5]);
        AuxS=LongNumber;
        if (AltFlag)
          if (AuxS>=CurPos)
            AuxS-=CurPos-1L;
          else
            ErrorExit(4,"final position",ArgStr[5]);
        else if (!AuxS)
          ErrorExit(3,"","");
        if (!sscanf(ArgStr[6],"%li",&LongNumber))
          ErrorExit(4,"number",ArgStr[6]);
        OffSetPos=LongNumber;
        if ((Source=fopen(ArgStr[2],"rb"))==NULL)
          ErrorExit(8,ArgStr[2],"");
        SourceSize=FileSize(Source);
        if (SourceSize<(CurPos+AuxS))
          if (CurPos>=SourceSize)
          { fprintf(stderr,"%s %s %s warns: Start position is set after end of source.\n",BM[BX],BA[BY],BB[BZ]);
            AuxR=AuxS;
            AuxS=0;
          }
          else
          { AuxR=CurPos+AuxS-SourceSize;
            AuxS-=AuxR;
          }
        else
          AuxR=0;
        fprintf(stdout,"%s %s %s will copy bytes from \"%s\" into \"%s\"...\n",BM[BX],BA[BY],BB[BZ],ArgStr[2],ArgStr[3]);
        if ((Destiny=fopen(ArgStr[3],"rb+"))==NULL)
          ErrorExit(9,ArgStr[3],"");
        switch (Ins(Source,Destiny,CurPos,AuxS,OffSetPos))
        { case '\xA':
            ErrorExit(10,ArgStr[3],"");
          case '\xB':
            ErrorExit(11,ArgStr[2],"");
          case '\xC':
            ErrorExit(12,ArgStr[3],"");
          case '\xD':
            ErrorExit(13,ArgStr[2],"");
        }
        fclose(Source);
        if (ByteOption<256)
          if (ErrCod=Fill(Destiny,AuxS+OffSetPos,AuxR,(char)ByteOption))
        fclose(Destiny);
        break;
      default:
        fprintf(stderr,",\nwho says: Unknown operation \"%c\".\n",Operation);
        exit(1);
    }
    fprintf(stdout,"Done! Unicorn and %s %s %s wish you a Good Day!\n",BM[BX],BA[BY],BB[BZ]);
    return(0);
  }
