/* Iris: Stereogram Generator - Version Bianca-3                           */
/* (C) 1994, 2000 Unicorn Dreams Artwork Programs                          */
/* Programmed by Cyberknight Masao Kawata                                  */

typedef unsigned char byte;
typedef unsigned int word;

#define EEERF1  1 /* Error Reading File 1                      */
#define EEERF2  2 /* Error Reading File 2                      */
#define EEERF3  3 /* Error Reading File 3                      */
#define EEEWF3  4 /* Error Writing File 3                      */
#define EEMISP  5 /* MISsing Parameters                        */
#define EETMNP  6 /* Too MaNy Parameters                       */
#define EEIFTC  7 /* Invalid FilTers' Combination              */
#define EENEMM  8 /* Not Enough MeMory                         */
#define EEUIFM  9 /* Unsupported Image ForMat                  */
#define EEISNO 10 /* Input files have Same Name of Output file */
#define EELHDS 11 /* Lists Have Different Sizes                */
#define EEIIDF 12 /* Input Images have DiFferent attributes    */
#define EEPGTD 13 /* Pattern image Greater Than Depth image    */
#define EETMER 14 /* Too Many ERrors                           */

#include <conio.h>
#include <fcntl.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Global variables                                                        */

byte
  EditMode=0,         /* This flag is not implemented.                   */
  JoinMode=0,         /* Flag for Join Modes.                            */
  MirrorMode=0,       /* Join images, inverting (by default) left image. */
  ReverseMirror=0,    /* Join images, inverting right image.             */
  SISMode=0,          /* Make SIS/SIRDS.                                 */
  InsertLine=0,       /* Insert the separator, instead of overdrawing.   */
  LineBrightness=0,   /* Brightness of separator line.                   */
  IgnoreUEOF=0,       /* Ignore End of File flag.                        */
  LeftFilter=2,       /* Left image Filter (bichromatic stereogram)      */
  RightFilter=0;      /* Right image Filter (bichromatic stereogram)     */

word
  DepthFactor=1,      /* SIS/SIRDS depth factor.                         */
  Separation=0;       /* Width of separator line (0 if no line).         */


/* Functions and procedures Definitions                                    */

void Help(void)
{ fprintf(stdout,"Iris: Stereogram Generator - Version Bianca-3.\n");
  fprintf(stdout,"(C) 1994, 2000 Unicorn Dreams Artwork Programs.\n");
  fprintf(stdout,"Programmed by \"Cyberknight\" Masao Kawata.\n\n");
  fprintf(stdout,"Syntax: IRIS [-Fxy] [-A] [-L] <Left> <Right> <Stereo>\n");
  fprintf(stdout,"        IRIS -J|-M [-R] [-Sn [-Cn] [-I]] [-A] [-L] <Left> <Right> <Stereo>\n");
  fprintf(stdout,"        IRIS -W [-Dn] [-A] [-L] <Pattern> <Depth> <SIS>\n\n");
  fprintf(stdout,"Required parameters:\n\n");
  fprintf(stdout," <Left> is the left eye component file name;\n");
  fprintf(stdout," <Right> is the right eye component file name;\n");
  fprintf(stdout," <Stereo> is the resulting stereographic file name;\n");
  fprintf(stdout," <Pattern> is the base pattern of a SIS/SIRDS;\n");
  fprintf(stdout," <Depth> is the depth description file;\n");
  fprintf(stdout," <SIS> is the resulting SIS/SIRDS file name;\n");
  fprintf(stdout,"Press <Enter> to continue...\n");
  while (getchar()!='\n');
  fprintf(stdout,"Modifiers and optional parameters:\n\n");
  fprintf(stdout," -M instructs program to make \"mirror stereopairs\" (read documentation);\n");
  fprintf(stdout," -J instructs program to joins images, side by side, without mirroring;\n");
  fprintf(stdout," -W instructs the program to make a SIS/SIRDS;\n");
  fprintf(stdout," [-Fxy] sets the colours of the left (x) and right (y) images (R, G or B);\n");
  fprintf(stdout," [-R] inverts right image instead of left one, in \"mirror mode\" (option -M);\n");
  fprintf(stdout," [-Sn] separates the \"mirror images\" by an n pixels wide line;\n");
  fprintf(stdout," [-Cn] defines the brightness of separation line (option -Sn);\n");
  fprintf(stdout," [-I] instructs option -Sn to insert line instead of overwriting image;\n");
  fprintf(stdout," [-Dn] sets the SIS/SIRDS \"depth factor\";\n");
  fprintf(stdout," [-A] instructs the program to ignore \"unexpected end of file\" errors;\n");
  fprintf(stdout," [-L] instructs program to use lists of files.\n");
  fprintf(stdout,"Press <Enter> to continue...\n");
  while (getchar()!='\n');
  fprintf(stdout,"Example 1) Creating a bichromatic stereogram:\n\n");
  fprintf(stdout,"iris gardenl.tga gardenr.tga garden3d.tga -frg\n\n");
  fprintf(stdout,"This command will merge \"gardenl.tga\" and \"gardenr.tga\" to create the \n");
  fprintf(stdout,"stereogram \"garden3d.tga\" (with the first image converted to the red \n");
  fprintf(stdout,"component and the second to the green component). If the option \"F\" is not \n");
  fprintf(stdout,"used, then it is assumed red to the left image and blue to the right one.\n");
  fprintf(stdout,"Press <Enter> to continue...\n");
  while (getchar()!='\n');
  fprintf(stdout,"Example 2) Creating a mirror \"stereopair\":\n\n");
  fprintf(stdout,"iris -m -s6 -c128 -I gardenl.tga gardenr.tga gardenp.tga\n\n");
  fprintf(stdout,"This command will join \"gardenl.tga\" and \"gardenr.tga\" to create the \n");
  fprintf(stdout,"\"stereopair\" \"gardenp.tga\" (with the first image mirrored in the left \n");
  fprintf(stdout,"side and the second, as is, in the right side). A six pixels wide middle \n");
  fprintf(stdout,"gray line will be inserted between the images. Read the documentation to \n");
  fprintf(stdout,"know how to view a \"stereopair\".\n");
  fprintf(stdout,"Press <Enter> to continue...\n");
  while (getchar()!='\n');
  fprintf(stdout,"Example 3) Creating a SIS/SIRDS:\n\n");
  fprintf(stdout,"iris -w -d10 flowers.tga garden.tga gardens.tga\n\n");
  fprintf(stdout,"This command will join \"flowers.tga\" and \"garden.tga\" to create the \n");
  fprintf(stdout,"SIS \"gardens.tga\". The resulting SIS will have the same size of the \n");
  fprintf(stdout,"second image, formed by a tiled pattern of the first image. If you want a \n");
  fprintf(stdout,"SIRDS, use a random dotted image as pattern file. The -d option will \n");
  fprintf(stdout,"define the number of depth levels in the resulting SIS and the distance \n");
  fprintf(stdout,"between levels.\n");
  fprintf(stdout,"Press <Enter> to continue...\n");
  while (getchar()!='\n');
  fprintf(stdout,"By now, all input images must be in 24 bits uncompressed .Tga file format. \n");
  fprintf(stdout,"The .Tga files also must have the same orientation. Future versions may \n");
  fprintf(stdout,"allow other image file formats, but that's not granted. Please, read \n");
  fprintf(stdout,"the documentation file if you have any doubts. If it is not cleared, \n");
  fprintf(stdout,"look for more information in \"http://welcome.to/unicorndreams\" or \n");
  fprintf(stdout,"\"http://unicorndreams.n3.net\". Contact the author by E-Mail: \n");
  fprintf(stdout,"\"cyberknight@catsrule.garfield.com\".\n");
  exit(0);
}

void ErrExt(ErrNum,ErrFile)
int
  ErrNum;
char
  *ErrFile;
{ switch (ErrNum)
  { case EENEMM:
      fprintf(stderr,"Error: not enough memory to allocate file buffer.\n");
      break;
    case EEUIFM:
      fprintf(stderr,"Error: %s has unsupported file image format.\n",ErrFile);
      break;
  }
  exit(ErrNum);
}

int ExceptUEOF(FileName,FileHandle)
char *FileName;
FILE *FileHandle;
{ fprintf(stderr,"%s: unexpected end of file.",FileName);
  if (IgnoreUEOF)
  { fprintf(stderr,"\n");
    fseek(FileHandle,18,0);
  }
  else
  { fprintf(stderr," Try \"-a\" option.\n");
    return(1);
  }
  return(0);
}

int Merge(FName1,FName2,FName3)
char *FName1,*FName2,*FName3;
{ byte
    *Buffer1,*Buffer2,*Buffer3;
  FILE
    *FH1,*FH2,*FH3;
  word
    X,Y,I,J,
    XC,YC,
    A,B,C,D,E,F,G,H,K,
    L,R,M,
    T,U;
  long
    FCounter;

  fprintf(stdout,"Processing files %s and %s into %s...\n",FName1,FName2,FName3);
  if ((strcmp(FName1,FName3)==0)||(strcmp(FName2,FName3)==0))
  { fprintf(stderr,"Error: one or more input files have the same name as output file!\n");
    return(EEISNO);
  }
  if ((FH1=fopen(FName1,"rb"))==NULL)
  { perror(FName1);
    return(EEERF1);
  }
  if ((FH2=fopen(FName2,"rb"))==NULL)
  { perror(FName2);
    return(EEERF2);
  }
  if ((FH3=fopen(FName3,"wb"))==NULL)
  { perror(FName3);
    return(EEEWF3);
  }
  if ((Buffer1=(byte *)malloc(20))==NULL) ErrExt(EENEMM,"");
  if ((Buffer2=(byte *)malloc(20))==NULL) ErrExt(EENEMM,"");
  if (!fread(Buffer1,18,1,FH1))
    if (ExceptUEOF(FName1,FH1))
      return(EEERF1);
  if (!fread(Buffer2,18,1,FH2))
    if (ExceptUEOF(FName2,FH2))
      return(EEERF2);
  if (Buffer1[2]>2) ErrExt(EEUIFM,FName1);
  if (Buffer2[2]>2) ErrExt(EEUIFM,FName2);
  if (Buffer1[17]!=Buffer2[17])
  { fprintf(stderr,"Error: input images have different orientations.\n");
    return(EEIIDF);
  }
  X=Buffer1[12]+Buffer1[13]*256;
  Y=Buffer1[14]+Buffer1[15]*256;
  I=Buffer2[12]+Buffer2[13]*256;
  J=Buffer2[14]+Buffer2[15]*256;
  if ((!SISMode)&&((X!=I)||(Y!=J)))
  { fprintf(stderr,"Error: images have different sizes.\n");
    return(EEIIDF);
  }
  else if (X>I)
  { fprintf(stderr,"Error: pattern image width is larger than depth image width!\n");
    return(EEPGTD);
  }
  T=I*3;
  U=Separation*3;
  if (MirrorMode||JoinMode)
  { Buffer2[12]=(byte)((X*2+Separation*InsertLine)%256);
    Buffer2[13]=(byte)((X*2+Separation*InsertLine)/256);
  }
  fwrite(Buffer2,18,1,FH3);
  free(Buffer2);
  free(Buffer1);
  if (SISMode)
  { fprintf(stdout,"Pattern image size    : %5u x %5u.\n",X,Y);
    fprintf(stdout,"Depth descriptor image: %5u x %5u.\n",I,J);
  }
  else
    fprintf(stdout,"Images' size: %5u x %5u.\n",X,Y);
  if ((MirrorMode)||(JoinMode))
  { if ((Buffer1=(byte *)malloc(T))==NULL) ErrExt(EENEMM,"");
    if ((Buffer2=(byte *)malloc(T))==NULL) ErrExt(EENEMM,"");
    if ((Buffer3=(byte *)malloc(T))==NULL) ErrExt(EENEMM,"");
    A=(Separation/2)*3;
    for (YC=0;YC<Y;YC++)
    { if (!fread(Buffer1,T,1,FH1))
        if (ExceptUEOF(FName1,FH1))
          return(EEERF1);
      if (!fread(Buffer2,T,1,FH2))
        if (ExceptUEOF(FName2,FH2))
          return(EEERF2);
      if (JoinMode)
      { if (InsertLine)
        { fwrite(Buffer1,T,1,FH3);
          for (XC=0;XC<U;XC++)
            Buffer1[XC]=LineBrightness;
          fwrite(Buffer1,U,1,FH3);
        }
        else
        { for (XC=0;XC<(U-A);XC++)
            Buffer1[T-XC-1]=LineBrightness;
          fwrite(Buffer1,T,1,FH3);
          for (XC=0;XC<A;XC++)
            Buffer2[XC]=LineBrightness;
        }
        fwrite(Buffer2,T,1,FH3);
      }
      else if (ReverseMirror)
      { for (XC=0;XC<X;XC++)
        { B=XC*3;
          Buffer3[T-B-3]=Buffer2[B];
          Buffer3[T-B-2]=Buffer2[B+1];
          Buffer3[T-B-1]=Buffer2[B+2];
        }
        if (InsertLine)
        { fwrite(Buffer1,T,1,FH3);
          for (XC=0;XC<U;XC++)
            Buffer1[XC]=LineBrightness;
          fwrite(Buffer1,U,1,FH3);
        }
        else
        { for (XC=0;XC<(U-A);XC++)
            Buffer1[T-XC-1]=LineBrightness;
          fwrite(Buffer1,T,1,FH3);
          for (XC=0;XC<A;XC++)
            Buffer3[XC]=LineBrightness;
        }
        fwrite(Buffer3,T,1,FH3);
      }
      else
      { for (XC=0;XC<X;XC++)
        { B=XC*3;
          Buffer3[T-B-3]=Buffer1[B];
          Buffer3[T-B-2]=Buffer1[B+1];
          Buffer3[T-B-1]=Buffer1[B+2];
        }
        if (InsertLine)
        { fwrite(Buffer3,T,1,FH3);
          for (XC=0;XC<U;XC++)
            Buffer3[XC]=LineBrightness;
          fwrite(Buffer3,U,1,FH3);
        }
        else
        { for (XC=0;XC<(U-A);XC++)
            Buffer3[T-XC-1]=LineBrightness;
          fwrite(Buffer3,T,1,FH3);
          for (XC=0;XC<A;XC++)
            Buffer2[XC]=LineBrightness;
        }
        fwrite(Buffer2,T,1,FH3);
      }
    }
    free(Buffer3);
    free(Buffer2);
    free(Buffer1);
  }
  else if (SISMode)
  { if ((Buffer1=(byte *)malloc(T))==NULL) ErrExt(EENEMM,"");
    if ((Buffer2=(byte *)malloc(T))==NULL) ErrExt(EENEMM,"");
    A=X*3;
    C=0;
    for (YC=0;YC<J;YC++)
    { if (C>=Y)
      { fseek(FH1,18,0);
        C=0;
      }
      if (!fread(Buffer1,A,1,FH1))
        if (ExceptUEOF(FName1,FH1))
          return(EEERF1);
      C++;
      if (!fread(Buffer2,T,1,FH2))
        if (ExceptUEOF(FName2,FH2))
          return(EEERF2);
      for (H=0;H<A;H++)
        Buffer2[H]=Buffer1[H];
      E=I/X;
      if ((I%X)>0)
        E++;
      for (F=1;F<E;F++)
      { K=X*F;
        if ((K+X)>I)
          B=I-K;
        else
          B=X;
        XC=K*3;
        G=(K-X)*3;
        for (H=0;H<B;H++)
        { D=((Buffer2[XC]+Buffer2[XC+1]+Buffer2[XC+2])*DepthFactor)/765*3+G;
          Buffer2[XC]=Buffer2[D];
          Buffer2[XC+1]=Buffer2[D+1];
          Buffer2[XC+2]=Buffer2[D+2];
          XC+=3;
          G+=3;
        }
      }
      fwrite(Buffer2,T,1,FH3);
    }
    free(Buffer2);
    free(Buffer1);
  }
  else
  { if (X<2048)
      D=2048;
    else
      D=T;
    C=D*3;
    if ((Buffer1=(byte *)malloc(C))==NULL)
    { if (D!=T)
        D=T;
      else
        D=2048;
      C=D*3;
      if ((Buffer1=(byte *)malloc(C))==NULL) ErrExt(EENEMM,"");
    }
    if ((Buffer2=(byte *)malloc(C))==NULL)
    { if (D!=T)
        D=T;
      else
        D=2048;
      C=D*3;
      free(Buffer1);
      if (((Buffer1=(byte *)malloc(C))==NULL)||((Buffer2=(byte *)malloc(C))==NULL))
        ErrExt(EENEMM,"");
    }
    if (!LeftFilter)
      if (RightFilter==1) M=2;
      else M=1;
    else if (LeftFilter==1)
      if (!RightFilter) M=2;
      else M=0;
    else if (!RightFilter) M=1;
    else M=0;
    FCounter=(unsigned long)X*Y;
    while (FCounter>0)
    { if (FCounter>D)
        B=D;
      else
        B=FCounter;
      C=B*3;
      if (!fread(Buffer1,C,1,FH1))
        if (ExceptUEOF(FName1,FH1))
          return(EEERF1);
      if (!fread(Buffer2,C,1,FH2))
        if (ExceptUEOF(FName2,FH2))
          return(EEERF2);
      for (A=0;A<C;A+=3)
      { L=(Buffer1[A]+Buffer1[A+1]+Buffer1[A+2])/3;
        R=(Buffer2[A]+Buffer2[A+1]+Buffer2[A+2])/3;
        Buffer1[A+M]=0;
        Buffer1[A+LeftFilter]=L;
        Buffer1[A+RightFilter]=R;
      }
      fwrite(Buffer1,C,1,FH3);
      FCounter-=B;
    }
    free(Buffer2);
    free(Buffer1);
  }
  fclose(FH1);
  fclose(FH2);
  fclose(FH3);
  fprintf(stdout,"Done!\n");
  return(0);
}

char *GetFileName(FHandle)
FILE *FHandle;
{ byte ByteBuf[2];
  char *FileName;
  int RdSt=0;
  long SPos,Size;

  ByteBuf[0]='\0';
  SPos=ftell(FHandle);
  while (RdSt<2)
    if (!fread(ByteBuf,1,1,FHandle))
      RdSt|=4;
    else if (ByteBuf[0]<33)
    { if (RdSt)
        RdSt|=2;
    }
    else
    { if (!RdSt)
      { SPos=ftell(FHandle)-1;
        RdSt|=1;
      }
    }
  if (RdSt&1)
  { Size=ftell(FHandle)-SPos-(RdSt&4?0:1);
    if (Size)
    { if ((FileName=(byte *)malloc((size_t)Size+1))==NULL) ErrExt(EENEMM,"");
      if (fseek(FHandle,SPos,0))
        return(NULL);
      if (fread(FileName,(size_t)1,(size_t)Size,FHandle)<Size)
        return(NULL);
      FileName[Size]='\0';
      return(FileName);
    }
  }
  return(NULL);
}

char chrupc(chr)
/* CHaRacter UPcase Convert */
const char chr;
{ if ((chr>='a')&&(chr<='z')) return(chr-32);
  return(chr);
}

int main (ArgCnt,ArgStr)
int
  ArgCnt;
char
  *ArgStr[];
{ FILE
    *F1H,*F2H,*F3H;
  const char
    RGB[4]="BGR";
  char
    *FN1,*FN2,*FN3,
    C;
  byte
    A,B;
  int
    ArgCounter,FileCounter=0,
    FNI[3],
    ListFiles=0,EndofList,Error;

  if (ArgCnt<2)
    Help();
  for (ArgCounter=1;ArgCounter<ArgCnt;ArgCounter++)
  { if (ArgStr[ArgCounter][0]=='-')
      switch (chrupc(ArgStr[ArgCounter][1]))
      { case 'A':
          IgnoreUEOF=1;
          break;
        case 'C':
          sscanf(ArgStr[ArgCounter]+2,"%d",&LineBrightness);
          break;
        case 'D':
          sscanf(ArgStr[ArgCounter]+2,"%d",&DepthFactor);
          break;
        case 'E':
          EditMode=1;
          break;
        case 'F':
          C=chrupc(ArgStr[ArgCounter][2]);
          A=0;
          while (RGB[A]&&(RGB[A]!=C)) A++;
          C=chrupc(ArgStr[ArgCounter][3]);
          B=0;
          while (RGB[B]&&(RGB[B]!=C)) B++;
          if ((A>2)||(B>2)||(A==B))
          { fprintf(stderr,"Error: Invalid filters' combination.\n");
            exit(EEIFTC);
          }
          LeftFilter=A;
          RightFilter=B;
          break;
        case 'I':
          InsertLine=1;
          break;
        case 'J':
          JoinMode=1;
          break;
        case 'L':
          ListFiles=1;
          break;
        case 'M':
          MirrorMode=1;
          break;
        case 'R':
          ReverseMirror=1;
          break;
        case 'S':
          sscanf(ArgStr[ArgCounter]+2,"%d",&Separation);
          break;
        case 'W':
          SISMode=1;
      }
    else if (FileCounter<3)
      FNI[FileCounter++]=ArgCounter;
    else
    { fprintf(stderr,"Fatal: too many parameters.\n");
      exit(EETMNP);
    }
  }
  if (FileCounter<3)
  { fprintf(stderr,"Fatal: missing parameters.\n");
    exit(EEMISP);
  }
  if ((!MirrorMode)&&(!JoinMode))
  { InsertLine=0;
    Separation=0;
    ReverseMirror=0;
  }
  if (JoinMode)
  { ReverseMirror=0;
    MirrorMode=0;
  }
  if (ListFiles)
  { if ((F1H=fopen(ArgStr[FNI[0]],"rb"))==NULL)
    { perror(ArgStr[FNI[0]]);
      exit(EEERF1);
    }
    if ((F2H=fopen(ArgStr[FNI[1]],"rb"))==NULL)
    { perror(ArgStr[FNI[1]]);
      exit(EEERF2);
    }
    if ((F3H=fopen(ArgStr[FNI[2]],"rb"))==NULL)
    { perror(ArgStr[FNI[2]]);
      exit(EEERF3);
    }
    EndofList=0;
    Error=0;
    while ((Error<50)&&(!EndofList))
    { FN1=GetFileName(F1H);
      FN2=GetFileName(F2H);
      FN3=GetFileName(F3H);
      if ((FN1==NULL)&&(FN2==NULL)&&(FN3==NULL))
        EndofList=1;
      else if ((FN1==NULL)||(FN2==NULL)||(FN3==NULL))
      { fprintf(stderr,"Error: lists have different number of files.\n");
        exit(EELHDS);
      }
      else
      { Error+=Merge(FN1,FN2,FN3);
        free(FN3);
        free(FN2);
        free(FN1);
      }
    }
    fclose(F1H);
    fclose(F2H);
    fclose(F3H);
    if (Error>=50)
      fprintf(stderr,"Stop: too many errors!\n\7");
    exit(EETMER);
  }
  else
    return(Merge(ArgStr[FNI[0]],ArgStr[FNI[1]],ArgStr[FNI[2]]));
  return(0);
}
