/* file : texture3d.h
 * load or write a rvf file
 *
 * rvf file :
 * 3x2 byte (little endian)....data....
 *
 * example:
 * a 256*255*170 volume begins with
 * 0100 00ff 00aa .........data...........
 *  x    y    z
 */


typedef struct tex3{
	int x;
	int y;
	int z;
	unsigned char *texture;
}
tex3;

void init_tex3(tex3 *tex,int x,int y,int z,unsigned char *texture);
int  load_tex3(tex3 *tex,char *name);
void save_rvf(tex3 *tex,char *name);
int  load_rvf(tex3 *tex,char *name);
int  load_raw(tex3 *tex,char *name,int x,int y,int z);
