#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "texture3d.h"

void init_tex3(tex3 *tex,int x,int y,int z,unsigned char *texture){
	tex->x=x;
	tex->y=y;
	tex->z=z;
	tex->texture=texture;
}

int  load_tex3(tex3 *tex,char *name){
	char *ext;
	ext=strrchr(name,'.');
	if (ext==NULL){
		fprintf(stderr,"load_tex3() : unknown format for '%s'\n",name);
		return -1;
	}
	if (!strcmp(ext,".rvf"))
		return load_rvf(tex,name);
	if (!strcmp(ext,".raw"))
		return load_raw(tex,name,256,256,256);
	return -1;

}

void save_rvf(tex3 *tex,char *name){
	FILE *fp;
	fp=fopen(name,"wb");
	if (fp==NULL){
		fprintf(stderr,"save_rvf() : can't create %s\n",name);
		return;
	}
	fwrite(&(tex->x),1,1,fp);
	fwrite(&(tex->y),1,1,fp);
	fwrite(&(tex->z),1,1,fp);
	fwrite(tex->texture,tex->x*tex->y*tex->z,1,fp);
	fclose(fp);
}


int  load_rvf(tex3 *tex,char *name){
	FILE *fp;
	unsigned char hi;
	unsigned char lo;
	fp=fopen(name,"rb");
	if (fp==NULL){
		fprintf(stderr,"load_rvf() : can't open %s\n",name);
		return -1;
	}
	fread(&hi,1,1,fp);
	fread(&lo,1,1,fp);
	tex->x=hi*256+lo;
	fread(&hi,1,1,fp);
	fread(&lo,1,1,fp);
	tex->y=hi*256+lo;
	fread(&hi,1,1,fp);
	fread(&lo,1,1,fp);
	tex->z=hi*256+lo;
	tex->texture=(unsigned char *)malloc(tex->x*tex->y*tex->z);
	if (tex->texture==NULL){
		fprintf(stderr,"load_rvf() : Out of memory (%s)\n",name);
		return -1;
	}
	fread(tex->texture,tex->x*tex->y*tex->z,1,fp);
	fclose(fp);
	return 0;
}

int  load_raw(tex3 *tex,char *name,int x,int y,int z){
	FILE *fp;
	fp=fopen(name,"rb");
	if (fp==NULL){
		fprintf(stderr,"load_raw() : can't open %s\n",name);
		return -1;
	}
	tex->x=x;
	tex->y=y;
	tex->z=z;
	tex->texture=(unsigned char *)malloc(tex->x*tex->y*tex->z);
	if (tex->texture==NULL){
		fprintf(stderr,"load_raw() : Out of memory (%s)\n",name);
		return -1;
	}
	fread(tex->texture,tex->x*tex->y*tex->z,1,fp);
	fclose(fp);
	return 0;
}
