#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "tga.h"

void init_tga(tga_t *t,unsigned short xs,unsigned short ys,unsigned short bpp ){
	t->id=0x00;
	t->colorMapType=0x00;
	t->imageType=0x02;
	t->colorMap0=t->colorMap1=t->colorMap2=0x0000;
	t->xOrigin=0;
	t->yOrigin=0;
	t->xSize=xs;
	t->ySize=ys;
	t->bpp=bpp;
	t->imageDesc=20;
}

int save_tga(tga_t t,unsigned char *d,char *n){
	int i,j,temp;
	FILE *fp ;
	unsigned short tmp;

	fp=fopen(n,"wb");
	if (fp==NULL)
		return -1;
	fwrite(&t.id,sizeof(unsigned char),1,fp);
	fwrite(&t.colorMapType,sizeof(unsigned char),1,fp);
	fwrite(&t.imageType,sizeof(unsigned char),1,fp);
	fwrite(&t.colorMap0,sizeof(unsigned short),1,fp);
	fwrite(&t.colorMap1,sizeof(unsigned short),1,fp);
	fwrite(&t.colorMap2,sizeof(unsigned char),1,fp);
	tmp=t.xOrigin;
#ifdef MOTOROLA
	tmp=(tmp>>8)|((tmp&0x00ff)<<8);
#endif
	fwrite(&tmp,sizeof(unsigned short),1,fp);
	tmp=t.yOrigin;
#ifdef MOTOROLA
	tmp=(tmp>>8)|((tmp&0x00ff)<<8);
#endif
	fwrite(&tmp,sizeof(unsigned short),1,fp);
	tmp=t.xSize;
#ifdef MOTOROLA
	tmp=(tmp>>8)|((tmp&0x00ff)<<8);
#endif
	fwrite(&tmp,sizeof(unsigned short),1,fp);
	tmp=t.ySize;
#ifdef MOTOROLA
	tmp=(tmp>>8)|((tmp&0x00ff)<<8);
#endif
	fwrite(&tmp,sizeof(unsigned short),1,fp);
	fwrite(&t.bpp,sizeof(unsigned char),1,fp);
	fwrite(&t.imageDesc,sizeof(unsigned char),1,fp);
	/* bgr -> rgb */
	for(j=0;j<t.ySize;j++){
		for (i=0;i<t.xSize;i++){
			temp=d[(i+j*t.xSize)*3+2];
			d[(i+j*t.xSize)*3+2]=d[(i+j*t.xSize)*3];
			d[(i+j*t.xSize)*3]=temp;
		}
	}
	fwrite(d,1,3*t.xSize*t.ySize,fp);
	fclose(fp);
	return 0;
}


/* really buggy loader , don't use me */
int load_tga(char *n,unsigned char **d,int *x,int *y){
	FILE *fp;
	int x1,y1,i,j;
	unsigned char temp;

	fp=fopen(n,"rb");
	if (fp==NULL)
		return -1;
	fseek(fp,18,0);
	fread(x,sizeof(unsigned short),1,fp);
	fread(y,sizeof(unsigned short),1,fp);
	x1=*x;
	y1=*y;

	fseek(fp,0x36,0);
	*d=(unsigned char*) malloc((x1)*(y1)*3);
	fread(*d,1,x1*y1*3,fp);
	/* bgr -> rgb */
	for(j=0;j<y1;j++){
		for (i=0;i<x1;i++){
			temp=(*d)[(i+j*x1)*3+2];
			(*d)[(i+j*x1)*3+2]=(*d)[(i+j*x1)*3];
			(*d)[(i+j*x1)*3]=temp;
		}
	}
	fclose(fp);
	return 0;
}
