#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "bmp.h"

void init_bmp(bmp_t *b,dword xs,dword ys,word bpp ){
	b->id=0x4d42;
	b->forty=40;
	b->xs=xs;
	b->ys=ys;
	b->nbplane=1;
	b->bpp=bpp;
	b->begin=0x36;
	b->zero_1=b->zero_2=b->zero_3=0;
	b->size=xs*ys*3+54;
	b->comp=0;
	b->xpix_m=b->ypix_m=b->clr_used=b->clr_imp=0;
}


int save_bmp(bmp_t b,byte *d,char *n){
	int i,j,temp;
	FILE *fp ;
	fp=fopen(n,"wb");
	if (fp==NULL)
		return -1;
	fwrite(&b.id,sizeof(word),1,fp);
	fwrite(&b.size,sizeof(dword),1,fp);
	fwrite(&b.zero_1,sizeof(word),1,fp);
	fwrite(&b.zero_2,sizeof(word),1,fp);
	fwrite(&b.begin,sizeof(dword),1,fp);
	fwrite(&b.forty,sizeof(dword),1,fp);
	fwrite(&b.xs,sizeof(dword),1,fp);
	fwrite(&b.ys,sizeof(dword),1,fp);
	fwrite(&b.nbplane,sizeof(word),1,fp);
	fwrite(&b.bpp,sizeof(word),1,fp);
	fwrite(&b.comp,sizeof(dword),1,fp);
	fwrite(&b.zero_3,sizeof(dword),1,fp);
	fwrite(&b.xpix_m,sizeof(dword),1,fp);
	fwrite(&b.ypix_m,sizeof(dword),1,fp);
	fwrite(&b.clr_used,sizeof(dword),1,fp);
	fwrite(&b.clr_imp,sizeof(dword),1,fp);
	for(j=0;j<b.ys;j++){
		for (i=0;i<b.xs;i++){
			temp=d[(i+j*b.xs)*3+2];
			d[(i+j*b.xs)*3+2]=d[(i+j*b.xs)*3];
			d[(i+j*b.xs)*3]=temp;
		}
	}
	fwrite(d,3*b.xs*b.ys,1,fp);
	fclose(fp);
	return 0;
}


int load_bmp(char *n,unsigned char **d,int *x,int *y){
	FILE *fp;
	int x1,y1,i,j;
	unsigned char temp;
	fp=fopen(n,"rb");
	if (fp==NULL)
		return -1;
	fseek(fp,18,0);
	fread(x,sizeof(dword),1,fp);
	fread(y,sizeof(dword),1,fp);
	x1=*x;
	y1=*y;
	fseek(fp,0x36,0);
	*d=(unsigned char*) malloc((x1)*(y1)*3);
	fread(*d,1,x1*y1*3,fp);
	for(j=0;j<y1;j++){
		for (i=0;i<x1;i++){
			temp=(*d)[(i+j*x1)*3+2];
			(*d)[(i+j*x1)*3+2]=(*d)[(i+j*x1)*3];
			(*d)[(i+j*x1)*3]=temp;
		}
	}
	fclose(fp);
	return 0;
}

