/*
 * Monaural 8 bits sampled PCM inplanter.
 * OUT/IN = 3/2
 * MixFULL:ODD sample
 * Mix LO :EVEN sample
 *
 * Inplantspell͂łĂ̂sB
 * QoCg̃TvɍlA
 * juւŃf[^uƂŊi[グB
 *
 * Uc[ɂ܂ŃGfBAlďȂʖڂłB
 *
 * KRIɁAT|[ĝ͂Wrbgwav݂̂ƂȂB
 * [v̂Œ͎RB
 * WVbNp[ŃuAbnbn@vĐȂB
 * PatoLaboŕuSystem Zero startvĐˁB
 * ASURA SystemNĂlAB
 *
 * For ex.
 *   Inplant:0x1F,3E
 * Dummy PCM:0x83,0x9E
 *    +  Noise+Voice  + DipNoise
 * -> 0x80|0x1,0x90|0xF,0x3E
 *
 * o͂PCḾAȂUUɂȂł낤B
 * GCAɂ鈳k͂邩ȂB
 */

#include <stdio.h>

/*
 * datapcmf[^ɃCvgAoutɏóB
 * ȂꍇA_~[PCM̓[vB
 */
int Inplant(unsigned char *pcm,int pcmlen,int *pcmpoint,unsigned char *data,int len,unsigned char *out)
{
	int i,j;
	unsigned char hi,lo;
	j = 0;
	for(i=0;i<len;i++)
	{
		// ݂ƂȂCvgBȂ肩B
		// KȂ̂ŉ䖝B
		if(i&1)
		{
			//Ԗ (2Tvɂ܂)
			//PCMƂ̃juPʍ
			
			//ʌ̕ۑ
			out[j++] = (pcm[*pcmpoint]&0xF0)|((data[i]>>4)&0x0F);
			(*pcmpoint)++;(*pcmpoint)%=pcmlen;
			//printf("i:%d,j:%d,nibble mix,%02x+%02x->%02x\n",i,j,pcm[*pcmpoint],data[i],out[j-1]);
			//ʌ̕ۑ
			out[j++] = (pcm[*pcmpoint]&0xF0)|((data[i])&0x0F);
			(*pcmpoint)++;(*pcmpoint)%=pcmlen;
			//printf("i:%d,j:%d,nibble mix,%02x+%02x->%02x\n",i,j,pcm[*pcmpoint],data[i],out[j-1]);
		}
		else
		{
			// j=0             1,2          3               4,5
			//juXbv->4rbg->juXbv->4rbg
			//̂܂܃juXbvB
			//mCYɂȂ͂B
			hi = (data[i] & 0xF0)>>4;
			lo = (data[i] &  0xF)<<4;
			out[j] = (hi|lo)^0x80;
			//printf("i:%d,j:%d,nibble swp,%02x->%02x,%x,%x\n",i,j,data[i],out[j],hi,lo);
			j++;
			(*pcmpoint)++;(*pcmpoint)%=pcmlen;
		}
	}
	//printf("\n");
	//TCYԂ
	return j;
}

int Deplant(unsigned char *data,int len,unsigned char *out)
{
	//ǂPCMŋU悤Ǝ͂܂ɉeȂB
	int i;
	int j=0;
	unsigned char hi,lo;
	for(i=0;i<len;i++)
	{
		//o̓obt@̃CfNXŏ킯ȂƎ
		if(j & 1)
		{
			//
			//printf("i:%d,nibble mix\n",i);
			
			//4rbg̒o
			hi = (data[i]&0xF)<<4;
			i++;
			lo = (data[i]&0xF);
			out[j++] = hi|lo;	//B
		}
		else
		{
			//
			//printf("i:%d,nibble swap\n",i);
			//juXbv
			data[i]^=0x80;
			out[j++] = ((data[i]&0x0F)<<4)|(data[i]>>4);
		}
	}
	//printf("\n");
	//ďoĂMTCY
	return j-1;
}

#ifdef TEST
/*eXg*/
void main(void)
{
	unsigned char test[17] = "This is the test\0";
	unsigned char out[30];
	unsigned char base[8] = "LAlaLAla";
	unsigned char test2[28];
	int pcmpos=0;
	int out1,out2;
	int i;
	
	//PCM,PCMsize,pcmpos,data,datasize,out
	out1 = Inplant(base,8,&pcmpos,test,17,out);
	out2 = Deplant(out,26,test2);
	printf("%d,%d,%s\n",out1,out2,test2);
	for(i=0;i<17;i++)
		printf("%02x,",test[i]);
	printf("\n");
	for(i=0;i<out1;i++)
		printf("%02x,",out[i]);
	printf("\n");
	for(i=0;i<out2;i++)
		printf("%02x,",test2[i]);
}
#endif
