#include <time.h>
#include "allegro.h" 
#include "bomb.h"
#include "player.h"


int main() 
{ 
  allegro_init();
  install_timer();
  install_mouse();
  install_keyboard();

  set_color_depth(8);
  set_gfx_mode( GFX_AUTODETECT || GFX_HW_VRAM_BLIT_MASKED, 800, 600, 0, 0);

   srand(time(0));

  BITMAP *buffer; 
  BITMAP *land; 
  BITMAP *background; 

  int max_bombs=300;
  Bomb* bomb[max_bombs]; 
  for (int a=0; a<max_bombs; a++) 
  { 
     bomb[a]=new Bomb(0); 
  }
  int max_shells=300;
  Bomb* shell[max_shells]; 
  for (int a=0; a<max_shells; a++) 
  { 
     shell[a]=new Bomb(1); 
  }

  PLAYER player(20,20);

  buffer=create_bitmap( 800, 600); 
  land=create_bitmap( 800, 600); 
  background=create_bitmap( 800, 600); 
 
  clear_bitmap(land); 
  clear_bitmap(background); 
 
  rectfill( background, 0, 0, 799, 599, makecol( 0, 255, 0)); 
  rectfill( land, 0, 300, 799, 599, makecol( 0, 0, 255)); 

   bool mbp1=0;
   int mxs,mys;

   while (!key[KEY_ESC]) 
   {
      if(mouse_b&1 && mbp1==0)
      {
         mxs=mouse_x;
         mys=mouse_y;
         mbp1=1;
      }
      if(!(mouse_b&1) && mbp1==1)
      {
         for (int a=0; a<max_bombs; a++) 
         {
	    if(bomb[a]->active==0)
            {
               bomb[a]->active=1;
               bomb[a]->x=mxs;
               bomb[a]->y=mys;
               bomb[a]->dx=(mouse_x-mxs)/100;
               bomb[a]->dy=(mouse_y-mys)/100;
               break;
	    }
         }
         mbp1=0;
      } 

      blit( background, buffer, 0, 0, 0, 0, 800, 600);
      masked_blit( land, buffer, 0, 0, 0, 0, 800, 600);

      player.move(land,bomb,max_bombs,shell,max_shells);
      player.draw(buffer);
      
      if(mouse_b&1 && mbp1==1)
      {
         line(buffer,mxs,mys,mouse_x,mouse_y,1);
      }

      for (int a=0; a<max_bombs; a++)
      { 
         if(bomb[a]->active==1)
         {
            bomb[a]->Move();
            bomb[a]->Collision(land);
            blit( bomb[a]->picture, buffer, 0, 0, int(bomb[a]->x), int(bomb[a]->y), 1, 1); 
         }
      } 
      for (int a=0; a<max_shells; a++)
      { 
         if(shell[a]->active==1)
         {
            shell[a]->Move();
            shell[a]->Collision(land);
            blit( shell[a]->picture, buffer, 0, 0, int(shell[a]->x), int(shell[a]->y), 1, 1); 
         }
      } 

      blit( buffer, screen, 0, 0, 0, 0, 800, 600); 
   } 
 
   return 1;
}
END_OF_MAIN();
