#include<allegro.h>

int mx,my;
int _time=0;
BITMAP *sprite;
BITMAP *projectile;

void update_time(){
   _time++;
}

class PICKUP{
   public:
      PICKUP();
      void use(float ix, float iy);
      void update();
      void draw(BITMAP *buffer);
      float x,y;
      int d,last_update,used;
};
PICKUP rocket[10];

PICKUP::PICKUP(){
   used=0;
}

void PICKUP::use(float ix, float iy){
   x=ix;
   y=iy;
   d=0;
   used=1;
}

void PICKUP::update(){
   d=_time;
}

void PICKUP::draw(BITMAP *buffer){
   pivot_sprite(buffer,projectile,int(x),int(y),4,4,-d<<16);
}

class PROJECTILE{
   public:
      PROJECTILE();
      void use(float ix, float iy, int id);
      void update();
      float x,y;
      int d,last_update,used,f;
};

PROJECTILE::PROJECTILE(){
   used=0;
}

void PROJECTILE::use(float ix, float iy, int id){
   x=ix;
   y=iy;
   d=id;
   f=_time-20;
   used=1;
}

void PROJECTILE::update(){
   x=x+sin(d)*((_time-f)/20);
   y=y+cos(d)*((_time-f)/20);
   if(x<16||x>SCREEN_W-16||y<16||y>SCREEN_H-16)used=0;
}

class PLAYER{
   public:
      PLAYER(int pnr);
      void update();
      void draw(BITMAP *buffer);
      void fire_rocket();
      float x,y;
      int d,nr;
      int last_update,last_fire;
      PROJECTILE rocket[100];
      int rockets;
};

PLAYER::PLAYER(int pnr){
   x=SCREEN_W/2;
   y=SCREEN_H/2;
   rockets=10;
   d=0;
   nr=pnr;
   last_fire=_time;
   PALETTE pal;
   BITMAP *temp=load_bitmap("sprite.bmp",pal);
   set_palette(pal);
   sprite=create_bitmap(17,8);
   blit(temp,sprite,0,0,0,0,17,8);
   projectile=create_bitmap(6,8);
   blit(temp,projectile,17,0,0,0,6,8);
}

void PLAYER::fire_rocket(){
   for(int n=0;n<100;n++){
      if(rocket[n].used==0){
         rocket[n].use(x,y,d);
         last_fire=_time;
         rockets--;
         break;
      }
   }
}

void PLAYER::update(){
   if(nr==1){
    d-=mx;
    if(key[KEY_A])d=d+1;
    if(key[KEY_D])d=d-1;
    if(key[KEY_W]){
       x=x+sin(d)*(_time-last_update);
       y=y+cos(d)*(_time-last_update);
    }
    if(key[KEY_S]){
       x=x-sin(d)*(_time-last_update);
       y=y-cos(d)*(_time-last_update);
    }
    if(key[KEY_G]){
       x=x+sin(d+64)*(_time-last_update);
       y=y+cos(d+64)*(_time-last_update);
    }
    if(key[KEY_H]){
       x=x-sin(d+64)*(_time-last_update);
       y=y-cos(d+64)*(_time-last_update);
    }
 
    if((mouse_b&1||key[KEY_F])&&_time-last_fire>20&&rockets){
       fire_rocket();
    }
   }

   else{
    if(key[KEY_LEFT])d=d+1;
    if(key[KEY_RIGHT])d=d-1;
    if(key[KEY_UP]){
       x=x+sin(d)*(_time-last_update);
       y=y+cos(d)*(_time-last_update);
    }
    if(key[KEY_DOWN]){
       x=x-sin(d)*(_time-last_update);
       y=y-cos(d)*(_time-last_update);
    }
    if(key[KEY_2_PAD]){
       x=x+sin(d+64)*(_time-last_update);
       y=y+cos(d+64)*(_time-last_update);
    }
    if(key[KEY_3_PAD]){
       x=x-sin(d+64)*(_time-last_update);
       y=y-cos(d+64)*(_time-last_update);
    }
 
    if((mouse_b&1||key[KEY_1_PAD])&&_time-last_fire>20&&rockets)fire_rocket();
   }

   x=(x<16)?x+1:x;
   x=(x>SCREEN_W-16)?x-1:x;
   y=(y<16)?y+1:y;
   y=(y>SCREEN_H-16)?y-1:y;

   for(int n=0;n<100;n++)
      if(rocket[n].used==1)
         rocket[n].update();

   last_update=_time;
}

void PLAYER::draw(BITMAP *buffer){
   pivot_sprite(buffer,sprite,x,y,8,5,-d<<16);
   for(int n=0;n<100;n++)
      if(rocket[n].used==1)
         pivot_sprite(buffer,projectile,rocket[n].x,rocket[n].y,4,4,-rocket[n].d<<16);
}

void main(){
   allegro_init();
   install_timer();
   install_mouse();
   install_keyboard();
   set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,640,400,0,0);
   BITMAP *buffer=create_bitmap(SCREEN_W,SCREEN_H);
   install_int_ex(update_time,BPS_TO_TIMER(100));
   srand(time(0));
   PLAYER p1(1);
   PLAYER p2(2);
   int updates=0,rate;

   for(int n=0;n<10;n++)
      rocket[n].use((rand()%(SCREEN_W-40)+20),(rand()%(SCREEN_H-40)+20));
   while(!_time);
   while(!key[KEY_ESC]){
      updates++;
      clear(buffer);
      get_mouse_mickeys(&mx,&my);
      p1.update();
      p2.update();
      p1.draw(buffer);
      p2.draw(buffer);
      for(int n=0;n<10;n++){
         rocket[n].update();
         rocket[n].draw(buffer);
         if(p1.x>rocket[n].x-5&&p1.x<rocket[n].x+5&&p1.y>rocket[n].y-5&&p1.y<rocket[n].y+5){
            p1.rockets++;
            rocket[n].use((rand()%(SCREEN_W-40)+20),(rand()%(SCREEN_H-40)+20));
         }
         if(p2.x>rocket[n].x-5&&p2.x<rocket[n].x+5&&p2.y>rocket[n].y-5&&p2.y<rocket[n].y+5){
            p2.rockets++;
            rocket[n].use((rand()%(SCREEN_W-40)+20),(rand()%(SCREEN_H-40)+20));
         }
      }
      rate=int(updates/_time)*100;
      textprintf(buffer,font,0,0,1,"FPS: %i",rate);
      textprintf(buffer,font,0,SCREEN_H-8,1,"P1 ROCKETS: %i",p1.rockets);
      textprintf(buffer,font,SCREEN_W-15*8,SCREEN_H-8,1,"P2 ROCKETS: %i",p2.rockets);
      blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
   }
}END_OF_MAIN();
