#include<stdlib.h>
#include<allegro.h>

MATRIX_f *m,*m2,*m1;
BITMAP *texture;
int rendermode=0,num_modes=3;

class TABLE
{
 public:
  int value,index;
};

int pol_cmp(const void *e1,const void *e2)
{
 TABLE *q1=(TABLE *)e1;
 TABLE *q2=(TABLE *)e2;
 return q2->value-q1->value;
}

//Polygon handling
class POL
{
 public:
  POL();
  void copy(POL tpol);
  void POL::draw(BITMAP *buffer,int scrollx,int scrolly,int view);
  int num_vtx;
  V3D_f *vtx;
};

//Created for making the temporary polygon
POL::POL()
{
 num_vtx=0;
 vtx=new V3D_f[256];
}

//Copy a polygon
void POL::copy(POL tpol)
{
 delete vtx;
 num_vtx=tpol.num_vtx;
 vtx=new V3D_f[num_vtx];
 for(int n=0;n<num_vtx;n++) {  vtx[n]=tpol.vtx[n]; }
}

void POL::draw(BITMAP *buffer,int scrollx,int scrolly,int view)
{
 if(view==1)
 {
  for(int n=0;n<num_vtx-1;n++)  {   line(buffer,int(vtx[n].x-scrollx),int(vtx[n].y-scrolly),int(vtx[n+1].x-scrollx),int(vtx[n+1].y-scrolly),4);  }
  line(buffer,int(vtx[num_vtx-1].x-scrollx),int(vtx[num_vtx-1].y-scrolly),int(vtx[0].x-scrollx),int(vtx[0].y-scrolly),4);
 }
 if(view==2)
 {
  for(int n=0;n<num_vtx-1;n++)  {   line(buffer,int(vtx[n].x-scrollx),int(vtx[n].z-scrolly),int(vtx[n+1].x-scrollx),int(vtx[n+1].z-scrolly),4);  }
  line(buffer,int(vtx[num_vtx-1].x-scrollx),int(vtx[num_vtx-1].z-scrolly),int(vtx[0].x-scrollx),int(vtx[0].z-scrolly),4);
 }
 if(view==3)
 {
  for(int n=0;n<num_vtx-1;n++)  {   line(buffer,int(vtx[n].z-scrollx),int(vtx[n].y-scrolly),int(vtx[n+1].z-scrollx),int(vtx[n+1].y-scrolly),4);  }
  line(buffer,int(vtx[num_vtx-1].z-scrollx),int(vtx[num_vtx-1].y-scrolly),int(vtx[0].z-scrollx),int(vtx[0].y-scrolly),4);
 }
}

class OBJECT
{
 public:
  OBJECT();
  void save(char *file);
  void load(char *file);
  void draw(BITMAP *buffer,int scrollx,int scrolly,int view);
  int num_pol;
  POL *pol;
};

OBJECT::OBJECT()
{
 num_pol=0;
 pol=new POL[256];
}

//Draw polygons in windows: xy,xz,zy,3d
void OBJECT::draw(BITMAP *buffer,int scrollx,int scrolly,int view)
{
 for(int p=0;p<num_pol;p++)
 {
  if(view==1)
  {
   for(int n=0;n<pol[p].num_vtx-1;n++)  {   line(buffer,int(pol[p].vtx[n].x-scrollx),int(pol[p].vtx[n].y-scrolly),int(pol[p].vtx[n+1].x-scrollx),int(pol[p].vtx[n+1].y-scrolly),4);  }
   line(buffer,int(pol[p].vtx[pol[p].num_vtx-1].x-scrollx),int(pol[p].vtx[pol[p].num_vtx-1].y-scrolly),int(pol[p].vtx[0].x-scrollx),int(pol[p].vtx[0].y-scrolly),4);
  }
  if(view==2)
  {
   for(int n=0;n<pol[p].num_vtx-1;n++)  {   line(buffer,int(pol[p].vtx[n].x-scrollx),int(pol[p].vtx[n].z-scrolly),int(pol[p].vtx[n+1].x-scrollx),int(pol[p].vtx[n+1].z-scrolly),4);  }
   line(buffer,int(pol[p].vtx[pol[p].num_vtx-1].x-scrollx),int(pol[p].vtx[pol[p].num_vtx-1].z-scrolly),int(pol[p].vtx[0].x-scrollx),int(pol[p].vtx[0].z-scrolly),4);
  }
  if(view==3)
  {
   for(int n=0;n<pol[p].num_vtx-1;n++)  {   line(buffer,int(pol[p].vtx[n].z-scrollx),int(pol[p].vtx[n].y-scrolly),int(pol[p].vtx[n+1].z-scrollx),int(pol[p].vtx[n+1].y-scrolly),4);  }
   line(buffer,int(pol[p].vtx[pol[p].num_vtx-1].z-scrollx),int(pol[p].vtx[pol[p].num_vtx-1].y-scrolly),int(pol[p].vtx[0].z-scrollx),int(pol[p].vtx[0].y-scrolly),4);
  }
 }
 if(view==4) //Drawing the perpective view
 {
  V3D_f tvtx[num_pol][256],
        *out[num_pol][256];
  TABLE z[num_pol];
  //convert to 2d world
  for(int p=0;p<num_pol;p++)
  {
   z[p].value=0;
   z[p].index=p;
   for(int n=0;n<pol[p].num_vtx;n++)
   {
    //put the point in a temporary out matrix
    out[p][n]=&tvtx[p][n];
    tvtx[p][n].c=(n+p)%256;//give it a color
    //move and rotate point
    apply_matrix_f(m,pol[p].vtx[n].x,pol[p].vtx[n].y,pol[p].vtx[n].z,&tvtx[p][n].x,&tvtx[p][n].y,&tvtx[p][n].z);
    //out of range protection
    if(tvtx[p][n].z < 1) tvtx[p][n].z=1;
    if(tvtx[p][n].x > tvtx[p][n].z) tvtx[p][n].x=tvtx[p][n].z;
    if(-tvtx[p][n].x > tvtx[p][n].z) tvtx[p][n].x=-tvtx[p][n].z;
    if(tvtx[p][n].y > tvtx[p][n].z) tvtx[p][n].y=tvtx[p][n].z;
    if(-tvtx[p][n].y > tvtx[p][n].z) tvtx[p][n].y=-tvtx[p][n].z;
    //converting
    persp_project_f(tvtx[p][n].x,tvtx[p][n].y,tvtx[p][n].z,&tvtx[p][n].x,&tvtx[p][n].y);
    z[p].value+=tvtx[p][n].z; //store zvalues for sorting
   }
   z[p].value/=pol[p].num_vtx;
  }
  //zsort the polygons
  qsort(z,num_pol,sizeof(TABLE),pol_cmp);

  for(int p=0;p<num_pol;p++)
  {
   if(rendermode==0)
   {
    for(int n=0;n<pol[p].num_vtx-1;n++){   line(buffer,int(tvtx[p][n].x),int(tvtx[p][n].y),int(tvtx[p][n+1].x),int(tvtx[p][n+1].y),4);  }
    line(buffer,int(tvtx[p][pol[p].num_vtx-1].x),int(tvtx[p][pol[p].num_vtx-1].y),int(tvtx[p][0].x),int(tvtx[p][0].y),4);
   }
   if(rendermode==1)
   {
    polygon3d_f(buffer,POLYTYPE_FLAT,texture,pol[z[p].index].num_vtx,out[z[p].index]);
   }
   if(rendermode==2)
   {
    polygon3d_f(buffer,POLYTYPE_GCOL,texture,pol[z[p].index].num_vtx,out[z[p].index]);
   }
  }
 }
}

//save object
void OBJECT::save(char *file)
{
 PACKFILE *f=pack_fopen(file,F_WRITE);
 pack_iputw(num_pol,f);
 for(int n=0;n<num_pol;n++)
 {
  pack_iputw(pol[n].num_vtx,f);
  for(int i=0;i<pol[n].num_vtx;i++)
  {
   pack_iputw(int(pol[n].vtx[i].x)+16000,f);
   pack_iputw(int(pol[n].vtx[i].y)+16000,f);
   pack_iputw(int(pol[n].vtx[i].z)+16000,f);
  }
 }
 pack_fclose(f);
}

//load object
void OBJECT::load(char *file)
{
 PACKFILE *f=pack_fopen(file,F_READ);
 num_pol=pack_igetw(f);
 POL tpol;
 for(int n=0;n<num_pol;n++)
 {
  tpol.num_vtx=pack_igetw(f);
  for(int i=0;i<tpol.num_vtx;i++)
  {
   tpol.vtx[i].x=pack_igetw(f)-16000;
   tpol.vtx[i].y=pack_igetw(f)-16000;
   tpol.vtx[i].z=pack_igetw(f)-16000;
  }
  pol[n].copy(tpol);
 }
 pack_fclose(f);
}

int main()
{
 //Setting up allegro stuff
 allegro_init();
 install_timer();
 install_mouse();
 install_keyboard();
 int c,w,h;
 set_gfx_mode(GFX_VGA,320,200,0,0);
 set_pallete(desktop_pallete);
 if(!gfx_mode_select(&c,&w,&h))
 {
  allegro_exit();
  return 0;
 }
 if(set_gfx_mode(c,w,h,0,0))
 {
  allegro_exit();
  return 0;
 }
 
 //width & height for the quarterwindows
 int win_w=SCREEN_W/2-8;
 int win_h=(SCREEN_H-32)/2-8;
 set_projection_viewport(0,0,win_w,win_h);

 //buffers
 //for blitting to screen.
 BITMAP *buffer=create_bitmap(SCREEN_W,SCREEN_H);
 //windowbuffers
 BITMAP *xybuffer=create_bitmap(win_w,win_h);
 BITMAP *xzbuffer=create_bitmap(win_w,win_h);
 BITMAP *zybuffer=create_bitmap(win_w,win_h);
 BITMAP *tdbuffer=create_bitmap(win_w,win_h);
 //texture
 PALLETE pal;
 texture=load_bitmap("texture.bmp",pal);
 
 //variables
 //snap
 int snapsize=10;
 bool snap=1;
 //colors
 int snapcolor=1,
     statscolor=2,
     mousecolor=3;
 //mousepos
 int xs,ys,zs;
 int mxp=0,myp=0,mx,my;
 bool mouse_in_zy,mouse_in_xy,mouse_in_xz,mouse_in_td;
 //2dscroll
 int xyscrollx=-win_w/2,xyscrolly=-win_h/2,
     xzscrollx=-win_w/2,xzscrolly=-win_h/2,
     zyscrollx=-win_w/2,zyscrolly=-win_h/2;
 //Polygons
 POL tpol;
 OBJECT obj;

 //3d trans
 int rxt=0,ryt=0,rzt=0,xt=0,yt=0,zt=0;

 //create snapgrid
 BITMAP *snapbuffer=create_bitmap(win_w,win_h);
 clear(snapbuffer);
 for(int x=0;x<win_w;x++)
  for(int y=0;y<win_h;y++)
  {
   if(!((x)%snapsize) && !((y)%2))      putpixel(snapbuffer,x,y,snapcolor);
   if(!((x)%2) && !((y)%snapsize))      putpixel(snapbuffer,x,y,snapcolor);
  }

 //main loop
 while(!key[KEY_ESC])
 {
  //update mousepos
  get_mouse_mickeys(&mx,&my);
  if(!(key[KEY_M]||key[KEY_R]||key[KEY_Z]))
  {
   mxp+=mx;
   myp+=my;
   if(mxp<0)mxp=0;
   if(mxp>SCREEN_W-1)mxp=SCREEN_W-1;
   if(myp<0)myp=0;
   if(myp>SCREEN_H-1)myp=SCREEN_H-1;
  }

  //check where mouse is
  if(mxp<win_w && myp>7 && myp<win_h+8) mouse_in_xz=1; else mouse_in_xz=0;
  if(mxp>win_w+7 && mxp<SCREEN_W-8 && myp>win_h+15 && myp<SCREEN_H-32) mouse_in_zy=1; else mouse_in_zy=0;
  if(mxp<win_w && myp>7 && myp>win_h+15 && myp<SCREEN_H-32) mouse_in_xy=1; else mouse_in_xy=0;
  if(mxp>win_w+7 && myp>7 && myp<win_h+8) mouse_in_td=1; else mouse_in_td=0;

  //scroll with mouse
  if(key[KEY_M])
  {
   if(mouse_in_xy)
   {
    xyscrollx+=mx;
    xyscrolly+=my;
   }
   if(mouse_in_xz)
   {
    xzscrollx+=mx;
    xzscrolly+=my;
   }
   if(mouse_in_zy)
   {
    zyscrollx+=mx;
    zyscrolly+=my;
   }
  }
  
  //Rotate and move 3d
  if(mouse_in_td)
  {
   if(key[KEY_M])
   {
    yt+=my;
    xt+=mx;
   }
   if(key[KEY_R])
   {
    rxt+=my;
    ryt+=mx;
   }
   if(key[KEY_Z])
   {
    zt-=my;
    rzt+=mx;
   }
  }

  if(mouse_b&1)
  {
   //In menus
   if(myp<8)
   {
    //Quit
    if(mxp<36)    return 1;
    //Snap
    else if(mxp<76)    snap=!snap;
    //save
    else if(mxp<116)    obj.save("test.sav");
    //load
    else if(mxp<156)    obj.load("test.sav");
    else if(mxp<204)    obj.num_pol=0;
    else if(mxp<260)
    {
     rendermode++;
     if(rendermode==num_modes)rendermode=0;
    }
   }
   //add a node in a polygon
   else
   {
    tpol.vtx[tpol.num_vtx].z=zs;
    tpol.vtx[tpol.num_vtx].y=ys;
    if(mouse_in_xz || mouse_in_zy || mouse_in_xy)
    {
     tpol.vtx[tpol.num_vtx].x=xs;
     tpol.vtx[tpol.num_vtx].y=ys;
     tpol.vtx[tpol.num_vtx].z=zs;
     tpol.num_vtx++;
    }
    if(tpol.num_vtx==256)
    {
     obj.pol[obj.num_pol].copy(tpol);
     obj.num_pol++;
     tpol.num_vtx=0;
    }
   }
   while(mouse_b&1);
  }

  //scrolling with keys
  if(mouse_in_xy)
  {
   if(key[KEY_UP])    xyscrolly--;
   if(key[KEY_DOWN])   xyscrolly++;
   if(key[KEY_LEFT])   xyscrollx--;
   if(key[KEY_RIGHT])   xyscrollx++;
  }
  if(mouse_in_xz)
  {
   if(key[KEY_UP])   xzscrolly--;
   if(key[KEY_DOWN])   xzscrolly++;
   if(key[KEY_LEFT])   xzscrollx--;
   if(key[KEY_RIGHT])   xzscrollx++;
  }
  if(mouse_in_zy)
  {
   if(key[KEY_UP])   zyscrolly--;
   if(key[KEY_DOWN])   zyscrolly++;
   if(key[KEY_LEFT])   zyscrollx--;
   if(key[KEY_RIGHT])   zyscrollx++;
  }

  //right mouse button handling
  if(mouse_b&2)
  {
   if(tpol.num_vtx>2)
   {
    obj.pol[obj.num_pol].copy(tpol);
    obj.num_pol++;
    tpol.num_vtx=0;
   }
   else
    tpol.num_vtx=0;
   while(!(mouse_b&2));
  }

  //get mousepositions
  if(mouse_in_xy)
  {
   xs=mxp+xyscrollx;
   ys=(myp-win_h-16)+xyscrolly;
   zs=zyscrollx+win_w/2;
  }
  if(mouse_in_xz)
  {
   xs=mxp+xzscrollx;
   ys=xyscrolly+win_h/2;
   zs=(myp-8)+xzscrolly;
  }
  if(mouse_in_zy)
  {
   xs=xyscrollx+win_w/2;
   ys=(myp-win_h-16)+zyscrolly;
   zs=(mxp-win_w-8)+zyscrollx;
  }

  //do snapstuff
  if(snap)
  {
   //snap mousepos
   if(xs<0)xs-=snapsize/2;else xs+=snapsize/2;
   if(ys<0)ys-=snapsize/2;else ys+=snapsize/2;
   if(zs<0)zs-=snapsize/2;else zs+=snapsize/2;
   xs=xs/snapsize*snapsize;
   ys=ys/snapsize*snapsize;
   zs=zs/snapsize*snapsize;
   //blit grid
   blit(snapbuffer,xybuffer,xyscrollx%snapsize,xyscrolly%snapsize,0,0,win_w,win_h);
   blit(snapbuffer,xzbuffer,xzscrollx%snapsize,xzscrolly%snapsize,0,0,win_w,win_h);
   blit(snapbuffer,zybuffer,zyscrollx%snapsize,zyscrolly%snapsize,0,0,win_w,win_h);
   //snapped cursor
   if(mouse_in_xy) rect(xybuffer,xs-xyscrollx-2,ys-xyscrolly-2,xs-xyscrollx+2,ys-xyscrolly+2,mousecolor);
   if(mouse_in_xz) rect(xzbuffer,xs-xzscrollx-2,zs-xzscrolly-2,xs-xzscrollx+2,zs-xzscrolly+2,mousecolor);
   if(mouse_in_zy) rect(zybuffer,zs-zyscrollx-2,ys-zyscrolly-2,zs-zyscrollx+2,ys-zyscrolly+2,mousecolor);
   //for the statusline
   textprintf(buffer,font,0,SCREEN_H-16,statscolor,"Snapped");
  }

  //Draw poslines
  hline(xybuffer,0,ys-xyscrolly,win_w,5);
  vline(xybuffer,xs-xyscrollx,0,win_h,5);
  hline(xzbuffer,0,zs-xzscrolly,win_w,5);
  vline(xzbuffer,xs-xzscrollx,0,win_h,5);
  hline(zybuffer,0,ys-zyscrolly,win_w,5);
  vline(zybuffer,zs-zyscrollx,0,win_h,5);

  //draw temp pol
  if(tpol.num_vtx>0)
  {
   tpol.draw(xybuffer,xyscrollx,xyscrolly,1);
   tpol.draw(xzbuffer,xzscrollx,xzscrolly,2);
   tpol.draw(zybuffer,zyscrollx,zyscrolly,3);
  }

  //draw all pols
  get_transformation_matrix_f(m,1,rxt,ryt,rzt,xt,yt,zt);
  if(obj.num_pol>0)
   for(int n=0;n<obj.num_pol;n++)
   {
    obj.draw(xybuffer,xyscrollx,xyscrolly,1);
    obj.draw(xzbuffer,xzscrollx,xzscrolly,2);
    obj.draw(zybuffer,zyscrollx,zyscrolly,3);
    obj.draw(tdbuffer,0,0,4);
   }

  //Menu
  textprintf(buffer,font,0,0,statscolor,"Quit Snap Save Load Reset 3DMode %i",rendermode);

  //mousepos to status
  textprintf(buffer,font,0,SCREEN_H-24,statscolor,"Mouse position");
  textprintf(buffer,font,0,SCREEN_H-8,statscolor,"X: %i    ",xs);
  textprintf(buffer,font,64,SCREEN_H-8,statscolor,"Y: %i    ",ys);
  textprintf(buffer,font,128,SCREEN_H-8,statscolor,"Z: %i    ",zs);
  textprintf(buffer,font,192,SCREEN_H-16,statscolor,"%i %i %i",rxt,ryt,rzt);
  textprintf(buffer,font,192,SCREEN_H-8,statscolor,"%i %i %i",xt,yt,zt);

  //windows to main buffer
  blit(xybuffer,buffer,0,0,0,16+win_h,win_w,win_h);
  blit(xzbuffer,buffer,0,0,0,8,win_w,win_h);
  blit(zybuffer,buffer,0,0,8+win_w,16+win_h,win_w,win_h);
  blit(tdbuffer,buffer,0,0,8+win_w,8,win_w,win_h);

  //the cursor
  hline(buffer,mxp-5,myp,mxp+5,mousecolor);
  vline(buffer,mxp,myp-5,myp+5,mousecolor);

  //blit
  blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);

  //cleanup
  clear(buffer);
  clear(xybuffer);
  clear(xzbuffer);
  clear(zybuffer);
  clear(tdbuffer);
 }
}
