/*
 *    SPEED - by Shawn Hargreaves, 1999
 *
 *    Title screen and results display.
 */

#include <math.h>
#include <allegro.h>

#include"main.h"
#include"func.h"

/* draws text with a dropshadow */
static void textout_shadow(BITMAP *bmp, char *msg, int x, int y, int c){
	textout_centre(bmp, font, msg, x+1, y+1, makecol(0, 0, 0));
	textout_centre(bmp, font, msg, x, y, c);
}

int mt=0;
void _mt(){mt++;}END_OF_FUNCTION(_mt);

/* display the title screen */
void title_screen(){
	BITMAP *bmp, *b;
	bmp = create_bitmap(SCREEN_W, SCREEN_H);
	b = create_bitmap(72, 8);
	clear_bitmap(b);
	textout(b, font, "MIFFONOID", 0, 0, makecol(128, 0, 64));

	LOCK_VARIABLE(mt);
	LOCK_FUNCTION(_mt);
	install_int_ex(_mt,BPS_TO_TIMER(60));

	int STQH=SCREEN_H-SCREEN_H/4; //Screen three quarter height
	float h=1;
	while( (!key[KEY_SPACE]) && (!key[KEY_ENTER]) && (!key[KEY_ESC]) ){
		while(mt){
			mt--;

			if(h>.51)	//This makes h end up at .5
				h-=.01;
		}

		clear_bitmap(bmp);

		stretch_sprite(bmp, b, SCREEN_W/128, int(SCREEN_H*h/24), SCREEN_W, int(SCREEN_H*h));

		textout_shadow(bmp, "A game developed with SPEED as base.", SCREEN_W/2, STQH-30, set_color_brightness(makecol(255, 255, 255),(1-h)*2));
		textout_shadow(bmp, "A merge of Arkanoid and SPEED.", SCREEN_W/2, STQH-10, set_color_brightness(makecol(255, 255, 255),(1-h)*2));
		textout_shadow(bmp, "Created 2002 by Anders Andersson.", SCREEN_W/2, STQH+10, set_color_brightness(makecol(255, 255, 255),(1-h)*2));
		textout_shadow(bmp, "Enter at your own risk.", SCREEN_W/2, STQH+30, set_color_brightness(makecol(255, 255, 255),(1-h)*2));

//		textprintf(bmp,font,0,0,-1,"%f",h);

		blit(bmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	}

	destroy_bitmap(b);
	destroy_bitmap(bmp);
}



/* display the results screen */
void show_results()
{
   char buf[80];
   BITMAP *bmp, *b;

   bmp = create_bitmap(SCREEN_W, SCREEN_H);
	clear_bitmap(bmp);

   b = create_bitmap(72, 8);
   clear_to_color(b, bitmap_mask_color(bmp));

   textout(b, font, "GAME OVER", 0, 0, makecol(0, 0, 0));
   stretch_sprite(bmp, b, 4, SCREEN_H/3+4, SCREEN_W, SCREEN_H/3);

   textout(b, font, "GAME OVER", 0, 0, makecol(128, 0, 0));
   stretch_sprite(bmp, b, 0, SCREEN_H/3, SCREEN_W, SCREEN_H/3);

   destroy_bitmap(b);

   sprintf(buf, "Score: %d", score);
   textout_shadow(bmp, buf, SCREEN_W/2, SCREEN_H*3/4, makecol(255, 255, 255));


	blit(bmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
   destroy_bitmap(bmp);

   while ((key[KEY_SPACE]) || (key[KEY_ENTER]) || (key[KEY_ESC]))
      poll_keyboard();

   while ( (!key[KEY_SPACE]) && (!key[KEY_ENTER]) && (!key[KEY_ESC]) )
      poll_keyboard();
}