#include<list>
#include<allegro.h>

#include"main.h"

#include"block.h"
#include"func.h"
#include"item.h"
#include"particles.h"
#include"message.h"
#include"editor.h"
using namespace std;

list<BLOCK> blocks;

float bs=.0625;
int level=0;



BLOCK::BLOCK(double ix,double iy,int istrength,int icolor)
:x(ix),y(iy),strength(istrength),color(icolor){}



bool BLOCK::update(){
	if (strength == 0) {
		score+=100;
		msgs.push_back(MESSAGE("+100",x+bs/2,y+bs/2));
		if(!(rand()%5))
			drop_item(x+bs/2,y-bs/2);
		fire_particles(x+bs/2,y+bs/2,color,10);
		return 0;
	}
	else
		return 1;
}



void soft_blocks(){
	for(list<BLOCK>::iterator block=blocks.begin();block!=blocks.end();block++)
		block->strength=1;
}



bool BLOCK::contains(double cx,double cy){
	if( cy > y && cy < y+bs && diff( cx , x ) < bs && diff( cx , x ) >= 0 && strength!=0)
		return 1;
	return 0;
}



int update_blocks(){
	int soft_blocks=0;	//To see if there are destructible blocks left

	for(list<BLOCK>::iterator block=blocks.begin();block!=blocks.end();){
		if(block->update()){
			if(block->strength>0)
				soft_blocks++;
			block++;
		}
		else
			block=blocks.erase(block);
	}
	return soft_blocks;
}



void outline(BITMAP *buffer,int n, int *vtx,int c){
	for(int i=0;i<n-1;i++)
		line(buffer,vtx[i*2],vtx[i*2+1],vtx[i*2+2],vtx[i*2+3],c);
	line(buffer,vtx[n*2-2],vtx[n*2-1],vtx[0],vtx[1],c);
}



void BLOCK::draw(BITMAP *buffer, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	int t=r;t=g;t=b;
	float shape[8];
	int ishape[16];

	int *dishape=ishape;

	shape[0] = x;
	shape[1] = y+bs;
	shape[2] = x+bs;
	shape[3] = y+bs;
	shape[4] = x+bs;
	shape[5] = y;
	shape[6] = x;
	shape[7] = y;

	int duoble=project(shape, ishape, 8);

	if (duoble){
		if(textures){
			V3D_f *_vtx[4],vtx[4];
			for(int i=0;i<4;i++)
				_vtx[i]=&vtx[i];

			vtx[0].u=0;
			vtx[0].v=32;
			vtx[1].u=32;
			vtx[1].v=32;
			vtx[2].u=32;
			vtx[2].v=0;
			vtx[3].u=0;
			vtx[3].v=0;

			for(int i=0;i<duoble;i++){
				vtx[0].x=dishape[0];
				vtx[0].y=dishape[1];
				vtx[1].x=dishape[2];
				vtx[1].y=dishape[3];
				vtx[2].x=dishape[4];
				vtx[2].y=dishape[5];
				vtx[3].x=dishape[6];
				vtx[3].y=dishape[7];

				if(strength==1){
					polygon3d_f(buffer, POLYTYPE_ATEX, (BITMAP*)gfx[TEX_block].dat, 4, _vtx);
					polygon(buffer, 4, dishape, color);
				}
				else if(strength==-1){
					polygon3d_f(buffer, POLYTYPE_ATEX, (BITMAP*)gfx[TEX_block].dat, 4, _vtx);
					polygon(buffer, 4, dishape, makecol(200,0,200));
				}
				else if(strength==-2){
					if(cheat)
						polygon(buffer, 4, dishape, makecol(rand()%256,rand()%256,rand()%256));
				}
				else if(strength==0){
					outline(buffer, 4, dishape, makecol(rand()%256,rand()%256,rand()%256));
				}
				else{
					polygon3d_f(buffer, POLYTYPE_ATEX, (BITMAP*)gfx[TEX_block].dat, 4, _vtx);
					//polygon(buffer, 4, dishape, makecol(128,128,128));
				}

				dishape+=8;
			}
		}
		else{
			for(int i=0;i<duoble;i++){
				if(strength==1)
					polygon(buffer, 4, dishape, color);
				else if(strength==-1)
					polygon(buffer, 4, dishape, makecol(200,0,200));
				else if(strength==-2){
					if(cheat)
						polygon(buffer, 4, dishape, makecol(rand()%256,rand()%256,rand()%256));
				}
				else
					polygon(buffer, 4, dishape, makecol(128,128,128));
				dishape+=8;
			}
		}
	}
}



void draw_blocks(BITMAP *buffer, int r, int g, int b, int (*project)(float *f, int *i, int c)){
	for(list<BLOCK>::iterator block=blocks.begin();block!=blocks.end();block++)
		block->draw(buffer,r,g,b,project);
}



void level1(){
	for(int x=0;x<16;x++)
		for(int y=8;y<14;y++){
			blocks.push_back(BLOCK(x*.0625,y*.0625,1,set_color_brightness(makecol(rand()%256,rand()%256,rand()%256),1)));
		}
}
void level2(){
	for(int x=0;x<16;x++){
		blocks.push_back(BLOCK(x*.0625,5*.0625,rand()%5+1,set_color_brightness(makecol(rand()%256,rand()%256,rand()%256),1)));
	}
}
void level3(){
	for(int x=0;x<16;x+=2)
		for(int y=8;y<12;y++)
			blocks.push_back(BLOCK(x*.0625,y*.0625,y-7,set_color_brightness(makecol(rand()%256,rand()%256,rand()%256),1)));
}
void level4(){
	for(int x=0;x<16;x+=1)
		for(int y=8;y<12;y++)
			blocks.push_back(BLOCK(x*.0625,y*.0625,rand()%2+1,set_color_brightness(makecol(rand()%256,rand()%256,rand()%256),1)));
	for(int x=0;x<16;x+=2)
		blocks.push_back(BLOCK(x*.0625,7*.0625,-1,set_color_brightness(makecol(rand()%256,rand()%256,rand()%256),1)));
}
void level5(){
	for(int x=0;x<16;x+=1)
		blocks.push_back(BLOCK(x*.0625,8*.0625,1,set_color_brightness(makecol(rand()%256,rand()%256,rand()%256),1)));
	for(int x=0;x<16;x+=2)
		blocks.push_back(BLOCK(x*.0625,7*.0625,-1,set_color_brightness(makecol(rand()%256,rand()%256,rand()%256),1)));
	for(int x=1;x<16;x+=2)
		blocks.push_back(BLOCK(x*.0625,7*.0625,-2,set_color_brightness(makecol(rand()%256,rand()%256,rand()%256),1)));
}


void (*lf[])()={
	level1,
	level2,
	level3,
	level4,
	level5
};



void next_level(){
	switch(gamemode){
		case 0:
			if (level == sizeof(lf)/sizeof(lf[0]))
				level = 0;
			blocks.clear();
			lf[level]();
			level++;
			break;
	case 1:
		blocks.clear();
		for(list<BLOCK>::iterator i=eblocks.begin();i!=eblocks.end();i++)
			blocks.push_back(*i);
		break;
	}
}
