#include<vector>
#include<libnet.h>
#include"network.h"

/* The listening connection. */
NET_CONN *ListenConn = NULL;
/* A connection for every client. */
vector<NET_CONN*> clientconns;
int active_players=0, noc=0; //Number of connections



/* Initialize the server. */
int server_init() {
	ListenConn = net_openconn(networkdriver, "");
	if(!ListenConn) {
		/* Error: Failed to open listening connection. */
		return -1;
	}

	if(net_listen(ListenConn)) {
		/* Error: Cannot listen. */
		return -2;
	}

	return 0;
}



/* Shut the server down. */
void server_exit() {
	for(vector<NET_CONN*>::iterator c = clientconns.begin() ; c != clientconns.end() ; ) {
		net_closeconn(*c);
		c=clientconns.erase(c);
	}

	if(ListenConn)
		net_closeconn(ListenConn);
	ListenConn = NULL;
}



bool server_listen() {
	NET_CONN *newconn;
	newconn = net_poll_listen (ListenConn);
	if(newconn == NULL) return 1;
	clientconns.push_back(newconn);
	noc++;
	return 0;
}



/* Receive data from a client, and store them in the provided array (must
   have room for 1024 bytes). Returns the size of the stored data. */
int server_receive(void *data, int *sender) {
	int l = 0;
	*sender=0;
	for(vector<NET_CONN*>::iterator n=clientconns.begin() ; n != clientconns.end() ; n++) {
		l = net_receive_rdm(*n, data, 1024);
		if(l > 0)
			return l;
		(*sender)++;
	}
	return 0;
}



/* Send data to a specific client. */
void server_sendto(void *data, int len, int who) {
	net_send_rdm(clientconns[who], data, len);
}



/* Send data to all connected clients. */
void server_broadcast(void *data, int len) {
	for(vector<NET_CONN*>::iterator n=clientconns.begin() ; n != clientconns.end() ; n++)
		net_send_rdm(*n, data, len);
}
