#include<vector>
#include<allegro.h>
#include"player.h"

PLAYER::PLAYER(){}



PLAYER::PLAYER(int ix,int iy,int in)
:x(ix),y(iy),n(in){
	//Zero all impulses so the player stands still until input comes fom the client.
	for(int i=0;i<4;i++)
		impulse[i]=0;
}



void PLAYER::update(){
	//The player moves if impulses are active.
	if(impulse[0])
		y--;
	if(impulse[1])
		y++;
	if(impulse[2])
		x--;
	if(impulse[3])
		x++;
}



void PLAYER::draw(BITMAP *bmp){
	textprintf(bmp,font,x,y,-1,"%i",n);
}



void update_players(vector<PLAYER> *players){
	vector<PLAYER>::iterator player=players->begin();
	for(;player!=players->end();player++)
		player->update();
}



void draw_players(vector<PLAYER> *players, BITMAP *bmp){
	vector<PLAYER>::iterator player=players->begin();
	for(;player!=players->end();player++)
		player->draw(bmp);
}
