#include <string.h>

#include "packet.h"

/* A global memory buffer for the current network packet. */
char packetbuffer[1024];
//Current size of the packet
int packetsize;
//Current position in the packet
int packetpos;

//Initialise a new packet
void packet(char *id) {
   strncpy(packetbuffer, id, 4);
   packetsize = 4;
}



/* Check if currently a packet with the given id can be read. */
int packetread(char *id) {
   if(packetsize >= 4 && !strncmp(packetbuffer, id, 4)) {
      packetpos = 4;
      return 1;
   }
   return 0;
}



//char
void packet_addc(char b) {
   packetbuffer[packetsize] = b;
   packetsize++;
}
char packet_getc() {
   char b = packetbuffer[packetpos];
   packetpos++;
   return b;
}



//Data
void packet_add(void *d,int l) {
	char *data=(char*)d;
	for(int i=0;i<l;i++)
		packetbuffer[packetsize+i] = data[i];
	packetsize+=l;
}
void packet_get(void *d,int l) {
	char *data=(char*)d;
	for(int i=0;i<l;i++)
		data[i]=packetbuffer[packetpos+i];
	packetpos+=l;
}