#include<vector>
#include<allegro.h>
#include"client.h"
#include"main.h"
#include"network.h"
#include"packet.h"
#include"player.h"
#include"server.h"

//A vector for the players.
vector<PLAYER> players;

//Your controls
int control[]={KEY_UP,KEY_DOWN,KEY_LEFT,KEY_RIGHT};

void update_server();
bool update_client();

bool play(BITMAP *bmp){
	//Logic update 60 times/second, using the timer in main.
	while(lc && (!key[KEY_ESC] && !wch)){
		lc--;
		if(server){
			update_server();
			update_players(&players);
		}
		if(!update_client())
			return 0;
	}

	draw_players(&players,bmp);
	if(key[KEY_ESC] || wch){
		packet("Quit");
		if(server)
			server_broadcast(packetbuffer, packetsize);
		else
			client_send(packetbuffer, packetsize);
		players.clear();
		client_exit();
		server_exit();
		noc=0;
		return 0;
	}
	return 1;
}



bool update_client(){
	if(connected){
		packetsize = client_receive(packetbuffer);
		while(packetsize){
			if(!server){
				if(packetread("Join")) {
					int x,y,n;
					packet_get(&n,sizeof(int));
					packet_get(&x,sizeof(int));
					packet_get(&y,sizeof(int));
					players.push_back(PLAYER(x, y, n));
				}

				if(packetread("Quit")){
					players.empty();
					client_exit();
					server_exit();
					return 0;
				}

				if(packetread("Left")){
					int who;
					packet_get(&who,sizeof(int));
					players.erase(&players[who]);
				}

				if(packetread("Move")) {
					int who;
					packet_get(&who,sizeof(int));
					packet_get(&players[who].x,sizeof(int));
					packet_get(&players[who].y,sizeof(int));
				}
			}
			packetsize = client_receive(packetbuffer);
		}
		packet("Ctrl");
		for(int n=0;n<4;n++)
			packet_addc(key[control[n]]);
		client_send(packetbuffer, packetsize);
	}
	else if(client_check_response()==-1){
		players.clear();
		client_exit();
		server_exit();
		return 0;
	}
	return 1;
}


void update_server(){
	vector<PLAYER>::iterator n=players.end();
	int who=0;
	/* Check for connecting clients. */
	if(!server_listen()) {
		/* A client just connected, now send back the current game data. */
		/* Send players. */
		for(n = players.begin() ; n != players.end() ; n++) {
			packet("Join");
			packet_add(&n->n,sizeof(int));
			packet_add(&n->x,sizeof(int));
			packet_add(&n->y,sizeof(int));
			/* Send it to the client who just joined. */
			server_sendto(packetbuffer, packetsize, players.size());
		}
		players.push_back(PLAYER(20,20,noc)); //We add the new client after the sendout, he'll get it through the following broadcast.
		n=players.end();n--;
		packet("Join");
		packet_add(&n->n,sizeof(int));
		packet_add(&n->x,sizeof(int));
		packet_add(&n->y,sizeof(int));
		server_broadcast(packetbuffer, packetsize);
	}

	/* Check for network packets. */
	packetsize=server_receive(packetbuffer, &who);
	while(packetsize){
		if(packetread("Ctrl")) {
			for(int n=0;n<4;n++)
				players[who].impulse[n]=packet_getc();
		}
		if(packetread("Quit")){
			packet("Left");
			packet_add(&who,sizeof(int));
			players.erase(&players[who]);
			clientconns.erase(&clientconns[who]);
			server_broadcast(packetbuffer, packetsize);
		}
		packetsize = server_receive(packetbuffer, &who);
	}

	who=0;
	for(n = players.begin() ; n != players.end() ; n++) {
		packet("Move");
		packet_add(&who,sizeof(int));
		packet_add(&n->x,sizeof(int));
		packet_add(&n->y,sizeof(int));
		/* Send it to the client who just joined. */
		server_broadcast(packetbuffer, packetsize);
		who++;
	}
}
