#include<libnet.h>
#include"network.h"

NET_CONN *serverconn;
bool connected=0;

int client_init(char *serveraddress) {
	serverconn = net_openconn(networkdriver, NULL);

	if(!serverconn) {
		/* Error: Unable to to open server connection. */
		return -1;
	}
	if(server)
		strcpy(serveraddress,"127.0.0.1");
	if(net_connect(serverconn, serveraddress)) {
		net_closeconn(serverconn);
		/* Error: Can't connect to that address. */
		return -2;
	}

	return 0;
}



void client_exit() {
	if(serverconn)
		net_closeconn(serverconn);
	serverconn = NULL;
	connected=0;
}



/* Check for a repsonse from the server.
    1 = ok
    0 = no response yet
   -1 = error */
int client_check_response() {
	int x = net_poll_connect(serverconn);
	if(x == 0)
		return 0;

	if(x < 0) {
		net_closeconn(serverconn);
		/* Error: Failed to receive server response. */
		return -1;
	}

	connected=1;
	return 1;
}



/* Receive data from the server, and store them in the provided array (must
   have room for 1024 bytes). Returns the size of the stored data. */
int client_receive(void *data) {
	return net_receive_rdm(serverconn, data, 1024);
}



/* Send data to the server. */
void client_send(void *data, int len) {
	net_send_rdm(serverconn, data, len);
}
