#include"funnie.h"

/*	Ide:
Kunna klicka p en funnie fr att vlja den som ml, sedan fljer kameran den automatiskt.
Klicka p tomrum fr att inte flja.
*/



bool _wch=0;
void wch(){_wch=1;}



int tid=0;
void _tid(){tid++;}
END_OF_FUNCTION(_tid);



int allegro_startup(){
	allegro_init();
	install_timer();
	install_mouse();
	install_keyboard();
	set_window_close_hook(wch);

	int c,w,h,bpp;
	set_gfx_mode(GFX_AUTODETECT_WINDOWED,320,200,0,0);
	set_pallete(desktop_pallete);
	if(!gfx_mode_select_ex(&c,&w,&h,&bpp)){
		allegro_exit();
		exit(0);
	}
	set_color_depth(bpp);
	if(set_gfx_mode(c,w,h,0,0)){
		allegro_exit();
		exit(0);
	}
}



int main(int argc, char *argv[]){
	allegro_startup();

	BITMAP *buffer=create_bitmap(SCREEN_W,SCREEN_H);

	srand(time(0));

	init_particles();

	ZBUFFER *zbuf=create_zbuffer(buffer);

	MATRIX_f matrix;
	V3D_f funpos;
	FUNNIE *funnies=NULL,*funsel=NULL;
	for(int i=0;i<256;i++){
		funnies=new FUNNIE(funnies);
	}

	int xr=0,yr=0,zr=0,mx,my;
	float xm=0,ym=0,zm=0;
	bool cam_or_trafo=0,space_pressed=0;

	LOCK_VARIABLE(tid);
	LOCK_FUNCTION(_tid);
	install_int_ex(_tid,BPS_TO_TIMER(30));

	while(!_wch && !key[KEY_ESC]){
		get_mouse_mickeys(&mx,&my);
		//Rotating the view
		if(mouse_b&2){
			position_mouse(mouse_x-mx,mouse_y-my);
			yr-=mx;
			xr-=my;
		}
		if(xr>63)	xr=63;
		if(xr<-63)	xr=-63;
		yr%=256;

		if(mouse_b&1){
			funsel=get_funnie_at(funnies,mouse_x,mouse_y);
		}

		//Change between camera and matrix.
		//It's supposed to convert the m and r values so you view from the same position, but I haven't solved this.
		//The formula used just makes it work at all.
		if(key[KEY_SPACE]){
			if(!space_pressed){
				space_pressed=1;
				if(cam_or_trafo){
					cam_or_trafo=0;
					xm=cos(yr)*zm;
					zm=sin(yr)*zm;
					yr-=64;
				}
				else{
					cam_or_trafo=1;
					zm=vector_length_f(xm,ym,zm);
					xm=0;
					ym=0;
				}
			}
		}
		else
			space_pressed=0;

		if(cam_or_trafo)
			get_transformation_matrix_f(&matrix, 1, xr, yr, zr, xm, ym, zm);
		else
			get_camera_matrix_f(&matrix, xm, ym, zm, sin(yr), sin(xr), cos(yr), 0, cos(xr), 0, 64, 1);

		if(!key[KEY_P]){
			while(tid && !_wch && !key[KEY_ESC]){
				tid--;

				if(cam_or_trafo){
					//Controls for use with transformation matrix
					if(key[KEY_S])
						zm+=4;
					if(key[KEY_W] && zm>0)
						zm-=4;
				}
				else{
					//Controls for use with camera matrix
					if(key[KEY_W]){
						xm=xm+sin(yr)*4;
						zm=zm+cos(yr)*4;
						ym=ym+sin(xr)*4;
					}
					if(key[KEY_S]){
						xm=xm-sin(yr)*4;
						zm=zm-cos(yr)*4;
						ym=ym-sin(xr)*4;
					}
					if(key[KEY_A]){
						xm=xm+sin(yr+64)*4;
						zm=zm+cos(yr+64)*4;
					}
					if(key[KEY_D]){
						xm=xm-sin(yr+64)*4;
						zm=zm-cos(yr+64)*4;
					}
					if(key[KEY_Q])
						ym+=4;
					if(key[KEY_Z])
						ym-=4;
				}

				update_funnie_list(funnies);
				update_particles();
			}
		}
		else tid=0;
		clear_zbuffer(zbuf, 0);
		draw_funnie_list(funnies,buffer,zbuf,matrix);
		draw_particles(buffer,zbuf,matrix);

		textprintf(buffer,font,0,0,makecol(255,255,255),"XR: %i YR: %i",xr,yr);
		textprintf(buffer,font,0,10,makecol(255,255,255),"XM: %f YM: %f ZM: %f",xm,ym,zm);
		textprintf(buffer,font,0,20,makecol(255,255,255),"Drawing takes %i ticks.",tid);
		if(funsel){
			funpos=funsel->get_pos();
			textprintf(buffer,font,0,30,makecol(255,255,255),"Selected funnie at %i %i %i.",int(funpos.x),int(funpos.y),int(funpos.z));
			yr=get_angle(funpos.z-zm,funpos.x-xm);
			xr=get_angle(distance(funpos.z-zm,funpos.x-xm),funpos.y-ym);
			if(funpos.y-ym<0)	xr=xr-256;
		}

		show_mouse(buffer);
		blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
		show_mouse(NULL);
		//I make the background a shade of blue that shows in what angle you are looking.
		clear_to_color(buffer,makecol(0,0,xr+64));
	}

	delete_funnie_list(funnies);
	shutdown_particles();
	destroy_bitmap(buffer);
	destroy_zbuffer(zbuf);
	return 0;
}END_OF_MAIN();