#include<math.h>
#include<allegro.h>
#include"player.h"
#include"background.h"
#include"main.h"
//#include"note.h"

list<PARTICLE> bo_particles;
int bor=200; //Blackout radius
void GO_blackout(BITMAP *bmp, int x, int y, int d){
	if(getpixel(bmp,x,y)==1){
		float a=atan2(120-y,160-x);
		bo_particles.push_back(PARTICLE(int(160+cos(a)*bor), int(120+sin(a)*bor*.75), cos(a)*2+1, sin(a)*2, 120, -2));
	}
	if(x<160)
		hline(bmp,x,y,0,0);
	else
		hline(bmp,x,y,319,0);
}

bool escexit;
int play(int score,LEVEL *level){
	//Reset and setup
	escexit=0;
	bor=200;
	yoff=120;
	PLAYER player;
	if(!level)	player.lives=1;  //Only one life in practice.
	player.score=score;
	list<BULLET> bullets;
	list<ENEMY> enemies;
	list<ITEM> items;
	list<SHOCKWAVE> sw;
	list<PARTICLE> particles;
//	list<NOTE> notes;
	BG bg;
	int time=0,fps=0,frames[31];
	for(int i=0;i<31;i++)
		frames[i]=0;
	bool needsupdate=1;

	int show_title=150;

	while(!wch && !key[KEY_ESC]){
		while(lc && !wch && !key[KEY_ESC]){
			if(show_title)  show_title--;
			needsupdate=1;
			fps-=frames[30];
			for(int i=30;i>0;i--)
				frames[i]=frames[i-1];
			frames[0]=0;
			fps+=frames[1];

			lc--;
			update_scrollers();
			if(!pause){
				time++;
				if(player.dead){
					player.dead--;
					if(!player.lives)	bor--;
					if(!player.dead){
						player.inv=150;
						player.power=2;
						player.x=160;
						player.y=0;
					}
				}
				else{
					if(player.inv)	player.inv--;
					if(!player.update(&bullets,&enemies,&items)){
						player.dead=150;
						player.sm=0;
						player.lives--;
						sw.push_back(SHOCKWAVE(player.x,player.y));
						float a=0;
						for(int j=0;j<16;j++){
							a+=M_PI/8;
							particles.push_back(PARTICLE(player.x,player.y,cos(a),sin(a),25,1));
						}
					}
				}
				bg.update(0);
				update_bullets(&bullets,&particles);
				update_enemies(&enemies,&bullets,&sw,&items,&player,&particles);
				update_items(&items);
				update_shockwaves(&sw);
				update_particles(&particles);
				update_particles(&bo_particles);
	//			update_notes(&notes);
				if(level==NULL){
					int t=60-(time/300);
					t=t<10?10:t;
					if(!(rand()%t)){
						t=rand()%6;
						enemies.push_back(ENEMY(320,(rand()%361)-180,-1,0,t));
					}
					if(!(time%300)){
						t=rand()%2;
						items.push_back(ITEM(320,0,-1,0,t));
					}
				}
				else
//					if(!level->update(&enemies,&items,&notes,0) && enemies.empty() && notes.empty())
					if(!level->update(&enemies,&items,0) && enemies.empty()){
						voice_stop(missile_chan);
						return player.score;
					}
			}
		}

		if(needsupdate){
			needsupdate=0;
			clear(buffer);
			text_mode(-1);
			if(!player.dead && (player.inv%10)<5)
				player.draw(buffer);
			if((player.dead%30)>5){
				if(player.lives>1)
					textprintf_centre(buffer, font, 160,120,1,"%i ships left.",(int)player.lives);
				else if(player.lives==1)
					textprintf_centre(buffer, font, 160,120,1,"Your last ship!");
				else{
					textprintf_centre(buffer, font, 160,110,1,"GAME OVER");
					textprintf_centre(buffer, font, 160,130,1,"Your score: %i",(int)player.score);
				}
			}
			else if(!player.lives && !(player.dead%30))
				player.dead+=30;
			bg.draw(buffer);
			draw_bullets(buffer,bullets);
			draw_enemies(buffer,enemies);
			draw_items(buffer,items);
			draw_particles(buffer,particles);
			draw_shockwaves(&sw);
	//		draw_notes(&notes);
			if(keypressed()){
				int k=readkey()>>8;
				switch(k){
				case KEY_Q:
					if(player.power<16)
						player.power++;
					else if(player.sp<99)
						player.sp++;
					break;
				case KEY_A:
					if(player.power>0)
						player.power--;
					break;
				case KEY_B:
					if(berzerk){
						berzerk=0;
						set_color(1,&(RGB){0,252,168,0});
					}else{
						berzerk=1;
						set_color(1,&(RGB){252,168,0,0});
					}
					break;
				case KEY_M:
					if(player.sm<99)
						player.sm++;
					break;
				case KEY_S:
					player.score++;
					break;
				case KEY_P:
					pause=pause?0:1;
					break;
				}
			}
			draw_rle_sprite(buffer,(RLE_SPRITE*)rle[POWER].dat,1,210);
			for(int i=0;i<player.power;i++){
				rect(buffer,13+i*4,212,17+i*4,215,1);
				if(i==3 || i==7 || i==11)
					vline(buffer,17+i*4,211,216,1);
			}
			if(player.power>12)
				textprintf(buffer,font,80,210,1,"+%i",player.sp);
	
			textprintf(buffer,font,110,210,1,"MISSILES:%i",player.sm);
	
			draw_rle_sprite(buffer,(RLE_SPRITE*)rle[LIVES].dat,206,210);
			if(player.lives)
				textprintf(buffer,font,220,210,1,"%i",player.lives-1);
			else
				textprintf(buffer,font,220,210,1,"0");
	
			if(player.score>10000)
				textprintf_right(buffer,font,320,210,1,"SCORE:%iK",player.score/1000);
			else
				textprintf_right(buffer,font,320,210,1,"SCORE:%i",player.score);
	
			if(!player.lives){
				if(bor>0){
					do_ellipse(buffer, 160, 120, bor, int(bor*.75), 0, GO_blackout);
					//Clear above and below the blackout ellipse.
					rectfill(buffer,0,20,319,120-int(bor*.75),0);
					rectfill(buffer,0,219,319,120+int(bor*.75),0);
				}
				else
					rectfill(buffer,0,20,319,219,0);
				if(bo_particles.empty() && bor<=0){
					voice_stop(missile_chan);
					return player.score;
				}
				else
					draw_particles(buffer,bo_particles);
			}
			draw_scrollers(buffer);
	
			if(show_fps)
				textprintf(buffer,font,1,25,1,"FPS:%i",fps);
	
			if(show_title)  textprintf_centre(buffer,font,160,100,1,"%s",lname);
		}
		acquire_screen();
		stretch_blit(buffer,screen,0,0,320,240,0,0,SCREEN_W,SCREEN_H);
		release_screen();
		frames[0]++;
	}
	voice_stop(missile_chan);
	escexit=1;
	return player.score;
}