#include<allegro.h>
#include "main.h"

float yoff=120;
int berzerk=0;
DATAFILE *rle;
BITMAP *buffer;

//Window close hook
bool wch=0;
void _wch(){wch=1;}END_OF_FUNCTION(_wch);

//Logic counter
int lc=0;
void _lc(){lc++;}END_OF_FUNCTION(_lc);

bool pause=0;
void _pause(){pause=1;}END_OF_FUNCTION(_pause);
void _unpause(){pause=0;}END_OF_FUNCTION(_unpause);

bool egg=0;
int show_fps=0;

//Initiating allegro
void allegro_startup(){
	//Basic stuff
	allegro_init();
	install_timer();
	install_mouse();
	install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT , NULL);

	//Window close hook
	LOCK_VARIABLE(wch);
	LOCK_FUNCTION(_wch);
	set_window_close_hook(_wch);
	//Logic counter
	LOCK_VARIABLE(lc);
	LOCK_FUNCTION(_lc);
	install_int_ex(_lc,BPS_TO_TIMER(30));
	//GFX
	set_config_file("devospace.cfg");
	show_fps=get_config_int(NULL,"show_fps",0);
	int windowed=get_config_int(NULL,"windowed",0)+1;
	int w=get_config_int(NULL,"width",320);
	int h=get_config_int(NULL,"height",240);
	set_config_int(NULL,"show_fps",show_fps);
	set_config_int(NULL,"height",h);
	set_config_int(NULL,"width",w);
	set_config_int(NULL,"windowed",windowed-1);
//	set_gfx_mode(GFX_AUTODETECT_WINDOWED,320,240,0,0);
	if(set_gfx_mode(windowed,w,h,0,0)){
		allegro_message("Unable to set gfx mode.\nEdit devospace.cfg or empty it, don't delete the file.");
		exit(0);
	}
/*	set_gfx_mode(GFX_AUTODETECT_WINDOWED,320,200,0,0);
	set_pallete(desktop_pallete);
	int c,w,h,bpp;
	if(!gfx_mode_select_ex(&c,&w,&h,&bpp)){
		allegro_exit();
		exit(0);
	}
	set_color_depth(bpp);
	if(set_gfx_mode(c,w,h,0,0)){
		allegro_exit();
		exit(0);
	}*/
	install_keyboard();
	if(windowed){
		set_display_switch_mode(SWITCH_BACKGROUND);
		LOCK_VARIABLE(pause);
		LOCK_FUNCTION(_pause);
		LOCK_FUNCTION(_unpause);
		set_display_switch_callback(SWITCH_OUT, _pause);
		set_display_switch_callback(SWITCH_IN, _unpause);
	}
	else
		set_display_switch_mode(SWITCH_PAUSE);
}

int missile_chan=-1;

int main(){//int argc, char *argv[]){
	allegro_startup();

	set_color(0,&(RGB){0,0,0,0});	//Darkness
	set_color(1,&(RGB){0,252,168,0});	//Color one, the only color
	set_color(15,&(RGB){0,252,168,0});	//Lazy change of mouse sprite.
	gui_fg_color=1;

	rle=load_datafile("gfx.dat");
	buffer=create_bitmap(320,240);

	missile_chan=allocate_voice((SAMPLE *)rle[BULLETSHOT].dat);
	voice_set_playmode(missile_chan, PLAYMODE_LOOP);

	menu();

	unload_datafile(rle);
	return 0;
}END_OF_MAIN();

char scroller1[]="   ***   Thank you for playing Devospace, a clone of the game Monospace by Milo Sedlacek a.k.a gradius, who left us September 24 1998 R.I.P.";
char scroller2[]="   ***   Devospace, by Anders Andersson a.k.a. Trezker, 2003. A clone and expansion of Monospace, see top scroller.   Art: copied from Monospace   Code: Trezker   Design: Copied from Monospace, modified and expanded by Trezker   Greetings: Shawn, Matthew, 23, Julien Cugniere and all allegroites";
int s1=0,s2=0;

void update_scrollers(){
	//The top scroller is slower because of it's serious content.
	//I also think it looks better.
	s1+=1;
	s2+=3;
	if(s1>(int)strlen(scroller1)*8) s1-=strlen(scroller1)*8;
	if(s2>(int)strlen(scroller2)*8) s2-=strlen(scroller2)*8;
}

void draw_scrollers(BITMAP *bmp){
	//clean up beneath the scrollers and draw a border.
	rectfill(bmp,0,0,319,19,0);
	hline(bmp,0,19,319,1);
	rectfill(bmp,0,221,319,239,0);
	hline(bmp,0,220,319,1);

	//Top scroller
	int s=s1/8;
	int o=-s1%8;
	for(int i=0;i<41;i++){
		s++;
		if(s>(int)strlen(scroller1)) s-=strlen(scroller1);
		if(s>0)
			textprintf(bmp,font,o+i*8,5,1,"%c",scroller1[s]);
	}

	//Bottom scroller
	s=s2/8;
	o=-s2%8;
	for(int i=0;i<41;i++){
		s++;
		if(s>(int)strlen(scroller2)) s-=strlen(scroller2);
		if(s>0)
			textprintf(bmp,font,o+i*8,227,1,"%c",scroller2[s]);
	}
}
