#include<list>
#include<string>
using namespace std;
#include"enemy.h"
#include"item.h"
#include"level.h"

EVENT::EVENT(int itime,int iy,int itype,float ixs,float iys)
	:time(itime),y(iy),type(itype),xs(ixs),ys(iys){}

bool EVENT::operator<(const EVENT& e) const	{
	return (this->time) < (e.time);
}


bool LEVEL::load(char *file){
	replace_extension(file, file, "lvl", 480);
	PACKFILE *f=pack_fopen(file,F_READ);
	load(f);
	pack_fclose(f);
}
bool LEVEL::load(PACKFILE *f){
	events.clear();
	EVENT temp(0,0,0,0,0);
	int n=pack_igetw(f);
	for(int i=0;i<n;i++){
		pack_fread((void *)&temp, sizeof(EVENT), f);
		events.push_back(temp);
	}
}



bool LEVEL::save(char *file){
	replace_extension(file, file, "lvl", 480);
	PACKFILE *f=pack_fopen(file,F_WRITE);
	save(f);
	pack_fclose(f);
}
bool LEVEL::save(PACKFILE *f){
	pack_iputw(events.size(),f);
	for(list<EVENT>::iterator i=events.begin();i!=events.end();i++)
		pack_fwrite((void *)&(*i), sizeof(EVENT), f);
}



//bool LEVEL::update(list<ENEMY> *enemies,list<ITEM> *items,list<NOTE> *notes,bool edit){
bool LEVEL::update(list<ENEMY> *enemies,list<ITEM> *items,bool edit){
	if(time==0){
//		checkpoint=events.begin();
		pos=events.begin();
	}
	while(pos!=events.end()){
		if(pos->time<time)
			pos++;
		else if(pos->time==time){
			if(pos->type<6)
				enemies->push_back(ENEMY(edit?time:320,pos->y,pos->xs,pos->ys,pos->type));
			else if(pos->type<8)
				items->push_back(ITEM(edit?time:320,pos->y,pos->xs,pos->ys,pos->type-6));
/*			else if(pos->type==8){
				checkpoint=pos;
				notes->push_back(NOTE(edit?time:320,0,"Checkpoint"));
			}
*/			pos++;
		}
		else
			break;
	}
	if(pos==events.end())
		return 0;
	time++;
	return 1;
}