#include<string>
#include<vector>
#include<list>
#include<allegro.h>
using namespace std;

#include"campaign.h"
#include"main.h"

CAMPAIGN campaign;

const char *level_name(int index, int *list_size){
	if(index<0){
		*list_size=campaign.name.size();
		return NULL;
	}
	else
		return campaign.name[index].c_str();
}



int add_button_proc(int msg,DIALOG *dlg,int c){
	int rv=d_button_proc(msg,dlg,c);
	DIALOG *list=(DIALOG*)dlg->dp2;
	if(rv==D_EXIT){
		if(file_select_ex("Select level file or cancel to practice", path, "lvl", 480, 320, 200)){
			LEVEL level;
			level.load(path);

			char *name=get_filename(path);
			int i=0;
			for(;name[i]!='.';i++)
				if(name[i]=='_')
					name[i]=' ';
			name[i]='\0';
			campaign.name.push_back(name);
			campaign.level.push_back(level);
			list->flags|=D_DIRTY;
		}
		return D_O_K;
	}
	return rv;
}



int remove_button_proc(int msg,DIALOG *dlg,int c){
	int rv=d_button_proc(msg,dlg,c);
	DIALOG *list=(DIALOG*)dlg->dp2;
	int index=list->d1;
	if(rv==D_EXIT){
		if(index>=0 && index<(int)campaign.name.size()){
			campaign.name.erase(&campaign.name[index]);
			campaign.level.erase(&campaign.level[index]);
			list->flags|=D_DIRTY;
		}
		return D_O_K;
	}
	return rv;
}



int export_button_proc(int msg,DIALOG *dlg,int c){
	int rv=d_button_proc(msg,dlg,c);
	DIALOG *list=(DIALOG*)dlg->dp2;
	int index=list->d1;
	if(rv==D_EXIT){
		if(index>=0 && index<(int)campaign.name.size()){
			if(file_select_ex("Save level", path, "lvl", 480, 320, 200))
				campaign.level[index].save(path);
		}
		return D_O_K;
	}
	return rv;
}



int rename_button_proc(int msg,DIALOG *dlg,int c){
	int rv=d_button_proc(msg,dlg,c);
	DIALOG *list=(DIALOG*)dlg->dp2;
	int index=list->d1;
	if(rv==D_EXIT){
		if(index>=0 && index<(int)campaign.name.size()){
			char text[32];
			strcpy(text,campaign.name[index].c_str());
			DIALOG d[]={
			   { d_edit_proc,	SCREEN_W/2+5,	SCREEN_H/2+index*8+2,	150,	16,	16777215,	0,	0,	D_EXIT,	32,	0,	text,		NULL,		NULL },
			   { NULL,		0,			0,					0,	0,	0,		0,	0,	0,		0,	0,	NULL,		NULL,		NULL }
			};
			do_dialog(d,0);
			campaign.name[index]=text;
			list->flags|=D_DIRTY;
		}
		return D_O_K;
	}
	return rv;
}



int save_button_proc(int msg,DIALOG *dlg,int c){
	int rv=d_button_proc(msg,dlg,c);
	if(rv==D_EXIT){
		char apa[480];
		if( file_select_ex("Save campaign", path, "CPN", 480, 320, 200) ){
			replace_extension(apa, path, "cpn", 480);
			if( exists(apa) ){
				//Ask for overwrite permission
			}
			PACKFILE *file=pack_fopen(apa, F_WRITE);
			//Write the format
			int nl=campaign.name.size();
			pack_iputw(nl, file);
			for(int i=0;i<nl;i++){
				pack_iputw(campaign.name[i].size()+1, file);
				pack_fwrite((void *)campaign.name[i].c_str(),campaign.name[i].size()+1, file);
			}
			
			for(int i=0;i<nl;i++)
				campaign.level[i].save(file);

			pack_fclose(file);
		}
		return D_O_K;
	}
	return rv;
}



bool load_campaign(){
	if( exists(path) ){
		PACKFILE *file=pack_fopen(path, F_READ);
		campaign.name.clear();
		campaign.level.clear();
		int namel,nl;
		char tn[480];
		nl=pack_igetw(file);
		for(int i=0;i<nl;i++){
			namel=pack_igetw(file);
			pack_fread((void *)tn,namel, file);
			campaign.name.push_back(tn);
		}

		LEVEL level;
		for(int i=0;i<nl;i++){
			level.load(file);
			campaign.level.push_back(level);
		}
		pack_fclose(file);
		return 1;
	}
	return 0;
}



int load_button_proc(int msg,DIALOG *dlg,int c){
	int rv=d_button_proc(msg,dlg,c);
	if(rv==D_EXIT){
		if( file_select_ex("Load campaign", path, "CPN", 480, 320, 200) )
			load_campaign();
		return D_O_K;
	}
	return rv;
}



int top_button_proc(int msg,DIALOG *dlg,int c){
	int rv=d_button_proc(msg,dlg,c);
	DIALOG *list=(DIALOG*)dlg->dp2;
	int index=list->d1;
	LEVEL level;
	if(rv==D_EXIT){
		if(index>0 && index<(int)campaign.name.size()){
			campaign.name[index].swap(campaign.name[0]);

			level=campaign.level[index];
			campaign.level[index]=campaign.level[0];
			campaign.level[0]=level;
//			campaign.level[index].swap(campaign.level[0]);
			list->d1=0;
			list->flags|=D_DIRTY;
		}
		return D_O_K;
	}
	return rv;
}



int up_button_proc(int msg,DIALOG *dlg,int c){
	int rv=d_button_proc(msg,dlg,c);
	DIALOG *list=(DIALOG*)dlg->dp2;
	int index=list->d1;
	LEVEL level;
	if(rv==D_EXIT){
		if(index>0 && index<(int)campaign.name.size()){
			campaign.name[index].swap(campaign.name[index-1]);

			level=campaign.level[index];
			campaign.level[index]=campaign.level[index-1];
			campaign.level[index-1]=level;
//			campaign.level[index].swap(campaign.level[index-1]);
			list->d1--;
			list->flags|=D_DIRTY;
		}
		return D_O_K;
	}
	return rv;
}



int down_button_proc(int msg,DIALOG *dlg,int c){
	int rv=d_button_proc(msg,dlg,c);
	DIALOG *list=(DIALOG*)dlg->dp2;
	int index=list->d1;
	LEVEL level;
	if(rv==D_EXIT){
		if(index>=0 && index<(int)campaign.name.size()-1){
			campaign.name[index].swap(campaign.name[index+1]);

			level=campaign.level[index];
			campaign.level[index]=campaign.level[index+1];
			campaign.level[index+1]=level;
//			campaign.level[index].swap(campaign.level[index+1]);
			list->d1++;
			list->flags|=D_DIRTY;
		}
		return D_O_K;
	}
	return rv;
}



int bottom_button_proc(int msg,DIALOG *dlg,int c){
	int rv=d_button_proc(msg,dlg,c);
	DIALOG *list=(DIALOG*)dlg->dp2;
	int index=list->d1;
	LEVEL level;
	if(rv==D_EXIT){
		if(index>=0 && index<(int)campaign.name.size()-1){
			campaign.name[index].swap(campaign.name[campaign.name.size()-1]);

			level=campaign.level[index];
			campaign.level[index]=campaign.level[campaign.name.size()-1];
			campaign.level[campaign.name.size()-1]=level;
//			campaign.level[index].swap(campaign.level[campaign.name.size()-1]);
			list->d1=campaign.name.size()-1;
			list->flags|=D_DIRTY;
		}
		return D_O_K;
	}
	return rv;
}



DIALOG dlg[] =
{
   // (proc)				(x)	(y)	(w)	(h)	(fg)		(bg)	(key)	(flags)		(d1)	(d2)	(dp)				(dp2)		(dp3) 
   { d_list_proc,			0,	16,	160,	224,	1,	0,	0,	0,			0,	0,	(void*)level_name,	NULL,		NULL },

   { d_button_proc,		0,	0,	224,	16,	1,	0,	0,	D_DISABLED,	0,	0,	(void*)"Campaign editor",	NULL,		NULL },
   { save_button_proc,		160,	16,	64,	16,	1,	0,	0,	D_EXIT,		0,	0,	(void*)"Save",		NULL,		NULL },
   { load_button_proc,		160,	32,	64,	16,	1,	0,	0,	D_EXIT,		0,	0,	(void*)"Load",		NULL,		NULL },

   { d_button_proc,		160,	64,	64,	16,	1,	0,	0,	D_DISABLED,	0,	0,	(void*)"Level",		NULL,		NULL },
   { add_button_proc,		160,	80,	64,	16,	1,	0,	0,	D_EXIT,		0,	0,	(void*)"Add",		&dlg[0],	NULL },
   { remove_button_proc,	160,	96,	64,	16,	1,	0,	0,	D_EXIT,		0,	0,	(void*)"Remove",	&dlg[0],	NULL },
   { export_button_proc,	160,	112,	64,	16,	1,	0,	0,	D_EXIT,		0,	0,	(void*)"Export",		&dlg[0],	NULL },
   { rename_button_proc,	160,	128,	64,	16,	1,	0,	0,	D_EXIT,		0,	0,	(void*)"Rename",	&dlg[0],	NULL },

   { d_button_proc,		160,	160,	64,	16,	1,	0,	0,	D_DISABLED,	0,	0,	(void*)"Move",		NULL,		NULL },
   { top_button_proc,		160,	176,	64,	16,	1,	0,	0,	D_EXIT,		0,	0,	(void*)"Top",		&dlg[0],	NULL },
   { up_button_proc,		160,	192,	64,	16,	1,	0,	0,	D_EXIT,		0,	0,	(void*)"Up",		&dlg[0],	NULL },
   { down_button_proc,	160,	208,	64,	16,	1,	0,	0,	D_EXIT,		0,	0,	(void*)"Down",		&dlg[0],	NULL },
   { bottom_button_proc,	160,	224,	64,	16,	1,	0,	0,	D_EXIT,		0,	0,	(void*)"Bottom",		&dlg[0],	NULL },
   { NULL,				0,	0,	0,	0,	0,		0,	0,	0,			0,	0,	NULL,				NULL,		NULL }
};



void edit_campaign(){
	static bool first=1;
	if(first){
		first=0;
		for(int i=0;i<14;i++){
			dlg[i].x+=(SCREEN_W/2-80);
			dlg[i].y+=(SCREEN_H/2-120);
		}
	}
	int index;
	while(do_dialog(dlg,-1)==7){
/*		index=dlg[0].d1;
		if(index>=0 && index<(int)campaign.name.size()){
			eblocks.swap(campaign.level[index]);
			BITMAP *bmp=create_bitmap(SCREEN_W,SCREEN_H);
			editor(bmp);
			destroy_bitmap(bmp);
			eblocks.swap(campaign.level[index]);
			while(key[KEY_ESC]);
				poll_keyboard();
			while(keypressed());
				readkey();
		}*/
	}
	while(key[KEY_ESC]);
//		poll_keyboard();
}
