#!/usr/bin/perl
#################################################################
#                                                               #
# Tag Board Script - by Dan Lewis [dan@infinitevoid.com]        #
# Last modified: 25/Feb/2001                                    #
# Version 1.1                                                   #
# Please give credit where credit is due.                       #
# www.danlewis.org                                              #
#                                                               #
# This version of the tag board was edited                      #
# by skizzo from lastchance3k.net                               #
#                                                               #
#################################################################

use strict;
use CGI;

# Configurable Variables ########################################

my $tag_path = 'tag.txt';
my $return_path = 'board.shtml';
my $ip_logfile = 'iplog.txt';
my @bad_words = qw(fuck);
my $admin    = 'sabin';
my $password = 'rpgsrule';
my $max_tags = 50;
my $separator = ' ';
my $max_content_size = 150;
my $word_max_chars = 15;
my $time_limit = 120;        # Number of seconds between posts


#################################################################

my $q = new CGI;
print $q->header;

my $name = $q->param('name');
my $url  = $q->param('url');
my $msg  = $q->param('msg');

$name =~ s/\n/ /g;
$url =~ s/\n/ /g;
$msg =~ s/\n/ /g;
$name =~ s/\r/ /g;
$url =~ s/\r/ /g;
$msg =~ s/\r/ /g;

############ Validate data ############
error_msg("No data.") unless ($msg ne "taggage");
my $content = $name . $url . $msg;
error_msg("Too much data.") if (length($content) > $max_content_size);
error_msg("Invalid character: &lt; or &gt;") if ($content =~ /</ || $content =~ />/);

############ Check for admin name ############
if(lc($name) eq lc($admin)) {
	my $pw = $q->param('pw');
	if(!$pw) {
		print <<"EOF";
<html>
	<body>
		<form method="POST">
			<center>
			PW: <input type="password" name="pw" size="8">
			<br><input type="submit" value="submit">
			</center>
			<input type="hidden" name="name" value="$name">
			<input type="hidden" name="url" value="$url">
			<input type="hidden" name="msg" value="$msg">
		</form>
	</body>
</html>
EOF
		exit;
	} else {
		error_msg("Invalid admin password.") if($pw ne $password);
	}
} else {

	############ Check vulgarity ############
	for (@bad_words) {
		error_msg("No vulgarity.") if ($content =~ /$_/i);
	}

	############ Check for huge words ############
	my @words = ($name, split(/ /, $msg));
	for (@words) {
		error_msg("This tag board is slightly illiterate. Big words are shunned upon.")
			if(length > $word_max_chars);
	}

	############ Check IP against time stamp ############
	my $ip = $ENV{'REMOTE_ADDR'};
	my $cur_time = time;
	open IP, $ip_logfile;
		my $old_time = <IP>;
		chop($old_time);
	
		if($old_time + $time_limit > $cur_time) {
			while(<IP>) {
				chop;
				if($ip eq $_) {
					close IP;
					error_msg("Posting time limit exceeded.");
				}
			}
			close IP;
			open IP, ">>$ip_logfile";
		} else {
			close IP;
			open IP, ">$ip_logfile";
			print IP "$cur_time\n";
		}
		print IP "$ip\n";
	close IP;

}

open TAG, $tag_path;
	my @board = <TAG>;
close TAG;

############ Prepare output ############
if($url) {
	$url = 'http://' . $url if($url !~ m!^http://!);
	$name = "<a href=\"$url\" target=\"blank\">$name</a>"
}
$content = "<b>$name</b>$separator$msg<br>\n";
unshift @board, $content;
$max_tags--;
$#board = $max_tags if ($#board > $max_tags);

open TAG, ">$tag_path";
	print TAG @board;
close TAG;

############ DONE ############
print <<"EOF";
<html>
<head>
<style>
a:link       { color: #FFFFFF; text-decoration: none }
a:visited    { color: #FFFFFF; text-decoration: none }
a:active     { color: #FFFFFF; text-decoration: none }
a:hover      { color: #00DDFF; text-decoration: underline }
</style>
</head>
	<body bgcolor=#666666
		<p align="center">
		<b>Done!</b><br>
<font face="verdana" size="1">
		Click <a href="$return_path">here</a> to view your post.
	</body>
</html>
EOF


#################################################################

sub error_msg {
	my $m = shift;
	print <<"EOF";
<html>
	<body>
		<p align="center">
		<b>Error</b>: $m
		<p align="center"><a href="$return_path">OK</a>
	</body>
</html>
EOF
exit;
}

#################################################################