# Config Part
#
#######################

$data_dir = "data"; # data directory like "data"
$welcome_msg = << "[END]"; # msg printed when user logs in
    Welcome to Ralfs Chat!<BR>
    /help - helptext
[END]
$masterpassword = "mpw"; # Masterpassword for special commands
$updatefrequency = 10; # number of seconds the chat updates itself
$min_update_freq = 5; # the minimum update frequency
$clear_old_msgs = 1; # set to 1 if you want that old msgs are deleted when the chat is empty
$message_limit = 20; # number of maximal (public) messages in the chat window
$new_msg_on_top = 0; # set to 1 if you want new messages printed on top, to work around the msie bug
$admin_email_addresse = 'you@yourserver.com'; # Your email address
$mailprogramme = '/usr/lib/sendmail'; # Path to the mail-transport-agent
$mail_on_new_registration = 0; # set to 1 if you want to be mailed when a new user registers
$logtype = 0; # The type of log you wish: 0 - no log, 1 - registrations, 2 - +logins, 3 - +messages
$log_dir = "logs"; # directory for log files
$script_name = "chat.cgi"; # filename of the script like "chat.cgi"
$script2_name = "chat2.cgi"; # filename of the second cript like "chat2.cgi"
$max_users = -1; # the maximal number of users in the chat at the same time, set to "-1" if unlimited
$days_to_keep_memos = 60; # Number of days to keep memos
$reset_private_msg_select = 0; # set to 1 if you want the select field for private msgs to be reset to "to all users" after msg was sent
$flocking = 1; # set to 1 if you want flocking, but flocking is not supported by Windows NT (set to 0)
$international_nicks = 1; # 0 - nick may only contain letters and numbers, 1 - nick may contain any character except ";/ :\?*<>|

# Files - don't need to be changed, only if you want several script
# using eg the same nick file but different msg file. So you can use
# the script for multiple chat rooms.

$data_msg_file = "messages";
$data_stillalive_file = "stillalive";
$data_private_file = "private"; # without .user
$data_nicks_file = "nicks"; # you should leave this one, else the user has to register on every single script
$data_userinfo_file = "userinfo"; # the user-info database
$data_banned_file = "banned"; # banned user file
$data_memo_file = "memo"; # memo file

# HTML-Stuff

$html_bodytag = '<BODY BGColor=#000000 TEXT=#6699FF Link=#0000FF VLINK=#0000CC ALINK=#0000FF>'; # The bodytag for html files
$html_css = << "[END]"; # The style sheet definition used for all html files
<STYLE TYPE="text/css">
</STYLE>
[END]
$html_title = "Ralfs Chat"; # The title of your chat
$banner_picture = "http://www.ralfchat.de/banner.jpg"; # the banner picture, set to "" if you dont want any banner
$banner_link = "http://www.ralfchat.de"; # The banner link
$logout_url = "$script_name"; # the url for the logout-link
$input_field_size = "30"; # the size of the msg input field

# END CONFIG PART - ALL DONE
#
########################

# HTML Part
#
########################


#USER_ERROR.HTML - view error msg
sub user_error_html { # $_[0] - title/headline, $_[1] - error msg
	print <<"[END]";
<HTML>
<HEAD><TITLE>$html_title - $_[0]</TITLE>
$html_css
</HEAD>
$html_bodytag
<CENTER>
<H1><I>$_[0]</I></H1>
<B>$_[1]</B>
</CENTER>
</BODY>
</HTML>
[END]
}

# MESSAGES Part
#
########################

$config_msg[0]  = "unknown nickname"; # unknown nickname

# nonick_html
$config_msg[1]  = "Nick doesn't exist"; # Nick doesn't exist
$config_msg[2]  = "<A HREF=\"$script2_name?action=register\">register</A> or<BR><A HREF=\"$script_name\">try another nick</A>"; # <A HREF=\"$script2_name?action=register\">register</A> or<BR><A HREF=\"$script_name\">try another nick</A>

# wrongpass_html
$config_msg[3]  = "Wrong Password"; # Wrong Password
$config_msg[4]  = "<A HREF=\"$script2_name?action=send_pwd&name="; # <A HREF=\"$script2_name?action=send_pwd&name=[nickname]
$config_msg[19] = "\">lost password</A><BR><A HREF=\"$script_name\">retry</A>"; # [config_msg[4]]\">lost password</A><BR><A HREF=\"$script_name\">retry</A>

# kicked_html
$config_msg[5]  = "You were kicked"; # You were kicked
$config_msg[6]  = "<A HREF=\"$script2_name?action=gotourl&url=$logout_url\" TARGET=\"_parent\">logout</A>"; # <A HREF=\"$script2_name?action=gotourl&url=$logout_url\" TARGET=\"_parent\">logout</A>

# banned_html
$config_msg[7]  = "You are banned"; # You are banned
$config_msg[8]  = "<A HREF=\"$script2_name?action=gotourl&url=$logout_url\" TARGET=\"_parent\">logout</A>"; # <A HREF=\"$script2_name?action=gotourl&url=$logout_url\" TARGET=\"_parent\">logout</A>

# user [user] not found
$config_msg[9]  = "user"; # user
$config_msg[10] = "not found"; # not found

# <B>[nickname]</B><BR>realname: [realname]<BR>email: <A HREF=\"mailto:[email]\">[email]</A><BR>age: [age]<BR>city: [city]<BR>country: [country]<BR>homepage: <A HREF=\"[url]\">[url]</A><BR>anything else: [stuff]<BR>photo: <A HREF=\"[photo_url]\">$userinfo{'photo_url'}</A>
$config_msg[11] = "realname"; # realname
$config_msg[12] = "eMail"; # eMail
$config_msg[13] = "age"; # age
$config_msg[14] = "city"; # city
$config_msg[15] = "country"; # country
$config_msg[16] = "homepage"; # homepage
$config_msg[17] = "anything else"; # anything else
$config_msg[18] = "photo"; # photo

# Main Part - DON'T CHANGE ANYTHING HERE!
#
#######################

$version = "0.12";     # don't change
$lastmodified = "Mar 10th 2000"; # don't change
$about_msg = "Ralfs Chat - <A HREF=\"$script2_name?action=gotourl\&url=http://www.ralfchat.de\" TARGET=\"ralfchat\">www.ralfchat.de</A> -  created and copyright by Ralf G&uuml;ldemeister \&lt;ralf\@ralfchat.de> on Dec 25th 1998; last modified on $lastmodified; Version $version"; # msg printed on /about

$timestamp = time;
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($timestamp);
$mon++; $year += 1900;
$log_file = "$year-$mon-$mday.txt";

&getquery;

sub extract_qs { # extract variables from $qs --> hash $query
	my @split = split (/&/, $qs);
	foreach $split (@split) {
		($query_key, $query_value) = split (/=/, $split);
		$query_value =~ tr/+/ /;
		$query_value =~ s/%([\dA-Fa-f][\dA-Fa-f])/ pack ("C", hex ($1))/eg;
		$query{$query_key} = $query_value;	
	}

}

sub getquery { # get query string
	if ($ENV{'REQUEST_METHOD'} eq "GET") {
		$qs = $ENV{'QUERY_STRING'};
	} elsif ($ENV{'REQUEST_METHOD'} eq "POST") {
		read(STDIN, $qs, $ENV{'CONTENT_LENGTH'});
	}
	&extract_qs;
}

sub header { # standard html header
	print "Content-type: text/html\n\n";
}

sub error { # $_[0] - error_msg
	&header;
	print <<"[END]";
<HTML>
<HEAD><TITLE>$html_title - An Error Occured</TITLE>
$html_css
</HEAD>
$html_bodytag
<H1>An Error Occured</H1>
<B>Error Message: $_[0]<BR>Query_String: $qs</B>
</BODY>
</HTML>
[END]
	exit;
}


sub repair_safile {
	my $i=0;
	my @satemp;
	my @satemp2;
	for (@sa) {        
		if (/[A-Za-z]/) {
			$satemp[$i]=$_;
			$i++;
		}
	}    
	$i=0;
	@sa = "";
	for (@satemp) {
		$sa[$i*2] = $satemp[$i];
		$sa[$i*2+1] = time;
		$i++; 
	}

	@sa = "" if ($#sa % 2 == 0);
}

sub checkpass {
	if (-e "$data_dir/$data_nicks_file") {  # wenn nickfile existiert dann oeffnen
		open (NICKFILE, "<$data_dir/$data_nicks_file") || &error("::open Nickfile failed::");
	} 
	else {  # else print nonick_html
		&header;
		&user_error_html($config_msg[1], $config_msg[2]);
		exit;
	}
	my @nickfile = <NICKFILE>; 
	close NICKFILE; 

	my @nickfile_matrix = ();

	for (my $i = 0; $i <= $#nickfile; $i++) {
		chomp($nickfile[$i]);
		push(@nickfile_matrix, [split(/;;/, $nickfile[$i])]);
	}
	
	my $nickok;
	for (my $cpi=0; $cpi<=$#nickfile_matrix; $cpi++) {
		if ($nickfile_matrix[$cpi][0] =~ /^$query{'name'}$/i) {
			$nickok = 1;
			if ($nickfile_matrix[$cpi][1] ne $query{'password'}) {
				&header;
				&user_error_html($config_msg[3], $config_msg[4]."$query{'name'}".$config_msg[19]);
				exit;
			}
			if ($nickfile_matrix[$cpi][10] == 1) {
				&header;
				&user_error_html($config_msg[5], $config_msg[6]);
				exit;
			}
			if ($nickfile_matrix[$cpi][10] == 2) {
				&header;
				&user_error_html($config_msg[7], $config_msg[8]);
				exit;
			}
		} 
	}

	if ($nickok != 1) {
		&header;
		&user_error_html($config_msg[1], $config_msg[2]);
		exit;
	}

}

sub postprivatemsg { # parameter: 0: empfaenger 1: sender 2: msg 
	&checkpass;  # Passwort checken

	# kill linebreaks
	$_[2] =~ s/\n/ /g;

	if (-e "$data_dir/$data_private_file.$_[0]") {
	} else {
		&postprivatemsg($query{'name'}, "MSG", "$config_msg[0]: $_[0]");
		return;
	}

	# alte Eintraege >35 loeschen
	open (PRIVATEFILE, "<$data_dir/$data_private_file.$_[0]") || &error("opening $data_dir/$data_private_file.$_[0] failed");
	my @privatefile = <PRIVATEFILE>;
	close PRIVATEFILE;

	for (my $ppm_i=0; $ppm_i <= ($#privatefile -35); $ppm_i++) {
		shift(@privatefile);
	}
	open (PRIVATEFILE, ">$data_dir/$data_private_file.$_[0]") || &error("opening privatefile failed");
	flock(PRIVATEFILE,2) if ($flocking == 1);

	print PRIVATEFILE @privatefile;

	close PRIVATEFILE;

	while (time == $last_priv_msg_id) {}
	$priv_msg_id = time;
	$last_priv_msg_id = $priv_msg_id;

	open (PRIVATEFILE, ">>$data_dir/$data_private_file.$_[0]");
	flock(PRIVATEFILE,2) if ($flocking == 1);

	if ($query{'color'} eq "standard") {
		print PRIVATEFILE "$priv_msg_id;;<B>[$_[1]]</B> $_[2]\n";
	} else {
		print PRIVATEFILE "$priv_msg_id;;<FONT COLOR=\"$query{'color'}\"><B>[$_[1]]</B> $_[2]</FONT>\n";
	}        

	close PRIVATEFILE;

	open (CHATFILE, ">>$data_dir/$data_msg_file");
	flock(CHATFILE,2) if ($flocking == 1);

	print CHATFILE "<!--PrivateMsgHere;;$_[0];;$priv_msg_id;;-->";

	close CHATFILE;
}

sub create_file { # Datei erstellen (in Klammern als parameter zu uebergeben)
	my $file2create = $_[0];
	open (CREATEFILE, ">$file2create") || &error("creating $file2create failed");
	close (CREATEFILE);
}

sub userinfo {
	open (UIFILE, "<$data_dir/$data_userinfo_file") || &create_file("$data_dir/$data_userinfo_file");
	my @uifile = <UIFILE>; 
	close UIFILE;

	my @uifile_matrix = ();

	for (my $i = 0; $i <= $#uifile; $i++) {
		chomp($uifile[$i]);
		push(@uifile_matrix, [split(/;;/, $uifile[$i])]);
	}
	
	my $nickfound = 0;
	for (my $i=0; $i<=$#uifile_matrix; $i++) {
		if ($uifile_matrix[$i][0] =~ /^$query{'infoabout'}$/i) {
			$userinfo{'realname'} = $uifile_matrix[$i][1];
			$userinfo{'email'} = $uifile_matrix[$i][2];
			$userinfo{'age'} = $uifile_matrix[$i][3];
			$userinfo{'city'} = $uifile_matrix[$i][4];
			$userinfo{'country'} = $uifile_matrix[$i][5];
			$userinfo{'url'} = $uifile_matrix[$i][6];
			$userinfo{'stuff'} = $uifile_matrix[$i][7];
			$userinfo{'photo_url'} = $uifile_matrix[$i][8];
			$userinfo{'icq_uin'} = $uifile_matrix[$i][9];
			$nickfound = 1;
		}
	}

	if ($userinfo_as_private_msg != 1) {
		&header;
		&userinfo_html;
	} elsif ($nickfound == 0){
		&postprivatemsg($query{'name'}, "USERINFO", $config_msg[9]." $query{'infoabout'} ".$config_msg[10]);
	} else {
		&postprivatemsg($query{'name'}, "USERINFO", "<B>$query{'infoabout'}</B><BR>$config_msg[11]: $userinfo{'realname'}<BR>$config_msg[12]: <A HREF=\"mailto:$userinfo{'email'}\">$userinfo{'email'}</A><BR>$config_msg[13]: $userinfo{'age'}<BR>$config_msg[14]: $userinfo{'city'}<BR>$config_msg[15]: $userinfo{'country'}<BR>$config_msg[16]: <A HREF=\"$userinfo{'url'}\">$userinfo{'url'}</A><BR>$config_msg[17]: $userinfo{'stuff'}<BR>$config_msg[18]: <A HREF=\"$userinfo{'photo_url'}\">$userinfo{'photo_url'}</A>");
	}
}

1;
