#!/usr/bin/perl
# This Script and the readme may only be given away "as is", unmodified
# and complete. The Script is Freeware.
# Created and Copyright by Ralf Gueldemeister <ralfg@bigfoot.com>
# on 25.12.98

require config; 

# HTML Part
#
########################


#REGISTER.HTML - Printed when user registers new nick
sub register_html {
    print <<"[END]";
<HTML>
<HEAD><TITLE>$html_title - register new nick</TITLE>
$html_css
</HEAD>
$html_bodytag
<CENTER>
<H1><I>Register New Nick</I></H1>
<FORM METHOD=POST ACTION="$script2_name">
<INPUT TYPE=HIDDEN NAME="action" VALUE="create_nick">
<TABLE><TR><TD>
<B>new Nickname: </B></TD><TD><INPUT NAME="name"><BR></TD></TR>
<TR><TD><B>Password:</B> </TD><TD><INPUT TYPE=PASSWORD NAME="password"><BR></TD></TR>
<TR><TD><B>Password again:</B> </TD><TD><INPUT TYPE=PASSWORD NAME="password2"><BR></TD></TR>
<TR><TD><B>eMail:<BR> (only for administration)</B> </TD><TD><INPUT NAME="email"><BR>
</TD></TR></TABLE>
<INPUT TYPE=SUBMIT VALUE="register">
</FORM>
</CENTER>
</BODY>
</HTML>
[END]
}

#BANNER.HTML - the banner on the top - You may change or remove it!
sub banner_html {
    print <<"[END]";
<HTML>
<HEAD>
$html_css
</HEAD>
$html_bodytag
<CENTER>
<A HREF="$banner_link" TARGET="_blank"><IMG SRC="$banner_picture" BORDER=0></A>
</CENTER>
</BODY></HTML>
[END]
}

#OPTIONS.HTML - the options page
sub options_html {
    print <<"[END]";
<HTML><HEAD><TITLE>$html_title - Options</TITLE>
$html_css
</HEAD>
$html_bodytag
<CENTER>
<H1><I>Options</I></H1>
<FORM METHOD=POST ACTION="$script2_name">
<INPUT TYPE=HIDDEN NAME="action" VALUE="setoptions">
<INPUT TYPE=HIDDEN NAME="name" VALUE="$query{'name'}">
<INPUT TYPE=HIDDEN NAME="password" VALUE="$query{'password'}">
<TABLE>
<TR><TD>Update Frequency (secs): </TD><TD><INPUT SIZE="10" NAME="updatefrequency" VALUE=$query{'updatefrequency'}></TD></TR>
<TR><TD>Font Color:</TD><TD><SELECT NAME="color">
<OPTION SELECTED VALUE="$query{'color'}">current</OPTION>
<OPTION VALUE="standard">standard</OPTION>
<OPTION VALUE="standard">--------</OPTION>
<OPTION VALUE="0000FF">blue</OPTION>
<OPTION VALUE="008000">green</OPTION>
<OPTION VALUE="FF0000">red</OPTION>
<OPTION VALUE="000000">black</OPTION>
<OPTION VALUE="FFFFFF">white</OPTION>
<OPTION VALUE="800000">maroon</OPTION>
<OPTION VALUE="808000">olive</OPTION>
<OPTION VALUE="000080">navy</OPTION>
<OPTION VALUE="800080">purple</OPTION>
<OPTION VALUE="808080">gray</OPTION>
<OPTION VALUE="C0C0C0">silver</OPTION>
<OPTION VALUE="00FF00">lime</OPTION>
<OPTION VALUE="FFFF00">yellow</OPTION>
<OPTION VALUE="FF00FF">fuchsia</OPTION>
<OPTION VALUE="00FFFF">aqua</OPTION>
<OPTION VALUE="008080">teal</OPTION>
</SELECT></TD></TR>
<TR><TD>Message order</TD><TD><SELECT NAME="new_msg_on_top">
<OPTION VALUE="$query{'new_msg_on_top'}" SELECTED>current</OPTION>
<OPTION VALUE="1">newest on top</OPTION>
<OPTION VALUE="0">newest on bottom</OPTION>
</SELECT></TD></TR>
<TR><TD>Login Sound</TD><TD><INPUT TYPE=TEXT SIZE=20 NAME="ls" VALUE="$query{'ls'}"></TD></TR>
<TR><TD><H3>Change password</H3></TR></TD>
<TR><TD>old password: </TD><TD><INPUT TYPE=PASSWORD NAME="change_pwd_old"></TD></TR>
<TR><TD>new password: </TD><TD><INPUT TYPE=PASSWORD NAME="change_pwd_new"></TD></TR>
<TR><TD>new password again: </TD><TD><INPUT TYPE=PASSWORD NAME="change_pwd_new2"></TD></TR>
</TABLE>
<INPUT TYPE=SUBMIT VALUE="set options">
</FORM>
</CENTER></BODY></HTML>
[END]
}


#USERINFO.HTML - information about the users, click on user in online list
sub userinfo_html {
    print <<"[END]";
<HTML>
<HEAD><TITLE>$html_title - User Information</TITLE>
$html_css
</HEAD>
$html_bodytag
<CENTER>
<H1><I>User Information</I></H1>
[END]

    print "<TABLE><TR><TD VALIGN=top><IMG SRC=\"$userinfo{'photo_url'}\"></TD><TD VALIGN=top>" if ($userinfo{'photo_url'} ne "");
    print "<TABLE>";
    print "<TR><TD><B>nickname</B>:</TD><TD>$query{'infoabout'}</TD></TR>";
    print "<TR><TD><B>real name</B>:</TD><TD>$userinfo{'realname'}</TD></TR>";
    print "<TR><TD><B>email</B>:</TD><TD><A HREF=\"mailto:$userinfo{'email'}\">$userinfo{'email'}</A></TD></TR>";
    print "<TR><TD><B>age</B>:</TD><TD>$userinfo{'age'}</TD></TR>";
    print "<TR><TD><B>city</B>:</TD><TD>$userinfo{'city'}</TD></TR>";
    print "<TR><TD><B>country</B>:</TD><TD>$userinfo{'country'}</TD></TR>";
    print "<TR><TD><B>homepage url</B>:</TD><TD><A HREF=\"$userinfo{'url'}\">$userinfo{'url'}</A></TD></TR>";
    print "<TR><TD><B>ICQ uin</B>:</TD><TD>$userinfo{'icq_uin'}</TD></TR>";
    print "<TR><TD VALIGN=top><B>anything else</B>:</TD><TD>$userinfo{'stuff'}</TD></TR>";
    print "</TABLE>";
    print "</TD></TR></TABLE>" if ($userinfo{'photo_url'} ne "");

    print <<"[END]";
</CENTER>
</BODY>
</HTML>
[END]
}

#CHANGEUSERINFO.HTML - change user information
sub changeuserinfo_html {
    print <<"[END]";
<HTML>
<HEAD><TITLE>$html_title - Change User Information</TITLE>
$html_css
</HEAD>
$html_bodytag
<CENTER>
<H1><I>Change User Information</I></H1>
<TABLE>
<FORM METHOD=POST ACTION="$script2_name">
<INPUT TYPE=hidden NAME="action" VALUE="setuserinfo">
<INPUT TYPE=HIDDEN NAME="name" VALUE="$query{'name'}">
<INPUT TYPE=HIDDEN NAME="password" VALUE="$query{'password'}">
<INPUT TYPE=HIDDEN NAME="color" VALUE="$query{'color'}">
<INPUT TYPE=HIDDEN NAME="new_msg_on_top" VALUE="$query{'new_msg_on_top'}">
<INPUT TYPE=HIDDEN NAME="updatefrequency" VALUE="$query{'updatefrequency'}">
<INPUT TYPE=HIDDEN NAME="ls" VALUE="$query{'ls'}">
<TR><TD><B>real name</B>:</TD><TD><INPUT NAME="realname" VALUE="$userinfo{'realname'}"></TD></TR>
<TR><TD><B>email</B>:</TD><TD><INPUT NAME="email" VALUE="$userinfo{'email'}"></TD></TR>
<TR><TD><B>country</B>:</TD><TD><INPUT NAME="country" VALUE="$userinfo{'country'}"></TD></TR>
<TR><TD><B>city</B>:</TD><TD><INPUT NAME="city" VALUE="$userinfo{'city'}"></TD></TR>
<TR><TD><B>age</B>:</TD><TD><INPUT NAME="age" VALUE="$userinfo{'age'}"></TD></TR>
<TR><TD><B>homepage url</B>:</TD><TD><INPUT NAME="url" VALUE="$userinfo{'url'}"></TD></TR>
<TR><TD><B>picture url</B>:</TD><TD><INPUT NAME="photo_url" VALUE="$userinfo{'photo_url'}"></TD></TR>
<TR><TD><B>ICQ uin</B>:</TD><TD><INPUT NAME="icq_uin" VALUE="$userinfo{'icq_uin'}"></TD></TR>
<TR><TD VALIGN=top><B>everything else</B>:</TD><TD><TEXTAREA ROWS=10 COLS=50 NAME="stuff" WRAP="physical">$userinfo{'stuff'}</TEXTAREA></A></TD></TR>
</TABLE>
<INPUT TYPE=SUBMIT VALUE="set user info"></FORM>
</CENTER>
</BODY>
</HTML>
[END]
}

#SCRIPTLINKS.HTML - Links to other chatscripts
sub scriptlinks_html {
    print <<"[END]";
<HTML>
<HEAD>
$html_css
</HEAD>
$html_bodytag
<A HREF="chat2.cgi?action=login&name=$query{'name'}&password=$query{'password'}" TARGET="_parent">chat 2</A>
</BODY></HTML>
[END]
}

#CHATFRAMES.HTML
sub chatframes_html {
	print "<HTML><HEAD><TITLE>$html_title</TITLE></HEAD>\n";
	if ($banner_picture) {
		print " <FRAMESET ROWS=\"65,*,60\" BORDER=0 FRAMEBORDER=0 FRAMESPACING=0>\n"
	} else {
		print " <FRAMESET ROWS=\"*,60\" BORDER=0 FRAMEBORDER=0 FRAMESPACING=0>\n"
	}
	print "  <FRAME SRC=\"$script2_name?action=banner\" SCROLLING=NO>\n" if ($banner_picture);
	print "  <FRAMESET COLS=\"*,150\" BORDER=0 FRAMEBORDER=0 FRAMESPACING=0>\n";
	print "   <FRAME NAME=\"main\" SRC=\"$script_name?action=chat&name=$query{'name'}&password=$query{'password'}&updatefrequency=$query{'updatefrequency'}&color=$query{'color'}&new_msg_on_top=$query{'new_msg_on_top'}&ls=$query{'ls'}&pause=$pause#end\">  \n";
#	print "	   <FRAMESET ROWS=\"*,100\" BORDER=0 FRAMEBORDER=0 FRAMESPACING=0> \n"; #UNCOMMENT IF YOU WANT MULTIPLE SCRIPT SUPPORT
	print "    <FRAME SRC=\"$script_name?action=stillalive&name=$query{'name'}&password=$query{'password'}&updatefrequency=$query{'updatefrequency'}&color=$query{'color'}&new_msg_on_top=$query{'new_msg_on_top'}&ls=$query{'ls'}\">    \n";
#	print "    <FRAME SRC=\"$script2_name?action=scriptlinks&name=$query{'name'}&password=$query{'password'}\" scrolling=auto>\n"; #UNCOMMENT IF YOU WANT MULTIPLE SCRIPT SUPPORT
	print "   </FRAMESET>\n";
#	print "  </FRAMESET>\n"; #UNCOMMENT IF YOU WANT MULTIPLE SCRIPT SUPPORT
	print "  <FRAME SRC=\"$script_name?action=chatinput_html&name=$query{'name'}&password=$query{'password'}&updatefrequency=$query{'updatefrequency'}&color=$query{'color'}&new_msg_on_top=$query{'new_msg_on_top'}&ls=$query{'ls'}&norefresh=1\" scrolling=no>\n";
	print "</FRAMESET>\n";
	print "</HTML>\n";
}


# MESSAGES Part
#
########################

$chat2_msg[0]  = "has entered the chat"; # [user] has entered the chat

# illegal_nick_html
$chat2_msg[1]  = "Illegal Nick"; # Illegal Nick
$chat2_msg[2]  = "Your Nick \"$query{'name'}\" contains illegal characters<BR>A Nick may contain only letters, numbers and the underdash \"_\".<BR><B><A HREF=\"$script2_name?action=register\">retry</A>"; # Your Nick \"$query{'name'}\" contains illegal characters<BR>A Nick may contain only letters, numbers and the underdash \"_\".<BR><B><A HREF=\"$script2_name?action=register\">retry</A>

# illegal_pass_html
$chat2_msg[3]  = "Illegal Password"; # Illegal Password
$chat2_msg[4]  = "A password may not contain \";\"<BR><A HREF=\"$script2_name?action=register\">retry</A>"; # A password may not contain \";\"<BR><A HREF=\"$script2_name?action=register\">retry</A>

# pass_check_failed_html
$chat2_msg[5]  = "Password Check Failed"; # Password Check Failed
$chat2_msg[6]  = "The passwords you entered are not equal<BR><A HREF=\"$script2_name?action=register\">retry</A>"; # The passwords you entered are not equal<BR><A HREF=\"$script2_name?action=register\">retry</A>

# existingnick_html
$chat2_msg[7]  = "Nickname already exists"; # Nickname already exists
$chat2_msg[8]  = "<A HREF=\"$script2_name?action=register\">try another nick</A>"; # <A HREF=\"$script2_name?action=register\">try another nick</A>

# nickcreated_html
$chat2_msg[9]  = "Your nick is now registered";# Your nick is now registered
$chat2_msg[10] = "<A HREF=\"$script_name\">login</A>"; # <A HREF=\"$script_name\">login</A>

# chat_is_full_html
$chat2_msg[11] = "Chat is full"; # Chat is full
$chat2_msg[12] = "Sorry, the chat room is full, please try another room or come back another time.<BR>You can login anyway if you login with the password \"yourpassword masterpassword\".<BR><A HREF=\"$script_name\">back</A>"; # Sorry, the chat room is full, please try another room or come back another time.<BR>You can login anyway if you login with the password \"yourpassword masterpassword\".<BR><A HREF=\"$script_name\">back</A>

# send_pwd_html
$chat2_msg[13] = "Lost Password"; # Lost Password
$chat2_msg[14] = "The password was sent to you.<BR><A HREF=\"$script_name\">back</A>"; # The password was sent to you ($query{'email'}).<BR><A HREF=\"$script_name\">back</A>

# illegal_international_nick_html
$chat2_msg[15] = "Illegal Nick"; # Illegal Nick
$chat2_msg[16] = "Your Nick \"$query{'name'}\" contains illegal characters<BR>A Nick may not contain \\\";/ :?*<>|<BR><A HREF=\"$script2_name?action=register\">retry</A>"; # Your Nick \"$query{'name'}\" contains illegal characters<BR>A Nick may not contain \\\";/ :?*<>|<BR><A HREF=\"$script2_name?action=register\">retry</A>

$chat2_msg[17] = "Password changed"; # Password changed
$chat2_msg[18] = "The new password may not contain \";\""; # The new password may not contain \";\"
$chat2_msg[19] = "New password check failed, probably mistyped"; # New password check failed, probably mistyped
$chat2_msg[20] = "please wait"; # please wait
$chat2_msg[21] = "Memo from"; # Memo from
$chat2_msg[22] = "[CHAT] Your Password"; # [CHAT] Your Password
$chat2_msg[23] = "Your password is"; # Your password is
$chat2_msg[24] = "- the admin"; # - the admin
$chat2_msg[25] = "Nick"; # Nick

# Main Part - DON'T CHANGE ANYTHING HERE!
#
#######################



&action;    # Fuehrt je nach action variable gegebene sub aus
	    # action im FORM definieren!

exit;

sub action {
    if ($qs eq "") { # Wenn query_string leer sprung zum
    	&error("dont't execute this file, run chat.cgi instead");
    } 
    elsif ($query{'action'} eq "register") {
        &header;
        &register_html;
    }
    elsif ($query{'action'} eq "login") {
    	&login;
    }
    elsif ($query{'action'} eq "create_nick") {
    	&create_nick;
    }
    elsif ($query{'action'} eq "banner") {
        &header;
        &banner_html;
    }
    elsif ($query{'action'} eq "options_html") {
        &header;
        &options_html;
    }
    elsif ($query{'action'} eq "setoptions") {
        &setoptions;
    }
    elsif ($query{'action'} eq "gotourl") {
        &gotourl;
    }
    elsif ($query{'action'} eq "userinfo") {
        &userinfo;
    }
    elsif ($query{'action'} eq "changeuserinfo") {
        &changeuserinfo;
    }
    elsif ($query{'action'} eq "setuserinfo") {
        &setuserinfo;
    }
    elsif ($query{'action'} eq "show_users") {
        &show_users;
    }
    elsif ($query{'action'} eq "scriptlinks") {
        &header;
        &scriptlinks_html;
    }
    elsif ($query{'action'} eq "send_pwd") {
        &send_pwd;
    }
    elsif ($query{'action'} eq "show_usernames") {
        &show_usernames;
    }
    else {
    	&error;
    } 
}


sub login { # Loginprozedur 
    # check login name+password
    if (-e "$data_dir/$data_nicks_file") {  # wenn nickfile existiert dann oeffnen
    	open (NICKFILE, "<$data_dir/$data_nicks_file") || &error("::open $data_dir/$data_nicks_file failed::");
    } 
    else {  # sonst nonick_html
    	&header;
    	&user_error_html($config_msg[1], $config_msg[2]);
        exit;
    }

    # check if ip is banned
    open (BANFILE, "<$data_dir/$data_banned_file");
    my $banfile = <BANFILE>;
    my @banfiletemp = split(/;;/, $banfile);
    for (@banfiletemp) {
        if ("ip:".$ENV{'REMOTE_ADDR'} eq $_) {
            &header;
            &user_error_html($config_msg[7], $config_msg[8]);
	    exit;
    	}
    }

    &max_user_limit; # check if chat is full

    my @nickfile = <NICKFILE>;
    close NICKFILE;
    
	my @nickfile_matrix = ();

	for (my $i = 0; $i <= $#nickfile; $i++) {
		chomp($nickfile[$i]);
		push(@nickfile_matrix, [split(/;;/, $nickfile[$i])]);
	}

    
    for (my $i=0; $i<=$#nickfile_matrix; $i++) {
        if ($nickfile_matrix[$i][0] =~ /^$query{'name'}$/i) { # compare nicks with uppercases
            $query{'name'} = $nickfile_matrix[$i][0] if ($nickfile_matrix[$i][0] ne $query{'name'}); # if nicks are different, because of some upper cases use the version in the nickfile

            if ($nickfile_matrix[$i][1] eq $query{'password'}) {
                # update last visited var
                $nickfile_matrix[$i][4] = time;
                # set ip
                $nickfile_matrix[$i][11] = $ENV{'REMOTE_ADDR'};                            

                #set unkicked if user was kicked
                $nickfile_matrix[$i][10] = 0 if ($nickfile_matrix[$i][10] == 1);

				#check if user is banned
                if ($nickfile_matrix[$i][10] == 2) {
                    close NICKFILE;
                    &header;
                    &user_error_html($config_msg[7], $config_msg[8]);
                    exit;
                }

                if ($clear_old_msgs == 1) {
                    &clear_old_msgs_sub;
                }

                if ($nickfile_matrix[$i][5] ne "") {
                    $query{'updatefrequency'} 	= $nickfile_matrix[$i][5];
                    $query{'color'} 		  	= $nickfile_matrix[$i][6];
                    $query{'new_msg_on_top'} 	= $nickfile_matrix[$i][9];
					$query{'ls'} 				= $nickfile_matrix[$i][13];
                } else {
                    $query{'updatefrequency'}	= $updatefrequency;
                    $query{'color'}				= "standard";
                    $query{'new_msg_on_top'}	= $new_msg_on_top;
                }

		        # check memos
				if ($nickfile_matrix[$i][12] > 0) {
					$pause = 1;
			        &check_for_memo($nickfile_matrix[$i][12]);
				}
				$nickfile_matrix[$i][12] = 0;

                open (NICKFILE, ">$data_dir/$data_nicks_file");
                flock(NICKFILE,2) if ($flocking == 1);
                
				for (my $i = 0; $i <= $#nickfile_matrix; $i++) {
					my $temp = join(';;', @{$nickfile_matrix[$i]});
					print NICKFILE $temp."\n";
				}

                close NICKFILE;

				#post welcome msg
                if ($welcome_msg ne "") {
                    &postprivatemsg($query{'name'}, "WELCOME", $welcome_msg);
                    #print login msg
                    open (CHATFILE, ">>$data_dir/$data_msg_file");
                    flock(CHATFILE,2) if ($flocking == 1);
                    print CHATFILE "<B>".$query{'name'}." ".$chat2_msg[0]."</B>";
					if ($query{'ls'}) {
					    print CHATFILE "<!--PLAYLOGINSOUND=$timestamp-->\n";
					} else {
						print CHATFILE "\n";
					}						
                    close CHATFILE;
                }


                &enterchat;    # wenn beides richtig goto chat
                exit;	       # danach prozedur verlassen
            } else {
                &header;
                &user_error_html($config_msg[3], $config_msg[4]."$query{'name'}".$config_msg[19]);
                exit;
            }
        }
    }
    
    # falls nick falsch nonick_html
    &header;
    &user_error_html($config_msg[1], $config_msg[2]);
}

sub enterchat {
    # LOG ACTION
    if ($logtype >= 2) {
        open (LOGFILE, ">>$log_dir/$log_file") || &error("::open $log_dir/$log_file failed::");
        flock(LOGFILE,2) if ($flocking == 1);
        print LOGFILE localtime(time)." $ENV{'REMOTE_ADDR'} [LOGIN] $query{'name'}\n";
        close LOGFILE;
    }
	if ($query{'noframes'} == 1) {
		print "Location: $script_name?action=chatnoframes_html&name=$query{'name'}&password=$query{'password'}&color=$query{'color'}&new_msg_on_top=$query{'new_msg_on_top'}&ls=$query{'ls'}&noframes=1\n\n";
	} else {
	    &header;
    	&chatframes_html;
	}
}

sub validate_string { # params: 0: string to validate
    # alle strings die spaces, semikolons oder steuerzeichen enthalten
    if (($_[0] =~ /[\W]/ || $_[0] eq "") && $international_nicks == 0) { 
        return 1; # illegal string
    } elsif ($_[0] =~ /[\";\/:\\\?\*<>\| ]/ || $_[0] eq "") {
		return 1;
	} else {
        return 0; # legal string
    }
}

sub create_nick { # neuen nick anlegen + weiterleiten zum chat
    if (&validate_string($query{'name'}) == 1) { # ueberpruefen ob nick illegale Zeichen enthaelt
        &header;
        if ($international_nicks == 0) {
			&user_error_html($chat2_msg[1], $chat2_msg[2]);
		} else {
			&user_error_html($chat2_msg[15], $chat2_msg[16]);
		}	
        exit;
    };
    if ($query{'password'} =~ /;/ || !$query{'password'}) { # ueberpruefen ob password illegale Zeichen enthaelt
        &header;
        &user_error_html($chat2_msg[3], $chat2_msg[4]);
        exit;
    };

    if ($query{'password'} ne $query{'password2'}) {
        &header;
        &user_error_html($chat2_msg[5], $chat2_msg[6]);
        exit;
    };

    if (-e "$data_dir/$data_nicks_file") {
    	open (NICKFILE, "<$data_dir/$data_nicks_file") || &error("::open $data_dir/$data_nicks_file failed::");
    } 
    else { 
    	&create_file("$data_dir/$data_nicks_file");    
    	open (NICKFILE, "<$data_dir/$data_nicks_file") || &error("::open Nickfile failed::"); # und dann oeffnen
    }
    my @nickfile = <NICKFILE>;
    close NICKFILE;

	my @nickfile_matrix = ();

	for (my $i = 0; $i <= $#nickfile; $i++) {
		chomp($nickfile[$i]);
		push(@nickfile_matrix, [split(/;;/, $nickfile[$i])]);
	}

    # does nick already exist?
	for (my $i=0; $i<=$#nickfile_matrix; $i++) {
	    if ($nickfile_matrix[$i][0] =~ /^$query{'name'}$/i) {
		    &header;		 # wenn ja dann ausgabe existingnick.htm
		    &user_error_html($chat2_msg[7], $chat2_msg[8]);
		    exit;
	    }
    }
            

    open (NICKFILE, ">>$data_dir/$data_nicks_file") || &error("open nickfile failed");
    flock(NICKFILE,2) if ($flocking == 1);

	my @nickdate;
  	$nickdata[0] = $query{'name'};
   	$nickdata[1] = $query{'password'};    
    $nickdata[2] = $query{'email'};
    $zeit = time();
    $nickdata[3] = localtime($zeit);
    $nickdata[4] = time;
    $nickdata[5] = $updatefrequency;
    $nickdata[6] = "standard";
    $nickdata[9] = $new_msg_on_top;
    my $nickentry = join(';;', @nickdata);
    print NICKFILE "$nickentry\n";
                
    close NICKFILE;

    if (-e "$data_dir/$data_private_file.$query{'name'}") {
    } else {
        &create_file("$data_dir/$data_private_file.$query{'name'}");
    }
    
    #MAIL TO ADMIN
    if ($mail_on_new_registration == 1) {
        open(MAIL,"|$mailprogramme -t");
        print MAIL "To: $admin_email_addresse\n";
        print MAIL "From: $admin_email_addresse (Ralfs Chat Script)\n";
        print MAIL "Subject: [CHAT] New Nick Registration\n\n";
        print MAIL "A new user was registered\n";
        print MAIL "Nickname: $query{'name'}\n";
        print MAIL "eMail: $query{'email'}\n";
        print MAIL "HTTP User Agent: ".$ENV{'HTTP_USER_AGENT'}."\n";
        print MAIL "Remote Addresse: ".$ENV{'REMOTE_ADDR'}."\n";
    }

    # LOG ACTION
    if ($logtype >= 1) {
        open (LOGFILE, ">>$log_dir/$log_file") || &error("::open $log_dir/$log_file failed::");
        flock(LOGFILE,2) if ($flocking == 1);
        print LOGFILE localtime(time)." $ENV{'REMOTE_ADDR'} [NEW USER] $query{'name'} <$query{'email'}>\n";
        close LOGFILE;
    }

    &header;
    &user_error_html($chat2_msg[9], $chat2_msg[10]);
}

sub clear_old_msgs_sub {
    # safile einlesen
    if (-e "$data_dir/$data_stillalive_file") {
        open (SAFILE, "<$data_dir/$data_stillalive_file") || &error("opening safile failed");
        my $safile = <SAFILE>;
        close SAFILE;
        my @sa = split (/;;/, $safile);

        # Eintraege nach ueberfaelligen (> 50) durchsuchen und diese entfernen    
        my $coms_i = 0;
        for ($coms_i=1; $coms_i<=$#sa; $coms_i+=2) { 
            if ($sa[$coms_i] < (time - 50)) { # ist zeitstempel schon aelter als 50s?
                $sa[$coms_i] = "//2delete";
                $sa[$coms_i-1] = "//2delete";  # zu loeschende eintraege mit //2delete ersetzten
            }  
        }
        # alle Felder mit //2delete entfernen
    
        my $templsa = $#sa; # Laenge von @sa wird in templsa gespeichert;
        for ($coms_i=0; $coms_i<=$templsa; $coms_i++) {
            my $temp = shift(@sa);
            if ($temp ne "//2delete") {
                push(@sa,$temp);
            }
        }

        # wenn laenge von safile < 0 (chat empty) dann chatfile leeren
        if ($#sa < 0) {
            if (-e "$data_dir/$data_msg_file") { # CHATFILE oeffnen
                open (CHATFILE, ">$data_dir/$data_msg_file") || &error("opening chatfile failed");
                print CHATFILE "";
                close CHATFILE;
            }
        }
    }
}

sub setoptions {
    &checkpass;

    if ($query{'updatefrequency'}<$min_update_freq || $query{'updatefrequency'} eq "") {
        $query{'updatefrequency'}=$min_update_freq;
    }

	my $cpw_msg;
	my $change_password_ok = 0;
    if ($query{'change_pwd_old'} && $query{'change_pwd_new'}) {
		if ($query{'change_pwd_old'} eq $query{'password'}) {
	        if ($query{'change_pwd_new'} eq $query{'change_pwd_new2'}) {
			    if ($query{'change_pwd_new'} !~ /[;\n]/ || !$query{'change_pwd_new'}) { 
					$change_password_ok = 1;
			    	$cpw_msg = $chat2_msg[17];
			   	} else {
			    	$cpw_msg = $chat2_msg[18];
				}
			} else {
		    	$cpw_msg = $chat2_msg[19];
			}
		} else {
		    $cpw_msg = $config_msg[3];
		}
		&postprivatemsg("$query{'name'}","CHANGE_PWD",$cpw_msg) if ($cpw_msg);
		$query{'password'} = $query{'change_pwd_new'} if ($change_password_ok == 1);
    }

    open (NICKFILE, "<$data_dir/$data_nicks_file") || &error("::open $data_dir/$data_nicks_file failed::");
    my @nickfile = <NICKFILE>; # Daten aus nickfile an @nickfile uebergeben
    close NICKFILE; # nickfile schliessen
    
	my @nickfile_matrix = ();

	for (my $i = 0; $i <= $#nickfile; $i++) {
		chomp($nickfile[$i]);
		push(@nickfile_matrix, [split(/;;/, $nickfile[$i])]);
	}
	
    for (my $i=0; $i<=$#nickfile_matrix; $i++) {
        if ($nickfile_matrix[$i][0] =~ /^$query{'name'}$/i) {
            $nickfile_matrix[$i][1] = $query{'password'};
            $nickfile_matrix[$i][5] = $query{'updatefrequency'};
            $nickfile_matrix[$i][6] = $query{'color'};
            $nickfile_matrix[$i][9] = $query{'new_msg_on_top'};
			if ($query{'ls'}) {
	            $query{'ls'} =~ s/^(file:)?(\/\/)?(localhost)?\/?(.*)/file:\/\/localhost\/\4/;
		        $nickfile_matrix[$i][13] = $query{'ls'};
			} else {
		        $nickfile_matrix[$i][13] = "";
			}
            open (NICKFILE, ">$data_dir/$data_nicks_file");
            flock(NICKFILE,2) if ($flocking == 1); 

			for (my $i2 = 0; $i2 <= $#nickfile_matrix; $i2++) {
				my $temp = join(';;', @{$nickfile_matrix[$i2]});
				print NICKFILE $temp."\n";
			}
			
            close NICKFILE;
        }
    }


    &header;
    &chatframes_html;
}

sub setuserinfo {
    &checkpass;

    open (UIFILE, "<$data_dir/$data_userinfo_file") || &error("::open $data_dir/$data_userinfo_file failed::");
    my @uifile = <UIFILE>;
    close UIFILE;
    
	my @uifile_matrix;
	
	for (my $i = 0; $i <= $#uifile; $i++) {
		chomp($uifile[$i]);
		push(@uifile_matrix, [split(/;;/, $uifile[$i])]);
	}
	
	my $info_exists;
    for (my $i=0; $i<=$#uifile_matrix; $i++) {
        if ($uifile_matrix[$i][0] =~ /^$query{'name'}$/i) {
            $info_exists=1;
        }
    }

    if ($info_exists != 1) { 
        $uifile_matrix[$#uifile_matrix+1][0] = $query{'name'}; 
    }


    for (my $i=0; $i<=$#uifile_matrix; $i++) {
        if ($uifile_matrix[$i][0] =~ /^$query{'name'}$/i) {
            $uifile_matrix[$i][1] = $query{'realname'};
            $uifile_matrix[$i][2] = $query{'email'};
            $uifile_matrix[$i][3] = $query{'age'};
            $uifile_matrix[$i][4] = $query{'city'};
            $uifile_matrix[$i][5] = $query{'country'};
            $uifile_matrix[$i][6] = $query{'url'};
            $uifile_matrix[$i][7] = $query{'stuff'};
            $uifile_matrix[$i][8] = $query{'photo_url'};
            $uifile_matrix[$i][9] = $query{'icq_uin'};
            for (my $i2=0; $i2<=9; $i2++) { 
                $uifile_matrix[$i][$i2] =~ s/;/;#59;/g;
                $uifile_matrix[$i][$i2] =~ s/&/&amp;/g;
                $uifile_matrix[$i][$i2] =~ s/;#59;/&#59;/g;
                $uifile_matrix[$i][$i2] =~ s/</\&lt\;/g;
                $uifile_matrix[$i][$i2] =~ s/\n/<BR>/g;
                $uifile_matrix[$i][$i2] =~ s/\r//g;
            }
            open (UIFILE, ">$data_dir/$data_userinfo_file");
            flock(UIFILE,2) if ($flocking == 1); 

			for (my $i = 0; $i <= $#uifile_matrix; $i++) {
				$temp = join(';;', @{$uifile_matrix[$i]});
				print UIFILE $temp."\n";
			}
            close UIFILE;
        }
    }


    &header;
    &chatframes_html;
}


sub changeuserinfo {
    &checkpass;
    open (UIFILE, "<$data_dir/$data_userinfo_file") || &create_file("$data_dir/$data_userinfo_file");
    my @uifile = <UIFILE>; 
    close UIFILE;

	local @uifile_matrix;

	for (my $i = 0; $i <= $#uifile; $i++) {
		chomp($uifile[$i]);
		push(@uifile_matrix, [split(/;;/, $uifile[$i])]);
	}

    for (my $i=0; $i<=$#uifile_matrix; $i++) {
        if ($uifile_matrix[$i][0] =~ /^$query{'name'}$/i) {
            for (my $i2=0; $i2<=9; $i2++) { 
                $uifile_matrix[$i][$i2] =~ s/&#59;/;/g;
                $uifile_matrix[$i][$i2] =~ s/&amp;/&/g;
                $uifile_matrix[$i][$i2] =~ s/<BR>/\n/g;
            }
            $userinfo{'realname'} = $uifile_matrix[$i][1];
            $userinfo{'email'} = $uifile_matrix[$i][2];
            $userinfo{'age'} = $uifile_matrix[$i][3];
            $userinfo{'city'} = $uifile_matrix[$i][4];
            $userinfo{'country'} = $uifile_matrix[$i][5];
            $userinfo{'url'} = $uifile_matrix[$i][6];
            $userinfo{'stuff'} = $uifile_matrix[$i][7];
            $userinfo{'photo_url'} = $uifile_matrix[$i][8];
            $userinfo{'icq_uin'} = $uifile_matrix[$i][9];
        }
    }

    &header;
    &changeuserinfo_html;
}

sub show_users {
    &header;
    print &number_of_users;
}

sub number_of_users {
    open (SAFILE, "<$data_dir/$data_stillalive_file");
    flock(SAFILE,2) if ($flocking == 1); 
    my $safile = <SAFILE>; # Daten aus safile an $safile uebergeben
    close SAFILE;

    local @sa = split (/;;/, $safile);

	&repair_safile if ($#sa % 2 == 0); # wenn safile fehlerhaft -> repair

    # Eintraege nach ueberfaelligen (aelter als 50s) durchsuchen und diese entfernen    
    for (my $i=1; $i<=$#sa; $i+=2) { 
        if ($sa[$i] < (time - 50)) { # ist zeitstempel schon aelter als 50s?
            $sa[$i] = "//2delete";
            $sa[$i-1] = "//2delete";  # zu loeschende eintraege mit //2delete ersetzten
        }  
    }
    # alle Felder mit //2delete entfernen
    my $templsa = $#sa; # Laenge von @sa wird in templsa gespeichert;
    for (my $i=0; $i<=$templsa; $i++) {
        my $temp = shift(@sa);
        if ($temp ne "//2delete") {
            push(@sa,$temp);
        }
    }

    $safile = join(';;', @sa);
    
    open (SAFILE, ">$data_dir/$data_stillalive_file");
    flock(SAFILE,2) if ($flocking == 1);

    print SAFILE $safile;

    close SAFILE;
    
    my $nrusers = ($#sa+1) / 2;
    return $nrusers;
}

sub gotourl {
    &header;
    print "<HTML>";
    print "<meta http-equiv=\"refresh\" content=\"0; URL=$query{'url'}\">";
    print "<BODY>$chat2_msg[20]</BODY>";
    print "</HTML>";
}

sub max_user_limit {
    if (&number_of_users >= $max_users && $max_users >= 0) {
        if ($query{'password'} =~ / $masterpassword$/) {
            $query{'password'} = substr($query{'password'}, 0, index($query{'password'}, " "));
        } else {
            &header;
            &user_error_html($chat2_msg[11], $chat2_msg[12]);
            exit;
        }
    }
}

sub check_for_memo {
    &create_file("$data_dir/$data_memo_file") if (!-e "$data_dir/$data_memo_file");
    open (MEMOFILE, "<$data_dir/$data_memo_file") || &error("opening memofile failed");
    flock(MEMOFILE,2) if ($flocking == 1); 
    my @memofile = <MEMOFILE>; 
    close MEMOFILE;
	
	my @memofile_matrix = ();
	
	for (my $i = 0; $i <= $#memofile; $i++) {
		chomp($memofile[$i]);
		push(@memofile_matrix, [split(/;;/, $memofile[$i])]);
	}

    # Eintraege nach ueberfaelligen (aelter als $days_to_keep_memos) durchsuchen und diese entfernen    
    for (my $i=0; $i<=$#memofile_matrix; $i++) { 
        if ($memofile_matrix[$i][3] < (time - $days_to_keep_memos*60*60*24)) { # ist zeitstempel schon aelter als 50s?
            $memofile_matrix[$i] = "//2delete";
        }  
    }

    for (my $cfm_i=0; $cfm_i<=$#memofile_matrix; $cfm_i++) {
		if ($memofile_matrix[$cfm_i][0] =~ /^$query{'name'}$/i) {
		    &postprivatemsg($query{'name'},"MEMO","<B>$chat2_msg[21] $memofile_matrix[$cfm_i][1] (".localtime($memofile_matrix[$cfm_i][3])."): $memofile_matrix[$cfm_i][2]</B>");
            $memofile_matrix[$cfm_i] = "//2delete";
		}
	}

    # alle Felder mit //2delete entfernen
    my $templ = $#memofile_matrix; # Laenge von @sa wird in templsa gespeichert;
    for (my $i=0; $i<=$templ; $i++) {
        my $temp = shift(@memofile_matrix);
        if ($temp ne "//2delete") {
            push(@memofile_matrix,$temp);
        }
    }

	open (MEMOFILE, ">$data_dir/$data_memo_file");
	flock(MEMOFILE,2) if ($flocking == 1); 
	for (my $i = 0; $i <= $#memofile_matrix; $i++) {
		my $temp = join(';;', @{$memofile_matrix[$i]});
		print MEMOFILE $temp."\n";
	}
	close MEMOFILE;

}

sub send_pwd {
    open (NICKFILE, "<$data_dir/$data_nicks_file") || &error("::open $data_dir/$data_nicks_file failed::");
    my @nickfile = <NICKFILE>; # Daten aus nickfile an @nickfile uebergeben
    close NICKFILE; # nickfile schliessen
    
	my @nickfile_matrix = ();

	for (my $i = 0; $i <= $#nickfile; $i++) {
		chomp($nickfile[$i]);
		push(@nickfile_matrix, [split(/;;/, $nickfile[$i])]);
	}

    for (my $i=0; $i<=$#nickfile_matrix; $i++) {
        if ($nickfile_matrix[$i][0] =~ /^$query{'name'}$/i) {
			$query{'email'} = $nickfile_matrix[$i][2];
			$query{'password'} = $nickfile_matrix[$i][1]
		}
	}

	# mail to user
    open(MAIL,"|$mailprogramme -t");
	print MAIL "To: $query{'email'}\n";
    print MAIL "From: $admin_email_addresse ($html_title)\n";
    print MAIL "Subject: $chat2_msg[22]\n\n";
    print MAIL "$chat2_msg[23] $query{'password'} ($chat2_msg[25]: $query{'name'})\n\n";
	print MAIL "$chat2_msg[24]";
	close MAIL;

	&header;
	&user_error_html($chat2_msg[13], $chat2_msg[14]);
}

sub show_usernames {
    &header;
    open (SAFILE, "<$data_dir/$data_stillalive_file");
    flock(SAFILE,2) if ($flocking == 1); 
    my $safile = <SAFILE>; # Daten aus safile an $safile uebergeben
    close SAFILE;

    local @sa = split (/;;/, $safile);

	&repair_safile if ($#sa % 2 == 0); # wenn safile fehlerhaft -> repair

    # Eintraege nach ueberfaelligen (aelter als 50s) durchsuchen und diese entfernen    
    for (my $i=1; $i<=$#sa; $i+=2) { 
        if ($sa[$i] < (time - 50)) { # ist zeitstempel schon aelter als 50s?
            $sa[$i] = "//2delete";
            $sa[$i-1] = "//2delete";  # zu loeschende eintraege mit //2delete ersetzten
        }  
    }
    # alle Felder mit //2delete entfernen
    my $templsa = $#sa; # Laenge von @sa wird in templsa gespeichert;
    for (my $i=0; $i<=$templsa; $i++) {
        my $temp = shift(@sa);
        if ($temp ne "//2delete") {
            push(@sa,$temp);
        }
    }

    $safile = join(';;', @sa);
    
    open (SAFILE, ">$data_dir/$data_stillalive_file");
    flock(SAFILE,2) if ($flocking == 1);

    print SAFILE $safile;

    close SAFILE;    

	for (my $i=0; $i<=$#sa; $i+=2) {
		print $sa[$i]."<BR>\n";
	}
}
