;---------------------------------
;Light' Out!  By Anthony Loven
;Source code commented February 2005
;This source may be modified, however credit to me would be appreciated.
;---------------------------------

#include "asm86.h"
#include "ti86asm.inc"
;#include GKey86 - Original on-calc header name
;#include Key86 - Original on-calc header name
.plugin lite86

.org _asm_exec_ram

    nop                       ; These 5 lines are for shell purposes only
    jp ProgStart              ; Tell program to jump to ProgStart
.dw 1                         ; Style format; not important
.dw ShellTitle                ; Points to shell title, which is below
.dw icon                      ; Points to shell icon, which shows up on iShell
ShellTitle:
    .db "Light' Out! by Anthony Loven",0
;******* WRITEBACK DATA **********
; This is the Current Level variable
data_start:
LLev: .dw 1
data_end:
; This hold your highest achieved level
data_start2:
HighLev: .dw 1
data_end2:
;***************************
ProgStart:
    call _runindicoff         ; Turn off the run indicator
StartGame:
    call _clrScrn             ; ROM call - clears screen
    ld de,$0201               ; Coordinate location.  Third column, second row.
    ld (_curRow),de           ; Points the cursor to the location
    ld hl,Name                ; Point HL to the game's name.
    call _puts                ; ROM call - Loads the string in HL on the screen at the coordinates
    ld de,$0203               ; Coordinate location.  Third column, fourth row.
    ld (_curRow),de
    ld hl,ByAuthor            ; Points HL to my name :)
    call _puts
    call DBorder              ; Call my border drawing routine!
    jp ChooseLevel            ; Jumps over to the ChooseLevel label
;***************************    
DBorder:                      ; This routine draws the border of lights in the game.
    ld de,$0000               ; Starting coordinates
    ld b,2                    ; Loop Counter
    ld hl,Border              ; Border icon
BigBord1:                     ; Outer Loop
    push bc                   ; Push loop counter in stack
    ld b,16                   ; Loop Counter --> 8 icons * 2 columns = 16
Border1:                      ; Inner Loop
    push bc                   ; Push the loop counter away, GridPutSprite destroys b!
    call GridPutSprite        ; Call GridPutSprite - it really inverses the pixels, not putting a sprite.
    pop bc                    ; Grab back the loop counter
    inc e                     ; Next row
    djnz Border1              ; Do this again
    
    pop bc                    ; Bring back the outer loop counter
    ld de,$0700               ; Move the the right-most column
    djnz BigBord1             ; Jump back to the OuterLoop
    
    ld b,2                    ; Repeat a similiar process, but for the top and bottom rows
    ld de,$0100               ; Point to the top row
BigBord2:
    push bc
    ld b,6
Border2:
    push bc
    call GridPutSprite
    pop bc
    inc d
    djnz Border2
    
    pop bc
    ld de,$010F
    djnz BigBord2  
    
    ret                       ; Return from routine
;**************************

;**************************
PutStuff:                     ; This procedure simply refreshes the level number, and the left arrow
    ld de,$0a05
    ld (_curRow),de
    ld h,0
    ld l,c
    xor a                     ; This makes a zero, very fast way
    call _dispAHL             ; ROM call - displays the value of hl, and a
    ld de,$0A05
    ld (_curRow),de
    ld hl,Left
    call _puts
    ret
;*************************
ChooseLevel:
    ld de,$0305
    ld (_curRow),de
    ld hl,Level
    call _puts
    ld bc,(LLev)              ; This stores the level value LLev in the registers bc
    call PutStuff             ; Call PutStuff - refreshes the level number, and left arrow
    ld de,$1005
    ld hl,Right
    ld (_curRow),de
    call _puts
LoopLevel:
    ld b,0
    ld a,c                    ; Load the level counter in a, and
    ld e,a                    ; then load it in e (because de is input for SaveLev)
    push bc                   ; SaveLev destroys this!
    call SaveLev
    pop bc
    call _get_key             ; ROM call - detect a keypress, but doesn't wait for one
    ld e,a                    ; The key value is stored in a, so this backs it up in e
    cp K_EXIT                 ; Equate for EXIT key, compares it with a
    jp z,Stop                 ; If it's equal, jump to Stop.
    ld a,e
    cp K_LEFT
    jp z,LeftChoose           ; If left is pressed, jump to LeftChoose
    ld a,e
    cp K_RIGHT
    jp z,RightChoose
    ld a,e
    cp K_ENTER
    jp z,St
    jp LoopLevel              ; Keep looping this procedure
St:
    push bc
    jp St2                    ; Skip over to St2
;***************************
;This routine draws 5x5 levels on the screen
;Input - HL pointing to the level matrix
MakeLevel:
    push hl
    pop ix                    ; This is used as an offset to move from byte to byte
    ld b,5
    ld de,$0001
    ld hl,BulbOn
LLoop:
    ld a,(ix+0)               ; This moves down a byte
    inc ix                    ; And this too :)
    push bc
    ld b,5
LLoop2:
    ld c,a
    bit 4,a
    push bc
    push af
    push ix
    call nz,GridPutSprite     ; This destroys a bunch of registers, hence the stack usage

    pop ix
    pop af
    pop bc
    sla a
    inc e
    djnz LLoop2
    
    pop bc
    inc d
    ld e,1
    djnz LLoop
    
    ret
;***************************
St2:
    call _clrScrn
    ld de,$0241
    ld (_penCol),de           ; ROM call - penCol signifies the coordinated pixel-wise
    ld hl,Name
    call _vputs
    ld de,$3515
    ld (_penCol),de
    ld hl,Author
    call _vputs
    ld b,6
    ld hl,$fc01               ; The next set of loops draws the 5x5 playing boxes
                              ; This was my first thing I wrote when I started writing this game on my calc.
BigLoop:
    push bc
    ld b,5
LoopStart:
    ld a,%11111111            ; This turns on 8 pixels when I display it.
    ld (hl),a                 ; Doing this makes the pixels turn on.
    inc l
    djnz LoopStart
    
    pop bc
    ld a,%10000000
    ld (hl),a
    ld de,%01111011
    add hl,de
    djnz BigLoop
    
    ld hl,$fc01
    ld b,5
BigLoopOne:
    push bc
    ld b,7
    ld de,%10000
    add hl,de
BigLoopTwo:
    push bc
    ld b,6
BigLoopThree:
    ld a,%10000000
    ld (hl),a
    inc l
    djnz BigLoopThree
    
    pop bc
    ld de,%1010
    add hl,de
    djnz BigLoopTwo
    
    pop bc
    djnz BigLoopOne
    pop bc                    ; This grabs the level value again
;------- The following code draws levels depending on the users choice --------
    ld a,c                    ; Load number into a
    ld (CurLev),a
    cp 1                      ; Check for level 1
    ld hl,Lev1                ; If so, point to Lev1 matrix
    call z,MakeLevel          ; Then call MakeLevel
    ld a,c
    cp 2
    ld hl,Lev2
    call z,MakeLevel
    ld a,c
    cp 3
    ld hl,Lev3
    call z,MakeLevel
    ld a,c
    cp 4
    ld hl,Lev4
    call z,MakeLevel
    ld a,c
    cp 5
    ld hl,Lev5
    call z,MakeLevel
    ld a,c
    cp 6
    ld hl,Lev6
    call z,MakeLevel
    ld a,c
    cp 7
    ld hl,Lev7
    call z,MakeLevel
    ld a,c
    cp 8
    ld hl,Lev8
    call z,MakeLevel
    ld a,c
    cp 9
    ld hl,Lev9
    call z,MakeLevel
    ld a,c
    cp 10
    ld hl,Lev10
    call z,MakeLevel
    ld a,c
    cp 11
    ld hl,Lev11
    call z,MakeLevel
    ld a,c
    cp 12
    ld hl,Lev12
    call z,MakeLevel
    ld a,c
    cp 13
    ld hl,Lev13
    call z,MakeLevel
    ld a,c
    cp 14
    ld hl,Lev14
    call z,MakeLevel
    ld a,c
    cp 15
    ld hl,Lev15
    call z,MakeLevel
    ld a,c
    cp 16
    ld hl,Lev16
    call z,MakeLevel
    ld a,c
    cp 17
    ld hl,Lev17
    call z,MakeLevel
    ld a,c
    cp 18
    ld hl,Lev18
    call z,MakeLevel
    ld a,c
    cp 19
    ld hl,Lev19
    call z,MakeLevel
    ld a,c
    cp 20
    ld hl,Lev20
    call z,MakeLevel
    ld a,c
    cp 21
    ld hl,Lev21
    call z,MakeLevel
    ld a,c
    cp 22
    ld hl,Lev22
    call z,MakeLevel
    ld a,c
    cp 23
    ld hl,Lev23
    call z,MakeLevel
    ld a,c
    cp 24
    ld hl,Lev24
    call z,MakeLevel
    ld a,c
    cp 25
    ld hl,Lev25
    call z,MakeLevel
    ld a,c
    cp 26
    ld hl,Lev26
    call z,MakeLevel
    ld a,c
    cp 27
    ld hl,Lev27
    call z,MakeLevel
    ld a,c
    cp 28
    ld hl,Lev28
    call z,MakeLevel
    ld a,c
    cp 29
    ld hl,Lev29
    call z,MakeLevel
    ld a,c
    cp 30
    ld hl,Lev30
    call z,MakeLevel
    ld a,c
    cp 31
    ld hl,Lev31
    call z,MakeLevel
    ld a,c
    cp 32
    ld hl,Lev32
    call z,MakeLevel
    ld a,c
    cp 33
    ld hl,Lev33
    call z,MakeLevel
    ld a,c
    cp 34
    ld hl,Lev34
    call z,MakeLevel
    ld a,c
    cp 35
    ld hl,Lev35
    call z,MakeLevel
    ld a,c
    cp 36
    ld hl,Lev36
    call z,MakeLevel
    ld a,c
    cp 37
    ld hl,Lev37
    call z,MakeLevel
    ld a,c
    cp 38
    ld hl,Lev38
    call z,MakeLevel
    ld a,c
    cp 39
    ld hl,Lev39
    call z,MakeLevel
    ld a,c
    cp 40
    ld hl,Lev40
    call z,MakeLevel
    ld a,c
    cp 41
    ld hl,Lev41
    call z,MakeLevel
    ld a,c
    cp 42
    ld hl,Lev42
    call z,MakeLevel
    ld a,c
    cp 43
    ld hl,Lev43
    call z,MakeLevel
    ld a,c
    cp 44
    ld hl,Lev44
    call z,MakeLevel
    ld a,c
    cp 45
    ld hl,Lev45
    call z,MakeLevel
    ld a,c
    cp 46
    ld hl,Lev46
    call z,MakeLevel
    ld a,c
    cp 47
    ld hl,Lev47
    call z,MakeLevel
    ld a,c
    cp 48
    ld hl,Lev48
    call z,MakeLevel
    ld a,c
    cp 49
    ld hl,Lev49
    call z,MakeLevel
    ld a,c
    cp 50
    ld hl,Lev50
    call z,MakeLevel
    ld a,c
    cp 51
    ld hl,Lev51
    call z,MakeLevel
    ld a,c
    cp 52
    ld hl,Lev52
    call z,MakeLevel
    ld a,c
    cp 53
    ld hl,Lev53
    call z,MakeLevel
    ld a,c
    cp 54
    ld hl,Lev54
    call z,MakeLevel
    ld a,c
    cp 55
    ld hl,Lev55
    call z,MakeLevel
    ld a,c
    cp 56
    ld hl,Lev56
    call z,MakeLevel
    ld a,c
    cp 57
    ld hl,Lev57
    call z,MakeLevel
    ld a,c
    cp 58
    ld hl,Lev58
    call z,MakeLevel
    ld a,c
    cp 59
    ld hl,Lev59
    call z,MakeLevel
    ld a,c
    cp 60
    ld hl,Lev60
    call z,MakeLevel
    ld a,c
    cp 61
    ld hl,Lev61
    call z,MakeLevel
    ld a,c
    cp 62
    ld hl,Lev62
    call z,MakeLevel
    ld a,c
    cp 63
    ld hl,Lev63
    call z,MakeLevel
    ld a,c
    cp 64
    ld hl,Lev64
    call z,MakeLevel
    ld a,c
    cp 65
    ld hl,Lev65
    call z,MakeLevel
    ld a,c
    cp 66
    ld hl,Lev66
    call z,MakeLevel
    ld a,c
    cp 67
    ld hl,Lev67
    call z,MakeLevel
    ld a,c
    cp 68
    ld hl,Lev68
    call z,MakeLevel
    ld a,c
    cp 69
    ld hl,Lev69
    call z,MakeLevel
    ld a,c
    cp 70
    ld hl,Lev70
    call z,MakeLevel
    ld a,c
    cp 71
    ld hl,Lev71
    call z,MakeLevel
    ld a,c
    cp 72
    ld hl,Lev72
    call z,MakeLevel
    ld a,c
    cp 73
    ld hl,Lev73
    call z,MakeLevel
    ld a,c
    cp 74
    ld hl,Lev74
    call z,MakeLevel
    ld a,c
    cp 75
    ld hl,Lev75
    call z,MakeLevel
    ld a,c
    cp 76
    ld hl,Lev76
    call z,MakeLevel
    ld a,c
    cp 77
    ld hl,Lev77
    call z,MakeLevel
    ld a,c
    cp 78
    ld hl,Lev78
    call z,MakeLevel
    ld a,c
    cp 79
    ld hl,Lev79
    call z,MakeLevel
    ld a,c
    cp 80
    ld hl,Lev80
    call z,MakeLevel
    ld a,c
    cp 81
    ld hl,Lev81
    call z,MakeLevel
    ld a,c
    cp 82
    ld hl,Lev82
    call z,MakeLevel
    ld a,c
    cp 83
    ld hl,Lev83
    call z,MakeLevel
    ld a,c
    cp 84
    ld hl,Lev84
    call z,MakeLevel
    ld a,c
    cp 85
    ld hl,Lev85
    call z,MakeLevel
    ld a,c
    cp 86
    ld hl,Lev86
    call z,MakeLevel
    ld a,c
    cp 87
    ld hl,Lev87
    call z,MakeLevel
    ld a,c
    cp 88
    ld hl,Lev88
    call z,MakeLevel
    ld a,c
    cp 89
    ld hl,Lev89
    call z,MakeLevel
    ld a,c
    cp 90
    ld hl,Lev90
    call z,MakeLevel
    ld c,0
;------ End of Level Checking Code ------
    push bc
;------ The following code checks for keypresses, and deals with turning on/off lights -----
Loop:

;    call _get_key              ; ROM call - This DOESNT WAIT for a keypress.
    ld de,$0001
    ld c,$2E
    push bc
    push de
    call _get_key
    pop de
    pop bc
    ld b,5
KLoop2:
    ld (LoopVar),bc
    ld b,5
KLoop3:
    
    cp c
    jp z,Bulb
    dec c
    inc d
    djnz KLoop3
    inc e
    ld d,0
    ld bc,(LoopVar)
    push af
    ld a,c
    sub 8
    ld c,a
    pop af
    djnz KLoop2
    
    cp K_EXIT
    pop bc
    jp z,Stop
    push bc
    cp K_MORE
    pop bc
    jp z,StartGame
    push bc
    jp Loop
    ;---- End of key wait code -----

Stop:
    call _clrScrn
    ret
;***********************************
;These are random routines the program uses.
Bulb:                         ; This turns on/off lights
    push bc
    push de
    push af
    ld a,242
    ld d,5
    call SoundBlast
    pop af
    pop de
    pop bc
    pop bc
    inc c
    ld l,c
    ld a,c
    cp 26
    jp z,YouLose
    push bc
    ld h,0
    xor a
    push de
    ld de,$1004
    ld (_curRow),de
    call _dispAHL
    ld de,$204B
    ld (_penCol),de
    ld hl,Moves
    call _vputs
    pop de
    ld hl,BulbOn
    call GridPutSprite
    ld a,d
    cp 4
    call nz,OthersS
    ld a,d
    cp 0
    call nz,OthersN
    ld a,e
    cp 1
    call nz,OthersE
    ld a,e
    cp 5
    call nz,OthersW
    jp CheckWin
OthersE:
    push de
    dec e
    ld hl,BulbOn
    call GridPutSprite
    pop de
    ret
OthersW:
    inc e
    ld hl,BulbOn
    call GridPutSprite
    ret
OthersN:
    push de
    dec d
    ld hl,BulbOn
    call GridPutSprite
    pop de
    ret
OthersS:
    push de
    inc d
    ld hl,BulbOn
    call GridPutSprite
    pop de
    ret
CheckWin:                     ; This routine checks if the player has won.  It scans each box after every move.
    ld hl,$fc21
    ld c,5
    ld b,5
LoopWin2:
    ld c,b
    ld b,5
LoopWin:
    ld a,(hl)
    cp %10000000
    jp nz,Finish
    inc l
    djnz LoopWin
    ld b,c
    push de
    ld de,%01111011
    add hl,de
    pop de
    djnz LoopWin2
    jp YouWin
Finish:
    jp Loop

GridPutSprite:                ; This inverses pixels bases on the input sprite;  VERY useful, but similiar code
                              ; to MakeLevel
    push hl
    push de
    push hl
    pop ix
    srl d
    rra
    and $80
    or e
    ld e,a
    ld hl,$fc00
    add hl,de
    ld b,8
    ld de,16
GPS_Loop:
    ld c,(ix+0)
    ld a,(hl)
    xor c
    ld (hl),a
    inc ix
    add hl,de
    djnz GPS_Loop
    pop de
    pop hl
    ret

CheckLev:                     ; Input - 'a' which is the level comparing with
                              ; This procedure saves registers de, hl, and bc :)
    push bc
    push de
    push hl
    ld e,a
    ld d,0
    ld a,(HighLev)
    cp e
    pop hl
    pop de
    pop bc
    jp z,Increase
    ret
Increase:
    ld a,(HighLev)
    cp 90
    jp z,SkipIncrease
    inc a
    cp 90                     ; If the HighLev is 90, don't increase
    push de
    push bc
    push hl
    ld e,a
    ld d,0
    ; This stuff saves it (writeback) into the program.
    ld (HighLev),de
    ld hl,_asapvar
    rst 20h
    rst 10h
    xor a
    ld hl,data_start2-_asm_exec_ram+4
    add hl,de
    adc a,b
    call _set_abs_dest_addr
    xor a
    ld hl,data_start2
    call _set_abs_src_addr
    ld hl,data_end2-data_start2
    call _set_mm_num_bytes
    call _mm_ldir
    pop hl
    pop bc
    pop de
SkipIncrease:
    ret
    
YouLose:                      ; This displays a losing message
    call _clrScrn
    call DBorder
    ld de,$090A
    ld (_penCol),de
    ld hl,Loser
    call _vputs
    ld de,$0f15
    ld (_penCol),de
    ld hl,More
    call _vputs
    ld de,$1525
    ld (_penCol),de
    ld hl,ExitToQuit
    call _vputs
    push bc
    push de
    push af
    ld a,242
    ld d,32
    call SoundBlast
    ld a,250
    ld d,80
    call SoundBlast
    pop af
    pop de
    pop bc
    jp WaitKey
YouWin:                       ; A winning message!
    ld a,(CurLev)
    call CheckLev
    call _clrScrn
    call DBorder
    ld de,$0932
    ld (_penCol),de
    ld hl,Winner
    call _vputs
    ld de,$0F15
    ld (_penCol),de
    ld hl,More
    call _vputs
    ld de,$1525
    ld (_penCol),de
    ld hl,ExitToQuit
    call _vputs
    pop bc
    ld l,c
    ld h,0
    xor a
    ld de,$0C05
    ld (_curRow),de
    call _dispAHL
    ld de,$0505
    ld (_curRow),de
    ld hl,Moves
    call _puts
    call WinSound

WaitKey:                      ; This is just an easier way to detect in-game a keypress of EXIT or MORE
    call _get_key
    ld b,a
    cp K_MORE
    jp z,StartGame
    ld a,b
    cp K_EXIT
    jp z,Stop
    jp WaitKey

LeftChoose:                   ; This, and RightChoose are for the menu screen.  They deal with level selection.
    push bc
    push de
    push af
    ld a,200
    ld d,2
    call SoundBlast
    pop af
    pop de
    pop bc
    ld a,c
    cp 1
    jp nz,Skip1
    ld a,(HighLev)
    inc a
    ld c,a
Skip1:
    dec c
    call PutStuff
    jp LoopLevel
RightChoose:
    push bc
    push de
    push af
    ld a,200
    ld d,2
    call SoundBlast
    pop af
    pop de
    pop bc
    ld a,c
    push af
    ld a,(HighLev)
    ld e,a
    pop af
    cp e
    jp nz,Skip2
    ld c,0
Skip2:
    inc c
    call PutStuff
    jp LoopLevel
; The following is a writeback procedure that saves the Level progress.
SaveLev:                      ; Input: de which is the current level
    ld (LLev),de
    ld hl,_asapvar
    rst 20h
    rst 10h
    xor a
    ld hl,data_start-_asm_exec_ram+4
    add hl,de
    adc a,b
    call _set_abs_dest_addr
    xor a
    ld hl,data_start
    call _set_abs_src_addr
    ld hl,data_end-data_start
    call _set_mm_num_bytes
    call _mm_ldir
    ret
    
;This SoundBlast routine has been modified for high notes.  Low notes will not work.
;****************** SOUNDBLAST Routine begins ************************
SoundBlast:        ; Takes 'a' value, 0-255, which determines wavelength
                   ; Takes 'd' value, 0-255, which determines play length
    di             ; Disable interrupts.  This makes a pure sound.
    ld c,a
    ld a,%11000000 ; This value, when sent to port 7, turns on red and white wires.
    ld e,%00111100 ; When xor with a, it makes $11111100, which turns wires off.
BigSndLoop:

    push af
    ld a,c
    cpl
    ld b,a
    pop af
PlayLoop:
    push bc        ; push the counter in stack, so frequency counter can be put in 'b'.
    ld b,c         ; Makes a frequency counter

Frequency:         ; Holds time pauses
    djnz Frequency
    
    xor e          ; Turns off/on wires
    out (7),a      ; Sends value to link port
    pop bc         ; Retrieve the 254 loop counter
    djnz PlayLoop  ; Jump back;  This counter depends on frequency
    dec d          ; Decreases play counter
    jp nz,BigSndLoop  ; If length counter = 0, go next line
    ei             ; Enable interrupts.
    ret            ; Exits the routine
;****************** SOUNDBLAST Routine ends ************************

; This routine plays the winning sound
WinSound:
    ld a,242
    ld d,10
    push bc
    push de
    push af
    call SoundBlast
    pop af
    pop de
    pop bc
    ld d,4
    ld a,192
    push bc
    push de
    push af
    call SoundBlast
    pop af
    pop de
    pop bc
    ld a,182
    push bc
    push de
    push af
    call SoundBlast
    pop af
    pop de
    pop bc
    ld a,192
    push bc
    push de
    push af
    call SoundBlast
    pop af
    pop de
    pop bc
    ld a,182
    push bc
    push de
    push af
    call SoundBlast
    pop af
    pop de
    pop bc
    ld a,242
    push bc
    push de
    push af
    call SoundBlast
    pop af
    pop de
    pop bc
    ret
    
;The following are all different strings, icons, sprites, etc. that this game uses.
Moves:
.db "Moves -",0
Left:
.db "<=",0
Right:
.db "=>",0
Level:
.db "Level",0
More:
.db "Press 'More' to play again,",0
ExitToQuit:
.db "or 'Exit' to quit.",0
Name:
.db "Light' Out! v0.7",0
Author:
.db "Written by Anthony Loven",0
ByAuthor:
.db "By Anthony Loven",0
Winner:
.db "You win!",0
Loser:
.db "You lose. Need 25 moves or less.",0
CurLev:
.dw 1
LoopVar:
.db 1

;***************** LEVEL SETS BEGIN ******************
Lev0:
.db %00000                       ; This is for debugging.  Not to be removed.
Lev1:
.db %00011
.db %00101
.db %01010
.db %01010
.db %00100
Lev2:
.db %00000
.db %01000
.db %10100
.db %10010
.db %00001
Lev3:
.db %11111
.db %11111
.db %11111
.db %10101
.db %10101
Lev4:
.db %11011
.db %10101
.db %10101
.db %10101
.db %11011
Lev5:
.db %01110
.db %10101
.db %11111
.db %01110
.db %01110
Lev6:
.db %01001
.db %11100
.db %00111
.db %11101
.db %10001
Lev7:
.db %10101
.db %11111
.db %00000
.db %11111
.db %10101
Lev8:
.db %11111
.db %11011
.db %10101
.db %11011
.db %11111
Lev9:
.db %10101
.db %00100
.db %01110
.db %00100
.db %10101
Lev10:
.db %01011
.db %10111
.db %01111
.db %11100
.db %11100
Lev11:
.db %11110
.db %10001
.db %10001
.db %10001
.db %11110
Lev12:
.db %00000
.db %00100
.db %01010
.db %10101
.db %01010
Lev13:
.db %01010
.db %11111
.db %01110
.db %01011
.db %11100
Lev14:
.db %01110
.db %01110
.db %01110
.db %00000
.db %00000
Lev15:
.db %10101
.db %10101
.db %10101
.db %10101
.db %01110
Lev16:
.db %11111
.db %01010
.db %11011
.db %01110
.db %01010
Lev17:
.db %00010
.db %00101
.db %01010
.db %10100
.db %01000
Lev18:
.db %00000
.db %00000
.db %00100
.db %01110
.db %11111
Lev19:
.db %00100
.db %01010
.db %10101
.db %01010
.db %00100
Lev20:
.db %10101
.db %00000
.db %10101
.db %00000
.db %10101
Lev21:
.db %01111
.db %01000
.db %01110
.db %01000
.db %01000
Lev22:
.db %01001
.db %01110
.db %10110
.db %01010
.db %01010
Lev23:
.db %00000
.db %00000
.db %10001
.db %00000
.db %00000
Lev24:
.db %01110
.db %10001
.db %10001
.db %10001
.db %01110
Lev25:
.db %00000
.db %00000
.db %00111
.db %00110
.db %00100
Lev26:
.db %00000
.db %00000
.db %10001
.db %11111
.db %01001
Lev27:
.db %10000
.db %11000
.db %11100
.db %11110
.db %01111
Lev28:
.db %01011
.db %10101
.db %11011
.db %10110
.db %10100
Lev29:
.db %11000
.db %00110
.db %11100
.db %10010
.db %11000
Lev30:
.db %10000
.db %10111
.db %01110
.db %10010
.db %00110
Lev31:
.db %00101
.db %11010
.db %01010
.db %10101
.db %10100
Lev32:
.db %01101
.db %01001
.db %00111
.db %11001
.db %00100
Lev33:
.db %01011
.db %01011
.db %10011
.db %00100
.db %11000
Lev34:
.db %10011
.db %01100
.db %11011
.db %11101
.db %11110
Lev35:
.db %01000
.db %01001
.db %00011
.db %10011
.db %11010
Lev36:
.db %10100
.db %11011
.db %11000
.db %10000
.db %11010
Lev37:
.db %11111
.db %10011
.db %00010
.db %11010
.db %00101
Lev38:
.db %10001
.db %01111
.db %11000
.db %01011
.db %01001
Lev39:
.db %11001
.db %00010
.db %11010
.db %01010
.db %11011
Lev40:
.db %01110
.db %11101
.db %01001
.db %11100
.db %01010
Lev41:
.db %10111
.db %01111
.db %01010
.db %00110
.db %01111
Lev42:
.db %11110
.db %11110
.db %10010
.db %11111
.db %11101
Lev43:
.db %11100
.db %01111
.db %11101
.db %10100
.db %00101
Lev44:
.db %00101
.db %11000
.db %01011
.db %11001
.db %00100
Lev45:
.db %00101
.db %11000
.db %11011
.db %10001
.db %01100
Lev46:
.db %10010
.db %11010
.db %10101
.db %11001
.db %10110
Lev47:
.db %11011
.db %00001
.db %11011
.db %10000
.db %01101
Lev48:
.db %01010
.db %01110
.db %10101
.db %11010
.db %01010
Lev49:
.db %11011
.db %01011
.db %10011
.db %00001
.db %10100
Lev50:
.db %11011
.db %00100
.db %10011
.db %10101
.db %10100
Lev51:
.db %10100
.db %10001
.db %01011
.db %00110
.db %10010
Lev52:
.db %10110
.db %00111
.db %11101
.db %10100
.db %01111
Lev53:
.db %11100
.db %11101
.db %00010
.db %10110
.db %11101
Lev54:
.db %10111
.db %01011
.db %00101
.db %10001
.db %10110
Lev55:
.db %10000
.db %00101
.db %00110
.db %00010
.db %01001
Lev56:
.db %01000
.db %11111
.db %10110
.db %10110
.db %10111
Lev57:
.db %00100
.db %11101
.db %01011
.db %11000
.db %00110
Lev58:
.db %01000
.db %00001
.db %11101
.db %10010
.db %11100
Lev59:
.db %11100
.db %10110
.db %11011
.db %11000
.db %10101
Lev60:
.db %11011
.db %11011
.db %10010
.db %10111
.db %01110
Lev61:
.db %10001
.db %00111
.db %10110
.db %11100
.db %11011
Lev62:
.db %11000
.db %10111
.db %10100
.db %11110
.db %11110
Lev63:
.db %11010
.db %00111
.db %01111
.db %10011
.db %11111
Lev64:
.db %01000
.db %11010
.db %01110
.db %00101
.db %10111
Lev65:
.db %11111
.db %10101
.db %11111
.db %11011
.db %11011
Lev66:
.db %11110
.db %10101
.db %11101
.db %10100
.db %10101
Lev67:
.db %01011
.db %00010
.db %01001
.db %00001
.db %11110
Lev68:
.db %10100
.db %11010
.db %11010
.db %10110
.db %10101
Lev69:
.db %00011
.db %11101
.db %01111
.db %11101
.db %00110
Lev70:
.db %01000
.db %01001
.db %10111
.db %10010
.db %11100
Lev71:
.db %00111
.db %10101
.db %01110
.db %00001
.db %00111
Lev72:
.db %01001
.db %00011
.db %01011
.db %11100
.db %01111
Lev73:
.db %10011
.db %10100
.db %11100
.db %01110
.db %01011
Lev74:
.db %01111
.db %01000
.db %01011
.db %10111
.db %10101
Lev75:
.db %10011
.db %01110
.db %10110
.db %11011
.db %00110
Lev76:
.db %11001
.db %11001
.db %10000
.db %11011
.db %10110
Lev77:
.db %00010
.db %10100
.db %10100
.db %11001
.db %10110
Lev78:
.db %10101
.db %01000
.db %01010
.db %10110
.db %00100
Lev79:
.db %11100
.db %01100
.db %01000
.db %00110
.db %01111
Lev80:
.db %11001
.db %10010
.db %10101
.db %00001
.db %11110
Lev81:
.db %10101
.db %10110
.db %01111
.db %01111
.db %11010
Lev82:
.db %00101
.db %10100
.db %00001
.db %00101
.db %10001
Lev83:
.db %11000
.db %11101
.db %10100
.db %10110
.db %00010
Lev84:
.db %00101
.db %11000
.db %11110
.db %01110
.db %10110
Lev85:
.db %00010
.db %11101
.db %11110
.db %00110
.db %10110
Lev86:
.db %10110
.db %10111
.db %01011
.db %01101
.db %01100
Lev87:
.db %10000
.db %01101
.db %11101
.db %01010
.db %00011
Lev88:
.db %11011
.db %11011
.db %10100
.db %10101
.db %01100
Lev89:
.db %11001
.db %00010
.db %10111
.db %10101
.db %00100
Lev90:
.db %00001
.db %10111
.db %00100
.db %11000
.db %11010
;******************* LEVEL SETS END ******************

BulbOn: ;Mask sprite for a light
.db %00000000
.db %00000000
.db %00111110
.db %00111110
.db %00111110
.db %00111110
.db %00111110
.db %00000000

icon:   ;Shell icon
.db 8,1
.db %00111100
.db %01000010
.db %01001010
.db %01000010
.db %00100100
.db %00011000
.db %00111100
.db %00111100
Border:  ; Border icon
.db %01111100
.db %10000010
.db %10001010
.db %10000010
.db %01000100
.db %00111000
.db %01111100
.db %00000000
.end