; --------------------------------------------------------------------------------------
; ----- defines ---------------------------------------------------------------------------
@define KPAD_UP	       0x40	
@define KPAD_DOWN      0x80	
@define KPAD_LEFT      0x20
@define KPAD_RIGHT     0x10
@define KPAD_A	       0x2
@define KPAD_B	       0x1
@define KPAD_START     0x8
@define KPAD_SELECT    0x4
@define KPAD_LSHOULDER 0x200
@define KPAD_RSHOULDER 0x100
; --------------------------------------------------------------------------------------

b start
	@dup dcb 0xBA (0)

; --------------------------------------------------------------------------------------
; ----- main ---------------------------------------------------------------------------

start

	; set up graphics
	
	mov	r0,$04000000
	mov	r1,$1100				; mode 0, bg 0 enabled, sprites enabled
	orr	r1,r1,$40				; sprite 1-d mapping
	str	r1,[r0]				
	ldr     r1,=$8883				
	str 	r1,[r0,+8]
	
	bl loadFont		
	
	mov     r0,M_STRING1				; the tile string
	mov	r1,5					; x pos
	mov     r2,1					; y pos
	bl	draw_string2				; draw

mainloop
	mov     r5,13			; number of regs to display
	mov     r4,TABLE		; address of string + address pointer table
	mov     r2,3			; leave a blank row in the display
	mov     r1,5
display
	ldr     r0,[r4]			; load string
	add     r4,r4,4			; inc r4 to point address
	ldr     r3,[r4]			; load address
	add     r4,r4,4			; inc r4 to point to next string
	add     r2,r2,1			; mov down a row
	bl      draw_string2		; draw the string
	subs    r5,r5,1			; decrement counter
	bpl     display			; loop


	ldr     r0,=$04000130		; key pad register
waitkey
	ldrh    r1,[r0]			; load
	tst     r1,KPAD_A		; test (low logic)
	bne     waitkey			; wait for press
	b 	mainloop		; replot the registers


TABLE	@DCD  M_STRING2,$04000000
	@DCD  M_STRING3,$04000004
	@DCD  M_STRING4,$04000006
	@DCD  M_STRING5,$04000008
	@DCD  M_STRING6,$0400000A
	@DCD  M_STRING7,$0400000C
	@DCD  M_STRING8,$0400000E
	@DCD  M_STRING9,$04000010
	@DCD  M_STRING10,$0400012
	@DCD  M_STRING11,$04000014
	@DCD  M_STRING12,$04000016
	@DCD  M_STRING13,$04000018
	@DCD  M_STRING14,$0400001A	
	@DCD  M_STRING15,$04000130

@ltorg
; --------------------------------------------------------------------------------------


; --------------------------------------------------------------------------------------
M_STRING1		@ascii	"agb system monitor"	
			@dcb 	$FF
M_STRING2		@ascii  "$04000000 : %d"
			@dcb    $FF
M_STRING3		@ascii  "$04000004 : %w"
			@dcb    $FF
M_STRING4		@ascii  "$04000006 : %w"
			@dcb    $FF
M_STRING5		@ascii  "$04000008 : %w"
			@dcb    $FF
M_STRING6		@ascii  "$0400000A : %w"
			@dcb    $FF
M_STRING7		@ascii  "$0400000C : %w"
			@dcb    $FF
M_STRING8		@ascii  "$0400000E : %w"
			@dcb    $FF
M_STRING9		@ascii  "$04000010 : %w"
			@dcb    $FF
M_STRING10		@ascii  "$04000012 : %w"
			@dcb    $FF
M_STRING11		@ascii  "$04000014 : %w"
			@dcb    $FF
M_STRING12		@ascii  "$04000016 : %w"
			@dcb    $FF
M_STRING13		@ascii  "$04000018 : %w"
			@dcb    $FF
M_STRING14		@ascii  "$0400001A : %w"
			@dcb    $FF
M_STRING15		@ascii  "$04000130 : %w"
			@dcb    $FF

;-- dma memory copy routine ---------------------------------------------------------;
;------------------------------------------------------------------------------------;
dmaMemCpy  ; r0 = source; r1 = destination; r2 = count;

	mov 	r3,$04000000			; io regs address base
	str 	r0,[r3,+$D4]			; store source address (DMA 3)
	str	r1,[r3,+$D8]			; store destination
	mov	r2,r2 LSR 2			; divide count by 4
	strh 	r2,[r3,+$DC]			; store count
	mov 	r0,%1000010000000000		;		
	strh	r0,[r3,+$DE]			; set DMA to 32-bit, and enable
	mov 	pc,lr				; return
;--------------------------------------------------------------------------------------;

; -------------------------------------------------------------------------------------
; -- load font ------------------------------------------------------------------------
loadFont

	stmia		r13!,{r0,r1,r2,lr}
	mov r0,AZDATA
	mov r1,$06000000
	ldr r2,=5377
	bl  dmaMemCpy
	mov r0,AZPAL
	mov r1,$05000000
	ldr r2,=513
	bl  dmaMemCpy
	ldmia		r13!,{r0,r1,r2,lr}
	mov pc,lr

	@ltorg
;-------------------------------------------------------------------------------------



; -----------------------------------------------------------------------------------
; -- draw_string 2 --------------------------------------------------------------------
; r0 = pointer to string
; r1 = x pos
; r2 = y pos
; r3 = pointer to variable

draw_string2

	stmia r13,!{r0,r1,r2,r3,r4,r5}
	ldr r4,=$06004000			; tile map address
	mov r5,64				; 
	mul r2,r2,r5				;
	add r2,r2,r1 LSL 1			; make coordinate
	orr r4,r4,r2
	mov r2,ASCIILUT
plotstring2
	ldrb r1,[r0]+1
	cmp  r1,$FF
	beq endstring2
	
	cmp  r1,$25				; '%'
	bne  notvar
	stmia r13,!{lr}
	bl   write_var_to_screen
	ldmia r13,!{lr}
	b   plotstring2
notvar
	ldrb r5,[r2,r1]
	strh r5,[r4]+2
	b 	plotstring2
endstring2
	ldmia r13,!{r0,r1,r2,r3,r4,r5}
	mov pc,lr

write_var_to_screen

	stmia  r13,!{r2,r5,r6,r7,r8,r9}

	ldrb  r5,[r0]+1		; load formatting byte
	mov   r9,2		; default=byte
	ldrb  r6,[r3]		; load byte as default
	cmp   r5,$77		; 'w' = word
	moveq r9,4		; 
	ldreqh r6,[r3]		; load half word
	cmp   r5,$64		; 'd' = long word	
	moveq r9,8		;
	ldreq r6,[r3]		; load word

	; next bit is very inefficent, nibble swaps the word so that
	; its easy to display in the loop

	eor   r5,r5,r5
	mov   r3,4
nibble_swap
	mov   r7,r6, LSR r3
	sub   r2,r3,4
	and   r7,r7,$F
	orr   r5,r5,r7 LSL r2
	mov   r7,r6,LSR r2
	and   r7,r7,$F
	orr   r5,r5,r7 LSL r3
	add   r3,r3,8
	cmp   r3,28
	ble   nibble_swap	
	mov   r6,r5		; nibble swapped word in r6

	mov   r2,NUMMAP		; smaller LUT for hexadecimal digits

decode_number
	and   r7,r6,$F		; get current lowest nibble
	ldrb  r5,[r2,r7]	; load index from look up
	strh  r5,[r4]+2		; store tile index
	mov   r6,r6,LSR 4	; shift number to write
	subs  r9,r9,1		;
	bne   decode_number

	ldmia  r13,!{r2,r5,r6,r7,r8,r9}
	mov	pc,lr

	@ltorg
	

;
; notes: this is a more advanced rouinte a bit more like printf which can tell you the value
; of a memory variable, whos address you pass to it in r3
NUMMAP		@DCB 53,54,55,56,57,58,59,60,61,62,1,2,3,4,5,6
; ------------------------------------------------------------------------------------





ASCIILUT
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $3F $00 $41 $42 $43 $44 $45 
@DCB $46 $47 $48 $49 $4A $4B $4C $4D $35 $36 
@DCB $37 $38 $39 $3A $3B $3C $3D $3E $4E $4F 
@DCB $50 $51 $52 $53 $00 $01 $02 $03 $04 $05 
@DCB $06 $07 $08 $09 $0A $0B $0C $0D $0E $0F 
@DCB $10 $11 $12 $13 $14 $15 $16 $17 $18 $19 
@DCB $1A $00 $00 $00 $00 $00 $00 $1B $1C $1D 
@DCB $1E $1F $20 $21 $22 $23 $24 $25 $26 $27 
@DCB $28 $29 $2A $2B $2C $2D $2E $2F $30 $31 
@DCB $32 $33 $34 $00 $00 $00 $40 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 
@DCB $00 $00 $00 $00 $00 $00  


AZDATA
	@incbin AZ.raw
AZPAL
	@incbin AZ.pal